// third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGER_CREDENTIAL_MANAGER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGER_CREDENTIAL_MANAGER_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
CredentialInfo::CredentialInfo()
    : type(),
      id(),
      name(),
      icon(),
      password(),
      federation() {}

CredentialInfo::CredentialInfo(
    CredentialType type_in,
    const ::WTF::String& id_in,
    const ::WTF::String& name_in,
    const ::blink::KURL& icon_in,
    const ::WTF::String& password_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& federation_in)
    : type(std::move(type_in)),
      id(std::move(id_in)),
      name(std::move(name_in)),
      icon(std::move(icon_in)),
      password(std::move(password_in)),
      federation(std::move(federation_in)) {}

CredentialInfo::~CredentialInfo() = default;

void CredentialInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CredentialType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password"), this->password,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "federation"), this->federation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CredentialInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CredentialManager::Name_[] = "blink.mojom.CredentialManager";

class CredentialManager_Store_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CredentialManager_Store_ForwardToCallback(
      CredentialManager::StoreCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CredentialManager::StoreCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CredentialManager_Store_ForwardToCallback);
};

class CredentialManager_PreventSilentAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CredentialManager_PreventSilentAccess_ForwardToCallback(
      CredentialManager::PreventSilentAccessCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CredentialManager::PreventSilentAccessCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CredentialManager_PreventSilentAccess_ForwardToCallback);
};

class CredentialManager_Get_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CredentialManager_Get_ForwardToCallback(
      CredentialManager::GetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CredentialManager::GetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CredentialManager_Get_ForwardToCallback);
};

CredentialManagerProxy::CredentialManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CredentialManagerProxy::Store(
    CredentialInfoPtr in_credential, StoreCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CredentialManager::Store", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type CredentialInfoPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCredentialManager_Store_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CredentialManager_Store_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CredentialInfoDataView>(
      in_credential, credential_fragment);
  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->credential.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential in CredentialManager.Store request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CredentialManager::Name_);
  message.set_method_name("Store");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CredentialManager_Store_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CredentialManagerProxy::PreventSilentAccess(
    PreventSilentAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::CredentialManager::PreventSilentAccess");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCredentialManager_PreventSilentAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CredentialManager_PreventSilentAccess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CredentialManager::Name_);
  message.set_method_name("PreventSilentAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CredentialManager_PreventSilentAccess_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CredentialManagerProxy::Get(
    CredentialMediationRequirement in_mediation, bool in_include_passwords, const WTF::Vector<::blink::KURL>& in_federations, GetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CredentialManager::Get", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mediation"), in_mediation,
                        "<value of type CredentialMediationRequirement>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_passwords"), in_include_passwords,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("federations"), in_federations,
                        "<value of type const WTF::Vector<::blink::KURL>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCredentialManager_Get_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CredentialManager_Get_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::CredentialMediationRequirement>(
      in_mediation, &params->mediation);
  params->include_passwords = in_include_passwords;
  mojo::internal::MessageFragment<
      typename decltype(params->federations)::BaseType>
      federations_fragment(params.message());
  const mojo::internal::ContainerValidateParams federations_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_federations, federations_fragment, &federations_validate_params);
  params->federations.Set(
      federations_fragment.is_null() ? nullptr : federations_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->federations.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null federations in CredentialManager.Get request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CredentialManager::Name_);
  message.set_method_name("Get");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CredentialManager_Get_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CredentialManager_Store_ProxyToResponder {
 public:
  static CredentialManager::StoreCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CredentialManager_Store_ProxyToResponder> proxy(
        new CredentialManager_Store_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CredentialManager_Store_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CredentialManager_Store_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CredentialManager_Store_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CredentialManager::StoreCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CredentialManager_Store_ProxyToResponder);
};

bool CredentialManager_Store_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CredentialManager::StoreCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CredentialManager_Store_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CredentialManager_Store_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CredentialManager_Store_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CredentialManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CredentialManager_Store_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::CredentialManager::StoreCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCredentialManager_Store_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CredentialManager_Store_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CredentialManager::StoreCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CredentialManager::Name_);
  message.set_method_name("Store");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CredentialManager_PreventSilentAccess_ProxyToResponder {
 public:
  static CredentialManager::PreventSilentAccessCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CredentialManager_PreventSilentAccess_ProxyToResponder> proxy(
        new CredentialManager_PreventSilentAccess_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CredentialManager_PreventSilentAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CredentialManager_PreventSilentAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CredentialManager_PreventSilentAccess_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CredentialManager::PreventSilentAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CredentialManager_PreventSilentAccess_ProxyToResponder);
};

bool CredentialManager_PreventSilentAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CredentialManager::PreventSilentAccessCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CredentialManager_PreventSilentAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CredentialManager_PreventSilentAccess_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CredentialManager_PreventSilentAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CredentialManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CredentialManager_PreventSilentAccess_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::CredentialManager::PreventSilentAccessCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCredentialManager_PreventSilentAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CredentialManager_PreventSilentAccess_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CredentialManager::PreventSilentAccessCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CredentialManager::Name_);
  message.set_method_name("PreventSilentAccess");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CredentialManager_Get_ProxyToResponder {
 public:
  static CredentialManager::GetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CredentialManager_Get_ProxyToResponder> proxy(
        new CredentialManager_Get_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CredentialManager_Get_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CredentialManager_Get_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CredentialManager_Get_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CredentialManager::GetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CredentialManagerError in_error, CredentialInfoPtr in_credential);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CredentialManager_Get_ProxyToResponder);
};

bool CredentialManager_Get_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CredentialManager::GetCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CredentialManager_Get_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CredentialManager_Get_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CredentialManagerError p_error{};
  CredentialInfoPtr p_credential{};
  CredentialManager_Get_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CredentialManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_credential));
  return true;
}

void CredentialManager_Get_ProxyToResponder::Run(
    CredentialManagerError in_error, CredentialInfoPtr in_credential) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CredentialManager::GetCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type CredentialManagerError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type CredentialInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCredentialManager_Get_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CredentialManager_Get_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::CredentialManagerError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CredentialInfoDataView>(
      in_credential, credential_fragment);
  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CredentialManager::GetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CredentialManager::Name_);
  message.set_method_name("Get");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CredentialManagerStubDispatch::Accept(
    CredentialManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCredentialManager_Store_Name: {
      break;
    }
    case internal::kCredentialManager_PreventSilentAccess_Name: {
      break;
    }
    case internal::kCredentialManager_Get_Name: {
      break;
    }
  }
  return false;
}

// static
bool CredentialManagerStubDispatch::AcceptWithResponder(
    CredentialManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCredentialManager_Store_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CredentialManager::Store",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CredentialManager::Store");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CredentialManager_Store_Params_Data* params =
          reinterpret_cast<
              internal::CredentialManager_Store_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CredentialInfoPtr p_credential{};
      CredentialManager_Store_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCredential(&p_credential))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CredentialManager::Name_, 0, false);
        return false;
      }
      CredentialManager::StoreCallback callback =
          CredentialManager_Store_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Store(
std::move(p_credential), std::move(callback));
      return true;
    }
    case internal::kCredentialManager_PreventSilentAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CredentialManager::PreventSilentAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CredentialManager::PreventSilentAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CredentialManager_PreventSilentAccess_Params_Data* params =
          reinterpret_cast<
              internal::CredentialManager_PreventSilentAccess_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CredentialManager_PreventSilentAccess_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CredentialManager::Name_, 1, false);
        return false;
      }
      CredentialManager::PreventSilentAccessCallback callback =
          CredentialManager_PreventSilentAccess_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreventSilentAccess(std::move(callback));
      return true;
    }
    case internal::kCredentialManager_Get_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CredentialManager::Get",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CredentialManager::Get");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CredentialManager_Get_Params_Data* params =
          reinterpret_cast<
              internal::CredentialManager_Get_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CredentialMediationRequirement p_mediation{};
      bool p_include_passwords{};
      WTF::Vector<::blink::KURL> p_federations{};
      CredentialManager_Get_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediation(&p_mediation))
        success = false;
      if (success)
        p_include_passwords = input_data_view.include_passwords();
      if (success && !input_data_view.ReadFederations(&p_federations))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CredentialManager::Name_, 2, false);
        return false;
      }
      CredentialManager::GetCallback callback =
          CredentialManager_Get_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Get(
std::move(p_mediation), 
std::move(p_include_passwords), 
std::move(p_federations), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kCredentialManagerValidationInfo[] = {
    {&internal::CredentialManager_Store_Params_Data::Validate,
     &internal::CredentialManager_Store_ResponseParams_Data::Validate},
    {&internal::CredentialManager_PreventSilentAccess_Params_Data::Validate,
     &internal::CredentialManager_PreventSilentAccess_ResponseParams_Data::Validate},
    {&internal::CredentialManager_Get_Params_Data::Validate,
     &internal::CredentialManager_Get_ResponseParams_Data::Validate},
};

bool CredentialManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CredentialManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kCredentialManagerValidationInfo);
}

bool CredentialManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CredentialManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kCredentialManagerValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::CredentialInfo::DataView, ::blink::mojom::blink::CredentialInfoPtr>::Read(
    ::blink::mojom::blink::CredentialInfo::DataView input,
    ::blink::mojom::blink::CredentialInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CredentialInfoPtr result(::blink::mojom::blink::CredentialInfo::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success && !input.ReadPassword(&result->password))
        success = false;
      if (success && !input.ReadFederation(&result->federation))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif