// third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/credentialmanager/credential_manager.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* CredentialTypeToStringHelper(CredentialType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CredentialType::EMPTY:
      return "EMPTY";
    case CredentialType::PASSWORD:
      return "PASSWORD";
    case CredentialType::FEDERATED:
      return "FEDERATED";
    default:
      return nullptr;
  }
}

std::string CredentialTypeToString(CredentialType value) {
  const char *str = CredentialTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CredentialType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CredentialType value) {
  return os << CredentialTypeToString(value);
}

static NOINLINE const char* CredentialMediationRequirementToStringHelper(CredentialMediationRequirement value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CredentialMediationRequirement::kSilent:
      return "kSilent";
    case CredentialMediationRequirement::kOptional:
      return "kOptional";
    case CredentialMediationRequirement::kRequired:
      return "kRequired";
    default:
      return nullptr;
  }
}

std::string CredentialMediationRequirementToString(CredentialMediationRequirement value) {
  const char *str = CredentialMediationRequirementToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CredentialMediationRequirement value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CredentialMediationRequirement value) {
  return os << CredentialMediationRequirementToString(value);
}

static NOINLINE const char* CredentialManagerErrorToStringHelper(CredentialManagerError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CredentialManagerError::SUCCESS:
      return "SUCCESS";
    case CredentialManagerError::PENDING_REQUEST:
      return "PENDING_REQUEST";
    case CredentialManagerError::PASSWORD_STORE_UNAVAILABLE:
      return "PASSWORD_STORE_UNAVAILABLE";
    case CredentialManagerError::NOT_ALLOWED:
      return "NOT_ALLOWED";
    case CredentialManagerError::INVALID_DOMAIN:
      return "INVALID_DOMAIN";
    case CredentialManagerError::INVALID_ICON_URL:
      return "INVALID_ICON_URL";
    case CredentialManagerError::CREDENTIAL_EXCLUDED:
      return "CREDENTIAL_EXCLUDED";
    case CredentialManagerError::CREDENTIAL_NOT_RECOGNIZED:
      return "CREDENTIAL_NOT_RECOGNIZED";
    case CredentialManagerError::NOT_IMPLEMENTED:
      return "NOT_IMPLEMENTED";
    case CredentialManagerError::NOT_FOCUSED:
      return "NOT_FOCUSED";
    case CredentialManagerError::RESIDENT_CREDENTIALS_UNSUPPORTED:
      return "RESIDENT_CREDENTIALS_UNSUPPORTED";
    case CredentialManagerError::PROTECTION_POLICY_INCONSISTENT:
      return "PROTECTION_POLICY_INCONSISTENT";
    case CredentialManagerError::ANDROID_ALGORITHM_UNSUPPORTED:
      return "ANDROID_ALGORITHM_UNSUPPORTED";
    case CredentialManagerError::ANDROID_EMPTY_ALLOW_CREDENTIALS:
      return "ANDROID_EMPTY_ALLOW_CREDENTIALS";
    case CredentialManagerError::ANDROID_NOT_SUPPORTED_ERROR:
      return "ANDROID_NOT_SUPPORTED_ERROR";
    case CredentialManagerError::ANDROID_USER_VERIFICATION_UNSUPPORTED:
      return "ANDROID_USER_VERIFICATION_UNSUPPORTED";
    case CredentialManagerError::ABORT:
      return "ABORT";
    case CredentialManagerError::OPAQUE_DOMAIN:
      return "OPAQUE_DOMAIN";
    case CredentialManagerError::INVALID_PROTOCOL:
      return "INVALID_PROTOCOL";
    case CredentialManagerError::BAD_RELYING_PARTY_ID:
      return "BAD_RELYING_PARTY_ID";
    case CredentialManagerError::CANNOT_READ_AND_WRITE_LARGE_BLOB:
      return "CANNOT_READ_AND_WRITE_LARGE_BLOB";
    case CredentialManagerError::INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB:
      return "INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB";
    case CredentialManagerError::FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION:
      return "FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION";
    case CredentialManagerError::UNKNOWN:
      return "UNKNOWN";
    default:
      return nullptr;
  }
}

std::string CredentialManagerErrorToString(CredentialManagerError value) {
  const char *str = CredentialManagerErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CredentialManagerError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CredentialManagerError value) {
  return os << CredentialManagerErrorToString(value);
}

namespace internal {


// static
bool CredentialInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialInfo_Data* object = static_cast<const CredentialInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CredentialType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->password, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->federation, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->federation, validation_context))
    return false;

  return true;
}

CredentialInfo_Data::CredentialInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Store_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Store_Params_Data* object = static_cast<const CredentialManager_Store_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credential, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

CredentialManager_Store_Params_Data::CredentialManager_Store_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Store_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Store_ResponseParams_Data* object = static_cast<const CredentialManager_Store_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CredentialManager_Store_ResponseParams_Data::CredentialManager_Store_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_PreventSilentAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_PreventSilentAccess_Params_Data* object = static_cast<const CredentialManager_PreventSilentAccess_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CredentialManager_PreventSilentAccess_Params_Data::CredentialManager_PreventSilentAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_PreventSilentAccess_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_PreventSilentAccess_ResponseParams_Data* object = static_cast<const CredentialManager_PreventSilentAccess_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CredentialManager_PreventSilentAccess_ResponseParams_Data::CredentialManager_PreventSilentAccess_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Get_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Get_Params_Data* object = static_cast<const CredentialManager_Get_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CredentialMediationRequirement_Data
        ::Validate(object->mediation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->federations, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams federations_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->federations, validation_context,
                                         &federations_validate_params)) {
    return false;
  }

  return true;
}

CredentialManager_Get_Params_Data::CredentialManager_Get_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CredentialManager_Get_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CredentialManager_Get_ResponseParams_Data* object = static_cast<const CredentialManager_Get_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::CredentialManagerError_Data
        ::Validate(object->error, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->credential, validation_context))
    return false;

  return true;
}

CredentialManager_Get_ResponseParams_Data::CredentialManager_Get_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CredentialType value) {
  return std::move(context).WriteString(::blink::mojom::CredentialTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialMediationRequirement>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CredentialMediationRequirement value) {
  return std::move(context).WriteString(::blink::mojom::CredentialMediationRequirementToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CredentialManagerError>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CredentialManagerError value) {
  return std::move(context).WriteString(::blink::mojom::CredentialManagerErrorToString(value));
}

} // namespace perfetto
