// third_party/blink/public/mojom/device/device.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/device/device.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/device/device.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool DeviceAttributeResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DeviceAttributeResult_Data* object = static_cast<const DeviceAttributeResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DeviceAttributeResult_Tag::ERROR_MESSAGE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_message, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams error_message_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_error_message, validation_context,
                                             &error_message_validate_params)) {
        return false;
      }
      return true;
    }
    case DeviceAttributeResult_Tag::ATTRIBUTE: {

      const mojo::internal::ContainerValidateParams attribute_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_attribute, validation_context,
                                             &attribute_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DeviceAttributeResult");
      return false;
    }
  }
}


// static
bool ManagedConfigurationObserver_OnConfigurationChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManagedConfigurationObserver_OnConfigurationChanged_Params_Data* object = static_cast<const ManagedConfigurationObserver_OnConfigurationChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ManagedConfigurationObserver_OnConfigurationChanged_Params_Data::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetDirectoryId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetDirectoryId_Params_Data* object = static_cast<const DeviceAPIService_GetDirectoryId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DeviceAPIService_GetDirectoryId_Params_Data::DeviceAPIService_GetDirectoryId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetDirectoryId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetDirectoryId_ResponseParams_Data* object = static_cast<const DeviceAPIService_GetDirectoryId_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

DeviceAPIService_GetDirectoryId_ResponseParams_Data::DeviceAPIService_GetDirectoryId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetHostname_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetHostname_Params_Data* object = static_cast<const DeviceAPIService_GetHostname_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DeviceAPIService_GetHostname_Params_Data::DeviceAPIService_GetHostname_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetHostname_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetHostname_ResponseParams_Data* object = static_cast<const DeviceAPIService_GetHostname_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

DeviceAPIService_GetHostname_ResponseParams_Data::DeviceAPIService_GetHostname_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetSerialNumber_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetSerialNumber_Params_Data* object = static_cast<const DeviceAPIService_GetSerialNumber_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DeviceAPIService_GetSerialNumber_Params_Data::DeviceAPIService_GetSerialNumber_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetSerialNumber_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetSerialNumber_ResponseParams_Data* object = static_cast<const DeviceAPIService_GetSerialNumber_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

DeviceAPIService_GetSerialNumber_ResponseParams_Data::DeviceAPIService_GetSerialNumber_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetAnnotatedAssetId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetAnnotatedAssetId_Params_Data* object = static_cast<const DeviceAPIService_GetAnnotatedAssetId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DeviceAPIService_GetAnnotatedAssetId_Params_Data::DeviceAPIService_GetAnnotatedAssetId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data* object = static_cast<const DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetAnnotatedLocation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetAnnotatedLocation_Params_Data* object = static_cast<const DeviceAPIService_GetAnnotatedLocation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DeviceAPIService_GetAnnotatedLocation_Params_Data::DeviceAPIService_GetAnnotatedLocation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data* object = static_cast<const DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManagedConfigurationService_GetManagedConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManagedConfigurationService_GetManagedConfiguration_Params_Data* object = static_cast<const ManagedConfigurationService_GetManagedConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

ManagedConfigurationService_GetManagedConfiguration_Params_Data::ManagedConfigurationService_GetManagedConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data* object = static_cast<const ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams configurations_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->configurations, validation_context,
                                         &configurations_validate_params)) {
    return false;
  }

  return true;
}

ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data* object = static_cast<const ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
