// third_party/blink/public/mojom/device/device.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/device/device.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/device/device.mojom-params-data.h"
#include "third_party/blink/public/mojom/device/device.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/device/device.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_DEVICE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_DEVICE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
DeviceAttributeResult::DeviceAttributeResult() : tag_(Tag::ERROR_MESSAGE) {
  data_.error_message = new std::string;
}

DeviceAttributeResult::~DeviceAttributeResult() {
  DestroyActive();
}


void DeviceAttributeResult::set_error_message(
    const std::string& error_message) {
  if (tag_ == Tag::ERROR_MESSAGE) {
    *(data_.error_message) = std::move(error_message);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_MESSAGE;
    data_.error_message = new std::string(
        std::move(error_message));
  }
}
void DeviceAttributeResult::set_attribute(
    const absl::optional<std::string>& attribute) {
  if (tag_ == Tag::ATTRIBUTE) {
    *(data_.attribute) = std::move(attribute);
  } else {
    DestroyActive();
    tag_ = Tag::ATTRIBUTE;
    data_.attribute = new absl::optional<std::string>(
        std::move(attribute));
  }
}

void DeviceAttributeResult::DestroyActive() {
  switch (tag_) {

    case Tag::ERROR_MESSAGE:

      delete data_.error_message;
      break;
    case Tag::ATTRIBUTE:

      delete data_.attribute;
      break;
  }
}

bool DeviceAttributeResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char ManagedConfigurationObserver::Name_[] = "blink.mojom.ManagedConfigurationObserver";

ManagedConfigurationObserverProxy::ManagedConfigurationObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ManagedConfigurationObserverProxy::OnConfigurationChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ManagedConfigurationObserver::OnConfigurationChanged");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kManagedConfigurationObserver_OnConfigurationChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationObserver::Name_);
  message.set_method_name("OnConfigurationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ManagedConfigurationObserverStubDispatch::Accept(
    ManagedConfigurationObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kManagedConfigurationObserver_OnConfigurationChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ManagedConfigurationObserver::OnConfigurationChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ManagedConfigurationObserver::OnConfigurationChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data* params =
          reinterpret_cast<internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ManagedConfigurationObserver_OnConfigurationChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManagedConfigurationObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConfigurationChanged();
      return true;
    }
  }
  return false;
}

// static
bool ManagedConfigurationObserverStubDispatch::AcceptWithResponder(
    ManagedConfigurationObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kManagedConfigurationObserver_OnConfigurationChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kManagedConfigurationObserverValidationInfo[] = {
    {&internal::ManagedConfigurationObserver_OnConfigurationChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool ManagedConfigurationObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ManagedConfigurationObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kManagedConfigurationObserverValidationInfo);
}

const char DeviceAPIService::Name_[] = "blink.mojom.DeviceAPIService";

class DeviceAPIService_GetDirectoryId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetDirectoryId_ForwardToCallback(
      DeviceAPIService::GetDirectoryIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetDirectoryIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetDirectoryId_ForwardToCallback);
};

class DeviceAPIService_GetHostname_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetHostname_ForwardToCallback(
      DeviceAPIService::GetHostnameCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetHostnameCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetHostname_ForwardToCallback);
};

class DeviceAPIService_GetSerialNumber_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetSerialNumber_ForwardToCallback(
      DeviceAPIService::GetSerialNumberCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetSerialNumberCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetSerialNumber_ForwardToCallback);
};

class DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback(
      DeviceAPIService::GetAnnotatedAssetIdCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetAnnotatedAssetIdCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback);
};

class DeviceAPIService_GetAnnotatedLocation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceAPIService_GetAnnotatedLocation_ForwardToCallback(
      DeviceAPIService::GetAnnotatedLocationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DeviceAPIService::GetAnnotatedLocationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetAnnotatedLocation_ForwardToCallback);
};

DeviceAPIServiceProxy::DeviceAPIServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceAPIServiceProxy::GetDirectoryId(
    GetDirectoryIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DeviceAPIService::GetDirectoryId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetDirectoryId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetDirectoryId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetDirectoryId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetDirectoryId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceAPIServiceProxy::GetHostname(
    GetHostnameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DeviceAPIService::GetHostname");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetHostname_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetHostname_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetHostname");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetHostname_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceAPIServiceProxy::GetSerialNumber(
    GetSerialNumberCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DeviceAPIService::GetSerialNumber");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetSerialNumber_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetSerialNumber_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetSerialNumber");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetSerialNumber_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceAPIServiceProxy::GetAnnotatedAssetId(
    GetAnnotatedAssetIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DeviceAPIService::GetAnnotatedAssetId");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetAnnotatedAssetId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedAssetId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceAPIServiceProxy::GetAnnotatedLocation(
    GetAnnotatedLocationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DeviceAPIService::GetAnnotatedLocation");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetAnnotatedLocation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedLocation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedLocation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceAPIService_GetAnnotatedLocation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DeviceAPIService_GetDirectoryId_ProxyToResponder {
 public:
  static DeviceAPIService::GetDirectoryIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DeviceAPIService_GetDirectoryId_ProxyToResponder> proxy(
        new DeviceAPIService_GetDirectoryId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DeviceAPIService_GetDirectoryId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetDirectoryId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DeviceAPIService_GetDirectoryId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceAPIService::GetDirectoryIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetDirectoryId_ProxyToResponder);
};

bool DeviceAPIService_GetDirectoryId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DeviceAPIService::GetDirectoryIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetDirectoryId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void DeviceAPIService_GetDirectoryId_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DeviceAPIService::GetDirectoryIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetDirectoryId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DeviceAPIService::GetDirectoryIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetDirectoryId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetHostname_ProxyToResponder {
 public:
  static DeviceAPIService::GetHostnameCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DeviceAPIService_GetHostname_ProxyToResponder> proxy(
        new DeviceAPIService_GetHostname_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DeviceAPIService_GetHostname_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetHostname_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DeviceAPIService_GetHostname_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceAPIService::GetHostnameCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetHostname_ProxyToResponder);
};

bool DeviceAPIService_GetHostname_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DeviceAPIService::GetHostnameCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetHostname_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetHostname_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetHostname_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void DeviceAPIService_GetHostname_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DeviceAPIService::GetHostnameCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetHostname_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetHostname_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DeviceAPIService::GetHostnameCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetHostname");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetSerialNumber_ProxyToResponder {
 public:
  static DeviceAPIService::GetSerialNumberCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DeviceAPIService_GetSerialNumber_ProxyToResponder> proxy(
        new DeviceAPIService_GetSerialNumber_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DeviceAPIService_GetSerialNumber_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetSerialNumber_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DeviceAPIService_GetSerialNumber_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceAPIService::GetSerialNumberCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetSerialNumber_ProxyToResponder);
};

bool DeviceAPIService_GetSerialNumber_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DeviceAPIService::GetSerialNumberCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetSerialNumber_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void DeviceAPIService_GetSerialNumber_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DeviceAPIService::GetSerialNumberCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetSerialNumber_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DeviceAPIService::GetSerialNumberCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetSerialNumber");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder {
 public:
  static DeviceAPIService::GetAnnotatedAssetIdCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder> proxy(
        new DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceAPIService::GetAnnotatedAssetIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder);
};

bool DeviceAPIService_GetAnnotatedAssetId_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DeviceAPIService::GetAnnotatedAssetIdCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetAnnotatedAssetId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedAssetIdCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetAnnotatedAssetId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedAssetIdCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedAssetId");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceAPIService_GetAnnotatedLocation_ProxyToResponder {
 public:
  static DeviceAPIService::GetAnnotatedLocationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DeviceAPIService_GetAnnotatedLocation_ProxyToResponder> proxy(
        new DeviceAPIService_GetAnnotatedLocation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DeviceAPIService_GetAnnotatedLocation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceAPIService_GetAnnotatedLocation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DeviceAPIService_GetAnnotatedLocation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceAPIService::GetAnnotatedLocationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAttributeResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DeviceAPIService_GetAnnotatedLocation_ProxyToResponder);
};

bool DeviceAPIService_GetAnnotatedLocation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::DeviceAPIService::GetAnnotatedLocationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DeviceAttributeResultPtr p_result{};
  DeviceAPIService_GetAnnotatedLocation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceAPIService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void DeviceAPIService_GetAnnotatedLocation_ProxyToResponder::Run(
    DeviceAttributeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedLocationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type DeviceAttributeResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceAPIService_GetAnnotatedLocation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::blink::mojom::DeviceAttributeResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedLocationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceAPIService::Name_);
  message.set_method_name("GetAnnotatedLocation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DeviceAPIServiceStubDispatch::Accept(
    DeviceAPIService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDeviceAPIService_GetDirectoryId_Name: {
      break;
    }
    case internal::kDeviceAPIService_GetHostname_Name: {
      break;
    }
    case internal::kDeviceAPIService_GetSerialNumber_Name: {
      break;
    }
    case internal::kDeviceAPIService_GetAnnotatedAssetId_Name: {
      break;
    }
    case internal::kDeviceAPIService_GetAnnotatedLocation_Name: {
      break;
    }
  }
  return false;
}

// static
bool DeviceAPIServiceStubDispatch::AcceptWithResponder(
    DeviceAPIService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDeviceAPIService_GetDirectoryId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DeviceAPIService::GetDirectoryId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DeviceAPIService::GetDirectoryId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DeviceAPIService_GetDirectoryId_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetDirectoryId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DeviceAPIService_GetDirectoryId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 0, false);
        return false;
      }
      DeviceAPIService::GetDirectoryIdCallback callback =
          DeviceAPIService_GetDirectoryId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectoryId(std::move(callback));
      return true;
    }
    case internal::kDeviceAPIService_GetHostname_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DeviceAPIService::GetHostname",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DeviceAPIService::GetHostname");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DeviceAPIService_GetHostname_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetHostname_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DeviceAPIService_GetHostname_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 1, false);
        return false;
      }
      DeviceAPIService::GetHostnameCallback callback =
          DeviceAPIService_GetHostname_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHostname(std::move(callback));
      return true;
    }
    case internal::kDeviceAPIService_GetSerialNumber_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DeviceAPIService::GetSerialNumber",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DeviceAPIService::GetSerialNumber");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DeviceAPIService_GetSerialNumber_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetSerialNumber_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DeviceAPIService_GetSerialNumber_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 2, false);
        return false;
      }
      DeviceAPIService::GetSerialNumberCallback callback =
          DeviceAPIService_GetSerialNumber_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSerialNumber(std::move(callback));
      return true;
    }
    case internal::kDeviceAPIService_GetAnnotatedAssetId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedAssetId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedAssetId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DeviceAPIService_GetAnnotatedAssetId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 3, false);
        return false;
      }
      DeviceAPIService::GetAnnotatedAssetIdCallback callback =
          DeviceAPIService_GetAnnotatedAssetId_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAnnotatedAssetId(std::move(callback));
      return true;
    }
    case internal::kDeviceAPIService_GetAnnotatedLocation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedLocation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DeviceAPIService::GetAnnotatedLocation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DeviceAPIService_GetAnnotatedLocation_Params_Data* params =
          reinterpret_cast<
              internal::DeviceAPIService_GetAnnotatedLocation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DeviceAPIService_GetAnnotatedLocation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceAPIService::Name_, 4, false);
        return false;
      }
      DeviceAPIService::GetAnnotatedLocationCallback callback =
          DeviceAPIService_GetAnnotatedLocation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAnnotatedLocation(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDeviceAPIServiceValidationInfo[] = {
    {&internal::DeviceAPIService_GetDirectoryId_Params_Data::Validate,
     &internal::DeviceAPIService_GetDirectoryId_ResponseParams_Data::Validate},
    {&internal::DeviceAPIService_GetHostname_Params_Data::Validate,
     &internal::DeviceAPIService_GetHostname_ResponseParams_Data::Validate},
    {&internal::DeviceAPIService_GetSerialNumber_Params_Data::Validate,
     &internal::DeviceAPIService_GetSerialNumber_ResponseParams_Data::Validate},
    {&internal::DeviceAPIService_GetAnnotatedAssetId_Params_Data::Validate,
     &internal::DeviceAPIService_GetAnnotatedAssetId_ResponseParams_Data::Validate},
    {&internal::DeviceAPIService_GetAnnotatedLocation_Params_Data::Validate,
     &internal::DeviceAPIService_GetAnnotatedLocation_ResponseParams_Data::Validate},
};

bool DeviceAPIServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::DeviceAPIService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDeviceAPIServiceValidationInfo);
}

bool DeviceAPIServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::DeviceAPIService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDeviceAPIServiceValidationInfo);
}
const char ManagedConfigurationService::Name_[] = "blink.mojom.ManagedConfigurationService";

class ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback(
      ManagedConfigurationService::GetManagedConfigurationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ManagedConfigurationService::GetManagedConfigurationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback);
};

ManagedConfigurationServiceProxy::ManagedConfigurationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ManagedConfigurationServiceProxy::GetManagedConfiguration(
    const std::vector<std::string>& in_keys, GetManagedConfigurationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ManagedConfigurationService::GetManagedConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kManagedConfigurationService_GetManagedConfiguration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_keys, keys_fragment, &keys_validate_params);
  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in ManagedConfigurationService.GetManagedConfiguration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationService::Name_);
  message.set_method_name("GetManagedConfiguration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ManagedConfigurationServiceProxy::SubscribeToManagedConfiguration(
    ::mojo::PendingRemote<ManagedConfigurationObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ManagedConfigurationService::SubscribeToManagedConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<ManagedConfigurationObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kManagedConfigurationService_SubscribeToManagedConfiguration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ManagedConfigurationObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in ManagedConfigurationService.SubscribeToManagedConfiguration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationService::Name_);
  message.set_method_name("SubscribeToManagedConfiguration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder {
 public:
  static ManagedConfigurationService::GetManagedConfigurationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder> proxy(
        new ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ManagedConfigurationService::GetManagedConfigurationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const absl::optional<base::flat_map<std::string, std::string>>& in_configurations);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder);
};

bool ManagedConfigurationService_GetManagedConfiguration_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ManagedConfigurationService::GetManagedConfigurationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<base::flat_map<std::string, std::string>> p_configurations{};
  ManagedConfigurationService_GetManagedConfiguration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfigurations(&p_configurations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManagedConfigurationService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_configurations));
  return true;
}

void ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder::Run(
    const absl::optional<base::flat_map<std::string, std::string>>& in_configurations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ManagedConfigurationService::GetManagedConfigurationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configurations"), in_configurations,
                        "<value of type const absl::optional<base::flat_map<std::string, std::string>>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kManagedConfigurationService_GetManagedConfiguration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configurations)::BaseType>
      configurations_fragment(params.message());
  const mojo::internal::ContainerValidateParams configurations_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_configurations, configurations_fragment, &configurations_validate_params);
  params->configurations.Set(
      configurations_fragment.is_null() ? nullptr : configurations_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ManagedConfigurationService::GetManagedConfigurationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManagedConfigurationService::Name_);
  message.set_method_name("GetManagedConfiguration");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ManagedConfigurationServiceStubDispatch::Accept(
    ManagedConfigurationService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kManagedConfigurationService_GetManagedConfiguration_Name: {
      break;
    }
    case internal::kManagedConfigurationService_SubscribeToManagedConfiguration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ManagedConfigurationService::SubscribeToManagedConfiguration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ManagedConfigurationService::SubscribeToManagedConfiguration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data* params =
          reinterpret_cast<internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<ManagedConfigurationObserver> p_observer{};
      ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManagedConfigurationService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToManagedConfiguration(
std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool ManagedConfigurationServiceStubDispatch::AcceptWithResponder(
    ManagedConfigurationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kManagedConfigurationService_GetManagedConfiguration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ManagedConfigurationService::GetManagedConfiguration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ManagedConfigurationService::GetManagedConfiguration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data* params =
          reinterpret_cast<
              internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_keys{};
      ManagedConfigurationService_GetManagedConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManagedConfigurationService::Name_, 0, false);
        return false;
      }
      ManagedConfigurationService::GetManagedConfigurationCallback callback =
          ManagedConfigurationService_GetManagedConfiguration_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetManagedConfiguration(
std::move(p_keys), std::move(callback));
      return true;
    }
    case internal::kManagedConfigurationService_SubscribeToManagedConfiguration_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kManagedConfigurationServiceValidationInfo[] = {
    {&internal::ManagedConfigurationService_GetManagedConfiguration_Params_Data::Validate,
     &internal::ManagedConfigurationService_GetManagedConfiguration_ResponseParams_Data::Validate},
    {&internal::ManagedConfigurationService_SubscribeToManagedConfiguration_Params_Data::Validate,
     nullptr /* no response */},
};

bool ManagedConfigurationServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ManagedConfigurationService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kManagedConfigurationServiceValidationInfo);
}

bool ManagedConfigurationServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ManagedConfigurationService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kManagedConfigurationServiceValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

// static
bool UnionTraits<::blink::mojom::DeviceAttributeResult::DataView, ::blink::mojom::DeviceAttributeResultPtr>::Read(
    ::blink::mojom::DeviceAttributeResult::DataView input,
    ::blink::mojom::DeviceAttributeResultPtr* output) {
  using UnionType = ::blink::mojom::DeviceAttributeResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ERROR_MESSAGE: {
      std::string result_error_message;
      if (!input.ReadErrorMessage(&result_error_message))
        return false;

      *output = UnionType::NewErrorMessage(
          std::move(result_error_message));
      break;
    }
    case Tag::ATTRIBUTE: {
      absl::optional<std::string> result_attribute;
      if (!input.ReadAttribute(&result_attribute))
        return false;

      *output = UnionType::NewAttribute(
          std::move(result_attribute));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif