// third_party/blink/public/mojom/devtools/console_message.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/console_message.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* ConsoleMessageLevelToStringHelper(ConsoleMessageLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConsoleMessageLevel::kVerbose:
      return "kVerbose";
    case ConsoleMessageLevel::kInfo:
      return "kInfo";
    case ConsoleMessageLevel::kWarning:
      return "kWarning";
    case ConsoleMessageLevel::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string ConsoleMessageLevelToString(ConsoleMessageLevel value) {
  const char *str = ConsoleMessageLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConsoleMessageLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConsoleMessageLevel value) {
  return os << ConsoleMessageLevelToString(value);
}

static NOINLINE const char* ConsoleMessageSourceToStringHelper(ConsoleMessageSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConsoleMessageSource::kXml:
      return "kXml";
    case ConsoleMessageSource::kJavaScript:
      return "kJavaScript";
    case ConsoleMessageSource::kNetwork:
      return "kNetwork";
    case ConsoleMessageSource::kConsoleApi:
      return "kConsoleApi";
    case ConsoleMessageSource::kStorage:
      return "kStorage";
    case ConsoleMessageSource::kAppCache:
      return "kAppCache";
    case ConsoleMessageSource::kRendering:
      return "kRendering";
    case ConsoleMessageSource::kSecurity:
      return "kSecurity";
    case ConsoleMessageSource::kOther:
      return "kOther";
    case ConsoleMessageSource::kDeprecation:
      return "kDeprecation";
    case ConsoleMessageSource::kWorker:
      return "kWorker";
    case ConsoleMessageSource::kViolation:
      return "kViolation";
    case ConsoleMessageSource::kIntervention:
      return "kIntervention";
    case ConsoleMessageSource::kRecommendation:
      return "kRecommendation";
    default:
      return nullptr;
  }
}

std::string ConsoleMessageSourceToString(ConsoleMessageSource value) {
  const char *str = ConsoleMessageSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConsoleMessageSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConsoleMessageSource value) {
  return os << ConsoleMessageSourceToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ConsoleMessageLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ConsoleMessageLevel value) {
  return std::move(context).WriteString(::blink::mojom::ConsoleMessageLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ConsoleMessageSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ConsoleMessageSource value) {
  return std::move(context).WriteString(::blink::mojom::ConsoleMessageSourceToString(value));
}

} // namespace perfetto
