// third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-params-data.h"
namespace payments {
namespace mojom {

static NOINLINE const char* BillingResponseCodeToStringHelper(BillingResponseCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BillingResponseCode::kOk:
      return "kOk";
    case BillingResponseCode::kError:
      return "kError";
    case BillingResponseCode::kItemAlreadyOwned:
      return "kItemAlreadyOwned";
    case BillingResponseCode::kItemNotOwned:
      return "kItemNotOwned";
    case BillingResponseCode::kItemUnavailable:
      return "kItemUnavailable";
    case BillingResponseCode::kClientAppUnavailable:
      return "kClientAppUnavailable";
    case BillingResponseCode::kClientAppError:
      return "kClientAppError";
    default:
      return nullptr;
  }
}

std::string BillingResponseCodeToString(BillingResponseCode value) {
  const char *str = BillingResponseCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BillingResponseCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BillingResponseCode value) {
  return os << BillingResponseCodeToString(value);
}

static NOINLINE const char* CreateDigitalGoodsResponseCodeToStringHelper(CreateDigitalGoodsResponseCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateDigitalGoodsResponseCode::kOk:
      return "kOk";
    case CreateDigitalGoodsResponseCode::kError:
      return "kError";
    case CreateDigitalGoodsResponseCode::kUnsupportedPaymentMethod:
      return "kUnsupportedPaymentMethod";
    case CreateDigitalGoodsResponseCode::kUnsupportedContext:
      return "kUnsupportedContext";
    default:
      return nullptr;
  }
}

std::string CreateDigitalGoodsResponseCodeToString(CreateDigitalGoodsResponseCode value) {
  const char *str = CreateDigitalGoodsResponseCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateDigitalGoodsResponseCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateDigitalGoodsResponseCode value) {
  return os << CreateDigitalGoodsResponseCodeToString(value);
}

static NOINLINE const char* PurchaseStateToStringHelper(PurchaseState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PurchaseState::kUnknown:
      return "kUnknown";
    case PurchaseState::kPurchased:
      return "kPurchased";
    case PurchaseState::kPending:
      return "kPending";
    default:
      return nullptr;
  }
}

std::string PurchaseStateToString(PurchaseState value) {
  const char *str = PurchaseStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PurchaseState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PurchaseState value) {
  return os << PurchaseStateToString(value);
}

namespace internal {


// static
bool ItemDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ItemDetails_Data* object = static_cast<const ItemDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams item_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->item_id, validation_context,
                                         &item_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams title_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->price, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->price, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams subscription_period_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->subscription_period, validation_context,
                                         &subscription_period_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams free_trial_period_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->free_trial_period, validation_context,
                                         &free_trial_period_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->introductory_price, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams introductory_price_period_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->introductory_price_period, validation_context,
                                         &introductory_price_period_validate_params)) {
    return false;
  }

  return true;
}

ItemDetails_Data::ItemDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PurchaseDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PurchaseDetails_Data* object = static_cast<const PurchaseDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams item_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->item_id, validation_context,
                                         &item_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purchase_token, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams purchase_token_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->purchase_token, validation_context,
                                         &purchase_token_validate_params)) {
    return false;
  }


  if (!::payments::mojom::internal::PurchaseState_Data
        ::Validate(object->purchase_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purchase_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->purchase_time, validation_context))
    return false;

  return true;
}

PurchaseDetails_Data::PurchaseDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_GetDetails_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_GetDetails_Params_Data* object = static_cast<const DigitalGoods_GetDetails_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams item_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->item_ids, validation_context,
                                         &item_ids_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoods_GetDetails_Params_Data::DigitalGoods_GetDetails_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_GetDetails_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_GetDetails_ResponseParams_Data* object = static_cast<const DigitalGoods_GetDetails_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::BillingResponseCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_details_list, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams item_details_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->item_details_list, validation_context,
                                         &item_details_list_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoods_GetDetails_ResponseParams_Data::DigitalGoods_GetDetails_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_Acknowledge_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_Acknowledge_Params_Data* object = static_cast<const DigitalGoods_Acknowledge_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purchase_token, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams purchase_token_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->purchase_token, validation_context,
                                         &purchase_token_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoods_Acknowledge_Params_Data::DigitalGoods_Acknowledge_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_Acknowledge_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_Acknowledge_ResponseParams_Data* object = static_cast<const DigitalGoods_Acknowledge_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::BillingResponseCode_Data
        ::Validate(object->code, validation_context))
    return false;

  return true;
}

DigitalGoods_Acknowledge_ResponseParams_Data::DigitalGoods_Acknowledge_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_ListPurchases_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_ListPurchases_Params_Data* object = static_cast<const DigitalGoods_ListPurchases_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DigitalGoods_ListPurchases_Params_Data::DigitalGoods_ListPurchases_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoods_ListPurchases_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoods_ListPurchases_ResponseParams_Data* object = static_cast<const DigitalGoods_ListPurchases_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::BillingResponseCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purchase_details_list, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams purchase_details_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->purchase_details_list, validation_context,
                                         &purchase_details_list_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoods_ListPurchases_ResponseParams_Data::DigitalGoods_ListPurchases_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoodsFactory_CreateDigitalGoods_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoodsFactory_CreateDigitalGoods_Params_Data* object = static_cast<const DigitalGoodsFactory_CreateDigitalGoods_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->payment_method, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams payment_method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->payment_method, validation_context,
                                         &payment_method_validate_params)) {
    return false;
  }

  return true;
}

DigitalGoodsFactory_CreateDigitalGoods_Params_Data::DigitalGoodsFactory_CreateDigitalGoods_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data* object = static_cast<const DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::payments::mojom::internal::CreateDigitalGoodsResponseCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->digital_goods,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace payments

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::BillingResponseCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::BillingResponseCode value) {
  return std::move(context).WriteString(::payments::mojom::BillingResponseCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::CreateDigitalGoodsResponseCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::CreateDigitalGoodsResponseCode value) {
  return std::move(context).WriteString(::payments::mojom::CreateDigitalGoodsResponseCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PurchaseState>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PurchaseState value) {
  return std::move(context).WriteString(::payments::mojom::PurchaseStateToString(value));
}

} // namespace perfetto
