// third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-params-data.h"
#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char DomStorageProvider::Name_[] = "blink.mojom.DomStorageProvider";

DomStorageProviderProxy::DomStorageProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DomStorageProviderProxy::BindDomStorage(
    ::mojo::PendingReceiver<DomStorage> in_receiver, ::mojo::PendingRemote<DomStorageClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DomStorageProvider::BindDomStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<DomStorage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DomStorageClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDomStorageProvider_BindDomStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorageProvider_BindDomStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DomStorageInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DomStorageProvider.BindDomStorage request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DomStorageClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in DomStorageProvider.BindDomStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorageProvider::Name_);
  message.set_method_name("BindDomStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DomStorageProviderStubDispatch::Accept(
    DomStorageProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDomStorageProvider_BindDomStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DomStorageProvider::BindDomStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DomStorageProvider::BindDomStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DomStorageProvider_BindDomStorage_Params_Data* params =
          reinterpret_cast<internal::DomStorageProvider_BindDomStorage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<DomStorage> p_receiver{};
      ::mojo::PendingRemote<DomStorageClient> p_client{};
      DomStorageProvider_BindDomStorage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorageProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDomStorage(
std::move(p_receiver), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool DomStorageProviderStubDispatch::AcceptWithResponder(
    DomStorageProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDomStorageProvider_BindDomStorage_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDomStorageProviderValidationInfo[] = {
    {internal::kDomStorageProvider_BindDomStorage_Name,
     {&internal::DomStorageProvider_BindDomStorage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DomStorageProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DomStorageProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDomStorageProviderValidationInfo);
}

const char DomStorage::Name_[] = "blink.mojom.DomStorage";

DomStorageProxy::DomStorageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DomStorageProxy::OpenLocalStorage(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> in_area) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DomStorage::OpenLocalStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("area"), in_area,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDomStorage_OpenLocalStorage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorage_OpenLocalStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in DomStorage.OpenLocalStorage request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
      in_area, &params->area, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->area),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid area in DomStorage.OpenLocalStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorage::Name_);
  message.set_method_name("OpenLocalStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DomStorageProxy::BindSessionStorageNamespace(
    const WTF::String& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DomStorage::BindSessionStorageNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDomStorage_BindSessionStorageNamespace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorage_BindSessionStorageNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id, namespace_id_fragment);
  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in DomStorage.BindSessionStorageNamespace request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SessionStorageNamespaceInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DomStorage.BindSessionStorageNamespace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorage::Name_);
  message.set_method_name("BindSessionStorageNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DomStorageProxy::BindSessionStorageArea(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const WTF::String& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> in_session_namespace) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DomStorage::BindSessionStorageArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_namespace"), in_session_namespace,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDomStorage_BindSessionStorageArea_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorage_BindSessionStorageArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in DomStorage.BindSessionStorageArea request");
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id, namespace_id_fragment);
  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->namespace_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in DomStorage.BindSessionStorageArea request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
      in_session_namespace, &params->session_namespace, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->session_namespace),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid session_namespace in DomStorage.BindSessionStorageArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorage::Name_);
  message.set_method_name("BindSessionStorageArea");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DomStorageStubDispatch::Accept(
    DomStorage* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDomStorage_OpenLocalStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DomStorage::OpenLocalStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DomStorage::OpenLocalStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DomStorage_OpenLocalStorage_Params_Data* params =
          reinterpret_cast<internal::DomStorage_OpenLocalStorage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> p_area{};
      DomStorage_OpenLocalStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success) {
        p_area =
            input_data_view.TakeArea<decltype(p_area)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenLocalStorage(
std::move(p_origin), 
std::move(p_area));
      return true;
    }
    case internal::kDomStorage_BindSessionStorageNamespace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DomStorage::BindSessionStorageNamespace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DomStorage::BindSessionStorageNamespace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DomStorage_BindSessionStorageNamespace_Params_Data* params =
          reinterpret_cast<internal::DomStorage_BindSessionStorageNamespace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace> p_receiver{};
      DomStorage_BindSessionStorageNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSessionStorageNamespace(
std::move(p_namespace_id), 
std::move(p_receiver));
      return true;
    }
    case internal::kDomStorage_BindSessionStorageArea_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DomStorage::BindSessionStorageArea",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DomStorage::BindSessionStorageArea");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DomStorage_BindSessionStorageArea_Params_Data* params =
          reinterpret_cast<internal::DomStorage_BindSessionStorageArea_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      WTF::String p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> p_session_namespace{};
      DomStorage_BindSessionStorageArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_session_namespace =
            input_data_view.TakeSessionNamespace<decltype(p_session_namespace)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSessionStorageArea(
std::move(p_origin), 
std::move(p_namespace_id), 
std::move(p_session_namespace));
      return true;
    }
  }
  return false;
}

// static
bool DomStorageStubDispatch::AcceptWithResponder(
    DomStorage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDomStorage_OpenLocalStorage_Name: {
      break;
    }
    case internal::kDomStorage_BindSessionStorageNamespace_Name: {
      break;
    }
    case internal::kDomStorage_BindSessionStorageArea_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDomStorageValidationInfo[] = {
    {internal::kDomStorage_OpenLocalStorage_Name,
     {&internal::DomStorage_OpenLocalStorage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDomStorage_BindSessionStorageNamespace_Name,
     {&internal::DomStorage_BindSessionStorageNamespace_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDomStorage_BindSessionStorageArea_Name,
     {&internal::DomStorage_BindSessionStorageArea_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DomStorageRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DomStorage::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDomStorageValidationInfo);
}

const char DomStorageClient::Name_[] = "blink.mojom.DomStorageClient";

DomStorageClientProxy::DomStorageClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DomStorageClientProxy::ResetStorageAreaAndNamespaceConnections(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::DomStorageClient::ResetStorageAreaAndNamespaceConnections");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDomStorageClient_ResetStorageAreaAndNamespaceConnections_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorageClient_ResetStorageAreaAndNamespaceConnections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorageClient::Name_);
  message.set_method_name("ResetStorageAreaAndNamespaceConnections");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DomStorageClientStubDispatch::Accept(
    DomStorageClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDomStorageClient_ResetStorageAreaAndNamespaceConnections_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DomStorageClient::ResetStorageAreaAndNamespaceConnections",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DomStorageClient::ResetStorageAreaAndNamespaceConnections");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DomStorageClient_ResetStorageAreaAndNamespaceConnections_Params_Data* params =
          reinterpret_cast<internal::DomStorageClient_ResetStorageAreaAndNamespaceConnections_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DomStorageClient_ResetStorageAreaAndNamespaceConnections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorageClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetStorageAreaAndNamespaceConnections();
      return true;
    }
  }
  return false;
}

// static
bool DomStorageClientStubDispatch::AcceptWithResponder(
    DomStorageClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDomStorageClient_ResetStorageAreaAndNamespaceConnections_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDomStorageClientValidationInfo[] = {
    {internal::kDomStorageClient_ResetStorageAreaAndNamespaceConnections_Name,
     {&internal::DomStorageClient_ResetStorageAreaAndNamespaceConnections_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DomStorageClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DomStorageClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDomStorageClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif