// third_party/blink/public/mojom/feature_observer/feature_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/feature_observer/feature_observer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/feature_observer/feature_observer.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* ObservedFeatureTypeToStringHelper(ObservedFeatureType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ObservedFeatureType::kWebLock:
      return "kWebLock";
    case ObservedFeatureType::kIndexedDBConnection:
      return "kIndexedDBConnection";
    default:
      return nullptr;
  }
}

std::string ObservedFeatureTypeToString(ObservedFeatureType value) {
  const char *str = ObservedFeatureTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ObservedFeatureType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ObservedFeatureType value) {
  return os << ObservedFeatureTypeToString(value);
}

namespace internal {


// static
bool FeatureObserver_Register_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FeatureObserver_Register_Params_Data* object = static_cast<const FeatureObserver_Register_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->feature, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->feature,
                                                 validation_context)) {
    return false;
  }


  if (!::blink::mojom::internal::ObservedFeatureType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

FeatureObserver_Register_Params_Data::FeatureObserver_Register_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ObservedFeatureType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ObservedFeatureType value) {
  return std::move(context).WriteString(::blink::mojom::ObservedFeatureTypeToString(value));
}

} // namespace perfetto
