// third_party/blink/public/mojom/font_access/font_access.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/font_access/font_access.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-params-data.h"
#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
FontMetadata::FontMetadata()
    : postscript_name(),
      full_name(),
      family(),
      style(),
      italic(),
      stretch(),
      weight() {}

FontMetadata::FontMetadata(
    const WTF::String& postscript_name_in,
    const WTF::String& full_name_in,
    const WTF::String& family_in,
    const WTF::String& style_in,
    bool italic_in,
    float stretch_in,
    float weight_in)
    : postscript_name(std::move(postscript_name_in)),
      full_name(std::move(full_name_in)),
      family(std::move(family_in)),
      style(std::move(style_in)),
      italic(std::move(italic_in)),
      stretch(std::move(stretch_in)),
      weight(std::move(weight_in)) {}

FontMetadata::~FontMetadata() = default;
size_t FontMetadata::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->postscript_name);
  seed = mojo::internal::WTFHash(seed, this->full_name);
  seed = mojo::internal::WTFHash(seed, this->family);
  seed = mojo::internal::WTFHash(seed, this->style);
  seed = mojo::internal::WTFHash(seed, this->italic);
  seed = mojo::internal::WTFHash(seed, this->stretch);
  seed = mojo::internal::WTFHash(seed, this->weight);
  return seed;
}

void FontMetadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "postscript_name"), this->postscript_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "full_name"), this->full_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "family"), this->family,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style"), this->style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "italic"), this->italic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stretch"), this->stretch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight"), this->weight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FontMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char FontAccessManager::Name_[] = "blink.mojom.FontAccessManager";

class FontAccessManager_EnumerateLocalFonts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontAccessManager_EnumerateLocalFonts_ForwardToCallback(
      FontAccessManager::EnumerateLocalFontsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FontAccessManager::EnumerateLocalFontsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FontAccessManager_EnumerateLocalFonts_ForwardToCallback);
};

class FontAccessManager_ChooseLocalFonts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontAccessManager_ChooseLocalFonts_ForwardToCallback(
      FontAccessManager::ChooseLocalFontsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FontAccessManager::ChooseLocalFontsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FontAccessManager_ChooseLocalFonts_ForwardToCallback);
};

FontAccessManagerProxy::FontAccessManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FontAccessManagerProxy::EnumerateLocalFonts(
    EnumerateLocalFontsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FontAccessManager::EnumerateLocalFonts");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFontAccessManager_EnumerateLocalFonts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FontAccessManager_EnumerateLocalFonts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("EnumerateLocalFonts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontAccessManager_EnumerateLocalFonts_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FontAccessManagerProxy::ChooseLocalFonts(
    const WTF::Vector<WTF::String>& in_selection, ChooseLocalFontsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FontAccessManager::ChooseLocalFonts", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection"), in_selection,
                        "<value of type const WTF::Vector<WTF::String>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFontAccessManager_ChooseLocalFonts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FontAccessManager_ChooseLocalFonts_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selection)::BaseType>
      selection_fragment(params.message());
  const mojo::internal::ContainerValidateParams selection_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_selection, selection_fragment, &selection_validate_params);
  params->selection.Set(
      selection_fragment.is_null() ? nullptr : selection_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->selection.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selection in FontAccessManager.ChooseLocalFonts request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("ChooseLocalFonts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontAccessManager_ChooseLocalFonts_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FontAccessManager_EnumerateLocalFonts_ProxyToResponder {
 public:
  static FontAccessManager::EnumerateLocalFontsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FontAccessManager_EnumerateLocalFonts_ProxyToResponder> proxy(
        new FontAccessManager_EnumerateLocalFonts_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FontAccessManager_EnumerateLocalFonts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontAccessManager_EnumerateLocalFonts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FontAccessManager_EnumerateLocalFonts_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FontAccessManager::EnumerateLocalFontsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      FontEnumerationStatus in_enumeration_status, ::base::ReadOnlySharedMemoryRegion in_enumeration_table);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FontAccessManager_EnumerateLocalFonts_ProxyToResponder);
};

bool FontAccessManager_EnumerateLocalFonts_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FontAccessManager::EnumerateLocalFontsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  FontEnumerationStatus p_enumeration_status{};
  ::base::ReadOnlySharedMemoryRegion p_enumeration_table{};
  FontAccessManager_EnumerateLocalFonts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEnumerationStatus(&p_enumeration_status))
    success = false;
  if (success && !input_data_view.ReadEnumerationTable(&p_enumeration_table))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontAccessManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_enumeration_status), 
std::move(p_enumeration_table));
  return true;
}

void FontAccessManager_EnumerateLocalFonts_ProxyToResponder::Run(
    FontEnumerationStatus in_enumeration_status, ::base::ReadOnlySharedMemoryRegion in_enumeration_table) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFontsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enumeration_status"), in_enumeration_status,
                        "<value of type FontEnumerationStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enumeration_table"), in_enumeration_table,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFontAccessManager_EnumerateLocalFonts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FontEnumerationStatus>(
      in_enumeration_status, &params->enumeration_status);
  mojo::internal::MessageFragment<
      typename decltype(params->enumeration_table)::BaseType> enumeration_table_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_enumeration_table, enumeration_table_fragment);
  params->enumeration_table.Set(
      enumeration_table_fragment.is_null() ? nullptr : enumeration_table_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFontsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("EnumerateLocalFonts");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FontAccessManager_ChooseLocalFonts_ProxyToResponder {
 public:
  static FontAccessManager::ChooseLocalFontsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FontAccessManager_ChooseLocalFonts_ProxyToResponder> proxy(
        new FontAccessManager_ChooseLocalFonts_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FontAccessManager_ChooseLocalFonts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontAccessManager_ChooseLocalFonts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FontAccessManager_ChooseLocalFonts_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FontAccessManager::ChooseLocalFontsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      FontEnumerationStatus in_status, WTF::Vector<FontMetadataPtr> in_chosen_fonts);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FontAccessManager_ChooseLocalFonts_ProxyToResponder);
};

bool FontAccessManager_ChooseLocalFonts_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FontAccessManager::ChooseLocalFontsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FontAccessManager_ChooseLocalFonts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontAccessManager_ChooseLocalFonts_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  FontEnumerationStatus p_status{};
  WTF::Vector<FontMetadataPtr> p_chosen_fonts{};
  FontAccessManager_ChooseLocalFonts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadChosenFonts(&p_chosen_fonts))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontAccessManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_chosen_fonts));
  return true;
}

void FontAccessManager_ChooseLocalFonts_ProxyToResponder::Run(
    FontEnumerationStatus in_status, WTF::Vector<FontMetadataPtr> in_chosen_fonts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FontAccessManager::ChooseLocalFontsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type FontEnumerationStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("chosen_fonts"), in_chosen_fonts,
                        "<value of type WTF::Vector<FontMetadataPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFontAccessManager_ChooseLocalFonts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FontAccessManager_ChooseLocalFonts_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FontEnumerationStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->chosen_fonts)::BaseType>
      chosen_fonts_fragment(params.message());
  const mojo::internal::ContainerValidateParams chosen_fonts_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FontMetadataDataView>>(
      in_chosen_fonts, chosen_fonts_fragment, &chosen_fonts_validate_params);
  params->chosen_fonts.Set(
      chosen_fonts_fragment.is_null() ? nullptr : chosen_fonts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->chosen_fonts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null chosen_fonts in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FontAccessManager::ChooseLocalFontsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("ChooseLocalFonts");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FontAccessManagerStubDispatch::Accept(
    FontAccessManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFontAccessManager_EnumerateLocalFonts_Name: {
      break;
    }
    case internal::kFontAccessManager_ChooseLocalFonts_Name: {
      break;
    }
  }
  return false;
}

// static
bool FontAccessManagerStubDispatch::AcceptWithResponder(
    FontAccessManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFontAccessManager_EnumerateLocalFonts_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFonts",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FontAccessManager::EnumerateLocalFonts");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FontAccessManager_EnumerateLocalFonts_Params_Data* params =
          reinterpret_cast<
              internal::FontAccessManager_EnumerateLocalFonts_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FontAccessManager_EnumerateLocalFonts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontAccessManager::Name_, 0, false);
        return false;
      }
      FontAccessManager::EnumerateLocalFontsCallback callback =
          FontAccessManager_EnumerateLocalFonts_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateLocalFonts(std::move(callback));
      return true;
    }
    case internal::kFontAccessManager_ChooseLocalFonts_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FontAccessManager::ChooseLocalFonts",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FontAccessManager::ChooseLocalFonts");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FontAccessManager_ChooseLocalFonts_Params_Data* params =
          reinterpret_cast<
              internal::FontAccessManager_ChooseLocalFonts_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<WTF::String> p_selection{};
      FontAccessManager_ChooseLocalFonts_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSelection(&p_selection))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontAccessManager::Name_, 1, false);
        return false;
      }
      FontAccessManager::ChooseLocalFontsCallback callback =
          FontAccessManager_ChooseLocalFonts_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChooseLocalFonts(
std::move(p_selection), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFontAccessManagerValidationInfo[] = {
    {&internal::FontAccessManager_EnumerateLocalFonts_Params_Data::Validate,
     &internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::Validate},
    {&internal::FontAccessManager_ChooseLocalFonts_Params_Data::Validate,
     &internal::FontAccessManager_ChooseLocalFonts_ResponseParams_Data::Validate},
};

bool FontAccessManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FontAccessManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFontAccessManagerValidationInfo);
}

bool FontAccessManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FontAccessManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFontAccessManagerValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::FontMetadata::DataView, ::blink::mojom::blink::FontMetadataPtr>::Read(
    ::blink::mojom::blink::FontMetadata::DataView input,
    ::blink::mojom::blink::FontMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FontMetadataPtr result(::blink::mojom::blink::FontMetadata::New());
  
      if (success && !input.ReadPostscriptName(&result->postscript_name))
        success = false;
      if (success && !input.ReadFullName(&result->full_name))
        success = false;
      if (success && !input.ReadFamily(&result->family))
        success = false;
      if (success && !input.ReadStyle(&result->style))
        success = false;
      if (success)
        result->italic = input.italic();
      if (success)
        result->stretch = input.stretch();
      if (success)
        result->weight = input.weight();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif