// third_party/blink/public/mojom/frame/frame.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/frame.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* PluginActionTypeToStringHelper(PluginActionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PluginActionType::kRotate90Clockwise:
      return "kRotate90Clockwise";
    case PluginActionType::kRotate90Counterclockwise:
      return "kRotate90Counterclockwise";
    default:
      return nullptr;
  }
}

std::string PluginActionTypeToString(PluginActionType value) {
  const char *str = PluginActionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PluginActionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PluginActionType value) {
  return os << PluginActionTypeToString(value);
}

namespace internal {


// static
bool SavableSubframe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SavableSubframe_Data* object = static_cast<const SavableSubframe_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->subframe_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->subframe_token, validation_context))
    return false;

  return true;
}

SavableSubframe_Data::SavableSubframe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetSavableResourceLinksReply_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GetSavableResourceLinksReply_Data* object = static_cast<const GetSavableResourceLinksReply_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resources_list, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resources_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resources_list, validation_context,
                                         &resources_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams subframes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->subframes, validation_context,
                                         &subframes_validate_params)) {
    return false;
  }

  return true;
}

GetSavableResourceLinksReply_Data::GetSavableResourceLinksReply_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPageResultAXParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FindInPageResultAXParams_Data* object = static_cast<const FindInPageResultAXParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FindInPageResultAXParams_Data::FindInPageResultAXParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DownloadURLParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DownloadURLParams_Data* object = static_cast<const DownloadURLParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->suggested_name, validation_context))
    return false;


  if (!::network::mojom::internal::RedirectMode_Data
        ::Validate(object->cross_origin_redirects, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->blob_url_token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->data_url_blob,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DownloadURLParams_Data::DownloadURLParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OpenURLParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const OpenURLParams_Data* object = static_cast<const OpenURLParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->post_body, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_headers, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extra_headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extra_headers, validation_context,
                                         &extra_headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::ui::mojom::internal::WindowOpenDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;


  if (!::blink::mojom::internal::TriggeringEventInfo_Data
        ::Validate(object->triggering_event_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->blob_url_token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->href_translate, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams href_translate_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->href_translate, validation_context,
                                         &href_translate_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->impression, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->download_policy, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->download_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->initiator_policy_container_keep_alive_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OpenURLParams_Data::OpenURLParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data* object = static_cast<const KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->keep_alive_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->keep_alive_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data::KeepAliveHandleFactory_IssueKeepAliveHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnterFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_EnterFullscreen_Params_Data* object = static_cast<const LocalFrameHost_EnterFullscreen_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

LocalFrameHost_EnterFullscreen_Params_Data::LocalFrameHost_EnterFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnterFullscreen_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_EnterFullscreen_ResponseParams_Data* object = static_cast<const LocalFrameHost_EnterFullscreen_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_EnterFullscreen_ResponseParams_Data::LocalFrameHost_EnterFullscreen_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ExitFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_ExitFullscreen_Params_Data* object = static_cast<const LocalFrameHost_ExitFullscreen_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_ExitFullscreen_Params_Data::LocalFrameHost_ExitFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_FullscreenStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_FullscreenStateChanged_Params_Data* object = static_cast<const LocalFrameHost_FullscreenStateChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

LocalFrameHost_FullscreenStateChanged_Params_Data::LocalFrameHost_FullscreenStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RegisterProtocolHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RegisterProtocolHandler_Params_Data* object = static_cast<const LocalFrameHost_RegisterProtocolHandler_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams scheme_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrameHost_RegisterProtocolHandler_Params_Data::LocalFrameHost_RegisterProtocolHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UnregisterProtocolHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_UnregisterProtocolHandler_Params_Data* object = static_cast<const LocalFrameHost_UnregisterProtocolHandler_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams scheme_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrameHost_UnregisterProtocolHandler_Params_Data::LocalFrameHost_UnregisterProtocolHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidDisplayInsecureContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidDisplayInsecureContent_Params_Data* object = static_cast<const LocalFrameHost_DidDisplayInsecureContent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidDisplayInsecureContent_Params_Data::LocalFrameHost_DidDisplayInsecureContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidContainInsecureFormAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidContainInsecureFormAction_Params_Data* object = static_cast<const LocalFrameHost_DidContainInsecureFormAction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidContainInsecureFormAction_Params_Data::LocalFrameHost_DidContainInsecureFormAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DocumentAvailableInMainFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DocumentAvailableInMainFrame_Params_Data* object = static_cast<const LocalFrameHost_DocumentAvailableInMainFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DocumentAvailableInMainFrame_Params_Data::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_SetNeedsOcclusionTracking_Params_Data* object = static_cast<const LocalFrameHost_SetNeedsOcclusionTracking_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data* object = static_cast<const LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_VisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_VisibilityChanged_Params_Data* object = static_cast<const LocalFrameHost_VisibilityChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FrameVisibility_Data
        ::Validate(object->visibility, validation_context))
    return false;

  return true;
}

LocalFrameHost_VisibilityChanged_Params_Data::LocalFrameHost_VisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeThemeColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeThemeColor_Params_Data* object = static_cast<const LocalFrameHost_DidChangeThemeColor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->theme_color, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeThemeColor_Params_Data::LocalFrameHost_DidChangeThemeColor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeBackgroundColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeBackgroundColor_Params_Data* object = static_cast<const LocalFrameHost_DidChangeBackgroundColor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeBackgroundColor_Params_Data::LocalFrameHost_DidChangeBackgroundColor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidFailLoadWithError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidFailLoadWithError_Params_Data* object = static_cast<const LocalFrameHost_DidFailLoadWithError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidFailLoadWithError_Params_Data::LocalFrameHost_DidFailLoadWithError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidFocusFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidFocusFrame_Params_Data* object = static_cast<const LocalFrameHost_DidFocusFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidFocusFrame_Params_Data::LocalFrameHost_DidFocusFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidCallFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidCallFocus_Params_Data* object = static_cast<const LocalFrameHost_DidCallFocus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidCallFocus_Params_Data::LocalFrameHost_DidCallFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data* object = static_cast<const LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::InsecureRequestPolicy_Data
        ::Validate(object->policy_bitmap, validation_context))
    return false;

  return true;
}

LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data* object = static_cast<const LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->set, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams set_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->set, validation_context,
                                         &set_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data* object = static_cast<const LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data* object = static_cast<const LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::SuddenTerminationDisablerType_Data
        ::Validate(object->disabler_type, validation_context))
    return false;

  return true;
}

LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data* object = static_cast<const LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data* object = static_cast<const LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect_to_scroll, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect_to_scroll, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data* object = static_cast<const LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ScrollDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::ui::mojom::internal::ScrollGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidAccessInitialDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidAccessInitialDocument_Params_Data* object = static_cast<const LocalFrameHost_DidAccessInitialDocument_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidAccessInitialDocument_Params_Data::LocalFrameHost_DidAccessInitialDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidBlockNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidBlockNavigation_Params_Data* object = static_cast<const LocalFrameHost_DidBlockNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initiator_url, validation_context))
    return false;


  if (!::blink::mojom::internal::NavigationBlockedReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidBlockNavigation_Params_Data::LocalFrameHost_DidBlockNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeLoadProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeLoadProgress_Params_Data* object = static_cast<const LocalFrameHost_DidChangeLoadProgress_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidChangeLoadProgress_Params_Data::LocalFrameHost_DidChangeLoadProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidFinishLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidFinishLoad_Params_Data* object = static_cast<const LocalFrameHost_DidFinishLoad_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->validated_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->validated_url, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidFinishLoad_Params_Data::LocalFrameHost_DidFinishLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DispatchLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DispatchLoad_Params_Data* object = static_cast<const LocalFrameHost_DispatchLoad_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DispatchLoad_Params_Data::LocalFrameHost_DispatchLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_GoToEntryAtOffset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_GoToEntryAtOffset_Params_Data* object = static_cast<const LocalFrameHost_GoToEntryAtOffset_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_GoToEntryAtOffset_Params_Data::LocalFrameHost_GoToEntryAtOffset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_NavigateToAppHistoryKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_NavigateToAppHistoryKey_Params_Data* object = static_cast<const LocalFrameHost_NavigateToAppHistoryKey_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_NavigateToAppHistoryKey_Params_Data::LocalFrameHost_NavigateToAppHistoryKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UpdateTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_UpdateTitle_Params_Data* object = static_cast<const LocalFrameHost_UpdateTitle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->title_direction, validation_context))
    return false;

  return true;
}

LocalFrameHost_UpdateTitle_Params_Data::LocalFrameHost_UpdateTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UpdateUserActivationState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_UpdateUserActivationState_Params_Data* object = static_cast<const LocalFrameHost_UpdateUserActivationState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::UserActivationUpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::blink::mojom::internal::UserActivationNotificationType_Data
        ::Validate(object->notification_type, validation_context))
    return false;

  return true;
}

LocalFrameHost_UpdateUserActivationState_Params_Data::LocalFrameHost_UpdateUserActivationState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data* object = static_cast<const LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data* object = static_cast<const LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DocumentOnLoadCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DocumentOnLoadCompleted_Params_Data* object = static_cast<const LocalFrameHost_DocumentOnLoadCompleted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DocumentOnLoadCompleted_Params_Data::LocalFrameHost_DocumentOnLoadCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ForwardResourceTimingToParent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_ForwardResourceTimingToParent_Params_Data* object = static_cast<const LocalFrameHost_ForwardResourceTimingToParent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  return true;
}

LocalFrameHost_ForwardResourceTimingToParent_Params_Data::LocalFrameHost_ForwardResourceTimingToParent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidFinishDocumentLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidFinishDocumentLoad_Params_Data* object = static_cast<const LocalFrameHost_DidFinishDocumentLoad_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_DidFinishDocumentLoad_Params_Data::LocalFrameHost_DidFinishDocumentLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalAlertDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunModalAlertDialog_Params_Data* object = static_cast<const LocalFrameHost_RunModalAlertDialog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->alert_message, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalAlertDialog_Params_Data::LocalFrameHost_RunModalAlertDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* object = static_cast<const LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalConfirmDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunModalConfirmDialog_Params_Data* object = static_cast<const LocalFrameHost_RunModalConfirmDialog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->alert_message, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalConfirmDialog_Params_Data::LocalFrameHost_RunModalConfirmDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* object = static_cast<const LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalPromptDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunModalPromptDialog_Params_Data* object = static_cast<const LocalFrameHost_RunModalPromptDialog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->alert_message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_value, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalPromptDialog_Params_Data::LocalFrameHost_RunModalPromptDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* object = static_cast<const LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunBeforeUnloadConfirm_Params_Data* object = static_cast<const LocalFrameHost_RunBeforeUnloadConfirm_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* object = static_cast<const LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_UpdateFaviconURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_UpdateFaviconURL_Params_Data* object = static_cast<const LocalFrameHost_UpdateFaviconURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon_urls, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams favicon_urls_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->favicon_urls, validation_context,
                                         &favicon_urls_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_UpdateFaviconURL_Params_Data::LocalFrameHost_UpdateFaviconURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DownloadURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DownloadURL_Params_Data* object = static_cast<const LocalFrameHost_DownloadURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_DownloadURL_Params_Data::LocalFrameHost_DownloadURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_FocusedElementChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_FocusedElementChanged_Params_Data* object = static_cast<const LocalFrameHost_FocusedElementChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds_in_frame_widget, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds_in_frame_widget, validation_context))
    return false;


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  return true;
}

LocalFrameHost_FocusedElementChanged_Params_Data::LocalFrameHost_FocusedElementChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_TextSelectionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_TextSelectionChanged_Params_Data* object = static_cast<const LocalFrameHost_TextSelectionChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

LocalFrameHost_TextSelectionChanged_Params_Data::LocalFrameHost_TextSelectionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ShowPopupMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_ShowPopupMenu_Params_Data* object = static_cast<const LocalFrameHost_ShowPopupMenu_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->popup_client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->popup_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->menu_items, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams menu_items_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->menu_items, validation_context,
                                         &menu_items_validate_params)) {
    return false;
  }

  return true;
}

LocalFrameHost_ShowPopupMenu_Params_Data::LocalFrameHost_ShowPopupMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_CreateNewPopupWidget_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_CreateNewPopupWidget_Params_Data* object = static_cast<const LocalFrameHost_CreateNewPopupWidget_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->popup_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->popup_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blink_widget_host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blink_widget_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->blink_widget, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->blink_widget,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrameHost_CreateNewPopupWidget_Params_Data::LocalFrameHost_CreateNewPopupWidget_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_ShowContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_ShowContextMenu_Params_Data* object = static_cast<const LocalFrameHost_ShowContextMenu_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

LocalFrameHost_ShowContextMenu_Params_Data::LocalFrameHost_ShowContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data* object = static_cast<const LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_method, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams http_method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->http_method, validation_context,
                                         &http_method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data* object = static_cast<const LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->child_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_owner_properties, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_owner_properties, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeOpener_Params_Data* object = static_cast<const LocalFrameHost_DidChangeOpener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->opener_frame, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeOpener_Params_Data::LocalFrameHost_DidChangeOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeFramePolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeFramePolicy_Params_Data* object = static_cast<const LocalFrameHost_DidChangeFramePolicy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->child_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeFramePolicy_Params_Data::LocalFrameHost_DidChangeFramePolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidChangeIframeAttributes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidChangeIframeAttributes_Params_Data* object = static_cast<const LocalFrameHost_DidChangeIframeAttributes_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->child_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parsed_csp_attribute, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidChangeIframeAttributes_Params_Data::LocalFrameHost_DidChangeIframeAttributes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data* object = static_cast<const LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->guid, validation_context))
    return false;

  return true;
}

LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_SetModalCloseListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_SetModalCloseListener_Params_Data* object = static_cast<const LocalFrameHost_SetModalCloseListener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrameHost_SetModalCloseListener_Params_Data::LocalFrameHost_SetModalCloseListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_Detach_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_Detach_Params_Data* object = static_cast<const LocalFrameHost_Detach_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrameHost_Detach_Params_Data::LocalFrameHost_Detach_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_GetKeepAliveHandleFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_GetKeepAliveHandleFactory_Params_Data* object = static_cast<const LocalFrameHost_GetKeepAliveHandleFactory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrameHost_GetKeepAliveHandleFactory_Params_Data::LocalFrameHost_GetKeepAliveHandleFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidAddMessageToConsole_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidAddMessageToConsole_Params_Data* object = static_cast<const LocalFrameHost_DidAddMessageToConsole_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ConsoleMessageLevel_Data
        ::Validate(object->log_level, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->msg, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->msg, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->untrusted_stack_trace, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidAddMessageToConsole_Params_Data::LocalFrameHost_DidAddMessageToConsole_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_FrameSizeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_FrameSizeChanged_Params_Data* object = static_cast<const LocalFrameHost_FrameSizeChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

LocalFrameHost_FrameSizeChanged_Params_Data::LocalFrameHost_FrameSizeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data* object = static_cast<const LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::PreferredColorScheme_Data
        ::Validate(object->preferred_color_scheme, validation_context))
    return false;

  return true;
}

LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data::LocalFrameHost_DidUpdatePreferredColorScheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetTextSurroundingSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_GetTextSurroundingSelection_Params_Data* object = static_cast<const LocalFrame_GetTextSurroundingSelection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_GetTextSurroundingSelection_Params_Data::LocalFrame_GetTextSurroundingSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_GetTextSurroundingSelection_ResponseParams_Data* object = static_cast<const LocalFrame_GetTextSurroundingSelection_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content, validation_context))
    return false;

  return true;
}

LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SendInterventionReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_SendInterventionReport_Params_Data* object = static_cast<const LocalFrame_SendInterventionReport_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_SendInterventionReport_Params_Data::LocalFrame_SendInterventionReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SetFrameOwnerProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_SetFrameOwnerProperties_Params_Data* object = static_cast<const LocalFrame_SetFrameOwnerProperties_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  return true;
}

LocalFrame_SetFrameOwnerProperties_Params_Data::LocalFrame_SetFrameOwnerProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_NotifyUserActivation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_NotifyUserActivation_Params_Data* object = static_cast<const LocalFrame_NotifyUserActivation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::UserActivationNotificationType_Data
        ::Validate(object->notification_type, validation_context))
    return false;

  return true;
}

LocalFrame_NotifyUserActivation_Params_Data::LocalFrame_NotifyUserActivation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data* object = static_cast<const LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyboard_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->keyboard_rect, validation_context))
    return false;

  return true;
}

LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AddMessageToConsole_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_AddMessageToConsole_Params_Data* object = static_cast<const LocalFrame_AddMessageToConsole_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ConsoleMessageLevel_Data
        ::Validate(object->level, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_AddMessageToConsole_Params_Data::LocalFrame_AddMessageToConsole_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AddInspectorIssue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_AddInspectorIssue_Params_Data* object = static_cast<const LocalFrame_AddInspectorIssue_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

LocalFrame_AddInspectorIssue_Params_Data::LocalFrame_AddInspectorIssue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SwapInImmediately_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_SwapInImmediately_Params_Data* object = static_cast<const LocalFrame_SwapInImmediately_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_SwapInImmediately_Params_Data::LocalFrame_SwapInImmediately_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_CheckCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_CheckCompleted_Params_Data* object = static_cast<const LocalFrame_CheckCompleted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_CheckCompleted_Params_Data::LocalFrame_CheckCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_StopLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_StopLoading_Params_Data* object = static_cast<const LocalFrame_StopLoading_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_StopLoading_Params_Data::LocalFrame_StopLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_Collapse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_Collapse_Params_Data* object = static_cast<const LocalFrame_Collapse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_Collapse_Params_Data::LocalFrame_Collapse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_EnableViewSourceMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_EnableViewSourceMode_Params_Data* object = static_cast<const LocalFrame_EnableViewSourceMode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_EnableViewSourceMode_Params_Data::LocalFrame_EnableViewSourceMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_Focus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_Focus_Params_Data* object = static_cast<const LocalFrame_Focus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_Focus_Params_Data::LocalFrame_Focus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ClearFocusedElement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_ClearFocusedElement_Params_Data* object = static_cast<const LocalFrame_ClearFocusedElement_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_ClearFocusedElement_Params_Data::LocalFrame_ClearFocusedElement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetResourceSnapshotForWebBundle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_GetResourceSnapshotForWebBundle_Params_Data* object = static_cast<const LocalFrame_GetResourceSnapshotForWebBundle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrame_GetResourceSnapshotForWebBundle_Params_Data::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_CopyImageAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_CopyImageAt_Params_Data* object = static_cast<const LocalFrame_CopyImageAt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_point, validation_context))
    return false;

  return true;
}

LocalFrame_CopyImageAt_Params_Data::LocalFrame_CopyImageAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_SaveImageAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_SaveImageAt_Params_Data* object = static_cast<const LocalFrame_SaveImageAt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_point, validation_context))
    return false;

  return true;
}

LocalFrame_SaveImageAt_Params_Data::LocalFrame_SaveImageAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ReportBlinkFeatureUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_ReportBlinkFeatureUsage_Params_Data* object = static_cast<const LocalFrame_ReportBlinkFeatureUsage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->features, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams features_validate_params(
      0, ::blink::mojom::internal::WebFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->features, validation_context,
                                         &features_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_ReportBlinkFeatureUsage_Params_Data::LocalFrame_ReportBlinkFeatureUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_RenderFallbackContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_RenderFallbackContent_Params_Data* object = static_cast<const LocalFrame_RenderFallbackContent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_RenderFallbackContent_Params_Data::LocalFrame_RenderFallbackContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data* object = static_cast<const LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_timing_value, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_timing_value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_timing_value, validation_context,
                                         &server_timing_value_validate_params)) {
    return false;
  }

  return true;
}

LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data::LocalFrame_RenderFallbackContentWithResourceTiming_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BeforeUnload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_BeforeUnload_Params_Data* object = static_cast<const LocalFrame_BeforeUnload_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_BeforeUnload_Params_Data::LocalFrame_BeforeUnload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BeforeUnload_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_BeforeUnload_ResponseParams_Data* object = static_cast<const LocalFrame_BeforeUnload_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_end_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_end_time, validation_context))
    return false;

  return true;
}

LocalFrame_BeforeUnload_ResponseParams_Data::LocalFrame_BeforeUnload_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_MediaPlayerActionAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_MediaPlayerActionAt_Params_Data* object = static_cast<const LocalFrame_MediaPlayerActionAt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  return true;
}

LocalFrame_MediaPlayerActionAt_Params_Data::LocalFrame_MediaPlayerActionAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AdvanceFocusInFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_AdvanceFocusInFrame_Params_Data* object = static_cast<const LocalFrame_AdvanceFocusInFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  return true;
}

LocalFrame_AdvanceFocusInFrame_Params_Data::LocalFrame_AdvanceFocusInFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_AdvanceFocusInForm_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_AdvanceFocusInForm_Params_Data* object = static_cast<const LocalFrame_AdvanceFocusInForm_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  return true;
}

LocalFrame_AdvanceFocusInForm_Params_Data::LocalFrame_AdvanceFocusInForm_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_ReportContentSecurityPolicyViolation_Params_Data* object = static_cast<const LocalFrame_ReportContentSecurityPolicyViolation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->violation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->violation, validation_context))
    return false;

  return true;
}

LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_DidUpdateFramePolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_DidUpdateFramePolicy_Params_Data* object = static_cast<const LocalFrame_DidUpdateFramePolicy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  return true;
}

LocalFrame_DidUpdateFramePolicy_Params_Data::LocalFrame_DidUpdateFramePolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_OnScreensChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_OnScreensChange_Params_Data* object = static_cast<const LocalFrame_OnScreensChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_OnScreensChange_Params_Data::LocalFrame_OnScreensChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_PostMessageEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_PostMessageEvent_Params_Data* object = static_cast<const LocalFrame_PostMessageEvent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

LocalFrame_PostMessageEvent_Params_Data::LocalFrame_PostMessageEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptMethodExecuteRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptMethodExecuteRequest_Params_Data* object = static_cast<const LocalFrame_JavaScriptMethodExecuteRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->object_name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->object_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->method_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->arguments, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->arguments, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptMethodExecuteRequest_Params_Data::LocalFrame_JavaScriptMethodExecuteRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data* object = static_cast<const LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data::LocalFrame_JavaScriptMethodExecuteRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptExecuteRequest_Params_Data* object = static_cast<const LocalFrame_JavaScriptExecuteRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequest_Params_Data::LocalFrame_JavaScriptExecuteRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data* object = static_cast<const LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data::LocalFrame_JavaScriptExecuteRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestForTests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptExecuteRequestForTests_Params_Data* object = static_cast<const LocalFrame_JavaScriptExecuteRequestForTests_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestForTests_Params_Data::LocalFrame_JavaScriptExecuteRequestForTests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data* object = static_cast<const LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data::LocalFrame_JavaScriptExecuteRequestForTests_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data* object = static_cast<const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data* object = static_cast<const LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data::LocalFrame_JavaScriptExecuteRequestInIsolatedWorld_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BindReportingObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_BindReportingObserver_Params_Data* object = static_cast<const LocalFrame_BindReportingObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrame_BindReportingObserver_Params_Data::LocalFrame_BindReportingObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_UpdateOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_UpdateOpener_Params_Data* object = static_cast<const LocalFrame_UpdateOpener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;

  return true;
}

LocalFrame_UpdateOpener_Params_Data::LocalFrame_UpdateOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetSavableResourceLinks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_GetSavableResourceLinks_Params_Data* object = static_cast<const LocalFrame_GetSavableResourceLinks_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_GetSavableResourceLinks_Params_Data::LocalFrame_GetSavableResourceLinks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetSavableResourceLinks_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_GetSavableResourceLinks_ResponseParams_Data* object = static_cast<const LocalFrame_GetSavableResourceLinks_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->reply, validation_context))
    return false;

  return true;
}

LocalFrame_GetSavableResourceLinks_ResponseParams_Data::LocalFrame_GetSavableResourceLinks_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_MixedContentFound_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_MixedContentFound_Params_Data* object = static_cast<const LocalFrame_MixedContentFound_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_resource_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_resource_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mixed_content_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mixed_content_url, validation_context))
    return false;


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->request_context, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_before_redirects, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url_before_redirects, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  return true;
}

LocalFrame_MixedContentFound_Params_Data::LocalFrame_MixedContentFound_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_BindDevToolsAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_BindDevToolsAgent_Params_Data* object = static_cast<const LocalFrame_BindDevToolsAgent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LocalFrame_BindDevToolsAgent_Params_Data::LocalFrame_BindDevToolsAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_HandleRendererDebugURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_HandleRendererDebugURL_Params_Data* object = static_cast<const LocalFrame_HandleRendererDebugURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalFrame_HandleRendererDebugURL_Params_Data::LocalFrame_HandleRendererDebugURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetCanonicalUrlForSharing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_GetCanonicalUrlForSharing_Params_Data* object = static_cast<const LocalFrame_GetCanonicalUrlForSharing_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalFrame_GetCanonicalUrlForSharing_Params_Data::LocalFrame_GetCanonicalUrlForSharing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data* object = static_cast<const LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->canonical_url, validation_context))
    return false;

  return true;
}

LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data::LocalFrame_GetCanonicalUrlForSharing_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data* object = static_cast<const HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data* object = static_cast<const HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_end_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_end_time, validation_context))
    return false;

  return true;
}

HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data* object = static_cast<const RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::cc::mojom::internal::TouchAction_Data
        ::Validate(object->touch_action, validation_context))
    return false;

  return true;
}

RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data* object = static_cast<const RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_VisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_VisibilityChanged_Params_Data* object = static_cast<const RemoteFrameHost_VisibilityChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FrameVisibility_Data
        ::Validate(object->visibility, validation_context))
    return false;

  return true;
}

RemoteFrameHost_VisibilityChanged_Params_Data::RemoteFrameHost_VisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_DidFocusFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_DidFocusFrame_Params_Data* object = static_cast<const RemoteFrameHost_DidFocusFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrameHost_DidFocusFrame_Params_Data::RemoteFrameHost_DidFocusFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_CheckCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_CheckCompleted_Params_Data* object = static_cast<const RemoteFrameHost_CheckCompleted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrameHost_CheckCompleted_Params_Data::RemoteFrameHost_CheckCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data* object = static_cast<const RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->guid, validation_context))
    return false;

  return true;
}

RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_SetIsInert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_SetIsInert_Params_Data* object = static_cast<const RemoteFrameHost_SetIsInert_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrameHost_SetIsInert_Params_Data::RemoteFrameHost_SetIsInert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_DidChangeOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_DidChangeOpener_Params_Data* object = static_cast<const RemoteFrameHost_DidChangeOpener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->opener_frame, validation_context))
    return false;

  return true;
}

RemoteFrameHost_DidChangeOpener_Params_Data::RemoteFrameHost_DidChangeOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_AdvanceFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_AdvanceFocus_Params_Data* object = static_cast<const RemoteFrameHost_AdvanceFocus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  return true;
}

RemoteFrameHost_AdvanceFocus_Params_Data::RemoteFrameHost_AdvanceFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_RouteMessageEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_RouteMessageEvent_Params_Data* object = static_cast<const RemoteFrameHost_RouteMessageEvent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

RemoteFrameHost_RouteMessageEvent_Params_Data::RemoteFrameHost_RouteMessageEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_PrintCrossProcessSubframe_Params_Data* object = static_cast<const RemoteFrameHost_PrintCrossProcessSubframe_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_content_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_content_rect, validation_context))
    return false;

  return true;
}

RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_Detach_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_Detach_Params_Data* object = static_cast<const RemoteFrameHost_Detach_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrameHost_Detach_Params_Data::RemoteFrameHost_Detach_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_UpdateViewportIntersection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_UpdateViewportIntersection_Params_Data* object = static_cast<const RemoteFrameHost_UpdateViewportIntersection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intersection_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intersection_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->visual_properties, validation_context))
    return false;

  return true;
}

RemoteFrameHost_UpdateViewportIntersection_Params_Data::RemoteFrameHost_UpdateViewportIntersection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_SynchronizeVisualProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_SynchronizeVisualProperties_Params_Data* object = static_cast<const RemoteFrameHost_SynchronizeVisualProperties_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  return true;
}

RemoteFrameHost_SynchronizeVisualProperties_Params_Data::RemoteFrameHost_SynchronizeVisualProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_OpenURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrameHost_OpenURL_Params_Data* object = static_cast<const RemoteFrameHost_OpenURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

RemoteFrameHost_OpenURL_Params_Data::RemoteFrameHost_OpenURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_WillEnterFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_WillEnterFullscreen_Params_Data* object = static_cast<const RemoteFrame_WillEnterFullscreen_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

RemoteFrame_WillEnterFullscreen_Params_Data::RemoteFrame_WillEnterFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_EnforceInsecureNavigationsSet_Params_Data* object = static_cast<const RemoteFrame_EnforceInsecureNavigationsSet_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->set, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams set_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->set, validation_context,
                                         &set_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetFrameOwnerProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetFrameOwnerProperties_Params_Data* object = static_cast<const RemoteFrame_SetFrameOwnerProperties_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  return true;
}

RemoteFrame_SetFrameOwnerProperties_Params_Data::RemoteFrame_SetFrameOwnerProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_EnforceInsecureRequestPolicy_Params_Data* object = static_cast<const RemoteFrame_EnforceInsecureRequestPolicy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::InsecureRequestPolicy_Data
        ::Validate(object->policy, validation_context))
    return false;

  return true;
}

RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetReplicatedOrigin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetReplicatedOrigin_Params_Data* object = static_cast<const RemoteFrame_SetReplicatedOrigin_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

RemoteFrame_SetReplicatedOrigin_Params_Data::RemoteFrame_SetReplicatedOrigin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetReplicatedIsAdSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetReplicatedIsAdSubframe_Params_Data* object = static_cast<const RemoteFrame_SetReplicatedIsAdSubframe_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_SetReplicatedIsAdSubframe_Params_Data::RemoteFrame_SetReplicatedIsAdSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetReplicatedName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetReplicatedName_Params_Data* object = static_cast<const RemoteFrame_SetReplicatedName_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams unique_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->unique_name, validation_context,
                                         &unique_name_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_SetReplicatedName_Params_Data::RemoteFrame_SetReplicatedName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data* object = static_cast<const RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetNeedsOcclusionTracking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetNeedsOcclusionTracking_Params_Data* object = static_cast<const RemoteFrame_SetNeedsOcclusionTracking_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_SetNeedsOcclusionTracking_Params_Data::RemoteFrame_SetNeedsOcclusionTracking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_Collapse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_Collapse_Params_Data* object = static_cast<const RemoteFrame_Collapse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_Collapse_Params_Data::RemoteFrame_Collapse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_Focus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_Focus_Params_Data* object = static_cast<const RemoteFrame_Focus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_Focus_Params_Data::RemoteFrame_Focus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data* object = static_cast<const RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_BubbleLogicalScroll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_BubbleLogicalScroll_Params_Data* object = static_cast<const RemoteFrame_BubbleLogicalScroll_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ScrollDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::ui::mojom::internal::ScrollGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

RemoteFrame_BubbleLogicalScroll_Params_Data::RemoteFrame_BubbleLogicalScroll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_UpdateUserActivationState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_UpdateUserActivationState_Params_Data* object = static_cast<const RemoteFrame_UpdateUserActivationState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::UserActivationUpdateType_Data
        ::Validate(object->state_update_type, validation_context))
    return false;


  if (!::blink::mojom::internal::UserActivationNotificationType_Data
        ::Validate(object->notification_type, validation_context))
    return false;

  return true;
}

RemoteFrame_UpdateUserActivationState_Params_Data::RemoteFrame_UpdateUserActivationState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetEmbeddingToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetEmbeddingToken_Params_Data* object = static_cast<const RemoteFrame_SetEmbeddingToken_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->embedding_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->embedding_token, validation_context))
    return false;

  return true;
}

RemoteFrame_SetEmbeddingToken_Params_Data::RemoteFrame_SetEmbeddingToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetPageFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetPageFocus_Params_Data* object = static_cast<const RemoteFrame_SetPageFocus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_SetPageFocus_Params_Data::RemoteFrame_SetPageFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_RenderFallbackContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_RenderFallbackContent_Params_Data* object = static_cast<const RemoteFrame_RenderFallbackContent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_RenderFallbackContent_Params_Data::RemoteFrame_RenderFallbackContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data* object = static_cast<const RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_timing_value, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_timing_value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_timing_value, validation_context,
                                         &server_timing_value_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data::RemoteFrame_RenderFallbackContentWithResourceTiming_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_AddResourceTimingFromChild_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_AddResourceTimingFromChild_Params_Data* object = static_cast<const RemoteFrame_AddResourceTimingFromChild_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  return true;
}

RemoteFrame_AddResourceTimingFromChild_Params_Data::RemoteFrame_AddResourceTimingFromChild_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_ScrollRectToVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_ScrollRectToVisible_Params_Data* object = static_cast<const RemoteFrame_ScrollRectToVisible_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

RemoteFrame_ScrollRectToVisible_Params_Data::RemoteFrame_ScrollRectToVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidStartLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DidStartLoading_Params_Data* object = static_cast<const RemoteFrame_DidStartLoading_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_DidStartLoading_Params_Data::RemoteFrame_DidStartLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidStopLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DidStopLoading_Params_Data* object = static_cast<const RemoteFrame_DidStopLoading_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_DidStopLoading_Params_Data::RemoteFrame_DidStopLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data* object = static_cast<const RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sizing_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sizing_info, validation_context))
    return false;

  return true;
}

RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidSetFramePolicyHeaders_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DidSetFramePolicyHeaders_Params_Data* object = static_cast<const RemoteFrame_DidSetFramePolicyHeaders_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::WebSandboxFlags_Data
        ::Validate(object->sandbox_flags, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsed_permissions_policy, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams parsed_permissions_policy_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->parsed_permissions_policy, validation_context,
                                         &parsed_permissions_policy_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_DidSetFramePolicyHeaders_Params_Data::RemoteFrame_DidSetFramePolicyHeaders_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidUpdateFramePolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DidUpdateFramePolicy_Params_Data* object = static_cast<const RemoteFrame_DidUpdateFramePolicy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  return true;
}

RemoteFrame_DidUpdateFramePolicy_Params_Data::RemoteFrame_DidUpdateFramePolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_UpdateOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_UpdateOpener_Params_Data* object = static_cast<const RemoteFrame_UpdateOpener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;

  return true;
}

RemoteFrame_UpdateOpener_Params_Data::RemoteFrame_UpdateOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DetachAndDispose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DetachAndDispose_Params_Data* object = static_cast<const RemoteFrame_DetachAndDispose_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_DetachAndDispose_Params_Data::RemoteFrame_DetachAndDispose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_EnableAutoResize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_EnableAutoResize_Params_Data* object = static_cast<const RemoteFrame_EnableAutoResize_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_size, validation_context))
    return false;

  return true;
}

RemoteFrame_EnableAutoResize_Params_Data::RemoteFrame_EnableAutoResize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DisableAutoResize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DisableAutoResize_Params_Data* object = static_cast<const RemoteFrame_DisableAutoResize_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_DisableAutoResize_Params_Data::RemoteFrame_DisableAutoResize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidUpdateVisualProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_DidUpdateVisualProperties_Params_Data* object = static_cast<const RemoteFrame_DidUpdateVisualProperties_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

RemoteFrame_DidUpdateVisualProperties_Params_Data::RemoteFrame_DidUpdateVisualProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetFrameSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_SetFrameSinkId_Params_Data* object = static_cast<const RemoteFrame_SetFrameSinkId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

RemoteFrame_SetFrameSinkId_Params_Data::RemoteFrame_SetFrameSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_ChildProcessGone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteFrame_ChildProcessGone_Params_Data* object = static_cast<const RemoteFrame_ChildProcessGone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteFrame_ChildProcessGone_Params_Data::RemoteFrame_ChildProcessGone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_AnimateDoubleTapZoom_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_AnimateDoubleTapZoom_Params_Data* object = static_cast<const LocalMainFrame_AnimateDoubleTapZoom_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  return true;
}

LocalMainFrame_AnimateDoubleTapZoom_Params_Data::LocalMainFrame_AnimateDoubleTapZoom_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_SetScaleFactor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_SetScaleFactor_Params_Data* object = static_cast<const LocalMainFrame_SetScaleFactor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrame_SetScaleFactor_Params_Data::LocalMainFrame_SetScaleFactor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_ClosePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_ClosePage_Params_Data* object = static_cast<const LocalMainFrame_ClosePage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrame_ClosePage_Params_Data::LocalMainFrame_ClosePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_ClosePage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_ClosePage_ResponseParams_Data* object = static_cast<const LocalMainFrame_ClosePage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrame_ClosePage_ResponseParams_Data::LocalMainFrame_ClosePage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_PluginActionAt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_PluginActionAt_Params_Data* object = static_cast<const LocalMainFrame_PluginActionAt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;


  if (!::blink::mojom::internal::PluginActionType_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

LocalMainFrame_PluginActionAt_Params_Data::LocalMainFrame_PluginActionAt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_SetInitialFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_SetInitialFocus_Params_Data* object = static_cast<const LocalMainFrame_SetInitialFocus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrame_SetInitialFocus_Params_Data::LocalMainFrame_SetInitialFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data* object = static_cast<const LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_ZoomToFindInPageRect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_ZoomToFindInPageRect_Params_Data* object = static_cast<const LocalMainFrame_ZoomToFindInPageRect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect_in_root_frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect_in_root_frame, validation_context))
    return false;

  return true;
}

LocalMainFrame_ZoomToFindInPageRect_Params_Data::LocalMainFrame_ZoomToFindInPageRect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_InstallCoopAccessMonitor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_InstallCoopAccessMonitor_Params_Data* object = static_cast<const LocalMainFrame_InstallCoopAccessMonitor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CoopAccessReportType_Data
        ::Validate(object->report_type, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->accessed_window, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->accessed_window, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->reporter, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->reporter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reported_window_url, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams reported_window_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reported_window_url, validation_context,
                                         &reported_window_url_validate_params)) {
    return false;
  }

  return true;
}

LocalMainFrame_InstallCoopAccessMonitor_Params_Data::LocalMainFrame_InstallCoopAccessMonitor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_OnPortalActivated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_OnPortalActivated_Params_Data* object = static_cast<const LocalMainFrame_OnPortalActivated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->portal_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->portal_token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->portal, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->portal,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->portal_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->portal_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

LocalMainFrame_OnPortalActivated_Params_Data::LocalMainFrame_OnPortalActivated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_OnPortalActivated_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_OnPortalActivated_ResponseParams_Data* object = static_cast<const LocalMainFrame_OnPortalActivated_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::PortalActivateResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

LocalMainFrame_OnPortalActivated_ResponseParams_Data::LocalMainFrame_OnPortalActivated_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_ForwardMessageFromHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_ForwardMessageFromHost_Params_Data* object = static_cast<const LocalMainFrame_ForwardMessageFromHost_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  return true;
}

LocalMainFrame_ForwardMessageFromHost_Params_Data::LocalMainFrame_ForwardMessageFromHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrame_UpdateBrowserControlsState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrame_UpdateBrowserControlsState_Params_Data* object = static_cast<const LocalMainFrame_UpdateBrowserControlsState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::cc::mojom::internal::BrowserControlsState_Data
        ::Validate(object->constraints, validation_context))
    return false;


  if (!::cc::mojom::internal::BrowserControlsState_Data
        ::Validate(object->current, validation_context))
    return false;

  return true;
}

LocalMainFrame_UpdateBrowserControlsState_Params_Data::LocalMainFrame_UpdateBrowserControlsState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data* object = static_cast<const RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_info, validation_context))
    return false;

  return true;
}

RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ScaleFactorChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_ScaleFactorChanged_Params_Data* object = static_cast<const LocalMainFrameHost_ScaleFactorChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_ScaleFactorChanged_Params_Data::LocalMainFrameHost_ScaleFactorChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data* object = static_cast<const LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pref_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pref_size, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data* object = static_cast<const LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_info, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_FocusPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_FocusPage_Params_Data* object = static_cast<const LocalMainFrameHost_FocusPage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_FocusPage_Params_Data::LocalMainFrameHost_FocusPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_TakeFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_TakeFocus_Params_Data* object = static_cast<const LocalMainFrameHost_TakeFocus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_TakeFocus_Params_Data::LocalMainFrameHost_TakeFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_UpdateTargetURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_UpdateTargetURL_Params_Data* object = static_cast<const LocalMainFrameHost_UpdateTargetURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_UpdateTargetURL_Params_Data::LocalMainFrameHost_UpdateTargetURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data* object = static_cast<const LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_RequestClose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_RequestClose_Params_Data* object = static_cast<const LocalMainFrameHost_RequestClose_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_RequestClose_Params_Data::LocalMainFrameHost_RequestClose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ShowCreatedWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_ShowCreatedWindow_Params_Data* object = static_cast<const LocalMainFrameHost_ShowCreatedWindow_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->opener_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->opener_frame_token, validation_context))
    return false;


  if (!::ui::mojom::internal::WindowOpenDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_ShowCreatedWindow_Params_Data::LocalMainFrameHost_ShowCreatedWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data* object = static_cast<const LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data::LocalMainFrameHost_ShowCreatedWindow_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_SetWindowRect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_SetWindowRect_Params_Data* object = static_cast<const LocalMainFrameHost_SetWindowRect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

LocalMainFrameHost_SetWindowRect_Params_Data::LocalMainFrameHost_SetWindowRect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_SetWindowRect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_SetWindowRect_ResponseParams_Data* object = static_cast<const LocalMainFrameHost_SetWindowRect_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_SetWindowRect_ResponseParams_Data::LocalMainFrameHost_SetWindowRect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data* object = static_cast<const LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data::LocalMainFrameHost_DidFirstVisuallyNonEmptyPaint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_FocusPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteMainFrameHost_FocusPage_Params_Data* object = static_cast<const RemoteMainFrameHost_FocusPage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteMainFrameHost_FocusPage_Params_Data::RemoteMainFrameHost_FocusPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_TakeFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteMainFrameHost_TakeFocus_Params_Data* object = static_cast<const RemoteMainFrameHost_TakeFocus_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteMainFrameHost_TakeFocus_Params_Data::RemoteMainFrameHost_TakeFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_UpdateTargetURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteMainFrameHost_UpdateTargetURL_Params_Data* object = static_cast<const RemoteMainFrameHost_UpdateTargetURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

RemoteMainFrameHost_UpdateTargetURL_Params_Data::RemoteMainFrameHost_UpdateTargetURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data* object = static_cast<const RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_RouteCloseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemoteMainFrameHost_RouteCloseEvent_Params_Data* object = static_cast<const RemoteMainFrameHost_RouteCloseEvent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RemoteMainFrameHost_RouteCloseEvent_Params_Data::RemoteMainFrameHost_RouteCloseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PluginActionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PluginActionType value) {
  return std::move(context).WriteString(::blink::mojom::PluginActionTypeToString(value));
}

} // namespace perfetto
