// third_party/blink/public/mojom/frame/frame_replication_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_JUMBO_H_
#include "third_party/blink/common/permissions_policy/permissions_policy_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
FrameReplicationState::FrameReplicationState()
    : origin(),
      name(),
      unique_name(),
      permissions_policy_header(),
      active_sandbox_flags(::network::mojom::WebSandboxFlags::kNone),
      frame_policy(),
      insecure_request_policy(::blink::mojom::InsecureRequestPolicy::kLeaveInsecureRequestsAlone),
      insecure_navigations_set(),
      has_potentially_trustworthy_unique_origin(false),
      has_active_user_gesture(false),
      has_received_user_gesture_before_nav(false),
      is_ad_subframe(false) {}

FrameReplicationState::FrameReplicationState(
    const ::url::Origin& origin_in,
    const std::string& name_in,
    const std::string& unique_name_in,
    std::vector<::blink::ParsedPermissionsPolicyDeclaration> permissions_policy_header_in,
    ::network::mojom::WebSandboxFlags active_sandbox_flags_in,
    const ::blink::FramePolicy& frame_policy_in,
    ::blink::mojom::InsecureRequestPolicy insecure_request_policy_in,
    std::vector<uint32_t> insecure_navigations_set_in,
    bool has_potentially_trustworthy_unique_origin_in,
    bool has_active_user_gesture_in,
    bool has_received_user_gesture_before_nav_in,
    bool is_ad_subframe_in)
    : origin(std::move(origin_in)),
      name(std::move(name_in)),
      unique_name(std::move(unique_name_in)),
      permissions_policy_header(std::move(permissions_policy_header_in)),
      active_sandbox_flags(std::move(active_sandbox_flags_in)),
      frame_policy(std::move(frame_policy_in)),
      insecure_request_policy(std::move(insecure_request_policy_in)),
      insecure_navigations_set(std::move(insecure_navigations_set_in)),
      has_potentially_trustworthy_unique_origin(std::move(has_potentially_trustworthy_unique_origin_in)),
      has_active_user_gesture(std::move(has_active_user_gesture_in)),
      has_received_user_gesture_before_nav(std::move(has_received_user_gesture_before_nav_in)),
      is_ad_subframe(std::move(is_ad_subframe_in)) {}

FrameReplicationState::~FrameReplicationState() = default;

void FrameReplicationState::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_name"), this->unique_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions_policy_header"), this->permissions_policy_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::ParsedPermissionsPolicyDeclaration>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_sandbox_flags"), this->active_sandbox_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::WebSandboxFlags>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_policy"), this->frame_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::FramePolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_request_policy"), this->insecure_request_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::InsecureRequestPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_navigations_set"), this->insecure_navigations_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potentially_trustworthy_unique_origin"), this->has_potentially_trustworthy_unique_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_active_user_gesture"), this->has_active_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_received_user_gesture_before_nav"), this->has_received_user_gesture_before_nav,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_ad_subframe"), this->is_ad_subframe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameReplicationState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FrameReplicationState::DataView, ::blink::mojom::FrameReplicationStatePtr>::Read(
    ::blink::mojom::FrameReplicationState::DataView input,
    ::blink::mojom::FrameReplicationStatePtr* output) {
  bool success = true;
  ::blink::mojom::FrameReplicationStatePtr result(::blink::mojom::FrameReplicationState::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUniqueName(&result->unique_name))
        success = false;
      if (success && !input.ReadPermissionsPolicyHeader(&result->permissions_policy_header))
        success = false;
      if (success && !input.ReadActiveSandboxFlags(&result->active_sandbox_flags))
        success = false;
      if (success && !input.ReadFramePolicy(&result->frame_policy))
        success = false;
      if (success && !input.ReadInsecureRequestPolicy(&result->insecure_request_policy))
        success = false;
      if (success && !input.ReadInsecureNavigationsSet(&result->insecure_navigations_set))
        success = false;
      if (success)
        result->has_potentially_trustworthy_unique_origin = input.has_potentially_trustworthy_unique_origin();
      if (success)
        result->has_active_user_gesture = input.has_active_user_gesture();
      if (success)
        result->has_received_user_gesture_before_nav = input.has_received_user_gesture_before_nav();
      if (success)
        result->is_ad_subframe = input.is_ad_subframe();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif