// third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* FrameOcclusionStateToStringHelper(FrameOcclusionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FrameOcclusionState::kUnknown:
      return "kUnknown";
    case FrameOcclusionState::kPossiblyOccluded:
      return "kPossiblyOccluded";
    case FrameOcclusionState::kGuaranteedNotOccluded:
      return "kGuaranteedNotOccluded";
    default:
      return nullptr;
  }
}

std::string FrameOcclusionStateToString(FrameOcclusionState value) {
  const char *str = FrameOcclusionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FrameOcclusionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FrameOcclusionState value) {
  return os << FrameOcclusionStateToString(value);
}

namespace internal {


// static
bool ViewportIntersectionState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ViewportIntersectionState_Data* object = static_cast<const ViewportIntersectionState_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_intersection, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport_intersection, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_intersection, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_intersection, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->compositor_visible_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->compositor_visible_rect, validation_context))
    return false;


  if (!::blink::mojom::internal::FrameOcclusionState_Data
        ::Validate(object->occlusion_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_viewport_size, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_viewport_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_scroll_offset, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_scroll_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_transform, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_transform, validation_context))
    return false;

  return true;
}

ViewportIntersectionState_Data::ViewportIntersectionState_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FrameOcclusionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FrameOcclusionState value) {
  return std::move(context).WriteString(::blink::mojom::FrameOcclusionStateToString(value));
}

} // namespace perfetto
