// third_party/blink/public/mojom/hid/hid.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/hid/hid.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool DeviceIdFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DeviceIdFilter_Data* object = static_cast<const DeviceIdFilter_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DeviceIdFilter_Tag::VENDOR: {

      return true;
    }
    case DeviceIdFilter_Tag::VENDOR_AND_PRODUCT: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_vendor_and_product, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_vendor_and_product, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DeviceIdFilter");
      return false;
    }
  }
}
// static
bool UsageFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const UsageFilter_Data* object = static_cast<const UsageFilter_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case UsageFilter_Tag::PAGE: {

      return true;
    }
    case UsageFilter_Tag::USAGE_AND_PAGE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_usage_and_page, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_usage_and_page, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in UsageFilter");
      return false;
    }
  }
}


// static
bool VendorAndProduct_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VendorAndProduct_Data* object = static_cast<const VendorAndProduct_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VendorAndProduct_Data::VendorAndProduct_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidDeviceFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidDeviceFilter_Data* object = static_cast<const HidDeviceFilter_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnion(object->device_ids, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->usage, validation_context))
    return false;

  return true;
}

HidDeviceFilter_Data::HidDeviceFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidService_RegisterClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidService_RegisterClient_Params_Data* object = static_cast<const HidService_RegisterClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HidService_RegisterClient_Params_Data::HidService_RegisterClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidService_GetDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidService_GetDevices_Params_Data* object = static_cast<const HidService_GetDevices_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

HidService_GetDevices_Params_Data::HidService_GetDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidService_GetDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidService_GetDevices_ResponseParams_Data* object = static_cast<const HidService_GetDevices_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

HidService_GetDevices_ResponseParams_Data::HidService_GetDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidService_RequestDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidService_RequestDevice_Params_Data* object = static_cast<const HidService_RequestDevice_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams filters_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->filters, validation_context,
                                         &filters_validate_params)) {
    return false;
  }

  return true;
}

HidService_RequestDevice_Params_Data::HidService_RequestDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidService_RequestDevice_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidService_RequestDevice_ResponseParams_Data* object = static_cast<const HidService_RequestDevice_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

HidService_RequestDevice_ResponseParams_Data::HidService_RequestDevice_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidService_Connect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidService_Connect_Params_Data* object = static_cast<const HidService_Connect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_guid, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams device_guid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->device_guid, validation_context,
                                         &device_guid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HidService_Connect_Params_Data::HidService_Connect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HidService_Connect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HidService_Connect_ResponseParams_Data* object = static_cast<const HidService_Connect_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->connection,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HidService_Connect_ResponseParams_Data::HidService_Connect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
