// third_party/blink/public/mojom/hyphenation/hyphenation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom-params-data.h"
#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HYPHENATION_HYPHENATION_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HYPHENATION_HYPHENATION_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char Hyphenation::Name_[] = "blink.mojom.Hyphenation";
bool Hyphenation::OpenDictionary(const std::string& locale, ::base::File* out_hyphenation_dictionary_handle) {
  NOTREACHED();
  return false;
}
class Hyphenation_OpenDictionary_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Hyphenation_OpenDictionary_HandleSyncResponse(
      bool* result, ::base::File* out_hyphenation_dictionary_handle)
      : result_(result), out_hyphenation_dictionary_handle_(out_hyphenation_dictionary_handle) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File* out_hyphenation_dictionary_handle_;DISALLOW_COPY_AND_ASSIGN(Hyphenation_OpenDictionary_HandleSyncResponse);
};

class Hyphenation_OpenDictionary_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Hyphenation_OpenDictionary_ForwardToCallback(
      Hyphenation::OpenDictionaryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Hyphenation::OpenDictionaryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Hyphenation_OpenDictionary_ForwardToCallback);
};

HyphenationProxy::HyphenationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool HyphenationProxy::OpenDictionary(
    const std::string& param_locale, ::base::File* out_param_hyphenation_dictionary_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::Hyphenation::OpenDictionary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locale"), param_locale,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHyphenation_OpenDictionary_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Hyphenation_OpenDictionary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->locale)::BaseType> locale_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_locale, locale_fragment);
  params->locale.Set(
      locale_fragment.is_null() ? nullptr : locale_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->locale.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null locale in Hyphenation.OpenDictionary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Hyphenation::Name_);
  message.set_method_name("OpenDictionary");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Hyphenation_OpenDictionary_HandleSyncResponse(
          &result, out_param_hyphenation_dictionary_handle));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::Hyphenation::OpenDictionary", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hyphenation_dictionary_handle"), out_param_hyphenation_dictionary_handle,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void HyphenationProxy::OpenDictionary(
    const std::string& in_locale, OpenDictionaryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Hyphenation::OpenDictionary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locale"), in_locale,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHyphenation_OpenDictionary_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Hyphenation_OpenDictionary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->locale)::BaseType> locale_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_locale, locale_fragment);
  params->locale.Set(
      locale_fragment.is_null() ? nullptr : locale_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->locale.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null locale in Hyphenation.OpenDictionary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Hyphenation::Name_);
  message.set_method_name("OpenDictionary");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Hyphenation_OpenDictionary_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Hyphenation_OpenDictionary_ProxyToResponder {
 public:
  static Hyphenation::OpenDictionaryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Hyphenation_OpenDictionary_ProxyToResponder> proxy(
        new Hyphenation_OpenDictionary_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Hyphenation_OpenDictionary_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Hyphenation_OpenDictionary_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Hyphenation_OpenDictionary_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Hyphenation::OpenDictionaryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_hyphenation_dictionary_handle);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Hyphenation_OpenDictionary_ProxyToResponder);
};

bool Hyphenation_OpenDictionary_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Hyphenation::OpenDictionaryCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Hyphenation_OpenDictionary_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Hyphenation_OpenDictionary_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File p_hyphenation_dictionary_handle{};
  Hyphenation_OpenDictionary_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHyphenationDictionaryHandle(&p_hyphenation_dictionary_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Hyphenation::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_hyphenation_dictionary_handle));
  return true;
}

void Hyphenation_OpenDictionary_ProxyToResponder::Run(
    ::base::File in_hyphenation_dictionary_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Hyphenation::OpenDictionaryCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hyphenation_dictionary_handle"), in_hyphenation_dictionary_handle,
                        "<value of type ::base::File>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHyphenation_OpenDictionary_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Hyphenation_OpenDictionary_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hyphenation_dictionary_handle)::BaseType> hyphenation_dictionary_handle_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_hyphenation_dictionary_handle, hyphenation_dictionary_handle_fragment);
  params->hyphenation_dictionary_handle.Set(
      hyphenation_dictionary_handle_fragment.is_null() ? nullptr : hyphenation_dictionary_handle_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Hyphenation::OpenDictionaryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Hyphenation::Name_);
  message.set_method_name("OpenDictionary");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Hyphenation_OpenDictionary_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Hyphenation_OpenDictionary_ResponseParams_Data* params =
      reinterpret_cast<internal::Hyphenation_OpenDictionary_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File p_hyphenation_dictionary_handle{};
  Hyphenation_OpenDictionary_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHyphenationDictionaryHandle(&p_hyphenation_dictionary_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Hyphenation::Name_, 0, true);
    return false;
  }
  *out_hyphenation_dictionary_handle_ = std::move(p_hyphenation_dictionary_handle);
  *result_ = true;
  return true;
}

// static
bool HyphenationStubDispatch::Accept(
    Hyphenation* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHyphenation_OpenDictionary_Name: {
      break;
    }
  }
  return false;
}

// static
bool HyphenationStubDispatch::AcceptWithResponder(
    Hyphenation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHyphenation_OpenDictionary_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Hyphenation::OpenDictionary",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Hyphenation::OpenDictionary");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Hyphenation_OpenDictionary_Params_Data* params =
          reinterpret_cast<
              internal::Hyphenation_OpenDictionary_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_locale{};
      Hyphenation_OpenDictionary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocale(&p_locale))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Hyphenation::Name_, 0, false);
        return false;
      }
      Hyphenation::OpenDictionaryCallback callback =
          Hyphenation_OpenDictionary_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDictionary(
std::move(p_locale), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kHyphenationValidationInfo[] = {
    {&internal::Hyphenation_OpenDictionary_Params_Data::Validate,
     &internal::Hyphenation_OpenDictionary_ResponseParams_Data::Validate},
};

bool HyphenationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::Hyphenation::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kHyphenationValidationInfo);
}

bool HyphenationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::Hyphenation::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kHyphenationValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif