// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-blink.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_BLINK_JUMBO_H_
#include "third_party/blink/renderer/modules/indexeddb/indexed_db_blink_mojom_traits.h"
#endif


namespace blink {
namespace mojom {
namespace blink {


void IDBCallbacksInterceptorForTesting::Error(IDBException code, const ::WTF::String& message) {
  GetForwardingInterface()->Error(std::move(code), std::move(message));
}
void IDBCallbacksInterceptorForTesting::SuccessNamesAndVersionsList(WTF::Vector<IDBNameAndVersionPtr> value) {
  GetForwardingInterface()->SuccessNamesAndVersionsList(std::move(value));
}
void IDBCallbacksInterceptorForTesting::Blocked(int64_t existing_version) {
  GetForwardingInterface()->Blocked(std::move(existing_version));
}
void IDBCallbacksInterceptorForTesting::UpgradeNeeded(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, int64_t old_version, IDBDataLoss data_loss, const WTF::String& data_loss_message, const ::blink::IDBDatabaseMetadata& db_metadata) {
  GetForwardingInterface()->UpgradeNeeded(std::move(pending_database), std::move(old_version), std::move(data_loss), std::move(data_loss_message), std::move(db_metadata));
}
void IDBCallbacksInterceptorForTesting::SuccessDatabase(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, const ::blink::IDBDatabaseMetadata& metadata) {
  GetForwardingInterface()->SuccessDatabase(std::move(pending_database), std::move(metadata));
}
void IDBCallbacksInterceptorForTesting::SuccessInteger(int64_t value) {
  GetForwardingInterface()->SuccessInteger(std::move(value));
}
void IDBCallbacksInterceptorForTesting::Success() {
  GetForwardingInterface()->Success();
}
IDBCallbacksAsyncWaiter::IDBCallbacksAsyncWaiter(
    IDBCallbacks* proxy) : proxy_(proxy) {}

IDBCallbacksAsyncWaiter::~IDBCallbacksAsyncWaiter() = default;




void IDBDatabaseCallbacksInterceptorForTesting::ForcedClose() {
  GetForwardingInterface()->ForcedClose();
}
void IDBDatabaseCallbacksInterceptorForTesting::VersionChange(int64_t old_version, int64_t new_version) {
  GetForwardingInterface()->VersionChange(std::move(old_version), std::move(new_version));
}
void IDBDatabaseCallbacksInterceptorForTesting::Abort(int64_t transaction_id, IDBException code, const ::WTF::String& message) {
  GetForwardingInterface()->Abort(std::move(transaction_id), std::move(code), std::move(message));
}
void IDBDatabaseCallbacksInterceptorForTesting::Complete(int64_t transaction_id) {
  GetForwardingInterface()->Complete(std::move(transaction_id));
}
IDBDatabaseCallbacksAsyncWaiter::IDBDatabaseCallbacksAsyncWaiter(
    IDBDatabaseCallbacks* proxy) : proxy_(proxy) {}

IDBDatabaseCallbacksAsyncWaiter::~IDBDatabaseCallbacksAsyncWaiter() = default;




void IDBCursorInterceptorForTesting::Advance(uint32_t count, AdvanceCallback callback) {
  GetForwardingInterface()->Advance(std::move(count), std::move(callback));
}
void IDBCursorInterceptorForTesting::CursorContinue(::std::unique_ptr<::blink::IDBKey> key, ::std::unique_ptr<::blink::IDBKey> primary_key, CursorContinueCallback callback) {
  GetForwardingInterface()->CursorContinue(std::move(key), std::move(primary_key), std::move(callback));
}
void IDBCursorInterceptorForTesting::Prefetch(int32_t count, PrefetchCallback callback) {
  GetForwardingInterface()->Prefetch(std::move(count), std::move(callback));
}
void IDBCursorInterceptorForTesting::PrefetchReset(int32_t used_prefetches, int32_t unused_prefetches) {
  GetForwardingInterface()->PrefetchReset(std::move(used_prefetches), std::move(unused_prefetches));
}
IDBCursorAsyncWaiter::IDBCursorAsyncWaiter(
    IDBCursor* proxy) : proxy_(proxy) {}

IDBCursorAsyncWaiter::~IDBCursorAsyncWaiter() = default;

void IDBCursorAsyncWaiter::Advance(
    uint32_t count, IDBCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Advance(std::move(count),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBCursorResultPtr* out_result
,
             IDBCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void IDBCursorAsyncWaiter::CursorContinue(
    ::std::unique_ptr<::blink::IDBKey> key, ::std::unique_ptr<::blink::IDBKey> primary_key, IDBCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CursorContinue(std::move(key),std::move(primary_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBCursorResultPtr* out_result
,
             IDBCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void IDBCursorAsyncWaiter::Prefetch(
    int32_t count, IDBCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Prefetch(std::move(count),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBCursorResultPtr* out_result
,
             IDBCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void IDBTransactionInterceptorForTesting::CreateObjectStore(int64_t object_store_id, const ::WTF::String& name, const ::blink::IDBKeyPath& key_path, bool auto_increment) {
  GetForwardingInterface()->CreateObjectStore(std::move(object_store_id), std::move(name), std::move(key_path), std::move(auto_increment));
}
void IDBTransactionInterceptorForTesting::DeleteObjectStore(int64_t object_store_id) {
  GetForwardingInterface()->DeleteObjectStore(std::move(object_store_id));
}
void IDBTransactionInterceptorForTesting::Put(int64_t object_store_id, ::std::unique_ptr<::blink::IDBValue> value, ::std::unique_ptr<::blink::IDBKey> key, IDBPutMode mode, WTF::Vector<::blink::IDBIndexKeys> index_keys, PutCallback callback) {
  GetForwardingInterface()->Put(std::move(object_store_id), std::move(value), std::move(key), std::move(mode), std::move(index_keys), std::move(callback));
}
void IDBTransactionInterceptorForTesting::PutAll(int64_t object_store_id, WTF::Vector<IDBPutParamsPtr> put_params, PutAllCallback callback) {
  GetForwardingInterface()->PutAll(std::move(object_store_id), std::move(put_params), std::move(callback));
}
void IDBTransactionInterceptorForTesting::Commit(int64_t num_errors_handled) {
  GetForwardingInterface()->Commit(std::move(num_errors_handled));
}
IDBTransactionAsyncWaiter::IDBTransactionAsyncWaiter(
    IDBTransaction* proxy) : proxy_(proxy) {}

IDBTransactionAsyncWaiter::~IDBTransactionAsyncWaiter() = default;

void IDBTransactionAsyncWaiter::Put(
    int64_t object_store_id, ::std::unique_ptr<::blink::IDBValue> value, ::std::unique_ptr<::blink::IDBKey> key, IDBPutMode mode, WTF::Vector<::blink::IDBIndexKeys> index_keys, IDBTransactionPutResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Put(std::move(object_store_id),std::move(value),std::move(key),std::move(mode),std::move(index_keys),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBTransactionPutResultPtr* out_result
,
             IDBTransactionPutResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void IDBTransactionAsyncWaiter::PutAll(
    int64_t object_store_id, WTF::Vector<IDBPutParamsPtr> put_params, IDBTransactionPutAllResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->PutAll(std::move(object_store_id),std::move(put_params),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBTransactionPutAllResultPtr* out_result
,
             IDBTransactionPutAllResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void IDBDatabaseGetAllResultSinkInterceptorForTesting::ReceiveValues(WTF::Vector<IDBReturnValuePtr> values) {
  GetForwardingInterface()->ReceiveValues(std::move(values));
}
void IDBDatabaseGetAllResultSinkInterceptorForTesting::ReceiveKeys(WTF::Vector<::std::unique_ptr<::blink::IDBKey>> keys) {
  GetForwardingInterface()->ReceiveKeys(std::move(keys));
}
void IDBDatabaseGetAllResultSinkInterceptorForTesting::OnError(IDBErrorPtr error) {
  GetForwardingInterface()->OnError(std::move(error));
}
IDBDatabaseGetAllResultSinkAsyncWaiter::IDBDatabaseGetAllResultSinkAsyncWaiter(
    IDBDatabaseGetAllResultSink* proxy) : proxy_(proxy) {}

IDBDatabaseGetAllResultSinkAsyncWaiter::~IDBDatabaseGetAllResultSinkAsyncWaiter() = default;




void IDBDatabaseInterceptorForTesting::RenameObjectStore(int64_t transaction_id, int64_t object_store_id, const ::WTF::String& new_name) {
  GetForwardingInterface()->RenameObjectStore(std::move(transaction_id), std::move(object_store_id), std::move(new_name));
}
void IDBDatabaseInterceptorForTesting::CreateTransaction(::mojo::PendingAssociatedReceiver<IDBTransaction> transaction_receiver, int64_t transaction_id, const WTF::Vector<int64_t>& object_store_ids, IDBTransactionMode mode, IDBTransactionDurability durability) {
  GetForwardingInterface()->CreateTransaction(std::move(transaction_receiver), std::move(transaction_id), std::move(object_store_ids), std::move(mode), std::move(durability));
}
void IDBDatabaseInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
void IDBDatabaseInterceptorForTesting::VersionChangeIgnored() {
  GetForwardingInterface()->VersionChangeIgnored();
}
void IDBDatabaseInterceptorForTesting::Get(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool key_only, GetCallback callback) {
  GetForwardingInterface()->Get(std::move(transaction_id), std::move(object_store_id), std::move(index_id), std::move(key_range), std::move(key_only), std::move(callback));
}
void IDBDatabaseInterceptorForTesting::GetAll(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool key_only, int64_t max_count, GetAllCallback callback) {
  GetForwardingInterface()->GetAll(std::move(transaction_id), std::move(object_store_id), std::move(index_id), std::move(key_range), std::move(key_only), std::move(max_count), std::move(callback));
}
void IDBDatabaseInterceptorForTesting::SetIndexKeys(int64_t transaction_id, int64_t object_store_id, ::std::unique_ptr<::blink::IDBKey> primary_key, WTF::Vector<::blink::IDBIndexKeys> index_keys) {
  GetForwardingInterface()->SetIndexKeys(std::move(transaction_id), std::move(object_store_id), std::move(primary_key), std::move(index_keys));
}
void IDBDatabaseInterceptorForTesting::SetIndexesReady(int64_t transaction_id, int64_t object_store_id, const WTF::Vector<int64_t>& index_ids) {
  GetForwardingInterface()->SetIndexesReady(std::move(transaction_id), std::move(object_store_id), std::move(index_ids));
}
void IDBDatabaseInterceptorForTesting::OpenCursor(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, OpenCursorCallback callback) {
  GetForwardingInterface()->OpenCursor(std::move(transaction_id), std::move(object_store_id), std::move(index_id), std::move(key_range), std::move(direction), std::move(key_only), std::move(task_type), std::move(callback));
}
void IDBDatabaseInterceptorForTesting::Count(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, ::mojo::PendingAssociatedRemote<IDBCallbacks> pending_callbacks) {
  GetForwardingInterface()->Count(std::move(transaction_id), std::move(object_store_id), std::move(index_id), std::move(key_range), std::move(pending_callbacks));
}
void IDBDatabaseInterceptorForTesting::DeleteRange(int64_t transaction_id, int64_t object_store_id, IDBKeyRangePtr key_range, ::mojo::PendingAssociatedRemote<IDBCallbacks> pending_callbacks) {
  GetForwardingInterface()->DeleteRange(std::move(transaction_id), std::move(object_store_id), std::move(key_range), std::move(pending_callbacks));
}
void IDBDatabaseInterceptorForTesting::GetKeyGeneratorCurrentNumber(int64_t transaction_id, int64_t object_store_id, ::mojo::PendingAssociatedRemote<IDBCallbacks> pending_callbacks) {
  GetForwardingInterface()->GetKeyGeneratorCurrentNumber(std::move(transaction_id), std::move(object_store_id), std::move(pending_callbacks));
}
void IDBDatabaseInterceptorForTesting::Clear(int64_t transaction_id, int64_t object_store_id, ::mojo::PendingAssociatedRemote<IDBCallbacks> pending_callbacks) {
  GetForwardingInterface()->Clear(std::move(transaction_id), std::move(object_store_id), std::move(pending_callbacks));
}
void IDBDatabaseInterceptorForTesting::CreateIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id, const ::WTF::String& name, const ::blink::IDBKeyPath& key_path, bool unique, bool multi_entry) {
  GetForwardingInterface()->CreateIndex(std::move(transaction_id), std::move(object_store_id), std::move(index_id), std::move(name), std::move(key_path), std::move(unique), std::move(multi_entry));
}
void IDBDatabaseInterceptorForTesting::DeleteIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id) {
  GetForwardingInterface()->DeleteIndex(std::move(transaction_id), std::move(object_store_id), std::move(index_id));
}
void IDBDatabaseInterceptorForTesting::RenameIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id, const ::WTF::String& new_name) {
  GetForwardingInterface()->RenameIndex(std::move(transaction_id), std::move(object_store_id), std::move(index_id), std::move(new_name));
}
void IDBDatabaseInterceptorForTesting::Abort(int64_t transaction_id) {
  GetForwardingInterface()->Abort(std::move(transaction_id));
}
IDBDatabaseAsyncWaiter::IDBDatabaseAsyncWaiter(
    IDBDatabase* proxy) : proxy_(proxy) {}

IDBDatabaseAsyncWaiter::~IDBDatabaseAsyncWaiter() = default;

void IDBDatabaseAsyncWaiter::Get(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool key_only, IDBDatabaseGetResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Get(std::move(transaction_id),std::move(object_store_id),std::move(index_id),std::move(key_range),std::move(key_only),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBDatabaseGetResultPtr* out_result
,
             IDBDatabaseGetResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void IDBDatabaseAsyncWaiter::GetAll(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool key_only, int64_t max_count, ::mojo::PendingReceiver<IDBDatabaseGetAllResultSink>* out_receiver) {
  base::RunLoop loop;
  proxy_->GetAll(std::move(transaction_id),std::move(object_store_id),std::move(index_id),std::move(key_range),std::move(key_only),std::move(max_count),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingReceiver<IDBDatabaseGetAllResultSink>* out_receiver
,
             ::mojo::PendingReceiver<IDBDatabaseGetAllResultSink> receiver) {*out_receiver = std::move(receiver);
            loop->Quit();
          },
          &loop,
          out_receiver));
  loop.Run();
}
void IDBDatabaseAsyncWaiter::OpenCursor(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, IDBDatabaseOpenCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->OpenCursor(std::move(transaction_id),std::move(object_store_id),std::move(index_id),std::move(key_range),std::move(direction),std::move(key_only),std::move(task_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBDatabaseOpenCursorResultPtr* out_result
,
             IDBDatabaseOpenCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void IDBFactoryInterceptorForTesting::GetDatabaseInfo(::mojo::PendingAssociatedRemote<IDBCallbacks> pending_callbacks) {
  GetForwardingInterface()->GetDatabaseInfo(std::move(pending_callbacks));
}
void IDBFactoryInterceptorForTesting::Open(::mojo::PendingAssociatedRemote<IDBCallbacks> pending_callbacks, ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> database_callbacks, const ::WTF::String& name, int64_t version, ::mojo::PendingAssociatedReceiver<IDBTransaction> version_change_transaction_receiver, int64_t transaction_id) {
  GetForwardingInterface()->Open(std::move(pending_callbacks), std::move(database_callbacks), std::move(name), std::move(version), std::move(version_change_transaction_receiver), std::move(transaction_id));
}
void IDBFactoryInterceptorForTesting::DeleteDatabase(::mojo::PendingAssociatedRemote<IDBCallbacks> pending_callbacks, const ::WTF::String& name, bool force_close) {
  GetForwardingInterface()->DeleteDatabase(std::move(pending_callbacks), std::move(name), std::move(force_close));
}
void IDBFactoryInterceptorForTesting::AbortTransactionsAndCompactDatabase(AbortTransactionsAndCompactDatabaseCallback callback) {
  GetForwardingInterface()->AbortTransactionsAndCompactDatabase(std::move(callback));
}
void IDBFactoryInterceptorForTesting::AbortTransactionsForDatabase(AbortTransactionsForDatabaseCallback callback) {
  GetForwardingInterface()->AbortTransactionsForDatabase(std::move(callback));
}
IDBFactoryAsyncWaiter::IDBFactoryAsyncWaiter(
    IDBFactory* proxy) : proxy_(proxy) {}

IDBFactoryAsyncWaiter::~IDBFactoryAsyncWaiter() = default;

void IDBFactoryAsyncWaiter::AbortTransactionsAndCompactDatabase(
    IDBStatus* out_status) {
  base::RunLoop loop;
  proxy_->AbortTransactionsAndCompactDatabase(
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBStatus* out_status
,
             IDBStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void IDBFactoryAsyncWaiter::AbortTransactionsForDatabase(
    IDBStatus* out_status) {
  base::RunLoop loop;
  proxy_->AbortTransactionsForDatabase(
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBStatus* out_status
,
             IDBStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif