// third_party/blink/public/mojom/input/input_event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_event.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* ButtonToStringHelper(Button value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Button::kNoButton:
      return "kNoButton";
    case Button::kLeft:
      return "kLeft";
    case Button::kMiddle:
      return "kMiddle";
    case Button::kRight:
      return "{kRight, kBarrel}";
    case Button::kBack:
      return "kBack";
    case Button::kForward:
      return "kForward";
    case Button::kEraser:
      return "kEraser";
    default:
      return nullptr;
  }
}

std::string ButtonToString(Button value) {
  const char *str = ButtonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Button value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Button value) {
  return os << ButtonToString(value);
}

static NOINLINE const char* DispatchTypeToStringHelper(DispatchType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DispatchType::kBlocking:
      return "kBlocking";
    case DispatchType::kEventNonBlocking:
      return "kEventNonBlocking";
    case DispatchType::kListenersNonBlockingPassive:
      return "kListenersNonBlockingPassive";
    case DispatchType::kListenersForcedNonBlockingDueToFling:
      return "kListenersForcedNonBlockingDueToFling";
    default:
      return nullptr;
  }
}

std::string DispatchTypeToString(DispatchType value) {
  const char *str = DispatchTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DispatchType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DispatchType value) {
  return os << DispatchTypeToString(value);
}

static NOINLINE const char* EventTypeToStringHelper(EventType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EventType::kUndefined:
      return "{kUndefined, kTypeFirst}";
    case EventType::kMouseDown:
      return "{kMouseDown, kMouseTypeFirst}";
    case EventType::kMouseUp:
      return "kMouseUp";
    case EventType::kMouseMove:
      return "kMouseMove";
    case EventType::kMouseEnter:
      return "kMouseEnter";
    case EventType::kMouseLeave:
      return "kMouseLeave";
    case EventType::kContextMenu:
      return "{kContextMenu, kMouseTypeLast}";
    case EventType::kMouseWheel:
      return "kMouseWheel";
    case EventType::kRawKeyDown:
      return "{kRawKeyDown, kKeyboardTypeFirst}";
    case EventType::kKeyDown:
      return "kKeyDown";
    case EventType::kKeyUp:
      return "kKeyUp";
    case EventType::kChar:
      return "{kChar, kKeyboardTypeLast}";
    case EventType::kGestureScrollBegin:
      return "{kGestureScrollBegin, kGestureTypeFirst}";
    case EventType::kGestureScrollEnd:
      return "kGestureScrollEnd";
    case EventType::kGestureScrollUpdate:
      return "kGestureScrollUpdate";
    case EventType::kGestureFlingStart:
      return "kGestureFlingStart";
    case EventType::kGestureFlingCancel:
      return "kGestureFlingCancel";
    case EventType::kGesturePinchBegin:
      return "{kGesturePinchBegin, kGesturePinchTypeFirst}";
    case EventType::kGesturePinchEnd:
      return "kGesturePinchEnd";
    case EventType::kGesturePinchUpdate:
      return "{kGesturePinchUpdate, kGesturePinchTypeLast}";
    case EventType::kGestureTapDown:
      return "kGestureTapDown";
    case EventType::kGestureShowPress:
      return "kGestureShowPress";
    case EventType::kGestureTap:
      return "kGestureTap";
    case EventType::kGestureTapCancel:
      return "kGestureTapCancel";
    case EventType::kGestureLongPress:
      return "kGestureLongPress";
    case EventType::kGestureLongTap:
      return "kGestureLongTap";
    case EventType::kGestureTwoFingerTap:
      return "kGestureTwoFingerTap";
    case EventType::kGestureTapUnconfirmed:
      return "kGestureTapUnconfirmed";
    case EventType::kGestureDoubleTap:
      return "{kGestureDoubleTap, kGestureTypeLast}";
    case EventType::kTouchStart:
      return "{kTouchStart, kTouchTypeFirst}";
    case EventType::kTouchMove:
      return "kTouchMove";
    case EventType::kTouchEnd:
      return "kTouchEnd";
    case EventType::kTouchCancel:
      return "kTouchCancel";
    case EventType::kTouchScrollStarted:
      return "{kTouchScrollStarted, kTouchTypeLast}";
    case EventType::kPointerDown:
      return "{kPointerDown, kPointerTypeFirst}";
    case EventType::kPointerUp:
      return "kPointerUp";
    case EventType::kPointerMove:
      return "kPointerMove";
    case EventType::kPointerRawUpdate:
      return "kPointerRawUpdate";
    case EventType::kPointerCancel:
      return "kPointerCancel";
    case EventType::kPointerCausedUaAction:
      return "{kPointerCausedUaAction, kPointerTypeLast, kTypeLast}";
    default:
      return nullptr;
  }
}

std::string EventTypeToString(EventType value) {
  const char *str = EventTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EventType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EventType value) {
  return os << EventTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Button>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::Button value) {
  return std::move(context).WriteString(::blink::mojom::ButtonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DispatchType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::DispatchType value) {
  return std::move(context).WriteString(::blink::mojom::DispatchTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EventType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::EventType value) {
  return std::move(context).WriteString(::blink::mojom::EventTypeToString(value));
}

} // namespace perfetto
