// third_party/blink/public/mojom/input/input_handler.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/input_handler.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_handler.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/input_handler.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
KeyData::KeyData()
    : dom_key(),
      dom_code(),
      windows_key_code(),
      native_key_code(),
      is_system_key(),
      is_browser_shortcut(),
      text(),
      unmodified_text() {}

KeyData::KeyData(
    int32_t dom_key_in,
    int32_t dom_code_in,
    int32_t windows_key_code_in,
    int32_t native_key_code_in,
    bool is_system_key_in,
    bool is_browser_shortcut_in,
    const ::std::u16string& text_in,
    const ::std::u16string& unmodified_text_in)
    : dom_key(std::move(dom_key_in)),
      dom_code(std::move(dom_code_in)),
      windows_key_code(std::move(windows_key_code_in)),
      native_key_code(std::move(native_key_code_in)),
      is_system_key(std::move(is_system_key_in)),
      is_browser_shortcut(std::move(is_browser_shortcut_in)),
      text(std::move(text_in)),
      unmodified_text(std::move(unmodified_text_in)) {}

KeyData::~KeyData() = default;

void KeyData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_key"), this->dom_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_code"), this->dom_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "windows_key_code"), this->windows_key_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_key_code"), this->native_key_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_system_key"), this->is_system_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_browser_shortcut"), this->is_browser_shortcut,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unmodified_text"), this->unmodified_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeyData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PointerData::PointerData()
    : pointer_id(),
      force(),
      tilt_x(),
      tilt_y(),
      tangential_pressure(),
      twist(),
      button(),
      pointer_type(),
      movement_x(),
      movement_y(),
      is_raw_movement_event(),
      widget_position(),
      screen_position(),
      mouse_data() {}

PointerData::PointerData(
    int32_t pointer_id_in,
    float force_in,
    int32_t tilt_x_in,
    int32_t tilt_y_in,
    float tangential_pressure_in,
    int32_t twist_in,
    ::blink::mojom::Button button_in,
    ::ui::EventPointerType pointer_type_in,
    int32_t movement_x_in,
    int32_t movement_y_in,
    bool is_raw_movement_event_in,
    const ::gfx::PointF& widget_position_in,
    const ::gfx::PointF& screen_position_in,
    MouseDataPtr mouse_data_in)
    : pointer_id(std::move(pointer_id_in)),
      force(std::move(force_in)),
      tilt_x(std::move(tilt_x_in)),
      tilt_y(std::move(tilt_y_in)),
      tangential_pressure(std::move(tangential_pressure_in)),
      twist(std::move(twist_in)),
      button(std::move(button_in)),
      pointer_type(std::move(pointer_type_in)),
      movement_x(std::move(movement_x_in)),
      movement_y(std::move(movement_y_in)),
      is_raw_movement_event(std::move(is_raw_movement_event_in)),
      widget_position(std::move(widget_position_in)),
      screen_position(std::move(screen_position_in)),
      mouse_data(std::move(mouse_data_in)) {}

PointerData::~PointerData() = default;

void PointerData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_id"), this->pointer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force"), this->force,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_x"), this->tilt_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_y"), this->tilt_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tangential_pressure"), this->tangential_pressure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "twist"), this->twist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button"), this->button,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::Button>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_type"), this->pointer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::EventPointerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "movement_x"), this->movement_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "movement_y"), this->movement_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_raw_movement_event"), this->is_raw_movement_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_position"), this->widget_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_position"), this->screen_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mouse_data"), this->mouse_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MouseDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PointerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WheelData::WheelData()
    : delta_x(),
      delta_y(),
      wheel_ticks_x(),
      wheel_ticks_y(),
      acceleration_ratio_x(),
      acceleration_ratio_y(),
      phase(),
      momentum_phase(),
      cancelable(),
      event_action(),
      delta_units() {}

WheelData::WheelData(
    float delta_x_in,
    float delta_y_in,
    float wheel_ticks_x_in,
    float wheel_ticks_y_in,
    float acceleration_ratio_x_in,
    float acceleration_ratio_y_in,
    uint8_t phase_in,
    uint8_t momentum_phase_in,
    ::blink::mojom::DispatchType cancelable_in,
    uint8_t event_action_in,
    uint8_t delta_units_in)
    : delta_x(std::move(delta_x_in)),
      delta_y(std::move(delta_y_in)),
      wheel_ticks_x(std::move(wheel_ticks_x_in)),
      wheel_ticks_y(std::move(wheel_ticks_y_in)),
      acceleration_ratio_x(std::move(acceleration_ratio_x_in)),
      acceleration_ratio_y(std::move(acceleration_ratio_y_in)),
      phase(std::move(phase_in)),
      momentum_phase(std::move(momentum_phase_in)),
      cancelable(std::move(cancelable_in)),
      event_action(std::move(event_action_in)),
      delta_units(std::move(delta_units_in)) {}

WheelData::~WheelData() = default;
size_t WheelData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->delta_x);
  seed = mojo::internal::Hash(seed, this->delta_y);
  seed = mojo::internal::Hash(seed, this->wheel_ticks_x);
  seed = mojo::internal::Hash(seed, this->wheel_ticks_y);
  seed = mojo::internal::Hash(seed, this->acceleration_ratio_x);
  seed = mojo::internal::Hash(seed, this->acceleration_ratio_y);
  seed = mojo::internal::Hash(seed, this->phase);
  seed = mojo::internal::Hash(seed, this->momentum_phase);
  seed = mojo::internal::Hash(seed, this->cancelable);
  seed = mojo::internal::Hash(seed, this->event_action);
  seed = mojo::internal::Hash(seed, this->delta_units);
  return seed;
}

void WheelData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_x"), this->delta_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_y"), this->delta_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_ticks_x"), this->wheel_ticks_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_ticks_y"), this->wheel_ticks_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "acceleration_ratio_x"), this->acceleration_ratio_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "acceleration_ratio_y"), this->acceleration_ratio_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "phase"), this->phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "momentum_phase"), this->momentum_phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cancelable"), this->cancelable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::DispatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_action"), this->event_action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_units"), this->delta_units,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WheelData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MouseData::MouseData()
    : click_count(),
      wheel_data() {}

MouseData::MouseData(
    int32_t click_count_in,
    WheelDataPtr wheel_data_in)
    : click_count(std::move(click_count_in)),
      wheel_data(std::move(wheel_data_in)) {}

MouseData::~MouseData() = default;

void MouseData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "click_count"), this->click_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_data"), this->wheel_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WheelDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MouseData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollUpdate::ScrollUpdate()
    : velocity_x(),
      velocity_y() {}

ScrollUpdate::ScrollUpdate(
    float velocity_x_in,
    float velocity_y_in)
    : velocity_x(std::move(velocity_x_in)),
      velocity_y(std::move(velocity_y_in)) {}

ScrollUpdate::~ScrollUpdate() = default;
size_t ScrollUpdate::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->velocity_x);
  seed = mojo::internal::Hash(seed, this->velocity_y);
  return seed;
}

void ScrollUpdate::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "velocity_x"), this->velocity_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "velocity_y"), this->velocity_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollData::ScrollData()
    : delta_x(),
      delta_y(),
      delta_units(),
      target_viewport(),
      inertial_phase(),
      synthetic(),
      pointer_count(),
      cursor_control(),
      update_details() {}

ScrollData::ScrollData(
    float delta_x_in,
    float delta_y_in,
    ::ui::ScrollGranularity delta_units_in,
    bool target_viewport_in,
    ::blink::mojom::InertialPhaseState inertial_phase_in,
    bool synthetic_in,
    int32_t pointer_count_in,
    bool cursor_control_in,
    ScrollUpdatePtr update_details_in)
    : delta_x(std::move(delta_x_in)),
      delta_y(std::move(delta_y_in)),
      delta_units(std::move(delta_units_in)),
      target_viewport(std::move(target_viewport_in)),
      inertial_phase(std::move(inertial_phase_in)),
      synthetic(std::move(synthetic_in)),
      pointer_count(std::move(pointer_count_in)),
      cursor_control(std::move(cursor_control_in)),
      update_details(std::move(update_details_in)) {}

ScrollData::~ScrollData() = default;

void ScrollData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_x"), this->delta_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_y"), this->delta_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_units"), this->delta_units,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::ScrollGranularity>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_viewport"), this->target_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inertial_phase"), this->inertial_phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::InertialPhaseState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "synthetic"), this->synthetic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_count"), this->pointer_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cursor_control"), this->cursor_control,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_details"), this->update_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollUpdatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinchBeginData::PinchBeginData()
    : needs_wheel_event() {}

PinchBeginData::PinchBeginData(
    bool needs_wheel_event_in)
    : needs_wheel_event(std::move(needs_wheel_event_in)) {}

PinchBeginData::~PinchBeginData() = default;
size_t PinchBeginData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->needs_wheel_event);
  return seed;
}

void PinchBeginData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinchBeginData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinchUpdateData::PinchUpdateData()
    : scale(),
      zoom_disabled(),
      needs_wheel_event() {}

PinchUpdateData::PinchUpdateData(
    float scale_in,
    bool zoom_disabled_in,
    bool needs_wheel_event_in)
    : scale(std::move(scale_in)),
      zoom_disabled(std::move(zoom_disabled_in)),
      needs_wheel_event(std::move(needs_wheel_event_in)) {}

PinchUpdateData::~PinchUpdateData() = default;
size_t PinchUpdateData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->scale);
  seed = mojo::internal::Hash(seed, this->zoom_disabled);
  seed = mojo::internal::Hash(seed, this->needs_wheel_event);
  return seed;
}

void PinchUpdateData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zoom_disabled"), this->zoom_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinchUpdateData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinchEndData::PinchEndData()
    : needs_wheel_event() {}

PinchEndData::PinchEndData(
    bool needs_wheel_event_in)
    : needs_wheel_event(std::move(needs_wheel_event_in)) {}

PinchEndData::~PinchEndData() = default;
size_t PinchEndData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->needs_wheel_event);
  return seed;
}

void PinchEndData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinchEndData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FlingData::FlingData()
    : velocity_x(),
      velocity_y(),
      target_viewport(),
      prevent_boosting() {}

FlingData::FlingData(
    float velocity_x_in,
    float velocity_y_in,
    bool target_viewport_in,
    bool prevent_boosting_in)
    : velocity_x(std::move(velocity_x_in)),
      velocity_y(std::move(velocity_y_in)),
      target_viewport(std::move(target_viewport_in)),
      prevent_boosting(std::move(prevent_boosting_in)) {}

FlingData::~FlingData() = default;
size_t FlingData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->velocity_x);
  seed = mojo::internal::Hash(seed, this->velocity_y);
  seed = mojo::internal::Hash(seed, this->target_viewport);
  seed = mojo::internal::Hash(seed, this->prevent_boosting);
  return seed;
}

void FlingData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "velocity_x"), this->velocity_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "velocity_y"), this->velocity_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_viewport"), this->target_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prevent_boosting"), this->prevent_boosting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FlingData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TapData::TapData()
    : tap_count(),
      needs_wheel_event() {}

TapData::TapData(
    int32_t tap_count_in,
    bool needs_wheel_event_in)
    : tap_count(std::move(tap_count_in)),
      needs_wheel_event(std::move(needs_wheel_event_in)) {}

TapData::~TapData() = default;
size_t TapData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->tap_count);
  seed = mojo::internal::Hash(seed, this->needs_wheel_event);
  return seed;
}

void TapData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tap_count"), this->tap_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TapData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GestureData::GestureData()
    : screen_position(),
      widget_position(),
      source_device(),
      is_source_touch_event_set_blocking(),
      primary_pointer_type(),
      primary_unique_touch_event_id(),
      unique_touch_event_id(),
      contact_size(),
      scroll_data(),
      pinch_begin_data(),
      pinch_update_data(),
      pinch_end_data(),
      tap_data(),
      fling_data() {}

GestureData::GestureData(
    const ::gfx::PointF& screen_position_in,
    const ::gfx::PointF& widget_position_in,
    ::blink::mojom::GestureDevice source_device_in,
    bool is_source_touch_event_set_blocking_in,
    ::ui::EventPointerType primary_pointer_type_in,
    int32_t primary_unique_touch_event_id_in,
    int32_t unique_touch_event_id_in,
    const absl::optional<::gfx::Size>& contact_size_in,
    ScrollDataPtr scroll_data_in,
    PinchBeginDataPtr pinch_begin_data_in,
    PinchUpdateDataPtr pinch_update_data_in,
    PinchEndDataPtr pinch_end_data_in,
    TapDataPtr tap_data_in,
    FlingDataPtr fling_data_in)
    : screen_position(std::move(screen_position_in)),
      widget_position(std::move(widget_position_in)),
      source_device(std::move(source_device_in)),
      is_source_touch_event_set_blocking(std::move(is_source_touch_event_set_blocking_in)),
      primary_pointer_type(std::move(primary_pointer_type_in)),
      primary_unique_touch_event_id(std::move(primary_unique_touch_event_id_in)),
      unique_touch_event_id(std::move(unique_touch_event_id_in)),
      contact_size(std::move(contact_size_in)),
      scroll_data(std::move(scroll_data_in)),
      pinch_begin_data(std::move(pinch_begin_data_in)),
      pinch_update_data(std::move(pinch_update_data_in)),
      pinch_end_data(std::move(pinch_end_data_in)),
      tap_data(std::move(tap_data_in)),
      fling_data(std::move(fling_data_in)) {}

GestureData::~GestureData() = default;

void GestureData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_position"), this->screen_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_position"), this->widget_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_device"), this->source_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::GestureDevice>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_source_touch_event_set_blocking"), this->is_source_touch_event_set_blocking,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_pointer_type"), this->primary_pointer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::EventPointerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_unique_touch_event_id"), this->primary_unique_touch_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_touch_event_id"), this->unique_touch_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contact_size"), this->contact_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_data"), this->scroll_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinch_begin_data"), this->pinch_begin_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PinchBeginDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinch_update_data"), this->pinch_update_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PinchUpdateDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinch_end_data"), this->pinch_end_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PinchEndDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tap_data"), this->tap_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TapDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fling_data"), this->fling_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FlingDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GestureData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchPoint::TouchPoint()
    : state(),
      radius_x(),
      radius_y(),
      rotation_angle(),
      pointer_data() {}

TouchPoint::TouchPoint(
    ::blink::mojom::TouchState state_in,
    float radius_x_in,
    float radius_y_in,
    float rotation_angle_in,
    PointerDataPtr pointer_data_in)
    : state(std::move(state_in)),
      radius_x(std::move(radius_x_in)),
      radius_y(std::move(radius_y_in)),
      rotation_angle(std::move(rotation_angle_in)),
      pointer_data(std::move(pointer_data_in)) {}

TouchPoint::~TouchPoint() = default;

void TouchPoint::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::TouchState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius_x"), this->radius_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius_y"), this->radius_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation_angle"), this->rotation_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_data"), this->pointer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PointerDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchPoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchData::TouchData()
    : cancelable(),
      moved_beyond_slop_region(),
      touch_start_or_first_move(),
      hovering(),
      unique_touch_event_id(),
      touches() {}

TouchData::TouchData(
    ::blink::mojom::DispatchType cancelable_in,
    bool moved_beyond_slop_region_in,
    bool touch_start_or_first_move_in,
    bool hovering_in,
    uint32_t unique_touch_event_id_in,
    std::vector<TouchPointPtr> touches_in)
    : cancelable(std::move(cancelable_in)),
      moved_beyond_slop_region(std::move(moved_beyond_slop_region_in)),
      touch_start_or_first_move(std::move(touch_start_or_first_move_in)),
      hovering(std::move(hovering_in)),
      unique_touch_event_id(std::move(unique_touch_event_id_in)),
      touches(std::move(touches_in)) {}

TouchData::~TouchData() = default;

void TouchData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cancelable"), this->cancelable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::DispatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "moved_beyond_slop_region"), this->moved_beyond_slop_region,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_start_or_first_move"), this->touch_start_or_first_move,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hovering"), this->hovering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_touch_event_id"), this->unique_touch_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touches"), this->touches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TouchPointPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Event::Event()
    : type(),
      modifiers(),
      timestamp(),
      latency(),
      key_data(),
      pointer_data(),
      gesture_data(),
      touch_data() {}

Event::Event(
    ::blink::mojom::EventType type_in,
    int32_t modifiers_in,
    ::base::TimeTicks timestamp_in,
    const ::ui::LatencyInfo& latency_in,
    KeyDataPtr key_data_in,
    PointerDataPtr pointer_data_in,
    GestureDataPtr gesture_data_in,
    TouchDataPtr touch_data_in)
    : type(std::move(type_in)),
      modifiers(std::move(modifiers_in)),
      timestamp(std::move(timestamp_in)),
      latency(std::move(latency_in)),
      key_data(std::move(key_data_in)),
      pointer_data(std::move(pointer_data_in)),
      gesture_data(std::move(gesture_data_in)),
      touch_data(std::move(touch_data_in)) {}

Event::~Event() = default;

void Event::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::EventType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency"), this->latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::LatencyInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_data"), this->key_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_data"), this->pointer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PointerDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_data"), this->gesture_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_data"), this->touch_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TouchDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Event::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidOverscrollParams::DidOverscrollParams()
    : accumulated_overscroll(),
      latest_overscroll_delta(),
      current_fling_velocity(),
      causal_event_viewport_point(),
      overscroll_behavior() {}

DidOverscrollParams::DidOverscrollParams(
    const ::gfx::Vector2dF& accumulated_overscroll_in,
    const ::gfx::Vector2dF& latest_overscroll_delta_in,
    const ::gfx::Vector2dF& current_fling_velocity_in,
    const ::gfx::PointF& causal_event_viewport_point_in,
    const ::cc::OverscrollBehavior& overscroll_behavior_in)
    : accumulated_overscroll(std::move(accumulated_overscroll_in)),
      latest_overscroll_delta(std::move(latest_overscroll_delta_in)),
      current_fling_velocity(std::move(current_fling_velocity_in)),
      causal_event_viewport_point(std::move(causal_event_viewport_point_in)),
      overscroll_behavior(std::move(overscroll_behavior_in)) {}

DidOverscrollParams::~DidOverscrollParams() = default;

void DidOverscrollParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accumulated_overscroll"), this->accumulated_overscroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latest_overscroll_delta"), this->latest_overscroll_delta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_fling_velocity"), this->current_fling_velocity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "causal_event_viewport_point"), this->causal_event_viewport_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overscroll_behavior"), this->overscroll_behavior,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::cc::OverscrollBehavior&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidOverscrollParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchActionOptional::TouchActionOptional()
    : touch_action() {}

TouchActionOptional::TouchActionOptional(
    ::cc::TouchAction touch_action_in)
    : touch_action(std::move(touch_action_in)) {}

TouchActionOptional::~TouchActionOptional() = default;

void TouchActionOptional::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_action"), this->touch_action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::TouchAction>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchActionOptional::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EditCommand::EditCommand()
    : name(),
      value() {}

EditCommand::EditCommand(
    const std::string& name_in,
    const std::string& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

EditCommand::~EditCommand() = default;
size_t EditCommand::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void EditCommand::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EditCommand::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char WidgetInputHandlerHost::Name_[] = "blink.mojom.WidgetInputHandlerHost";

class WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback(
      WidgetInputHandlerHost::RequestMouseLockCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandlerHost::RequestMouseLockCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback);
};

WidgetInputHandlerHostProxy::WidgetInputHandlerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetInputHandlerHostProxy::SetTouchActionFromMain(
    ::cc::TouchAction in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandlerHost::SetTouchActionFromMain", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_action"), in_touch_action,
                        "<value of type ::cc::TouchAction>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_SetTouchActionFromMain_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::cc::mojom::TouchAction>(
      in_touch_action, &params->touch_action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("SetTouchActionFromMain");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerHostProxy::DidOverscroll(
    DidOverscrollParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandlerHost::DidOverscroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidOverscrollParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_DidOverscroll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_DidOverscroll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DidOverscrollParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in WidgetInputHandlerHost.DidOverscroll request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("DidOverscroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerHostProxy::DidStartScrollingViewport(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WidgetInputHandlerHost::DidStartScrollingViewport");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_DidStartScrollingViewport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("DidStartScrollingViewport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerHostProxy::ImeCancelComposition(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WidgetInputHandlerHost::ImeCancelComposition");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_ImeCancelComposition_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("ImeCancelComposition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerHostProxy::ImeCompositionRangeChanged(
    const ::gfx::Range& in_range, const std::vector<::gfx::Rect>& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandlerHost::ImeCompositionRangeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const std::vector<::gfx::Rect>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_ImeCompositionRangeChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
      in_range, range_fragment);
  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null range in WidgetInputHandlerHost.ImeCompositionRangeChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType>
      bounds_fragment(params.message());
  const mojo::internal::ContainerValidateParams bounds_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
      in_bounds, bounds_fragment, &bounds_validate_params);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in WidgetInputHandlerHost.ImeCompositionRangeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("ImeCompositionRangeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerHostProxy::SetMouseCapture(
    bool in_capture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandlerHost::SetMouseCapture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture"), in_capture,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_SetMouseCapture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data> params(
          message);
  params.Allocate();
  params->capture = in_capture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("SetMouseCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerHostProxy::RequestMouseLock(
    bool in_from_user_gesture, bool in_unadjusted_movement, RequestMouseLockCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandlerHost::RequestMouseLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("from_user_gesture"), in_from_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unadjusted_movement"), in_unadjusted_movement,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_RequestMouseLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data> params(
          message);
  params.Allocate();
  params->from_user_gesture = in_from_user_gesture;
  params->unadjusted_movement = in_unadjusted_movement;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("RequestMouseLock");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder {
 public:
  static WidgetInputHandlerHost::RequestMouseLockCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder> proxy(
        new WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WidgetInputHandlerHost::RequestMouseLockCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PointerLockResult in_result, ::mojo::PendingRemote<::blink::mojom::PointerLockContext> in_context);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder);
};

bool WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WidgetInputHandlerHost::RequestMouseLockCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::PointerLockResult p_result{};
  ::mojo::PendingRemote<::blink::mojom::PointerLockContext> p_context{};
  WidgetInputHandlerHost_RequestMouseLock_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_context =
        input_data_view.TakeContext<decltype(p_context)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandlerHost::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_context));
  return true;
}

void WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder::Run(
    ::blink::mojom::PointerLockResult in_result, ::mojo::PendingRemote<::blink::mojom::PointerLockContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WidgetInputHandlerHost::RequestMouseLockCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::PointerLockResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::PointerLockContext>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandlerHost_RequestMouseLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PointerLockResult>(
      in_result, &params->result);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PointerLockContextInterfaceBase>>(
      in_context, &params->context, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WidgetInputHandlerHost::RequestMouseLockCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("RequestMouseLock");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetInputHandlerHostStubDispatch::Accept(
    WidgetInputHandlerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWidgetInputHandlerHost_SetTouchActionFromMain_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandlerHost::SetTouchActionFromMain",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandlerHost::SetTouchActionFromMain");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::cc::TouchAction p_touch_action{};
      WidgetInputHandlerHost_SetTouchActionFromMain_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTouchAction(&p_touch_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTouchActionFromMain(
std::move(p_touch_action));
      return true;
    }
    case internal::kWidgetInputHandlerHost_DidOverscroll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandlerHost::DidOverscroll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandlerHost::DidOverscroll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_DidOverscroll_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_DidOverscroll_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DidOverscrollParamsPtr p_params{};
      WidgetInputHandlerHost_DidOverscroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidOverscroll(
std::move(p_params));
      return true;
    }
    case internal::kWidgetInputHandlerHost_DidStartScrollingViewport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandlerHost::DidStartScrollingViewport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandlerHost::DidStartScrollingViewport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WidgetInputHandlerHost_DidStartScrollingViewport_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartScrollingViewport();
      return true;
    }
    case internal::kWidgetInputHandlerHost_ImeCancelComposition_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandlerHost::ImeCancelComposition",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandlerHost::ImeCancelComposition");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WidgetInputHandlerHost_ImeCancelComposition_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCancelComposition();
      return true;
    }
    case internal::kWidgetInputHandlerHost_ImeCompositionRangeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandlerHost::ImeCompositionRangeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandlerHost::ImeCompositionRangeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Range p_range{};
      std::vector<::gfx::Rect> p_bounds{};
      WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCompositionRangeChanged(
std::move(p_range), 
std::move(p_bounds));
      return true;
    }
    case internal::kWidgetInputHandlerHost_SetMouseCapture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandlerHost::SetMouseCapture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandlerHost::SetMouseCapture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_capture{};
      WidgetInputHandlerHost_SetMouseCapture_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_capture = input_data_view.capture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMouseCapture(
std::move(p_capture));
      return true;
    }
    case internal::kWidgetInputHandlerHost_RequestMouseLock_Name: {
      break;
    }
  }
  return false;
}

// static
bool WidgetInputHandlerHostStubDispatch::AcceptWithResponder(
    WidgetInputHandlerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWidgetInputHandlerHost_SetTouchActionFromMain_Name: {
      break;
    }
    case internal::kWidgetInputHandlerHost_DidOverscroll_Name: {
      break;
    }
    case internal::kWidgetInputHandlerHost_DidStartScrollingViewport_Name: {
      break;
    }
    case internal::kWidgetInputHandlerHost_ImeCancelComposition_Name: {
      break;
    }
    case internal::kWidgetInputHandlerHost_ImeCompositionRangeChanged_Name: {
      break;
    }
    case internal::kWidgetInputHandlerHost_SetMouseCapture_Name: {
      break;
    }
    case internal::kWidgetInputHandlerHost_RequestMouseLock_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandlerHost::RequestMouseLock",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandlerHost::RequestMouseLock");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_from_user_gesture{};
      bool p_unadjusted_movement{};
      WidgetInputHandlerHost_RequestMouseLock_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_from_user_gesture = input_data_view.from_user_gesture();
      if (success)
        p_unadjusted_movement = input_data_view.unadjusted_movement();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 6, false);
        return false;
      }
      WidgetInputHandlerHost::RequestMouseLockCallback callback =
          WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMouseLock(
std::move(p_from_user_gesture), 
std::move(p_unadjusted_movement), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWidgetInputHandlerHostValidationInfo[] = {
    {&internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandlerHost_DidOverscroll_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data::Validate,
     &internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data::Validate},
};

bool WidgetInputHandlerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WidgetInputHandlerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWidgetInputHandlerHostValidationInfo);
}

bool WidgetInputHandlerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WidgetInputHandlerHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kWidgetInputHandlerHostValidationInfo);
}
const char FrameWidgetInputHandler::Name_[] = "blink.mojom.FrameWidgetInputHandler";

FrameWidgetInputHandlerProxy::FrameWidgetInputHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameWidgetInputHandlerProxy::AddImeTextSpansToExistingText(
    uint32_t in_start, uint32_t in_end, const std::vector<::ui::ImeTextSpan>& in_ime_text_spans) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::AddImeTextSpansToExistingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const std::vector<::ui::ImeTextSpan>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_AddImeTextSpansToExistingText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data> params(
          message);
  params.Allocate();
  params->start = in_start;
  params->end = in_end;
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  const mojo::internal::ContainerValidateParams ime_text_spans_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
      in_ime_text_spans, ime_text_spans_fragment, &ime_text_spans_validate_params);
  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ime_text_spans.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ime_text_spans in FrameWidgetInputHandler.AddImeTextSpansToExistingText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("AddImeTextSpansToExistingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::ClearImeTextSpansByType(
    uint32_t in_start, uint32_t in_end, ::ui::ImeTextSpan::Type in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::ClearImeTextSpansByType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::ui::ImeTextSpan::Type>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_ClearImeTextSpansByType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data> params(
          message);
  params.Allocate();
  params->start = in_start;
  params->end = in_end;
  mojo::internal::Serialize<::ui::mojom::ImeTextSpanType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ClearImeTextSpansByType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::SetCompositionFromExistingText(
    int32_t in_start, int32_t in_end, const std::vector<::ui::ImeTextSpan>& in_ime_text_spans) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::SetCompositionFromExistingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const std::vector<::ui::ImeTextSpan>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_SetCompositionFromExistingText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data> params(
          message);
  params.Allocate();
  params->start = in_start;
  params->end = in_end;
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  const mojo::internal::ContainerValidateParams ime_text_spans_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
      in_ime_text_spans, ime_text_spans_fragment, &ime_text_spans_validate_params);
  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ime_text_spans.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ime_text_spans in FrameWidgetInputHandler.SetCompositionFromExistingText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SetCompositionFromExistingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::ExtendSelectionAndDelete(
    int32_t in_before, int32_t in_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndDelete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before"), in_before,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("after"), in_after,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_ExtendSelectionAndDelete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data> params(
          message);
  params.Allocate();
  params->before = in_before;
  params->after = in_after;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ExtendSelectionAndDelete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::DeleteSurroundingText(
    int32_t in_before, int32_t in_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::DeleteSurroundingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before"), in_before,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("after"), in_after,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_DeleteSurroundingText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data> params(
          message);
  params.Allocate();
  params->before = in_before;
  params->after = in_after;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("DeleteSurroundingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::DeleteSurroundingTextInCodePoints(
    int32_t in_before, int32_t in_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before"), in_before,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("after"), in_after,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data> params(
          message);
  params.Allocate();
  params->before = in_before;
  params->after = in_after;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("DeleteSurroundingTextInCodePoints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::SetEditableSelectionOffsets(
    int32_t in_start, int32_t in_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::SetEditableSelectionOffsets", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_SetEditableSelectionOffsets_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data> params(
          message);
  params.Allocate();
  params->start = in_start;
  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SetEditableSelectionOffsets");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::ExecuteEditCommand(
    const std::string& in_command, const absl::optional<::std::u16string>& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::ExecuteEditCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), in_command,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const absl::optional<::std::u16string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_ExecuteEditCommand_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->command)::BaseType> command_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_command, command_fragment);
  params->command.Set(
      command_fragment.is_null() ? nullptr : command_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->command.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null command in FrameWidgetInputHandler.ExecuteEditCommand request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_value, value_fragment);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ExecuteEditCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::Undo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::Undo");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_Undo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Undo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::Redo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::Redo");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_Redo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Redo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Redo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::Cut(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::Cut");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_Cut_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Cut_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Cut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::Copy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::Copy");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_Copy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Copy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Copy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::CopyToFindPboard(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::CopyToFindPboard");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_CopyToFindPboard_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("CopyToFindPboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::Paste(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::Paste");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_Paste_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Paste_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Paste");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::PasteAndMatchStyle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::PasteAndMatchStyle");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_PasteAndMatchStyle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("PasteAndMatchStyle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::Delete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::Delete");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Delete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Delete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::SelectAll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::SelectAll");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_SelectAll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SelectAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SelectAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::CollapseSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetInputHandler::CollapseSelection");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_CollapseSelection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_CollapseSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("CollapseSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::Replace(
    const ::std::u16string& in_word) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::Replace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("word"), in_word,
                        "<value of type const ::std::u16string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_Replace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Replace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->word)::BaseType> word_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_word, word_fragment);
  params->word.Set(
      word_fragment.is_null() ? nullptr : word_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->word.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null word in FrameWidgetInputHandler.Replace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Replace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::ReplaceMisspelling(
    const ::std::u16string& in_word) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::ReplaceMisspelling", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("word"), in_word,
                        "<value of type const ::std::u16string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_ReplaceMisspelling_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->word)::BaseType> word_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_word, word_fragment);
  params->word.Set(
      word_fragment.is_null() ? nullptr : word_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->word.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null word in FrameWidgetInputHandler.ReplaceMisspelling request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ReplaceMisspelling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::SelectRange(
    const ::gfx::Point& in_base, const ::gfx::Point& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::SelectRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("base"), in_base,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::Point&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_SelectRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SelectRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->base)::BaseType> base_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_base, base_fragment);
  params->base.Set(
      base_fragment.is_null() ? nullptr : base_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->base.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null base in FrameWidgetInputHandler.SelectRange request");
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_extent, extent_fragment);
  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extent in FrameWidgetInputHandler.SelectRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SelectRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::AdjustSelectionByCharacterOffset(
    int32_t in_start, int32_t in_end, ::blink::mojom::SelectionMenuBehavior in_behavior) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::AdjustSelectionByCharacterOffset", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("behavior"), in_behavior,
                        "<value of type ::blink::mojom::SelectionMenuBehavior>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data> params(
          message);
  params.Allocate();
  params->start = in_start;
  params->end = in_end;
  mojo::internal::Serialize<::blink::mojom::SelectionMenuBehavior>(
      in_behavior, &params->behavior);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("AdjustSelectionByCharacterOffset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::MoveRangeSelectionExtent(
    const ::gfx::Point& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::MoveRangeSelectionExtent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::Point&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_MoveRangeSelectionExtent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_extent, extent_fragment);
  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extent in FrameWidgetInputHandler.MoveRangeSelectionExtent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("MoveRangeSelectionExtent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::ScrollFocusedEditableNodeIntoRect(
    const ::gfx::Rect& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoRect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect, rect_fragment);
  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in FrameWidgetInputHandler.ScrollFocusedEditableNodeIntoRect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ScrollFocusedEditableNodeIntoRect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetInputHandlerProxy::MoveCaret(
    const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetInputHandler::MoveCaret", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameWidgetInputHandler_MoveCaret_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_MoveCaret_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in FrameWidgetInputHandler.MoveCaret request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("MoveCaret");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameWidgetInputHandlerStubDispatch::Accept(
    FrameWidgetInputHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameWidgetInputHandler_AddImeTextSpansToExistingText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::AddImeTextSpansToExistingText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::AddImeTextSpansToExistingText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_start{};
      uint32_t p_end{};
      std::vector<::ui::ImeTextSpan> p_ime_text_spans{};
      FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddImeTextSpansToExistingText(
std::move(p_start), 
std::move(p_end), 
std::move(p_ime_text_spans));
      return true;
    }
    case internal::kFrameWidgetInputHandler_ClearImeTextSpansByType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::ClearImeTextSpansByType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::ClearImeTextSpansByType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_start{};
      uint32_t p_end{};
      ::ui::ImeTextSpan::Type p_type{};
      FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearImeTextSpansByType(
std::move(p_start), 
std::move(p_end), 
std::move(p_type));
      return true;
    }
    case internal::kFrameWidgetInputHandler_SetCompositionFromExistingText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::SetCompositionFromExistingText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::SetCompositionFromExistingText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_start{};
      int32_t p_end{};
      std::vector<::ui::ImeTextSpan> p_ime_text_spans{};
      FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCompositionFromExistingText(
std::move(p_start), 
std::move(p_end), 
std::move(p_ime_text_spans));
      return true;
    }
    case internal::kFrameWidgetInputHandler_ExtendSelectionAndDelete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndDelete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndDelete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_before{};
      int32_t p_after{};
      FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_before = input_data_view.before();
      if (success)
        p_after = input_data_view.after();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtendSelectionAndDelete(
std::move(p_before), 
std::move(p_after));
      return true;
    }
    case internal::kFrameWidgetInputHandler_DeleteSurroundingText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::DeleteSurroundingText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::DeleteSurroundingText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_before{};
      int32_t p_after{};
      FrameWidgetInputHandler_DeleteSurroundingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_before = input_data_view.before();
      if (success)
        p_after = input_data_view.after();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSurroundingText(
std::move(p_before), 
std::move(p_after));
      return true;
    }
    case internal::kFrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_before{};
      int32_t p_after{};
      FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_before = input_data_view.before();
      if (success)
        p_after = input_data_view.after();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSurroundingTextInCodePoints(
std::move(p_before), 
std::move(p_after));
      return true;
    }
    case internal::kFrameWidgetInputHandler_SetEditableSelectionOffsets_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::SetEditableSelectionOffsets",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::SetEditableSelectionOffsets");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_start{};
      int32_t p_end{};
      FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEditableSelectionOffsets(
std::move(p_start), 
std::move(p_end));
      return true;
    }
    case internal::kFrameWidgetInputHandler_ExecuteEditCommand_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::ExecuteEditCommand",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::ExecuteEditCommand");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_command{};
      absl::optional<::std::u16string> p_value{};
      FrameWidgetInputHandler_ExecuteEditCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommand(&p_command))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteEditCommand(
std::move(p_command), 
std::move(p_value));
      return true;
    }
    case internal::kFrameWidgetInputHandler_Undo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::Undo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::Undo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Undo_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Undo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo();
      return true;
    }
    case internal::kFrameWidgetInputHandler_Redo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::Redo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::Redo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Redo_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Redo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_Redo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Redo();
      return true;
    }
    case internal::kFrameWidgetInputHandler_Cut_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::Cut",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::Cut");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Cut_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Cut_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_Cut_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cut();
      return true;
    }
    case internal::kFrameWidgetInputHandler_Copy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::Copy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::Copy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Copy_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Copy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_Copy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Copy();
      return true;
    }
    case internal::kFrameWidgetInputHandler_CopyToFindPboard_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::CopyToFindPboard",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::CopyToFindPboard");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_CopyToFindPboard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyToFindPboard();
      return true;
    }
    case internal::kFrameWidgetInputHandler_Paste_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::Paste",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::Paste");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Paste_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Paste_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_Paste_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Paste();
      return true;
    }
    case internal::kFrameWidgetInputHandler_PasteAndMatchStyle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::PasteAndMatchStyle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::PasteAndMatchStyle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_PasteAndMatchStyle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasteAndMatchStyle();
      return true;
    }
    case internal::kFrameWidgetInputHandler_Delete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::Delete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::Delete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Delete_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Delete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_Delete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete();
      return true;
    }
    case internal::kFrameWidgetInputHandler_SelectAll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::SelectAll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::SelectAll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SelectAll_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SelectAll_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_SelectAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectAll();
      return true;
    }
    case internal::kFrameWidgetInputHandler_CollapseSelection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::CollapseSelection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::CollapseSelection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_CollapseSelection_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_CollapseSelection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetInputHandler_CollapseSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CollapseSelection();
      return true;
    }
    case internal::kFrameWidgetInputHandler_Replace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::Replace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::Replace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Replace_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Replace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_word{};
      FrameWidgetInputHandler_Replace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Replace(
std::move(p_word));
      return true;
    }
    case internal::kFrameWidgetInputHandler_ReplaceMisspelling_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::ReplaceMisspelling",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::ReplaceMisspelling");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_word{};
      FrameWidgetInputHandler_ReplaceMisspelling_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReplaceMisspelling(
std::move(p_word));
      return true;
    }
    case internal::kFrameWidgetInputHandler_SelectRange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::SelectRange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::SelectRange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SelectRange_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SelectRange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_base{};
      ::gfx::Point p_extent{};
      FrameWidgetInputHandler_SelectRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBase(&p_base))
        success = false;
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectRange(
std::move(p_base), 
std::move(p_extent));
      return true;
    }
    case internal::kFrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::AdjustSelectionByCharacterOffset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::AdjustSelectionByCharacterOffset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_start{};
      int32_t p_end{};
      ::blink::mojom::SelectionMenuBehavior p_behavior{};
      FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadBehavior(&p_behavior))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdjustSelectionByCharacterOffset(
std::move(p_start), 
std::move(p_end), 
std::move(p_behavior));
      return true;
    }
    case internal::kFrameWidgetInputHandler_MoveRangeSelectionExtent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::MoveRangeSelectionExtent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::MoveRangeSelectionExtent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_extent{};
      FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveRangeSelectionExtent(
std::move(p_extent));
      return true;
    }
    case internal::kFrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoRect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoRect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect{};
      FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollFocusedEditableNodeIntoRect(
std::move(p_rect));
      return true;
    }
    case internal::kFrameWidgetInputHandler_MoveCaret_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetInputHandler::MoveCaret",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetInputHandler::MoveCaret");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_MoveCaret_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_MoveCaret_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_point{};
      FrameWidgetInputHandler_MoveCaret_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveCaret(
std::move(p_point));
      return true;
    }
  }
  return false;
}

// static
bool FrameWidgetInputHandlerStubDispatch::AcceptWithResponder(
    FrameWidgetInputHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameWidgetInputHandler_AddImeTextSpansToExistingText_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_ClearImeTextSpansByType_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_SetCompositionFromExistingText_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_ExtendSelectionAndDelete_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_DeleteSurroundingText_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_SetEditableSelectionOffsets_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_ExecuteEditCommand_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_Undo_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_Redo_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_Cut_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_Copy_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_CopyToFindPboard_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_Paste_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_PasteAndMatchStyle_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_Delete_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_SelectAll_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_CollapseSelection_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_Replace_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_ReplaceMisspelling_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_SelectRange_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_MoveRangeSelectionExtent_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_Name: {
      break;
    }
    case internal::kFrameWidgetInputHandler_MoveCaret_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFrameWidgetInputHandlerValidationInfo[] = {
    {&internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_Undo_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_Redo_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_Cut_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_Copy_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_Paste_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_Delete_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_SelectAll_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_CollapseSelection_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_Replace_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_SelectRange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoRect_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetInputHandler_MoveCaret_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameWidgetInputHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FrameWidgetInputHandler::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFrameWidgetInputHandlerValidationInfo);
}

const char WidgetInputHandler::Name_[] = "blink.mojom.WidgetInputHandler";

class WidgetInputHandler_ImeSetComposition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_ImeSetComposition_ForwardToCallback(
      WidgetInputHandler::ImeSetCompositionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::ImeSetCompositionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_ImeSetComposition_ForwardToCallback);
};

class WidgetInputHandler_ImeCommitText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_ImeCommitText_ForwardToCallback(
      WidgetInputHandler::ImeCommitTextCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::ImeCommitTextCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_ImeCommitText_ForwardToCallback);
};

class WidgetInputHandler_DispatchEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_DispatchEvent_ForwardToCallback(
      WidgetInputHandler::DispatchEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::DispatchEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_DispatchEvent_ForwardToCallback);
};

class WidgetInputHandler_WaitForInputProcessed_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_WaitForInputProcessed_ForwardToCallback(
      WidgetInputHandler::WaitForInputProcessedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::WaitForInputProcessedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_WaitForInputProcessed_ForwardToCallback);
};

WidgetInputHandlerProxy::WidgetInputHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetInputHandlerProxy::SetFocus(
    bool in_focused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::SetFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focused"), in_focused,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_SetFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_SetFocus_Params_Data> params(
          message);
  params.Allocate();
  params->focused = in_focused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("SetFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::MouseCaptureLost(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WidgetInputHandler::MouseCaptureLost");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_MouseCaptureLost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_MouseCaptureLost_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("MouseCaptureLost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::SetEditCommandsForNextKeyEvent(
    std::vector<EditCommandPtr> in_commands) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::SetEditCommandsForNextKeyEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("commands"), in_commands,
                        "<value of type std::vector<EditCommandPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_SetEditCommandsForNextKeyEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->commands)::BaseType>
      commands_fragment(params.message());
  const mojo::internal::ContainerValidateParams commands_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::EditCommandDataView>>(
      in_commands, commands_fragment, &commands_validate_params);
  params->commands.Set(
      commands_fragment.is_null() ? nullptr : commands_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->commands.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null commands in WidgetInputHandler.SetEditCommandsForNextKeyEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("SetEditCommandsForNextKeyEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::CursorVisibilityChanged(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::CursorVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_CursorVisibilityChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();
  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("CursorVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::ImeSetComposition(
    const ::std::u16string& in_text, const std::vector<::ui::ImeTextSpan>& in_ime_text_spans, const ::gfx::Range& in_range, int32_t in_start, int32_t in_end, ImeSetCompositionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::ImeSetComposition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const std::vector<::ui::ImeTextSpan>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_ImeSetComposition_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeSetComposition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text, text_fragment);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in WidgetInputHandler.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  const mojo::internal::ContainerValidateParams ime_text_spans_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
      in_ime_text_spans, ime_text_spans_fragment, &ime_text_spans_validate_params);
  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ime_text_spans.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ime_text_spans in WidgetInputHandler.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
      in_range, range_fragment);
  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null range in WidgetInputHandler.ImeSetComposition request");
  params->start = in_start;
  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeSetComposition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_ImeSetComposition_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WidgetInputHandlerProxy::ImeCommitText(
    const ::std::u16string& in_text, const std::vector<::ui::ImeTextSpan>& in_ime_text_spans, const ::gfx::Range& in_range, int32_t in_relative_cursor_position, ImeCommitTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::ImeCommitText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const std::vector<::ui::ImeTextSpan>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("relative_cursor_position"), in_relative_cursor_position,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_ImeCommitText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeCommitText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text, text_fragment);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in WidgetInputHandler.ImeCommitText request");
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  const mojo::internal::ContainerValidateParams ime_text_spans_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
      in_ime_text_spans, ime_text_spans_fragment, &ime_text_spans_validate_params);
  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ime_text_spans.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ime_text_spans in WidgetInputHandler.ImeCommitText request");
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
      in_range, range_fragment);
  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null range in WidgetInputHandler.ImeCommitText request");
  params->relative_cursor_position = in_relative_cursor_position;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeCommitText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_ImeCommitText_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WidgetInputHandlerProxy::ImeFinishComposingText(
    bool in_keep_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::ImeFinishComposingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_selection"), in_keep_selection,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_ImeFinishComposingText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeFinishComposingText_Params_Data> params(
          message);
  params.Allocate();
  params->keep_selection = in_keep_selection;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeFinishComposingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::RequestTextInputStateUpdate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WidgetInputHandler::RequestTextInputStateUpdate");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_RequestTextInputStateUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("RequestTextInputStateUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::RequestCompositionUpdates(
    bool in_immediate_request, bool in_monitor_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::RequestCompositionUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("immediate_request"), in_immediate_request,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("monitor_request"), in_monitor_request,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_RequestCompositionUpdates_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data> params(
          message);
  params.Allocate();
  params->immediate_request = in_immediate_request;
  params->monitor_request = in_monitor_request;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("RequestCompositionUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::DispatchEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, DispatchEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::DispatchEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_DispatchEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_DispatchEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in WidgetInputHandler.DispatchEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("DispatchEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_DispatchEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WidgetInputHandlerProxy::DispatchNonBlockingEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::DispatchNonBlockingEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_DispatchNonBlockingEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in WidgetInputHandler.DispatchNonBlockingEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("DispatchNonBlockingEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetInputHandlerProxy::WaitForInputProcessed(
    WaitForInputProcessedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WidgetInputHandler::WaitForInputProcessed");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_WaitForInputProcessed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_WaitForInputProcessed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("WaitForInputProcessed");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_WaitForInputProcessed_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WidgetInputHandlerProxy::GetFrameWidgetInputHandler(
    ::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> in_interface_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetInputHandler::GetFrameWidgetInputHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_request"), in_interface_request,
                        "<value of type ::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_GetFrameWidgetInputHandler_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::FrameWidgetInputHandlerAssociatedRequestDataView>(
      in_interface_request, &params->interface_request, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->interface_request),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid interface_request in WidgetInputHandler.GetFrameWidgetInputHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("GetFrameWidgetInputHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class WidgetInputHandler_ImeSetComposition_ProxyToResponder {
 public:
  static WidgetInputHandler::ImeSetCompositionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WidgetInputHandler_ImeSetComposition_ProxyToResponder> proxy(
        new WidgetInputHandler_ImeSetComposition_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WidgetInputHandler_ImeSetComposition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_ImeSetComposition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WidgetInputHandler_ImeSetComposition_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WidgetInputHandler::ImeSetCompositionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_ImeSetComposition_ProxyToResponder);
};

bool WidgetInputHandler_ImeSetComposition_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WidgetInputHandler::ImeSetCompositionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WidgetInputHandler_ImeSetComposition_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void WidgetInputHandler_ImeSetComposition_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::WidgetInputHandler::ImeSetCompositionCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_ImeSetComposition_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WidgetInputHandler::ImeSetCompositionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeSetComposition");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WidgetInputHandler_ImeCommitText_ProxyToResponder {
 public:
  static WidgetInputHandler::ImeCommitTextCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WidgetInputHandler_ImeCommitText_ProxyToResponder> proxy(
        new WidgetInputHandler_ImeCommitText_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WidgetInputHandler_ImeCommitText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_ImeCommitText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WidgetInputHandler_ImeCommitText_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WidgetInputHandler::ImeCommitTextCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_ImeCommitText_ProxyToResponder);
};

bool WidgetInputHandler_ImeCommitText_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WidgetInputHandler::ImeCommitTextCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WidgetInputHandler_ImeCommitText_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void WidgetInputHandler_ImeCommitText_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::WidgetInputHandler::ImeCommitTextCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_ImeCommitText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WidgetInputHandler::ImeCommitTextCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeCommitText");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WidgetInputHandler_DispatchEvent_ProxyToResponder {
 public:
  static WidgetInputHandler::DispatchEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WidgetInputHandler_DispatchEvent_ProxyToResponder> proxy(
        new WidgetInputHandler_DispatchEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WidgetInputHandler_DispatchEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_DispatchEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WidgetInputHandler_DispatchEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WidgetInputHandler::DispatchEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::InputEventResultSource in_source, const ::ui::LatencyInfo& in_updated_latency, ::blink::mojom::InputEventResultState in_state, DidOverscrollParamsPtr in_overscroll, TouchActionOptionalPtr in_touch_action);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_DispatchEvent_ProxyToResponder);
};

bool WidgetInputHandler_DispatchEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WidgetInputHandler::DispatchEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::InputEventResultSource p_source{};
  ::ui::LatencyInfo p_updated_latency{};
  ::blink::mojom::InputEventResultState p_state{};
  DidOverscrollParamsPtr p_overscroll{};
  TouchActionOptionalPtr p_touch_action{};
  WidgetInputHandler_DispatchEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSource(&p_source))
    success = false;
  if (success && !input_data_view.ReadUpdatedLatency(&p_updated_latency))
    success = false;
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (success && !input_data_view.ReadOverscroll(&p_overscroll))
    success = false;
  if (success && !input_data_view.ReadTouchAction(&p_touch_action))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_source), 
std::move(p_updated_latency), 
std::move(p_state), 
std::move(p_overscroll), 
std::move(p_touch_action));
  return true;
}

void WidgetInputHandler_DispatchEvent_ProxyToResponder::Run(
    ::blink::mojom::InputEventResultSource in_source, const ::ui::LatencyInfo& in_updated_latency, ::blink::mojom::InputEventResultState in_state, DidOverscrollParamsPtr in_overscroll, TouchActionOptionalPtr in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::WidgetInputHandler::DispatchEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::blink::mojom::InputEventResultSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updated_latency"), in_updated_latency,
                        "<value of type const ::ui::LatencyInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::blink::mojom::InputEventResultState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("overscroll"), in_overscroll,
                        "<value of type DidOverscrollParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_action"), in_touch_action,
                        "<value of type TouchActionOptionalPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_DispatchEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::InputEventResultSource>(
      in_source, &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->updated_latency)::BaseType> updated_latency_fragment(
          params.message());
  mojo::internal::Serialize<::ui::mojom::LatencyInfoDataView>(
      in_updated_latency, updated_latency_fragment);
  params->updated_latency.Set(
      updated_latency_fragment.is_null() ? nullptr : updated_latency_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->updated_latency.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null updated_latency in ");
  mojo::internal::Serialize<::blink::mojom::InputEventResultState>(
      in_state, &params->state);
  mojo::internal::MessageFragment<
      typename decltype(params->overscroll)::BaseType> overscroll_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::DidOverscrollParamsDataView>(
      in_overscroll, overscroll_fragment);
  params->overscroll.Set(
      overscroll_fragment.is_null() ? nullptr : overscroll_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->touch_action)::BaseType> touch_action_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::TouchActionOptionalDataView>(
      in_touch_action, touch_action_fragment);
  params->touch_action.Set(
      touch_action_fragment.is_null() ? nullptr : touch_action_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WidgetInputHandler::DispatchEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("DispatchEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WidgetInputHandler_WaitForInputProcessed_ProxyToResponder {
 public:
  static WidgetInputHandler::WaitForInputProcessedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WidgetInputHandler_WaitForInputProcessed_ProxyToResponder> proxy(
        new WidgetInputHandler_WaitForInputProcessed_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WidgetInputHandler_WaitForInputProcessed_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_WaitForInputProcessed_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WidgetInputHandler_WaitForInputProcessed_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WidgetInputHandler::WaitForInputProcessedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WidgetInputHandler_WaitForInputProcessed_ProxyToResponder);
};

bool WidgetInputHandler_WaitForInputProcessed_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WidgetInputHandler::WaitForInputProcessedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WidgetInputHandler_WaitForInputProcessed_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void WidgetInputHandler_WaitForInputProcessed_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::WidgetInputHandler::WaitForInputProcessedCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWidgetInputHandler_WaitForInputProcessed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WidgetInputHandler::WaitForInputProcessedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("WaitForInputProcessed");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetInputHandlerStubDispatch::Accept(
    WidgetInputHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWidgetInputHandler_SetFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::SetFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::SetFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_SetFocus_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_SetFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_focused{};
      WidgetInputHandler_SetFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_focused = input_data_view.focused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFocus(
std::move(p_focused));
      return true;
    }
    case internal::kWidgetInputHandler_MouseCaptureLost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::MouseCaptureLost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::MouseCaptureLost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_MouseCaptureLost_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_MouseCaptureLost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WidgetInputHandler_MouseCaptureLost_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MouseCaptureLost();
      return true;
    }
    case internal::kWidgetInputHandler_SetEditCommandsForNextKeyEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::SetEditCommandsForNextKeyEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::SetEditCommandsForNextKeyEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<EditCommandPtr> p_commands{};
      WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommands(&p_commands))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEditCommandsForNextKeyEvent(
std::move(p_commands));
      return true;
    }
    case internal::kWidgetInputHandler_CursorVisibilityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::CursorVisibilityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::CursorVisibilityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_visible{};
      WidgetInputHandler_CursorVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CursorVisibilityChanged(
std::move(p_visible));
      return true;
    }
    case internal::kWidgetInputHandler_ImeSetComposition_Name: {
      break;
    }
    case internal::kWidgetInputHandler_ImeCommitText_Name: {
      break;
    }
    case internal::kWidgetInputHandler_ImeFinishComposingText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::ImeFinishComposingText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::ImeFinishComposingText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_ImeFinishComposingText_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_ImeFinishComposingText_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_keep_selection{};
      WidgetInputHandler_ImeFinishComposingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_keep_selection = input_data_view.keep_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeFinishComposingText(
std::move(p_keep_selection));
      return true;
    }
    case internal::kWidgetInputHandler_RequestTextInputStateUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::RequestTextInputStateUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::RequestTextInputStateUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WidgetInputHandler_RequestTextInputStateUpdate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestTextInputStateUpdate();
      return true;
    }
    case internal::kWidgetInputHandler_RequestCompositionUpdates_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::RequestCompositionUpdates",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::RequestCompositionUpdates");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_immediate_request{};
      bool p_monitor_request{};
      WidgetInputHandler_RequestCompositionUpdates_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_immediate_request = input_data_view.immediate_request();
      if (success)
        p_monitor_request = input_data_view.monitor_request();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestCompositionUpdates(
std::move(p_immediate_request), 
std::move(p_monitor_request));
      return true;
    }
    case internal::kWidgetInputHandler_DispatchEvent_Name: {
      break;
    }
    case internal::kWidgetInputHandler_DispatchNonBlockingEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::DispatchNonBlockingEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::DispatchNonBlockingEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WidgetInputHandler_DispatchNonBlockingEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchNonBlockingEvent(
std::move(p_event));
      return true;
    }
    case internal::kWidgetInputHandler_WaitForInputProcessed_Name: {
      break;
    }
    case internal::kWidgetInputHandler_GetFrameWidgetInputHandler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::GetFrameWidgetInputHandler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::GetFrameWidgetInputHandler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> p_interface_request{};
      WidgetInputHandler_GetFrameWidgetInputHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_interface_request =
            input_data_view.TakeInterfaceRequest<decltype(p_interface_request)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFrameWidgetInputHandler(
std::move(p_interface_request));
      return true;
    }
  }
  return false;
}

// static
bool WidgetInputHandlerStubDispatch::AcceptWithResponder(
    WidgetInputHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWidgetInputHandler_SetFocus_Name: {
      break;
    }
    case internal::kWidgetInputHandler_MouseCaptureLost_Name: {
      break;
    }
    case internal::kWidgetInputHandler_SetEditCommandsForNextKeyEvent_Name: {
      break;
    }
    case internal::kWidgetInputHandler_CursorVisibilityChanged_Name: {
      break;
    }
    case internal::kWidgetInputHandler_ImeSetComposition_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::ImeSetComposition",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::ImeSetComposition");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WidgetInputHandler_ImeSetComposition_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_ImeSetComposition_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_text{};
      std::vector<::ui::ImeTextSpan> p_ime_text_spans{};
      ::gfx::Range p_range{};
      int32_t p_start{};
      int32_t p_end{};
      WidgetInputHandler_ImeSetComposition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 4, false);
        return false;
      }
      WidgetInputHandler::ImeSetCompositionCallback callback =
          WidgetInputHandler_ImeSetComposition_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeSetComposition(
std::move(p_text), 
std::move(p_ime_text_spans), 
std::move(p_range), 
std::move(p_start), 
std::move(p_end), std::move(callback));
      return true;
    }
    case internal::kWidgetInputHandler_ImeCommitText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::ImeCommitText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::ImeCommitText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WidgetInputHandler_ImeCommitText_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_ImeCommitText_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::u16string p_text{};
      std::vector<::ui::ImeTextSpan> p_ime_text_spans{};
      ::gfx::Range p_range{};
      int32_t p_relative_cursor_position{};
      WidgetInputHandler_ImeCommitText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success)
        p_relative_cursor_position = input_data_view.relative_cursor_position();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 5, false);
        return false;
      }
      WidgetInputHandler::ImeCommitTextCallback callback =
          WidgetInputHandler_ImeCommitText_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCommitText(
std::move(p_text), 
std::move(p_ime_text_spans), 
std::move(p_range), 
std::move(p_relative_cursor_position), std::move(callback));
      return true;
    }
    case internal::kWidgetInputHandler_ImeFinishComposingText_Name: {
      break;
    }
    case internal::kWidgetInputHandler_RequestTextInputStateUpdate_Name: {
      break;
    }
    case internal::kWidgetInputHandler_RequestCompositionUpdates_Name: {
      break;
    }
    case internal::kWidgetInputHandler_DispatchEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::DispatchEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::DispatchEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WidgetInputHandler_DispatchEvent_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_DispatchEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WidgetInputHandler_DispatchEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 9, false);
        return false;
      }
      WidgetInputHandler::DispatchEventCallback callback =
          WidgetInputHandler_DispatchEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchEvent(
std::move(p_event), std::move(callback));
      return true;
    }
    case internal::kWidgetInputHandler_DispatchNonBlockingEvent_Name: {
      break;
    }
    case internal::kWidgetInputHandler_WaitForInputProcessed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetInputHandler::WaitForInputProcessed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetInputHandler::WaitForInputProcessed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WidgetInputHandler_WaitForInputProcessed_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_WaitForInputProcessed_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WidgetInputHandler_WaitForInputProcessed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 11, false);
        return false;
      }
      WidgetInputHandler::WaitForInputProcessedCallback callback =
          WidgetInputHandler_WaitForInputProcessed_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForInputProcessed(std::move(callback));
      return true;
    }
    case internal::kWidgetInputHandler_GetFrameWidgetInputHandler_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWidgetInputHandlerValidationInfo[] = {
    {&internal::WidgetInputHandler_SetFocus_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_MouseCaptureLost_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_ImeSetComposition_Params_Data::Validate,
     &internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data::Validate},
    {&internal::WidgetInputHandler_ImeCommitText_Params_Data::Validate,
     &internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data::Validate},
    {&internal::WidgetInputHandler_ImeFinishComposingText_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_DispatchEvent_Params_Data::Validate,
     &internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data::Validate},
    {&internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetInputHandler_WaitForInputProcessed_Params_Data::Validate,
     &internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data::Validate},
    {&internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool WidgetInputHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WidgetInputHandler::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWidgetInputHandlerValidationInfo);
}

bool WidgetInputHandlerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WidgetInputHandler::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kWidgetInputHandlerValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::KeyData::DataView, ::blink::mojom::KeyDataPtr>::Read(
    ::blink::mojom::KeyData::DataView input,
    ::blink::mojom::KeyDataPtr* output) {
  bool success = true;
  ::blink::mojom::KeyDataPtr result(::blink::mojom::KeyData::New());
  
      if (success)
        result->dom_key = input.dom_key();
      if (success)
        result->dom_code = input.dom_code();
      if (success)
        result->windows_key_code = input.windows_key_code();
      if (success)
        result->native_key_code = input.native_key_code();
      if (success)
        result->is_system_key = input.is_system_key();
      if (success)
        result->is_browser_shortcut = input.is_browser_shortcut();
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadUnmodifiedText(&result->unmodified_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PointerData::DataView, ::blink::mojom::PointerDataPtr>::Read(
    ::blink::mojom::PointerData::DataView input,
    ::blink::mojom::PointerDataPtr* output) {
  bool success = true;
  ::blink::mojom::PointerDataPtr result(::blink::mojom::PointerData::New());
  
      if (success)
        result->pointer_id = input.pointer_id();
      if (success)
        result->force = input.force();
      if (success)
        result->tilt_x = input.tilt_x();
      if (success)
        result->tilt_y = input.tilt_y();
      if (success)
        result->tangential_pressure = input.tangential_pressure();
      if (success)
        result->twist = input.twist();
      if (success && !input.ReadButton(&result->button))
        success = false;
      if (success && !input.ReadPointerType(&result->pointer_type))
        success = false;
      if (success)
        result->movement_x = input.movement_x();
      if (success)
        result->movement_y = input.movement_y();
      if (success)
        result->is_raw_movement_event = input.is_raw_movement_event();
      if (success && !input.ReadWidgetPosition(&result->widget_position))
        success = false;
      if (success && !input.ReadScreenPosition(&result->screen_position))
        success = false;
      if (success && !input.ReadMouseData(&result->mouse_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::WheelData::DataView, ::blink::mojom::WheelDataPtr>::Read(
    ::blink::mojom::WheelData::DataView input,
    ::blink::mojom::WheelDataPtr* output) {
  bool success = true;
  ::blink::mojom::WheelDataPtr result(::blink::mojom::WheelData::New());
  
      if (success)
        result->delta_x = input.delta_x();
      if (success)
        result->delta_y = input.delta_y();
      if (success)
        result->wheel_ticks_x = input.wheel_ticks_x();
      if (success)
        result->wheel_ticks_y = input.wheel_ticks_y();
      if (success)
        result->acceleration_ratio_x = input.acceleration_ratio_x();
      if (success)
        result->acceleration_ratio_y = input.acceleration_ratio_y();
      if (success)
        result->phase = input.phase();
      if (success)
        result->momentum_phase = input.momentum_phase();
      if (success && !input.ReadCancelable(&result->cancelable))
        success = false;
      if (success)
        result->event_action = input.event_action();
      if (success)
        result->delta_units = input.delta_units();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::MouseData::DataView, ::blink::mojom::MouseDataPtr>::Read(
    ::blink::mojom::MouseData::DataView input,
    ::blink::mojom::MouseDataPtr* output) {
  bool success = true;
  ::blink::mojom::MouseDataPtr result(::blink::mojom::MouseData::New());
  
      if (success)
        result->click_count = input.click_count();
      if (success && !input.ReadWheelData(&result->wheel_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ScrollUpdate::DataView, ::blink::mojom::ScrollUpdatePtr>::Read(
    ::blink::mojom::ScrollUpdate::DataView input,
    ::blink::mojom::ScrollUpdatePtr* output) {
  bool success = true;
  ::blink::mojom::ScrollUpdatePtr result(::blink::mojom::ScrollUpdate::New());
  
      if (success)
        result->velocity_x = input.velocity_x();
      if (success)
        result->velocity_y = input.velocity_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ScrollData::DataView, ::blink::mojom::ScrollDataPtr>::Read(
    ::blink::mojom::ScrollData::DataView input,
    ::blink::mojom::ScrollDataPtr* output) {
  bool success = true;
  ::blink::mojom::ScrollDataPtr result(::blink::mojom::ScrollData::New());
  
      if (success)
        result->delta_x = input.delta_x();
      if (success)
        result->delta_y = input.delta_y();
      if (success && !input.ReadDeltaUnits(&result->delta_units))
        success = false;
      if (success)
        result->target_viewport = input.target_viewport();
      if (success && !input.ReadInertialPhase(&result->inertial_phase))
        success = false;
      if (success)
        result->synthetic = input.synthetic();
      if (success)
        result->pointer_count = input.pointer_count();
      if (success)
        result->cursor_control = input.cursor_control();
      if (success && !input.ReadUpdateDetails(&result->update_details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PinchBeginData::DataView, ::blink::mojom::PinchBeginDataPtr>::Read(
    ::blink::mojom::PinchBeginData::DataView input,
    ::blink::mojom::PinchBeginDataPtr* output) {
  bool success = true;
  ::blink::mojom::PinchBeginDataPtr result(::blink::mojom::PinchBeginData::New());
  
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PinchUpdateData::DataView, ::blink::mojom::PinchUpdateDataPtr>::Read(
    ::blink::mojom::PinchUpdateData::DataView input,
    ::blink::mojom::PinchUpdateDataPtr* output) {
  bool success = true;
  ::blink::mojom::PinchUpdateDataPtr result(::blink::mojom::PinchUpdateData::New());
  
      if (success)
        result->scale = input.scale();
      if (success)
        result->zoom_disabled = input.zoom_disabled();
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PinchEndData::DataView, ::blink::mojom::PinchEndDataPtr>::Read(
    ::blink::mojom::PinchEndData::DataView input,
    ::blink::mojom::PinchEndDataPtr* output) {
  bool success = true;
  ::blink::mojom::PinchEndDataPtr result(::blink::mojom::PinchEndData::New());
  
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FlingData::DataView, ::blink::mojom::FlingDataPtr>::Read(
    ::blink::mojom::FlingData::DataView input,
    ::blink::mojom::FlingDataPtr* output) {
  bool success = true;
  ::blink::mojom::FlingDataPtr result(::blink::mojom::FlingData::New());
  
      if (success)
        result->velocity_x = input.velocity_x();
      if (success)
        result->velocity_y = input.velocity_y();
      if (success)
        result->target_viewport = input.target_viewport();
      if (success)
        result->prevent_boosting = input.prevent_boosting();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::TapData::DataView, ::blink::mojom::TapDataPtr>::Read(
    ::blink::mojom::TapData::DataView input,
    ::blink::mojom::TapDataPtr* output) {
  bool success = true;
  ::blink::mojom::TapDataPtr result(::blink::mojom::TapData::New());
  
      if (success)
        result->tap_count = input.tap_count();
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::GestureData::DataView, ::blink::mojom::GestureDataPtr>::Read(
    ::blink::mojom::GestureData::DataView input,
    ::blink::mojom::GestureDataPtr* output) {
  bool success = true;
  ::blink::mojom::GestureDataPtr result(::blink::mojom::GestureData::New());
  
      if (success && !input.ReadScreenPosition(&result->screen_position))
        success = false;
      if (success && !input.ReadWidgetPosition(&result->widget_position))
        success = false;
      if (success && !input.ReadSourceDevice(&result->source_device))
        success = false;
      if (success)
        result->is_source_touch_event_set_blocking = input.is_source_touch_event_set_blocking();
      if (success && !input.ReadPrimaryPointerType(&result->primary_pointer_type))
        success = false;
      if (success)
        result->primary_unique_touch_event_id = input.primary_unique_touch_event_id();
      if (success)
        result->unique_touch_event_id = input.unique_touch_event_id();
      if (success && !input.ReadContactSize(&result->contact_size))
        success = false;
      if (success && !input.ReadScrollData(&result->scroll_data))
        success = false;
      if (success && !input.ReadPinchBeginData(&result->pinch_begin_data))
        success = false;
      if (success && !input.ReadPinchUpdateData(&result->pinch_update_data))
        success = false;
      if (success && !input.ReadPinchEndData(&result->pinch_end_data))
        success = false;
      if (success && !input.ReadTapData(&result->tap_data))
        success = false;
      if (success && !input.ReadFlingData(&result->fling_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::TouchPoint::DataView, ::blink::mojom::TouchPointPtr>::Read(
    ::blink::mojom::TouchPoint::DataView input,
    ::blink::mojom::TouchPointPtr* output) {
  bool success = true;
  ::blink::mojom::TouchPointPtr result(::blink::mojom::TouchPoint::New());
  
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->radius_x = input.radius_x();
      if (success)
        result->radius_y = input.radius_y();
      if (success)
        result->rotation_angle = input.rotation_angle();
      if (success && !input.ReadPointerData(&result->pointer_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::TouchData::DataView, ::blink::mojom::TouchDataPtr>::Read(
    ::blink::mojom::TouchData::DataView input,
    ::blink::mojom::TouchDataPtr* output) {
  bool success = true;
  ::blink::mojom::TouchDataPtr result(::blink::mojom::TouchData::New());
  
      if (success && !input.ReadCancelable(&result->cancelable))
        success = false;
      if (success)
        result->moved_beyond_slop_region = input.moved_beyond_slop_region();
      if (success)
        result->touch_start_or_first_move = input.touch_start_or_first_move();
      if (success)
        result->hovering = input.hovering();
      if (success)
        result->unique_touch_event_id = input.unique_touch_event_id();
      if (success && !input.ReadTouches(&result->touches))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::Event::DataView, ::blink::mojom::EventPtr>::Read(
    ::blink::mojom::Event::DataView input,
    ::blink::mojom::EventPtr* output) {
  bool success = true;
  ::blink::mojom::EventPtr result(::blink::mojom::Event::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->modifiers = input.modifiers();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadLatency(&result->latency))
        success = false;
      if (success && !input.ReadKeyData(&result->key_data))
        success = false;
      if (success && !input.ReadPointerData(&result->pointer_data))
        success = false;
      if (success && !input.ReadGestureData(&result->gesture_data))
        success = false;
      if (success && !input.ReadTouchData(&result->touch_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DidOverscrollParams::DataView, ::blink::mojom::DidOverscrollParamsPtr>::Read(
    ::blink::mojom::DidOverscrollParams::DataView input,
    ::blink::mojom::DidOverscrollParamsPtr* output) {
  bool success = true;
  ::blink::mojom::DidOverscrollParamsPtr result(::blink::mojom::DidOverscrollParams::New());
  
      if (success && !input.ReadAccumulatedOverscroll(&result->accumulated_overscroll))
        success = false;
      if (success && !input.ReadLatestOverscrollDelta(&result->latest_overscroll_delta))
        success = false;
      if (success && !input.ReadCurrentFlingVelocity(&result->current_fling_velocity))
        success = false;
      if (success && !input.ReadCausalEventViewportPoint(&result->causal_event_viewport_point))
        success = false;
      if (success && !input.ReadOverscrollBehavior(&result->overscroll_behavior))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::TouchActionOptional::DataView, ::blink::mojom::TouchActionOptionalPtr>::Read(
    ::blink::mojom::TouchActionOptional::DataView input,
    ::blink::mojom::TouchActionOptionalPtr* output) {
  bool success = true;
  ::blink::mojom::TouchActionOptionalPtr result(::blink::mojom::TouchActionOptional::New());
  
      if (success && !input.ReadTouchAction(&result->touch_action))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::EditCommand::DataView, ::blink::mojom::EditCommandPtr>::Read(
    ::blink::mojom::EditCommand::DataView input,
    ::blink::mojom::EditCommandPtr* output) {
  bool success = true;
  ::blink::mojom::EditCommandPtr result(::blink::mojom::EditCommand::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif