// third_party/blink/public/mojom/input/input_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/input_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/input_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/input_host.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HOST_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HOST_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
SpellCheckSuggestion::SpellCheckSuggestion()
    : suggestion() {}

SpellCheckSuggestion::SpellCheckSuggestion(
    const WTF::String& suggestion_in)
    : suggestion(std::move(suggestion_in)) {}

SpellCheckSuggestion::~SpellCheckSuggestion() = default;
size_t SpellCheckSuggestion::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->suggestion);
  return seed;
}

void SpellCheckSuggestion::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion"), this->suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpellCheckSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextSuggestion::TextSuggestion()
    : marker_tag(),
      suggestion_index(),
      prefix(),
      suggestion(),
      suffix() {}

TextSuggestion::TextSuggestion(
    int32_t marker_tag_in,
    int32_t suggestion_index_in,
    const WTF::String& prefix_in,
    const WTF::String& suggestion_in,
    const WTF::String& suffix_in)
    : marker_tag(std::move(marker_tag_in)),
      suggestion_index(std::move(suggestion_index_in)),
      prefix(std::move(prefix_in)),
      suggestion(std::move(suggestion_in)),
      suffix(std::move(suffix_in)) {}

TextSuggestion::~TextSuggestion() = default;
size_t TextSuggestion::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->marker_tag);
  seed = mojo::internal::WTFHash(seed, this->suggestion_index);
  seed = mojo::internal::WTFHash(seed, this->prefix);
  seed = mojo::internal::WTFHash(seed, this->suggestion);
  seed = mojo::internal::WTFHash(seed, this->suffix);
  return seed;
}

void TextSuggestion::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "marker_tag"), this->marker_tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion_index"), this->suggestion_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefix"), this->prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion"), this->suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suffix"), this->suffix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TextSuggestionHost::Name_[] = "blink.mojom.TextSuggestionHost";

TextSuggestionHostProxy::TextSuggestionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextSuggestionHostProxy::StartSuggestionMenuTimer(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::TextSuggestionHost::StartSuggestionMenuTimer");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextSuggestionHost_StartSuggestionMenuTimer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionHost::Name_);
  message.set_method_name("StartSuggestionMenuTimer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextSuggestionHostProxy::ShowSpellCheckSuggestionMenu(
    double in_caret_x, double in_caret_y, const WTF::String& in_marked_text, WTF::Vector<SpellCheckSuggestionPtr> in_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::TextSuggestionHost::ShowSpellCheckSuggestionMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_x"), in_caret_x,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_y"), in_caret_y,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("marked_text"), in_marked_text,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestions"), in_suggestions,
                        "<value of type WTF::Vector<SpellCheckSuggestionPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextSuggestionHost_ShowSpellCheckSuggestionMenu_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data> params(
          message);
  params.Allocate();
  params->caret_x = in_caret_x;
  params->caret_y = in_caret_y;
  mojo::internal::MessageFragment<
      typename decltype(params->marked_text)::BaseType> marked_text_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_marked_text, marked_text_fragment);
  params->marked_text.Set(
      marked_text_fragment.is_null() ? nullptr : marked_text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->marked_text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null marked_text in TextSuggestionHost.ShowSpellCheckSuggestionMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->suggestions)::BaseType>
      suggestions_fragment(params.message());
  const mojo::internal::ContainerValidateParams suggestions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SpellCheckSuggestionDataView>>(
      in_suggestions, suggestions_fragment, &suggestions_validate_params);
  params->suggestions.Set(
      suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->suggestions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestions in TextSuggestionHost.ShowSpellCheckSuggestionMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionHost::Name_);
  message.set_method_name("ShowSpellCheckSuggestionMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextSuggestionHostProxy::ShowTextSuggestionMenu(
    double in_caret_x, double in_caret_y, const WTF::String& in_marked_text, WTF::Vector<TextSuggestionPtr> in_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::TextSuggestionHost::ShowTextSuggestionMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_x"), in_caret_x,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_y"), in_caret_y,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("marked_text"), in_marked_text,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestions"), in_suggestions,
                        "<value of type WTF::Vector<TextSuggestionPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextSuggestionHost_ShowTextSuggestionMenu_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data> params(
          message);
  params.Allocate();
  params->caret_x = in_caret_x;
  params->caret_y = in_caret_y;
  mojo::internal::MessageFragment<
      typename decltype(params->marked_text)::BaseType> marked_text_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_marked_text, marked_text_fragment);
  params->marked_text.Set(
      marked_text_fragment.is_null() ? nullptr : marked_text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->marked_text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null marked_text in TextSuggestionHost.ShowTextSuggestionMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->suggestions)::BaseType>
      suggestions_fragment(params.message());
  const mojo::internal::ContainerValidateParams suggestions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::TextSuggestionDataView>>(
      in_suggestions, suggestions_fragment, &suggestions_validate_params);
  params->suggestions.Set(
      suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->suggestions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestions in TextSuggestionHost.ShowTextSuggestionMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionHost::Name_);
  message.set_method_name("ShowTextSuggestionMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TextSuggestionHostStubDispatch::Accept(
    TextSuggestionHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTextSuggestionHost_StartSuggestionMenuTimer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextSuggestionHost::StartSuggestionMenuTimer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextSuggestionHost::StartSuggestionMenuTimer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      TextSuggestionHost_StartSuggestionMenuTimer_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSuggestionMenuTimer();
      return true;
    }
    case internal::kTextSuggestionHost_ShowSpellCheckSuggestionMenu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextSuggestionHost::ShowSpellCheckSuggestionMenu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextSuggestionHost::ShowSpellCheckSuggestionMenu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_caret_x{};
      double p_caret_y{};
      WTF::String p_marked_text{};
      WTF::Vector<SpellCheckSuggestionPtr> p_suggestions{};
      TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_caret_x = input_data_view.caret_x();
      if (success)
        p_caret_y = input_data_view.caret_y();
      if (success && !input_data_view.ReadMarkedText(&p_marked_text))
        success = false;
      if (success && !input_data_view.ReadSuggestions(&p_suggestions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSpellCheckSuggestionMenu(
std::move(p_caret_x), 
std::move(p_caret_y), 
std::move(p_marked_text), 
std::move(p_suggestions));
      return true;
    }
    case internal::kTextSuggestionHost_ShowTextSuggestionMenu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextSuggestionHost::ShowTextSuggestionMenu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextSuggestionHost::ShowTextSuggestionMenu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_caret_x{};
      double p_caret_y{};
      WTF::String p_marked_text{};
      WTF::Vector<TextSuggestionPtr> p_suggestions{};
      TextSuggestionHost_ShowTextSuggestionMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_caret_x = input_data_view.caret_x();
      if (success)
        p_caret_y = input_data_view.caret_y();
      if (success && !input_data_view.ReadMarkedText(&p_marked_text))
        success = false;
      if (success && !input_data_view.ReadSuggestions(&p_suggestions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowTextSuggestionMenu(
std::move(p_caret_x), 
std::move(p_caret_y), 
std::move(p_marked_text), 
std::move(p_suggestions));
      return true;
    }
  }
  return false;
}

// static
bool TextSuggestionHostStubDispatch::AcceptWithResponder(
    TextSuggestionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTextSuggestionHost_StartSuggestionMenuTimer_Name: {
      break;
    }
    case internal::kTextSuggestionHost_ShowSpellCheckSuggestionMenu_Name: {
      break;
    }
    case internal::kTextSuggestionHost_ShowTextSuggestionMenu_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kTextSuggestionHostValidationInfo[] = {
    {&internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextSuggestionHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::TextSuggestionHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kTextSuggestionHostValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SpellCheckSuggestion::DataView, ::blink::mojom::blink::SpellCheckSuggestionPtr>::Read(
    ::blink::mojom::blink::SpellCheckSuggestion::DataView input,
    ::blink::mojom::blink::SpellCheckSuggestionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SpellCheckSuggestionPtr result(::blink::mojom::blink::SpellCheckSuggestion::New());
  
      if (success && !input.ReadSuggestion(&result->suggestion))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TextSuggestion::DataView, ::blink::mojom::blink::TextSuggestionPtr>::Read(
    ::blink::mojom::blink::TextSuggestion::DataView input,
    ::blink::mojom::blink::TextSuggestionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TextSuggestionPtr result(::blink::mojom::blink::TextSuggestion::New());
  
      if (success)
        result->marker_tag = input.marker_tag();
      if (success)
        result->suggestion_index = input.suggestion_index();
      if (success && !input.ReadPrefix(&result->prefix))
        success = false;
      if (success && !input.ReadSuggestion(&result->suggestion))
        success = false;
      if (success && !input.ReadSuffix(&result->suffix))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif