// third_party/blink/public/mojom/interest_group/interest_group_types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-params-data.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_INTEREST_GROUP_TYPES_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
InterestGroupAd::InterestGroupAd()
    : render_url(),
      metadata() {}

InterestGroupAd::InterestGroupAd(
    const ::blink::KURL& render_url_in,
    const WTF::String& metadata_in)
    : render_url(std::move(render_url_in)),
      metadata(std::move(metadata_in)) {}

InterestGroupAd::~InterestGroupAd() = default;

void InterestGroupAd::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_url"), this->render_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InterestGroupAd::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InterestGroup::InterestGroup()
    : expiry(),
      owner(),
      name(),
      bidding_url(),
      update_url(),
      trusted_bidding_signals_url(),
      trusted_bidding_signals_keys(),
      user_bidding_signals(),
      ads() {}

InterestGroup::InterestGroup(
    ::base::Time expiry_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& owner_in,
    const WTF::String& name_in,
    const absl::optional<::blink::KURL>& bidding_url_in,
    const absl::optional<::blink::KURL>& update_url_in,
    const absl::optional<::blink::KURL>& trusted_bidding_signals_url_in,
    absl::optional<WTF::Vector<WTF::String>> trusted_bidding_signals_keys_in,
    const WTF::String& user_bidding_signals_in,
    absl::optional<WTF::Vector<InterestGroupAdPtr>> ads_in)
    : expiry(std::move(expiry_in)),
      owner(std::move(owner_in)),
      name(std::move(name_in)),
      bidding_url(std::move(bidding_url_in)),
      update_url(std::move(update_url_in)),
      trusted_bidding_signals_url(std::move(trusted_bidding_signals_url_in)),
      trusted_bidding_signals_keys(std::move(trusted_bidding_signals_keys_in)),
      user_bidding_signals(std::move(user_bidding_signals_in)),
      ads(std::move(ads_in)) {}

InterestGroup::~InterestGroup() = default;

void InterestGroup::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "owner"), this->owner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bidding_url"), this->bidding_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_url"), this->update_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_url"), this->trusted_bidding_signals_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_keys"), this->trusted_bidding_signals_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<WTF::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_bidding_signals"), this->user_bidding_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ads"), this->ads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<WTF::Vector<InterestGroupAdPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InterestGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AllBuyers::AllBuyers() {}

AllBuyers::~AllBuyers() = default;
size_t AllBuyers::Hash(size_t seed) const {
  return seed;
}

void AllBuyers::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
}

bool AllBuyers::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionAdConfig::AuctionAdConfig()
    : seller(),
      decision_logic_url(),
      interest_group_buyers(),
      auction_signals(),
      seller_signals(),
      per_buyer_signals() {}

AuctionAdConfig::AuctionAdConfig(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& seller_in,
    const ::blink::KURL& decision_logic_url_in,
    InterestGroupBuyersPtr interest_group_buyers_in,
    const WTF::String& auction_signals_in,
    const WTF::String& seller_signals_in,
    const absl::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::String>>& per_buyer_signals_in)
    : seller(std::move(seller_in)),
      decision_logic_url(std::move(decision_logic_url_in)),
      interest_group_buyers(std::move(interest_group_buyers_in)),
      auction_signals(std::move(auction_signals_in)),
      seller_signals(std::move(seller_signals_in)),
      per_buyer_signals(std::move(per_buyer_signals_in)) {}

AuctionAdConfig::~AuctionAdConfig() = default;

void AuctionAdConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller"), this->seller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decision_logic_url"), this->decision_logic_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interest_group_buyers"), this->interest_group_buyers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InterestGroupBuyersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_signals"), this->auction_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_signals"), this->seller_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_signals"), this->per_buyer_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, WTF::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionAdConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InterestGroupBuyers::InterestGroupBuyers() : tag_(Tag::BUYERS) {
  data_.buyers = new WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>;
}

InterestGroupBuyers::~InterestGroupBuyers() {
  DestroyActive();
}


void InterestGroupBuyers::set_buyers(
    WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> buyers) {
  if (tag_ == Tag::BUYERS) {
    *(data_.buyers) = std::move(buyers);
  } else {
    DestroyActive();
    tag_ = Tag::BUYERS;
    data_.buyers = new WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>(
        std::move(buyers));
  }
}
void InterestGroupBuyers::set_all_buyers(
    AllBuyersPtr all_buyers) {
  if (tag_ == Tag::ALL_BUYERS) {
    *(data_.all_buyers) = std::move(all_buyers);
  } else {
    DestroyActive();
    tag_ = Tag::ALL_BUYERS;
    data_.all_buyers = new AllBuyersPtr(
        std::move(all_buyers));
  }
}

void InterestGroupBuyers::DestroyActive() {
  switch (tag_) {

    case Tag::BUYERS:

      delete data_.buyers;
      break;
    case Tag::ALL_BUYERS:

      delete data_.all_buyers;
      break;
  }
}

bool InterestGroupBuyers::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::InterestGroupAd::DataView, ::blink::mojom::blink::InterestGroupAdPtr>::Read(
    ::blink::mojom::blink::InterestGroupAd::DataView input,
    ::blink::mojom::blink::InterestGroupAdPtr* output) {
  bool success = true;
  ::blink::mojom::blink::InterestGroupAdPtr result(::blink::mojom::blink::InterestGroupAd::New());
  
      if (success && !input.ReadRenderUrl(&result->render_url))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::InterestGroup::DataView, ::blink::mojom::blink::InterestGroupPtr>::Read(
    ::blink::mojom::blink::InterestGroup::DataView input,
    ::blink::mojom::blink::InterestGroupPtr* output) {
  bool success = true;
  ::blink::mojom::blink::InterestGroupPtr result(::blink::mojom::blink::InterestGroup::New());
  
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
      if (success && !input.ReadOwner(&result->owner))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadBiddingUrl(&result->bidding_url))
        success = false;
      if (success && !input.ReadUpdateUrl(&result->update_url))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsUrl(&result->trusted_bidding_signals_url))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsKeys(&result->trusted_bidding_signals_keys))
        success = false;
      if (success && !input.ReadUserBiddingSignals(&result->user_bidding_signals))
        success = false;
      if (success && !input.ReadAds(&result->ads))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AllBuyers::DataView, ::blink::mojom::blink::AllBuyersPtr>::Read(
    ::blink::mojom::blink::AllBuyers::DataView input,
    ::blink::mojom::blink::AllBuyersPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AllBuyersPtr result(::blink::mojom::blink::AllBuyers::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AuctionAdConfig::DataView, ::blink::mojom::blink::AuctionAdConfigPtr>::Read(
    ::blink::mojom::blink::AuctionAdConfig::DataView input,
    ::blink::mojom::blink::AuctionAdConfigPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AuctionAdConfigPtr result(::blink::mojom::blink::AuctionAdConfig::New());
  
      if (success && !input.ReadSeller(&result->seller))
        success = false;
      if (success && !input.ReadDecisionLogicUrl(&result->decision_logic_url))
        success = false;
      if (success && !input.ReadInterestGroupBuyers(&result->interest_group_buyers))
        success = false;
      if (success && !input.ReadAuctionSignals(&result->auction_signals))
        success = false;
      if (success && !input.ReadSellerSignals(&result->seller_signals))
        success = false;
      if (success && !input.ReadPerBuyerSignals(&result->per_buyer_signals))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::InterestGroupBuyers::DataView, ::blink::mojom::blink::InterestGroupBuyersPtr>::Read(
    ::blink::mojom::blink::InterestGroupBuyers::DataView input,
    ::blink::mojom::blink::InterestGroupBuyersPtr* output) {
  using UnionType = ::blink::mojom::blink::InterestGroupBuyers;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::BUYERS: {
      WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> result_buyers;
      if (!input.ReadBuyers(&result_buyers))
        return false;

      *output = UnionType::NewBuyers(
          std::move(result_buyers));
      break;
    }
    case Tag::ALL_BUYERS: {
      ::blink::mojom::blink::AllBuyersPtr result_all_buyers;
      if (!input.ReadAllBuyers(&result_all_buyers))
        return false;

      *output = UnionType::NewAllBuyers(
          std::move(result_all_buyers));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif