// third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool InterestGroupBuyers_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const InterestGroupBuyers_Data* object = static_cast<const InterestGroupBuyers_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case InterestGroupBuyers_Tag::BUYERS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_buyers, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams buyers_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_buyers, validation_context,
                                             &buyers_validate_params)) {
        return false;
      }
      return true;
    }
    case InterestGroupBuyers_Tag::ALL_BUYERS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_all_buyers, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_all_buyers, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in InterestGroupBuyers");
      return false;
    }
  }
}


// static
bool InterestGroupAd_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InterestGroupAd_Data* object = static_cast<const InterestGroupAd_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->render_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->render_url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams metadata_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->metadata, validation_context,
                                         &metadata_validate_params)) {
    return false;
  }

  return true;
}

InterestGroupAd_Data::InterestGroupAd_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InterestGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InterestGroup_Data* object = static_cast<const InterestGroup_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiry, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->owner, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->owner, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bidding_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->update_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_bidding_signals_url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams trusted_bidding_signals_keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->trusted_bidding_signals_keys, validation_context,
                                         &trusted_bidding_signals_keys_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams user_bidding_signals_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_bidding_signals, validation_context,
                                         &user_bidding_signals_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams ads_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->ads, validation_context,
                                         &ads_validate_params)) {
    return false;
  }

  return true;
}

InterestGroup_Data::InterestGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AllBuyers_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AllBuyers_Data* object = static_cast<const AllBuyers_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

AllBuyers_Data::AllBuyers_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionAdConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuctionAdConfig_Data* object = static_cast<const AuctionAdConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seller, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seller, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decision_logic_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->decision_logic_url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->interest_group_buyers, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams auction_signals_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->auction_signals, validation_context,
                                         &auction_signals_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams seller_signals_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->seller_signals, validation_context,
                                         &seller_signals_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams per_buyer_signals_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->per_buyer_signals, validation_context,
                                         &per_buyer_signals_validate_params)) {
    return false;
  }

  return true;
}

AuctionAdConfig_Data::AuctionAdConfig_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
