// third_party/blink/public/mojom/interest_group/restricted_interest_group_store.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/interest_group/restricted_interest_group_store.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/interest_group/restricted_interest_group_store.mojom-params-data.h"
#include "third_party/blink/public/mojom/interest_group/restricted_interest_group_store.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/interest_group/restricted_interest_group_store.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_RESTRICTED_INTEREST_GROUP_STORE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_RESTRICTED_INTEREST_GROUP_STORE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char RestrictedInterestGroupStore::Name_[] = "blink.mojom.RestrictedInterestGroupStore";

RestrictedInterestGroupStoreProxy::RestrictedInterestGroupStoreProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RestrictedInterestGroupStoreProxy::JoinInterestGroup(
    const ::blink::InterestGroup& in_group) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RestrictedInterestGroupStore::JoinInterestGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type const ::blink::InterestGroup&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRestrictedInterestGroupStore_JoinInterestGroup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RestrictedInterestGroupStore_JoinInterestGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::InterestGroupDataView>(
      in_group, group_fragment);
  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group in RestrictedInterestGroupStore.JoinInterestGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedInterestGroupStore::Name_);
  message.set_method_name("JoinInterestGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RestrictedInterestGroupStoreProxy::LeaveInterestGroup(
    const ::url::Origin& in_owner, const std::string& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RestrictedInterestGroupStore::LeaveInterestGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner"), in_owner,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRestrictedInterestGroupStore_LeaveInterestGroup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RestrictedInterestGroupStore_LeaveInterestGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->owner)::BaseType> owner_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_owner, owner_fragment);
  params->owner.Set(
      owner_fragment.is_null() ? nullptr : owner_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->owner.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null owner in RestrictedInterestGroupStore.LeaveInterestGroup request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in RestrictedInterestGroupStore.LeaveInterestGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedInterestGroupStore::Name_);
  message.set_method_name("LeaveInterestGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RestrictedInterestGroupStoreProxy::UpdateAdInterestGroups(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RestrictedInterestGroupStore::UpdateAdInterestGroups");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRestrictedInterestGroupStore_UpdateAdInterestGroups_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RestrictedInterestGroupStore_UpdateAdInterestGroups_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedInterestGroupStore::Name_);
  message.set_method_name("UpdateAdInterestGroups");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RestrictedInterestGroupStoreStubDispatch::Accept(
    RestrictedInterestGroupStore* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRestrictedInterestGroupStore_JoinInterestGroup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RestrictedInterestGroupStore::JoinInterestGroup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RestrictedInterestGroupStore::JoinInterestGroup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RestrictedInterestGroupStore_JoinInterestGroup_Params_Data* params =
          reinterpret_cast<internal::RestrictedInterestGroupStore_JoinInterestGroup_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::InterestGroup p_group{};
      RestrictedInterestGroupStore_JoinInterestGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedInterestGroupStore::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JoinInterestGroup(
std::move(p_group));
      return true;
    }
    case internal::kRestrictedInterestGroupStore_LeaveInterestGroup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RestrictedInterestGroupStore::LeaveInterestGroup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RestrictedInterestGroupStore::LeaveInterestGroup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RestrictedInterestGroupStore_LeaveInterestGroup_Params_Data* params =
          reinterpret_cast<internal::RestrictedInterestGroupStore_LeaveInterestGroup_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_owner{};
      std::string p_name{};
      RestrictedInterestGroupStore_LeaveInterestGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOwner(&p_owner))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedInterestGroupStore::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LeaveInterestGroup(
std::move(p_owner), 
std::move(p_name));
      return true;
    }
    case internal::kRestrictedInterestGroupStore_UpdateAdInterestGroups_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RestrictedInterestGroupStore::UpdateAdInterestGroups",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RestrictedInterestGroupStore::UpdateAdInterestGroups");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RestrictedInterestGroupStore_UpdateAdInterestGroups_Params_Data* params =
          reinterpret_cast<internal::RestrictedInterestGroupStore_UpdateAdInterestGroups_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RestrictedInterestGroupStore_UpdateAdInterestGroups_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedInterestGroupStore::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAdInterestGroups();
      return true;
    }
  }
  return false;
}

// static
bool RestrictedInterestGroupStoreStubDispatch::AcceptWithResponder(
    RestrictedInterestGroupStore* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRestrictedInterestGroupStore_JoinInterestGroup_Name: {
      break;
    }
    case internal::kRestrictedInterestGroupStore_LeaveInterestGroup_Name: {
      break;
    }
    case internal::kRestrictedInterestGroupStore_UpdateAdInterestGroups_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kRestrictedInterestGroupStoreValidationInfo[] = {
    {&internal::RestrictedInterestGroupStore_JoinInterestGroup_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::RestrictedInterestGroupStore_LeaveInterestGroup_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::RestrictedInterestGroupStore_UpdateAdInterestGroups_Params_Data::Validate,
     nullptr /* no response */},
};

bool RestrictedInterestGroupStoreRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::RestrictedInterestGroupStore::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kRestrictedInterestGroupStoreValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif