// third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* ResourceTypeToStringHelper(ResourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResourceType::kMainFrame:
      return "kMainFrame";
    case ResourceType::kSubFrame:
      return "kSubFrame";
    case ResourceType::kStylesheet:
      return "kStylesheet";
    case ResourceType::kScript:
      return "kScript";
    case ResourceType::kImage:
      return "kImage";
    case ResourceType::kFontResource:
      return "kFontResource";
    case ResourceType::kSubResource:
      return "kSubResource";
    case ResourceType::kObject:
      return "kObject";
    case ResourceType::kMedia:
      return "kMedia";
    case ResourceType::kWorker:
      return "kWorker";
    case ResourceType::kSharedWorker:
      return "kSharedWorker";
    case ResourceType::kPrefetch:
      return "kPrefetch";
    case ResourceType::kFavicon:
      return "kFavicon";
    case ResourceType::kXhr:
      return "kXhr";
    case ResourceType::kPing:
      return "kPing";
    case ResourceType::kServiceWorker:
      return "kServiceWorker";
    case ResourceType::kCspReport:
      return "kCspReport";
    case ResourceType::kPluginResource:
      return "kPluginResource";
    case ResourceType::kNavigationPreloadMainFrame:
      return "kNavigationPreloadMainFrame";
    case ResourceType::kNavigationPreloadSubFrame:
      return "kNavigationPreloadSubFrame";
    default:
      return nullptr;
  }
}

std::string ResourceTypeToString(ResourceType value) {
  const char *str = ResourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResourceType value) {
  return os << ResourceTypeToString(value);
}

namespace internal {


// static
bool CommonNetworkInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CommonNetworkInfo_Data* object = static_cast<const CommonNetworkInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;

  return true;
}

CommonNetworkInfo_Data::CommonNetworkInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RedirectInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RedirectInfo_Data* object = static_cast<const RedirectInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_of_new_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin_of_new_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_info, validation_context))
    return false;

  return true;
}

RedirectInfo_Data::RedirectInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceLoadInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceLoadInfo_Data* object = static_cast<const ResourceLoadInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->final_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->final_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->request_priority, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_info, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->load_timing_info, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->load_timing_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_info_chain, 15, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams redirect_info_chain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->redirect_info_chain, validation_context,
                                         &redirect_info_chain_validate_params)) {
    return false;
  }

  return true;
}

ResourceLoadInfo_Data::ResourceLoadInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ResourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ResourceType value) {
  return std::move(context).WriteString(::blink::mojom::ResourceTypeToString(value));
}

} // namespace perfetto
