// third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char ResourceLoadInfoNotifier::Name_[] = "blink.mojom.ResourceLoadInfoNotifier";

ResourceLoadInfoNotifierProxy::ResourceLoadInfoNotifierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResourceLoadInfoNotifierProxy::NotifyResourceRedirectReceived(
    const ::net::RedirectInfo& in_redirect_info, ::network::mojom::URLResponseHeadPtr in_redirect_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_info"), in_redirect_info,
                        "<value of type const ::net::RedirectInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_response"), in_redirect_response,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_info)::BaseType> redirect_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLRequestRedirectInfoDataView>(
      in_redirect_info, redirect_info_fragment);
  params->redirect_info.Set(
      redirect_info_fragment.is_null() ? nullptr : redirect_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->redirect_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_info in ResourceLoadInfoNotifier.NotifyResourceRedirectReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_response)::BaseType> redirect_response_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_redirect_response, redirect_response_fragment);
  params->redirect_response.Set(
      redirect_response_fragment.is_null() ? nullptr : redirect_response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->redirect_response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_response in ResourceLoadInfoNotifier.NotifyResourceRedirectReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceRedirectReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceResponseReceived(
    int64_t in_request_id, const ::GURL& in_response_url, ::network::mojom::URLResponseHeadPtr in_head, ::network::mojom::RequestDestination in_request_destination, int32_t in_previews_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_url"), in_response_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_destination"), in_request_destination,
                        "<value of type ::network::mojom::RequestDestination>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("previews_state"), in_previews_state,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceResponseReceived_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data> params(
          message);
  params.Allocate();
  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->response_url)::BaseType> response_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_response_url, response_url_fragment);
  params->response_url.Set(
      response_url_fragment.is_null() ? nullptr : response_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_url in ResourceLoadInfoNotifier.NotifyResourceResponseReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, head_fragment);
  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in ResourceLoadInfoNotifier.NotifyResourceResponseReceived request");
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
      in_request_destination, &params->request_destination);
  params->previews_state = in_previews_state;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceResponseReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceTransferSizeUpdated(
    int64_t in_request_id, int32_t in_transfer_size_diff) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_size_diff"), in_transfer_size_diff,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data> params(
          message);
  params.Allocate();
  params->request_id = in_request_id;
  params->transfer_size_diff = in_transfer_size_diff;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceTransferSizeUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceLoadCompleted(
    ::blink::mojom::ResourceLoadInfoPtr in_resource_load_info, const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_load_info"), in_resource_load_info,
                        "<value of type ::blink::mojom::ResourceLoadInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resource_load_info)::BaseType> resource_load_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ResourceLoadInfoDataView>(
      in_resource_load_info, resource_load_info_fragment);
  params->resource_load_info.Set(
      resource_load_info_fragment.is_null() ? nullptr : resource_load_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_load_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_load_info in ResourceLoadInfoNotifier.NotifyResourceLoadCompleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ResourceLoadInfoNotifier.NotifyResourceLoadCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceLoadCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceLoadCanceled(
    int64_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data> params(
          message);
  params.Allocate();
  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceLoadCanceled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::Clone(
    ::mojo::PendingReceiver<ResourceLoadInfoNotifier> in_pending_resource_load_info_notifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_resource_load_info_notifier"), in_pending_resource_load_info_notifier,
                        "<value of type ::mojo::PendingReceiver<ResourceLoadInfoNotifier>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ResourceLoadInfoNotifier_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ResourceLoadInfoNotifierInterfaceBase>>(
      in_pending_resource_load_info_notifier, &params->pending_resource_load_info_notifier, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_resource_load_info_notifier),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid pending_resource_load_info_notifier in ResourceLoadInfoNotifier.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ResourceLoadInfoNotifierStubDispatch::Accept(
    ResourceLoadInfoNotifier* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::RedirectInfo p_redirect_info{};
      ::network::mojom::URLResponseHeadPtr p_redirect_response{};
      ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRedirectInfo(&p_redirect_info))
        success = false;
      if (success && !input_data_view.ReadRedirectResponse(&p_redirect_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceRedirectReceived(
std::move(p_redirect_info), 
std::move(p_redirect_response));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceResponseReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_request_id{};
      ::GURL p_response_url{};
      ::network::mojom::URLResponseHeadPtr p_head{};
      ::network::mojom::RequestDestination p_request_destination{};
      int32_t p_previews_state{};
      ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadResponseUrl(&p_response_url))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (success && !input_data_view.ReadRequestDestination(&p_request_destination))
        success = false;
      if (success)
        p_previews_state = input_data_view.previews_state();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceResponseReceived(
std::move(p_request_id), 
std::move(p_response_url), 
std::move(p_head), 
std::move(p_request_destination), 
std::move(p_previews_state));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_request_id{};
      int32_t p_transfer_size_diff{};
      ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_transfer_size_diff = input_data_view.transfer_size_diff();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceTransferSizeUpdated(
std::move(p_request_id), 
std::move(p_transfer_size_diff));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceLoadInfoPtr p_resource_load_info{};
      ::network::URLLoaderCompletionStatus p_status{};
      ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResourceLoadInfo(&p_resource_load_info))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceLoadCompleted(
std::move(p_resource_load_info), 
std::move(p_status));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_request_id{};
      ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceLoadCanceled(
std::move(p_request_id));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_Clone_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ResourceLoadInfoNotifier> p_pending_resource_load_info_notifier{};
      ResourceLoadInfoNotifier_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_pending_resource_load_info_notifier =
            input_data_view.TakePendingResourceLoadInfoNotifier<decltype(p_pending_resource_load_info_notifier)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_pending_resource_load_info_notifier));
      return true;
    }
  }
  return false;
}

// static
bool ResourceLoadInfoNotifierStubDispatch::AcceptWithResponder(
    ResourceLoadInfoNotifier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceResponseReceived_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_Clone_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kResourceLoadInfoNotifierValidationInfo[] = {
    {&internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool ResourceLoadInfoNotifierRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ResourceLoadInfoNotifier::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kResourceLoadInfoNotifierValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif