// third_party/blink/public/mojom/locks/lock_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/locks/lock_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/locks/lock_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/locks/lock_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/locks/lock_manager.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
LockInfo::LockInfo()
    : name(),
      mode(),
      client_id() {}

LockInfo::LockInfo(
    const std::string& name_in,
    LockMode mode_in,
    const std::string& client_id_in)
    : name(std::move(name_in)),
      mode(std::move(mode_in)),
      client_id(std::move(client_id_in)) {}

LockInfo::~LockInfo() = default;
size_t LockInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->mode);
  seed = mojo::internal::Hash(seed, this->client_id);
  return seed;
}

void LockInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LockMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_id"), this->client_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LockInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char LockHandle::Name_[] = "blink.mojom.LockHandle";

LockHandleProxy::LockHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool LockHandleStubDispatch::Accept(
    LockHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool LockHandleStubDispatch::AcceptWithResponder(
    LockHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool LockHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LockHandle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char LockRequest::Name_[] = "blink.mojom.LockRequest";

LockRequestProxy::LockRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LockRequestProxy::Granted(
    ::mojo::PendingAssociatedRemote<LockHandle> in_lock_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LockRequest::Granted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lock_handle"), in_lock_handle,
                        "<value of type ::mojo::PendingAssociatedRemote<LockHandle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLockRequest_Granted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockRequest_Granted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::LockHandleAssociatedPtrInfoDataView>(
      in_lock_handle, &params->lock_handle, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->lock_handle),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid lock_handle in LockRequest.Granted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockRequest::Name_);
  message.set_method_name("Granted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LockRequestProxy::Failed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LockRequest::Failed");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLockRequest_Failed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockRequest_Failed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockRequest::Name_);
  message.set_method_name("Failed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LockRequestProxy::Abort(
    const std::string& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LockRequest::Abort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLockRequest_Abort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockRequest_Abort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reason)::BaseType> reason_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reason, reason_fragment);
  params->reason.Set(
      reason_fragment.is_null() ? nullptr : reason_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reason.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reason in LockRequest.Abort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockRequest::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool LockRequestStubDispatch::Accept(
    LockRequest* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLockRequest_Granted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LockRequest::Granted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LockRequest::Granted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LockRequest_Granted_Params_Data* params =
          reinterpret_cast<internal::LockRequest_Granted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<LockHandle> p_lock_handle{};
      LockRequest_Granted_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_lock_handle =
            input_data_view.TakeLockHandle<decltype(p_lock_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockRequest::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Granted(
std::move(p_lock_handle));
      return true;
    }
    case internal::kLockRequest_Failed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LockRequest::Failed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LockRequest::Failed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LockRequest_Failed_Params_Data* params =
          reinterpret_cast<internal::LockRequest_Failed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LockRequest_Failed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockRequest::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Failed();
      return true;
    }
    case internal::kLockRequest_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LockRequest::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LockRequest::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LockRequest_Abort_Params_Data* params =
          reinterpret_cast<internal::LockRequest_Abort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_reason{};
      LockRequest_Abort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockRequest::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(
std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool LockRequestStubDispatch::AcceptWithResponder(
    LockRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLockRequest_Granted_Name: {
      break;
    }
    case internal::kLockRequest_Failed_Name: {
      break;
    }
    case internal::kLockRequest_Abort_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kLockRequestValidationInfo[] = {
    {&internal::LockRequest_Granted_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::LockRequest_Failed_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::LockRequest_Abort_Params_Data::Validate,
     nullptr /* no response */},
};

bool LockRequestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LockRequest::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kLockRequestValidationInfo);
}

const char LockManager::Name_[] = "blink.mojom.LockManager";

class LockManager_QueryState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LockManager_QueryState_ForwardToCallback(
      LockManager::QueryStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LockManager::QueryStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LockManager_QueryState_ForwardToCallback);
};

LockManagerProxy::LockManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LockManagerProxy::RequestLock(
    const std::string& in_name, LockMode in_mode, LockManager::WaitMode in_wait, ::mojo::PendingAssociatedRemote<LockRequest> in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LockManager::RequestLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type LockMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wait"), in_wait,
                        "<value of type LockManager::WaitMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::mojo::PendingAssociatedRemote<LockRequest>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLockManager_RequestLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockManager_RequestLock_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in LockManager.RequestLock request");
  mojo::internal::Serialize<::blink::mojom::LockMode>(
      in_mode, &params->mode);
  mojo::internal::Serialize<::blink::mojom::LockManager_WaitMode>(
      in_wait, &params->wait);
  mojo::internal::Serialize<::blink::mojom::LockRequestAssociatedPtrInfoDataView>(
      in_request, &params->request, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->request),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid request in LockManager.RequestLock request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockManager::Name_);
  message.set_method_name("RequestLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LockManagerProxy::QueryState(
    QueryStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LockManager::QueryState");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLockManager_QueryState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockManager_QueryState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockManager::Name_);
  message.set_method_name("QueryState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LockManager_QueryState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LockManager_QueryState_ProxyToResponder {
 public:
  static LockManager::QueryStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LockManager_QueryState_ProxyToResponder> proxy(
        new LockManager_QueryState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LockManager_QueryState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LockManager_QueryState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LockManager_QueryState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LockManager::QueryStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<LockInfoPtr> in_requested, std::vector<LockInfoPtr> in_held);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LockManager_QueryState_ProxyToResponder);
};

bool LockManager_QueryState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LockManager::QueryStateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LockManager_QueryState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LockManager_QueryState_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<LockInfoPtr> p_requested{};
  std::vector<LockInfoPtr> p_held{};
  LockManager_QueryState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequested(&p_requested))
    success = false;
  if (success && !input_data_view.ReadHeld(&p_held))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LockManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_requested), 
std::move(p_held));
  return true;
}

void LockManager_QueryState_ProxyToResponder::Run(
    std::vector<LockInfoPtr> in_requested, std::vector<LockInfoPtr> in_held) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LockManager::QueryStateCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested"), in_requested,
                        "<value of type std::vector<LockInfoPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("held"), in_held,
                        "<value of type std::vector<LockInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kLockManager_QueryState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LockManager_QueryState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested)::BaseType>
      requested_fragment(params.message());
  const mojo::internal::ContainerValidateParams requested_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::LockInfoDataView>>(
      in_requested, requested_fragment, &requested_validate_params);
  params->requested.Set(
      requested_fragment.is_null() ? nullptr : requested_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requested.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested in ");
  mojo::internal::MessageFragment<
      typename decltype(params->held)::BaseType>
      held_fragment(params.message());
  const mojo::internal::ContainerValidateParams held_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::LockInfoDataView>>(
      in_held, held_fragment, &held_validate_params);
  params->held.Set(
      held_fragment.is_null() ? nullptr : held_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->held.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null held in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LockManager::QueryStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LockManager::Name_);
  message.set_method_name("QueryState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LockManagerStubDispatch::Accept(
    LockManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLockManager_RequestLock_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LockManager::RequestLock",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LockManager::RequestLock");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LockManager_RequestLock_Params_Data* params =
          reinterpret_cast<internal::LockManager_RequestLock_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      LockMode p_mode{};
      LockManager::WaitMode p_wait{};
      ::mojo::PendingAssociatedRemote<LockRequest> p_request{};
      LockManager_RequestLock_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadWait(&p_wait))
        success = false;
      if (success) {
        p_request =
            input_data_view.TakeRequest<decltype(p_request)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestLock(
std::move(p_name), 
std::move(p_mode), 
std::move(p_wait), 
std::move(p_request));
      return true;
    }
    case internal::kLockManager_QueryState_Name: {
      break;
    }
  }
  return false;
}

// static
bool LockManagerStubDispatch::AcceptWithResponder(
    LockManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLockManager_RequestLock_Name: {
      break;
    }
    case internal::kLockManager_QueryState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LockManager::QueryState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LockManager::QueryState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LockManager_QueryState_Params_Data* params =
          reinterpret_cast<
              internal::LockManager_QueryState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LockManager_QueryState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LockManager::Name_, 1, false);
        return false;
      }
      LockManager::QueryStateCallback callback =
          LockManager_QueryState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryState(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kLockManagerValidationInfo[] = {
    {&internal::LockManager_RequestLock_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::LockManager_QueryState_Params_Data::Validate,
     &internal::LockManager_QueryState_ResponseParams_Data::Validate},
};

bool LockManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LockManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kLockManagerValidationInfo);
}

bool LockManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::LockManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kLockManagerValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::LockInfo::DataView, ::blink::mojom::LockInfoPtr>::Read(
    ::blink::mojom::LockInfo::DataView input,
    ::blink::mojom::LockInfoPtr* output) {
  bool success = true;
  ::blink::mojom::LockInfoPtr result(::blink::mojom::LockInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadClientId(&result->client_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif