// third_party/blink/public/mojom/media/capture_handle_config.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/media/capture_handle_config.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-params-data.h"
#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_CAPTURE_HANDLE_CONFIG_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
CaptureHandleConfig::CaptureHandleConfig()
    : expose_origin(false),
      capture_handle(),
      all_origins_permitted(false),
      permitted_origins() {}

CaptureHandleConfig::CaptureHandleConfig(
    bool expose_origin_in,
    const ::std::u16string& capture_handle_in,
    bool all_origins_permitted_in,
    std::vector<::url::Origin> permitted_origins_in)
    : expose_origin(std::move(expose_origin_in)),
      capture_handle(std::move(capture_handle_in)),
      all_origins_permitted(std::move(all_origins_permitted_in)),
      permitted_origins(std::move(permitted_origins_in)) {}

CaptureHandleConfig::~CaptureHandleConfig() = default;

void CaptureHandleConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expose_origin"), this->expose_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_handle"), this->capture_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_origins_permitted"), this->all_origins_permitted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permitted_origins"), this->permitted_origins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CaptureHandleConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::CaptureHandleConfig::DataView, ::blink::mojom::CaptureHandleConfigPtr>::Read(
    ::blink::mojom::CaptureHandleConfig::DataView input,
    ::blink::mojom::CaptureHandleConfigPtr* output) {
  bool success = true;
  ::blink::mojom::CaptureHandleConfigPtr result(::blink::mojom::CaptureHandleConfig::New());
  
      if (success)
        result->expose_origin = input.expose_origin();
      if (success && !input.ReadCaptureHandle(&result->capture_handle))
        success = false;
      if (success)
        result->all_origins_permitted = input.all_origins_permitted();
      if (success && !input.ReadPermittedOrigins(&result->permitted_origins))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif