// third_party/blink/public/mojom/mediastream/media_devices.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
MediaDeviceInfo::MediaDeviceInfo()
    : device_id(),
      label(),
      group_id() {}

MediaDeviceInfo::MediaDeviceInfo(
    const std::string& device_id_in,
    const std::string& label_in,
    const std::string& group_id_in)
    : device_id(std::move(device_id_in)),
      label(std::move(label_in)),
      group_id(std::move(group_id_in)) {}

MediaDeviceInfo::~MediaDeviceInfo() = default;

void MediaDeviceInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoInputDeviceCapabilities::VideoInputDeviceCapabilities()
    : device_id(),
      group_id(),
      control_support(),
      formats(),
      facing_mode() {}

VideoInputDeviceCapabilities::VideoInputDeviceCapabilities(
    const std::string& device_id_in,
    const std::string& group_id_in,
    const ::media::VideoCaptureControlSupport& control_support_in,
    std::vector<::media::VideoCaptureFormat> formats_in,
    FacingMode facing_mode_in)
    : device_id(std::move(device_id_in)),
      group_id(std::move(group_id_in)),
      control_support(std::move(control_support_in)),
      formats(std::move(formats_in)),
      facing_mode(std::move(facing_mode_in)) {}

VideoInputDeviceCapabilities::~VideoInputDeviceCapabilities() = default;

void VideoInputDeviceCapabilities::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "control_support"), this->control_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoCaptureControlSupport&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "formats"), this->formats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::VideoCaptureFormat>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "facing_mode"), this->facing_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FacingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoInputDeviceCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioInputDeviceCapabilities::AudioInputDeviceCapabilities()
    : device_id(),
      group_id(),
      parameters(),
      is_valid(),
      channels(),
      sample_rate(),
      latency() {}

AudioInputDeviceCapabilities::AudioInputDeviceCapabilities(
    const std::string& device_id_in,
    const std::string& group_id_in,
    const ::media::AudioParameters& parameters_in,
    bool is_valid_in,
    int32_t channels_in,
    int32_t sample_rate_in,
    ::base::TimeDelta latency_in)
    : device_id(std::move(device_id_in)),
      group_id(std::move(group_id_in)),
      parameters(std::move(parameters_in)),
      is_valid(std::move(is_valid_in)),
      channels(std::move(channels_in)),
      sample_rate(std::move(sample_rate_in)),
      latency(std::move(latency_in)) {}

AudioInputDeviceCapabilities::~AudioInputDeviceCapabilities() = default;

void AudioInputDeviceCapabilities::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parameters"), this->parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::AudioParameters&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_valid"), this->is_valid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channels"), this->channels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency"), this->latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioInputDeviceCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char MediaDevicesDispatcherHost::Name_[] = "blink.mojom.MediaDevicesDispatcherHost";

class MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback(
      MediaDevicesDispatcherHost::EnumerateDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::EnumerateDevicesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback);
};

class MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback(
      MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback);
};

class MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback(
      MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback);
};

class MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback(
      MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback);
};

class MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback(
      MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback);
};

MediaDevicesDispatcherHostProxy::MediaDevicesDispatcherHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaDevicesDispatcherHostProxy::EnumerateDevices(
    bool in_request_audio_input, bool in_request_video_input, bool in_request_audio_output, bool in_request_video_input_capabilities, bool in_request_audio_input_capabilities, EnumerateDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_audio_input"), in_request_audio_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_video_input"), in_request_video_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_audio_output"), in_request_audio_output,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_video_input_capabilities"), in_request_video_input_capabilities,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_audio_input_capabilities"), in_request_audio_input_capabilities,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_EnumerateDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data> params(
          message);
  params.Allocate();
  params->request_audio_input = in_request_audio_input;
  params->request_video_input = in_request_video_input;
  params->request_audio_output = in_request_audio_output;
  params->request_video_input_capabilities = in_request_video_input_capabilities;
  params->request_audio_input_capabilities = in_request_audio_input_capabilities;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("EnumerateDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaDevicesDispatcherHostProxy::GetVideoInputCapabilities(
    GetVideoInputCapabilitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetVideoInputCapabilities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaDevicesDispatcherHostProxy::GetAllVideoInputDeviceFormats(
    const std::string& in_device_id, GetAllVideoInputDeviceFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in MediaDevicesDispatcherHost.GetAllVideoInputDeviceFormats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAllVideoInputDeviceFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaDevicesDispatcherHostProxy::GetAvailableVideoInputDeviceFormats(
    const std::string& in_device_id, GetAvailableVideoInputDeviceFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in MediaDevicesDispatcherHost.GetAvailableVideoInputDeviceFormats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAvailableVideoInputDeviceFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaDevicesDispatcherHostProxy::GetAudioInputCapabilities(
    GetAudioInputCapabilitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAudioInputCapabilities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaDevicesDispatcherHostProxy::AddMediaDevicesListener(
    bool in_subscribe_audio_input, bool in_subscribe_video_input, bool in_subscribe_audio_output, ::mojo::PendingRemote<MediaDevicesListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaDevicesDispatcherHost::AddMediaDevicesListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscribe_audio_input"), in_subscribe_audio_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscribe_video_input"), in_subscribe_video_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscribe_audio_output"), in_subscribe_audio_output,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<MediaDevicesListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_AddMediaDevicesListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data> params(
          message);
  params.Allocate();
  params->subscribe_audio_input = in_subscribe_audio_input;
  params->subscribe_video_input = in_subscribe_video_input;
  params->subscribe_audio_output = in_subscribe_audio_output;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::MediaDevicesListenerInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in MediaDevicesDispatcherHost.AddMediaDevicesListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("AddMediaDevicesListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaDevicesDispatcherHostProxy::SetCaptureHandleConfig(
    ::blink::mojom::CaptureHandleConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaDevicesDispatcherHost::SetCaptureHandleConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::blink::mojom::CaptureHandleConfigPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_SetCaptureHandleConfig_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CaptureHandleConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in MediaDevicesDispatcherHost.SetCaptureHandleConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("SetCaptureHandleConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::EnumerateDevicesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaDevicesDispatcherHost::EnumerateDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::vector<::blink::WebMediaDeviceInfo>>& in_enumeration, std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities, std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder);
};

bool MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::MediaDevicesDispatcherHost::EnumerateDevicesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<std::vector<::blink::WebMediaDeviceInfo>> p_enumeration{};
  std::vector<VideoInputDeviceCapabilitiesPtr> p_video_input_device_capabilities{};
  std::vector<AudioInputDeviceCapabilitiesPtr> p_audio_input_device_capabilities{};
  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEnumeration(&p_enumeration))
    success = false;
  if (success && !input_data_view.ReadVideoInputDeviceCapabilities(&p_video_input_device_capabilities))
    success = false;
  if (success && !input_data_view.ReadAudioInputDeviceCapabilities(&p_audio_input_device_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_enumeration), 
std::move(p_video_input_device_capabilities), 
std::move(p_audio_input_device_capabilities));
  return true;
}

void MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder::Run(
    const std::vector<std::vector<::blink::WebMediaDeviceInfo>>& in_enumeration, std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities, std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::EnumerateDevicesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enumeration"), in_enumeration,
                        "<value of type const std::vector<std::vector<::blink::WebMediaDeviceInfo>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_input_device_capabilities"), in_video_input_device_capabilities,
                        "<value of type std::vector<VideoInputDeviceCapabilitiesPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_input_device_capabilities"), in_audio_input_device_capabilities,
                        "<value of type std::vector<AudioInputDeviceCapabilitiesPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_EnumerateDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->enumeration)::BaseType>
      enumeration_fragment(params.message());
  const mojo::internal::ContainerValidateParams enumeration_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::blink::mojom::MediaDeviceInfoDataView>>>(
      in_enumeration, enumeration_fragment, &enumeration_validate_params);
  params->enumeration.Set(
      enumeration_fragment.is_null() ? nullptr : enumeration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->enumeration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null enumeration in ");
  mojo::internal::MessageFragment<
      typename decltype(params->video_input_device_capabilities)::BaseType>
      video_input_device_capabilities_fragment(params.message());
  const mojo::internal::ContainerValidateParams video_input_device_capabilities_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::VideoInputDeviceCapabilitiesDataView>>(
      in_video_input_device_capabilities, video_input_device_capabilities_fragment, &video_input_device_capabilities_validate_params);
  params->video_input_device_capabilities.Set(
      video_input_device_capabilities_fragment.is_null() ? nullptr : video_input_device_capabilities_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->video_input_device_capabilities.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_input_device_capabilities in ");
  mojo::internal::MessageFragment<
      typename decltype(params->audio_input_device_capabilities)::BaseType>
      audio_input_device_capabilities_fragment(params.message());
  const mojo::internal::ContainerValidateParams audio_input_device_capabilities_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AudioInputDeviceCapabilitiesDataView>>(
      in_audio_input_device_capabilities, audio_input_device_capabilities_fragment, &audio_input_device_capabilities_validate_params);
  params->audio_input_device_capabilities.Set(
      audio_input_device_capabilities_fragment.is_null() ? nullptr : audio_input_device_capabilities_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_input_device_capabilities.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_input_device_capabilities in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::EnumerateDevicesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("EnumerateDevices");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder);
};

bool MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<VideoInputDeviceCapabilitiesPtr> p_video_input_device_capabilities{};
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVideoInputDeviceCapabilities(&p_video_input_device_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_video_input_device_capabilities));
  return true;
}

void MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder::Run(
    std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_input_device_capabilities"), in_video_input_device_capabilities,
                        "<value of type std::vector<VideoInputDeviceCapabilitiesPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->video_input_device_capabilities)::BaseType>
      video_input_device_capabilities_fragment(params.message());
  const mojo::internal::ContainerValidateParams video_input_device_capabilities_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::VideoInputDeviceCapabilitiesDataView>>(
      in_video_input_device_capabilities, video_input_device_capabilities_fragment, &video_input_device_capabilities_validate_params);
  params->video_input_device_capabilities.Set(
      video_input_device_capabilities_fragment.is_null() ? nullptr : video_input_device_capabilities_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->video_input_device_capabilities.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_input_device_capabilities in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetVideoInputCapabilities");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureFormat>& in_formats);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder);
};

bool MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::media::VideoCaptureFormat> p_formats{};
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormats(&p_formats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_formats));
  return true;
}

void MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureFormat>& in_formats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats"), in_formats,
                        "<value of type const std::vector<::media::VideoCaptureFormat>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats)::BaseType>
      formats_fragment(params.message());
  const mojo::internal::ContainerValidateParams formats_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
      in_formats, formats_fragment, &formats_validate_params);
  params->formats.Set(
      formats_fragment.is_null() ? nullptr : formats_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->formats.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null formats in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAllVideoInputDeviceFormats");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureFormat>& in_formats);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder);
};

bool MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::media::VideoCaptureFormat> p_formats{};
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormats(&p_formats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_formats));
  return true;
}

void MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureFormat>& in_formats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats"), in_formats,
                        "<value of type const std::vector<::media::VideoCaptureFormat>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats)::BaseType>
      formats_fragment(params.message());
  const mojo::internal::ContainerValidateParams formats_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
      in_formats, formats_fragment, &formats_validate_params);
  params->formats.Set(
      formats_fragment.is_null() ? nullptr : formats_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->formats.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null formats in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAvailableVideoInputDeviceFormats");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder);
};

bool MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<AudioInputDeviceCapabilitiesPtr> p_audio_input_device_capabilities{};
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAudioInputDeviceCapabilities(&p_audio_input_device_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_audio_input_device_capabilities));
  return true;
}

void MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder::Run(
    std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_input_device_capabilities"), in_audio_input_device_capabilities,
                        "<value of type std::vector<AudioInputDeviceCapabilitiesPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->audio_input_device_capabilities)::BaseType>
      audio_input_device_capabilities_fragment(params.message());
  const mojo::internal::ContainerValidateParams audio_input_device_capabilities_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AudioInputDeviceCapabilitiesDataView>>(
      in_audio_input_device_capabilities, audio_input_device_capabilities_fragment, &audio_input_device_capabilities_validate_params);
  params->audio_input_device_capabilities.Set(
      audio_input_device_capabilities_fragment.is_null() ? nullptr : audio_input_device_capabilities_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_input_device_capabilities.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_input_device_capabilities in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAudioInputCapabilities");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaDevicesDispatcherHostStubDispatch::Accept(
    MediaDevicesDispatcherHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaDevicesDispatcherHost_EnumerateDevices_Name: {
      break;
    }
    case internal::kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name: {
      break;
    }
    case internal::kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name: {
      break;
    }
    case internal::kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name: {
      break;
    }
    case internal::kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name: {
      break;
    }
    case internal::kMediaDevicesDispatcherHost_AddMediaDevicesListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesDispatcherHost::AddMediaDevicesListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesDispatcherHost::AddMediaDevicesListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data* params =
          reinterpret_cast<internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_subscribe_audio_input{};
      bool p_subscribe_video_input{};
      bool p_subscribe_audio_output{};
      ::mojo::PendingRemote<MediaDevicesListener> p_listener{};
      MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_subscribe_audio_input = input_data_view.subscribe_audio_input();
      if (success)
        p_subscribe_video_input = input_data_view.subscribe_video_input();
      if (success)
        p_subscribe_audio_output = input_data_view.subscribe_audio_output();
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMediaDevicesListener(
std::move(p_subscribe_audio_input), 
std::move(p_subscribe_video_input), 
std::move(p_subscribe_audio_output), 
std::move(p_listener));
      return true;
    }
    case internal::kMediaDevicesDispatcherHost_SetCaptureHandleConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesDispatcherHost::SetCaptureHandleConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesDispatcherHost::SetCaptureHandleConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data* params =
          reinterpret_cast<internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::CaptureHandleConfigPtr p_config{};
      MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCaptureHandleConfig(
std::move(p_config));
      return true;
    }
  }
  return false;
}

// static
bool MediaDevicesDispatcherHostStubDispatch::AcceptWithResponder(
    MediaDevicesDispatcherHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaDevicesDispatcherHost_EnumerateDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_request_audio_input{};
      bool p_request_video_input{};
      bool p_request_audio_output{};
      bool p_request_video_input_capabilities{};
      bool p_request_audio_input_capabilities{};
      MediaDevicesDispatcherHost_EnumerateDevices_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_audio_input = input_data_view.request_audio_input();
      if (success)
        p_request_video_input = input_data_view.request_video_input();
      if (success)
        p_request_audio_output = input_data_view.request_audio_output();
      if (success)
        p_request_video_input_capabilities = input_data_view.request_video_input_capabilities();
      if (success)
        p_request_audio_input_capabilities = input_data_view.request_audio_input_capabilities();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 0, false);
        return false;
      }
      MediaDevicesDispatcherHost::EnumerateDevicesCallback callback =
          MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateDevices(
std::move(p_request_audio_input), 
std::move(p_request_video_input), 
std::move(p_request_audio_output), 
std::move(p_request_video_input_capabilities), 
std::move(p_request_audio_input_capabilities), std::move(callback));
      return true;
    }
    case internal::kMediaDevicesDispatcherHost_GetVideoInputCapabilities_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 1, false);
        return false;
      }
      MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback callback =
          MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoInputCapabilities(std::move(callback));
      return true;
    }
    case internal::kMediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_device_id{};
      MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 2, false);
        return false;
      }
      MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback callback =
          MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllVideoInputDeviceFormats(
std::move(p_device_id), std::move(callback));
      return true;
    }
    case internal::kMediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_device_id{};
      MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 3, false);
        return false;
      }
      MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback callback =
          MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAvailableVideoInputDeviceFormats(
std::move(p_device_id), std::move(callback));
      return true;
    }
    case internal::kMediaDevicesDispatcherHost_GetAudioInputCapabilities_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 4, false);
        return false;
      }
      MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback callback =
          MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAudioInputCapabilities(std::move(callback));
      return true;
    }
    case internal::kMediaDevicesDispatcherHost_AddMediaDevicesListener_Name: {
      break;
    }
    case internal::kMediaDevicesDispatcherHost_SetCaptureHandleConfig_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaDevicesDispatcherHostValidationInfo[] = {
    {&internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data::Validate},
    {&internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data::Validate},
    {&internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data::Validate},
    {&internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data::Validate},
    {&internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data::Validate},
    {&internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaDevicesDispatcherHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MediaDevicesDispatcherHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaDevicesDispatcherHostValidationInfo);
}

bool MediaDevicesDispatcherHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MediaDevicesDispatcherHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kMediaDevicesDispatcherHostValidationInfo);
}
const char MediaDevicesListener::Name_[] = "blink.mojom.MediaDevicesListener";

MediaDevicesListenerProxy::MediaDevicesListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaDevicesListenerProxy::OnDevicesChanged(
    MediaDeviceType in_type, const std::vector<::blink::WebMediaDeviceInfo>& in_device_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaDevicesListener::OnDevicesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type MediaDeviceType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_infos"), in_device_infos,
                        "<value of type const std::vector<::blink::WebMediaDeviceInfo>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaDevicesListener_OnDevicesChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesListener_OnDevicesChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::MediaDeviceType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->device_infos)::BaseType>
      device_infos_fragment(params.message());
  const mojo::internal::ContainerValidateParams device_infos_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MediaDeviceInfoDataView>>(
      in_device_infos, device_infos_fragment, &device_infos_validate_params);
  params->device_infos.Set(
      device_infos_fragment.is_null() ? nullptr : device_infos_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_infos.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_infos in MediaDevicesListener.OnDevicesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesListener::Name_);
  message.set_method_name("OnDevicesChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaDevicesListenerStubDispatch::Accept(
    MediaDevicesListener* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaDevicesListener_OnDevicesChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaDevicesListener::OnDevicesChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaDevicesListener::OnDevicesChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaDevicesListener_OnDevicesChanged_Params_Data* params =
          reinterpret_cast<internal::MediaDevicesListener_OnDevicesChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaDeviceType p_type{};
      std::vector<::blink::WebMediaDeviceInfo> p_device_infos{};
      MediaDevicesListener_OnDevicesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadDeviceInfos(&p_device_infos))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDevicesChanged(
std::move(p_type), 
std::move(p_device_infos));
      return true;
    }
  }
  return false;
}

// static
bool MediaDevicesListenerStubDispatch::AcceptWithResponder(
    MediaDevicesListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaDevicesListener_OnDevicesChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaDevicesListenerValidationInfo[] = {
    {&internal::MediaDevicesListener_OnDevicesChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaDevicesListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MediaDevicesListener::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaDevicesListenerValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::MediaDeviceInfo::DataView, ::blink::mojom::MediaDeviceInfoPtr>::Read(
    ::blink::mojom::MediaDeviceInfo::DataView input,
    ::blink::mojom::MediaDeviceInfoPtr* output) {
  bool success = true;
  ::blink::mojom::MediaDeviceInfoPtr result(::blink::mojom::MediaDeviceInfo::New());
  
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::VideoInputDeviceCapabilities::DataView, ::blink::mojom::VideoInputDeviceCapabilitiesPtr>::Read(
    ::blink::mojom::VideoInputDeviceCapabilities::DataView input,
    ::blink::mojom::VideoInputDeviceCapabilitiesPtr* output) {
  bool success = true;
  ::blink::mojom::VideoInputDeviceCapabilitiesPtr result(::blink::mojom::VideoInputDeviceCapabilities::New());
  
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadControlSupport(&result->control_support))
        success = false;
      if (success && !input.ReadFormats(&result->formats))
        success = false;
      if (success && !input.ReadFacingMode(&result->facing_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AudioInputDeviceCapabilities::DataView, ::blink::mojom::AudioInputDeviceCapabilitiesPtr>::Read(
    ::blink::mojom::AudioInputDeviceCapabilities::DataView input,
    ::blink::mojom::AudioInputDeviceCapabilitiesPtr* output) {
  bool success = true;
  ::blink::mojom::AudioInputDeviceCapabilitiesPtr result(::blink::mojom::AudioInputDeviceCapabilities::New());
  
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadParameters(&result->parameters))
        success = false;
      if (success)
        result->is_valid = input.is_valid();
      if (success)
        result->channels = input.channels();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success && !input.ReadLatency(&result->latency))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif