// third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool TransferableMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TransferableMessage_Data* object = static_cast<const TransferableMessage_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ports, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams ports_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->ports, validation_context,
                                         &ports_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stream_channels, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stream_channels_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stream_channels, validation_context,
                                         &stream_channels_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->array_buffer_contents_array, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams array_buffer_contents_array_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->array_buffer_contents_array, validation_context,
                                         &array_buffer_contents_array_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_bitmap_contents_array, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams image_bitmap_contents_array_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->image_bitmap_contents_array, validation_context,
                                         &image_bitmap_contents_array_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->user_activation, validation_context))
    return false;

  return true;
}

TransferableMessage_Data::TransferableMessage_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
