// third_party/blink/public/mojom/navigation/navigation_params.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-params-data.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_PARAMS_MOJOM_JUMBO_H_
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "third_party/blink/common/permissions_policy/permissions_policy_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
BeginNavigationParams::BeginNavigationParams()
    : initiator_frame_token(),
      headers(),
      load_flags(0),
      skip_service_worker(false),
      request_context_type(::blink::mojom::RequestContextType::UNSPECIFIED),
      request_destination(::network::mojom::RequestDestination::kEmpty),
      mixed_content_context_type(::blink::mojom::MixedContentContextType::kNotMixedContent),
      is_form_submission(false),
      was_initiated_by_link_click(false),
      searchable_form_url(),
      searchable_form_encoding(),
      client_side_redirect_url(),
      devtools_initiator(),
      trust_token_params(),
      impression(),
      before_unload_start(),
      before_unload_end(),
      web_bundle_token() {}

BeginNavigationParams::BeginNavigationParams(
    const absl::optional<::blink::LocalFrameToken>& initiator_frame_token_in,
    const std::string& headers_in,
    int32_t load_flags_in,
    bool skip_service_worker_in,
    ::blink::mojom::RequestContextType request_context_type_in,
    ::network::mojom::RequestDestination request_destination_in,
    ::blink::mojom::MixedContentContextType mixed_content_context_type_in,
    bool is_form_submission_in,
    bool was_initiated_by_link_click_in,
    const ::GURL& searchable_form_url_in,
    const std::string& searchable_form_encoding_in,
    const ::GURL& client_side_redirect_url_in,
    absl::optional<::base::Value> devtools_initiator_in,
    ::network::mojom::TrustTokenParamsPtr trust_token_params_in,
    const absl::optional<::blink::Impression>& impression_in,
    ::base::TimeTicks before_unload_start_in,
    ::base::TimeTicks before_unload_end_in,
    const absl::optional<::network::ResourceRequest::WebBundleTokenParams>& web_bundle_token_in)
    : initiator_frame_token(std::move(initiator_frame_token_in)),
      headers(std::move(headers_in)),
      load_flags(std::move(load_flags_in)),
      skip_service_worker(std::move(skip_service_worker_in)),
      request_context_type(std::move(request_context_type_in)),
      request_destination(std::move(request_destination_in)),
      mixed_content_context_type(std::move(mixed_content_context_type_in)),
      is_form_submission(std::move(is_form_submission_in)),
      was_initiated_by_link_click(std::move(was_initiated_by_link_click_in)),
      searchable_form_url(std::move(searchable_form_url_in)),
      searchable_form_encoding(std::move(searchable_form_encoding_in)),
      client_side_redirect_url(std::move(client_side_redirect_url_in)),
      devtools_initiator(std::move(devtools_initiator_in)),
      trust_token_params(std::move(trust_token_params_in)),
      impression(std::move(impression_in)),
      before_unload_start(std::move(before_unload_start_in)),
      before_unload_end(std::move(before_unload_end_in)),
      web_bundle_token(std::move(web_bundle_token_in)) {}

BeginNavigationParams::~BeginNavigationParams() = default;

void BeginNavigationParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_frame_token"), this->initiator_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::LocalFrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_flags"), this->load_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_service_worker"), this->skip_service_worker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_context_type"), this->request_context_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::RequestContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_destination"), this->request_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RequestDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mixed_content_context_type"), this->mixed_content_context_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::MixedContentContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_form_submission"), this->is_form_submission,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_initiated_by_link_click"), this->was_initiated_by_link_click,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "searchable_form_url"), this->searchable_form_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "searchable_form_encoding"), this->searchable_form_encoding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_side_redirect_url"), this->client_side_redirect_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_initiator"), this->devtools_initiator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_params"), this->trust_token_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::TrustTokenParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::Impression>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "before_unload_start"), this->before_unload_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "before_unload_end"), this->before_unload_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_token"), this->web_bundle_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::network::ResourceRequest::WebBundleTokenParams>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BeginNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommonNavigationParams::CommonNavigationParams()
    : url(),
      initiator_origin(),
      referrer(),
      transition(),
      navigation_type(NavigationType::DIFFERENT_DOCUMENT),
      download_policy(),
      should_replace_current_entry(false),
      base_url_for_data_url(),
      history_url_for_data_url(),
      previews_state(0),
      navigation_start(),
      method("GET"),
      post_data(),
      source_location(),
      started_from_context_menu(false),
      has_user_gesture(false),
      text_fragment_token(false),
      should_check_main_world_csp(::network::mojom::CSPDisposition::CHECK),
      initiator_origin_trial_features(),
      href_translate(),
      is_history_navigation_in_new_child_frame(false),
      input_start() {}

CommonNavigationParams::CommonNavigationParams(
    const ::GURL& url_in,
    const absl::optional<::url::Origin>& initiator_origin_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    int32_t transition_in,
    NavigationType navigation_type_in,
    const ::blink::NavigationDownloadPolicy& download_policy_in,
    bool should_replace_current_entry_in,
    const ::GURL& base_url_for_data_url_in,
    const ::GURL& history_url_for_data_url_in,
    int32_t previews_state_in,
    ::base::TimeTicks navigation_start_in,
    const std::string& method_in,
    ::scoped_refptr<::network::ResourceRequestBody> post_data_in,
    ::network::mojom::SourceLocationPtr source_location_in,
    bool started_from_context_menu_in,
    bool has_user_gesture_in,
    bool text_fragment_token_in,
    ::network::mojom::CSPDisposition should_check_main_world_csp_in,
    std::vector<int32_t> initiator_origin_trial_features_in,
    const std::string& href_translate_in,
    bool is_history_navigation_in_new_child_frame_in,
    ::base::TimeTicks input_start_in)
    : url(std::move(url_in)),
      initiator_origin(std::move(initiator_origin_in)),
      referrer(std::move(referrer_in)),
      transition(std::move(transition_in)),
      navigation_type(std::move(navigation_type_in)),
      download_policy(std::move(download_policy_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      base_url_for_data_url(std::move(base_url_for_data_url_in)),
      history_url_for_data_url(std::move(history_url_for_data_url_in)),
      previews_state(std::move(previews_state_in)),
      navigation_start(std::move(navigation_start_in)),
      method(std::move(method_in)),
      post_data(std::move(post_data_in)),
      source_location(std::move(source_location_in)),
      started_from_context_menu(std::move(started_from_context_menu_in)),
      has_user_gesture(std::move(has_user_gesture_in)),
      text_fragment_token(std::move(text_fragment_token_in)),
      should_check_main_world_csp(std::move(should_check_main_world_csp_in)),
      initiator_origin_trial_features(std::move(initiator_origin_trial_features_in)),
      href_translate(std::move(href_translate_in)),
      is_history_navigation_in_new_child_frame(std::move(is_history_navigation_in_new_child_frame_in)),
      input_start(std::move(input_start_in)) {}

CommonNavigationParams::~CommonNavigationParams() = default;

void CommonNavigationParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin"), this->initiator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition"), this->transition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_type"), this->navigation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NavigationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_policy"), this->download_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::NavigationDownloadPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_replace_current_entry"), this->should_replace_current_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_url_for_data_url"), this->base_url_for_data_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "history_url_for_data_url"), this->history_url_for_data_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "previews_state"), this->previews_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start"), this->navigation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_data"), this->post_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_location"), this->source_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::SourceLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "started_from_context_menu"), this->started_from_context_menu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_gesture"), this->has_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_fragment_token"), this->text_fragment_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_check_main_world_csp"), this->should_check_main_world_csp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::CSPDisposition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin_trial_features"), this->initiator_origin_trial_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "href_translate"), this->href_translate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_history_navigation_in_new_child_frame"), this->is_history_navigation_in_new_child_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_start"), this->input_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommonNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NavigationTiming::NavigationTiming()
    : redirect_start(),
      redirect_end(),
      fetch_start() {}

NavigationTiming::NavigationTiming(
    ::base::TimeTicks redirect_start_in,
    ::base::TimeTicks redirect_end_in,
    ::base::TimeTicks fetch_start_in)
    : redirect_start(std::move(redirect_start_in)),
      redirect_end(std::move(redirect_end_in)),
      fetch_start(std::move(fetch_start_in)) {}

NavigationTiming::~NavigationTiming() = default;

void NavigationTiming::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_start"), this->redirect_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_end"), this->redirect_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_start"), this->fetch_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NavigationTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OldPageInfo::OldPageInfo()
    : routing_id_for_old_main_frame(-1),
      new_lifecycle_state_for_old_page() {}

OldPageInfo::OldPageInfo(
    int32_t routing_id_for_old_main_frame_in,
    ::blink::mojom::PageLifecycleStatePtr new_lifecycle_state_for_old_page_in)
    : routing_id_for_old_main_frame(std::move(routing_id_for_old_main_frame_in)),
      new_lifecycle_state_for_old_page(std::move(new_lifecycle_state_for_old_page_in)) {}

OldPageInfo::~OldPageInfo() = default;
size_t OldPageInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->routing_id_for_old_main_frame);
  seed = mojo::internal::Hash(seed, this->new_lifecycle_state_for_old_page);
  return seed;
}

void OldPageInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id_for_old_main_frame"), this->routing_id_for_old_main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_lifecycle_state_for_old_page"), this->new_lifecycle_state_for_old_page,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PageLifecycleStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OldPageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AppHistoryEntry::AppHistoryEntry()
    : key(),
      id(),
      url() {}

AppHistoryEntry::AppHistoryEntry(
    const ::std::u16string& key_in,
    const ::std::u16string& id_in,
    const ::std::u16string& url_in)
    : key(std::move(key_in)),
      id(std::move(id_in)),
      url(std::move(url_in)) {}

AppHistoryEntry::~AppHistoryEntry() = default;

void AppHistoryEntry::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AppHistoryEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommitNavigationParams::CommitNavigationParams()
    : origin_to_commit(),
      storage_key(),
      sandbox_flags(::network::mojom::WebSandboxFlags::kAll),
      is_overriding_user_agent(false),
      redirects(),
      redirect_response(),
      redirect_infos(),
      post_content_type(),
      original_url(),
      original_method(),
      can_load_local_resources(false),
      page_state(),
      nav_entry_id(0),
      subframe_unique_names(),
      intended_as_new_entry(false),
      pending_history_list_offset(-1),
      current_history_list_offset(-1),
      current_history_list_length(0),
      was_discarded(false),
      is_view_source(false),
      should_clear_history_list(false),
      navigation_timing(),
      appcache_host_id(),
      was_activated(::blink::mojom::WasActivatedOption::kUnknown),
      navigation_token(),
      prefetched_signed_exchanges(),
      is_browser_initiated(false),
      web_bundle_physical_url(),
      web_bundle_claimed_url(),
      document_ukm_source_id(),
      frame_policy(),
      force_enabled_origin_trials(),
      origin_agent_cluster(false),
      enabled_client_hints(),
      is_cross_site_cross_browsing_context_group(false),
      old_page_info(),
      http_response_code(-1),
      app_history_back_entries(),
      app_history_forward_entries(),
      early_hints_preloaded_resources() {}

CommitNavigationParams::CommitNavigationParams(
    const absl::optional<::url::Origin>& origin_to_commit_in,
    const ::blink::StorageKey& storage_key_in,
    ::network::mojom::WebSandboxFlags sandbox_flags_in,
    bool is_overriding_user_agent_in,
    std::vector<::GURL> redirects_in,
    std::vector<::network::mojom::URLResponseHeadPtr> redirect_response_in,
    std::vector<::net::RedirectInfo> redirect_infos_in,
    const std::string& post_content_type_in,
    const ::GURL& original_url_in,
    const std::string& original_method_in,
    bool can_load_local_resources_in,
    const std::string& page_state_in,
    int32_t nav_entry_id_in,
    const base::flat_map<std::string, bool>& subframe_unique_names_in,
    bool intended_as_new_entry_in,
    int32_t pending_history_list_offset_in,
    int32_t current_history_list_offset_in,
    int32_t current_history_list_length_in,
    bool was_discarded_in,
    bool is_view_source_in,
    bool should_clear_history_list_in,
    NavigationTimingPtr navigation_timing_in,
    const absl::optional<::base::UnguessableToken>& appcache_host_id_in,
    ::blink::mojom::WasActivatedOption was_activated_in,
    const ::base::UnguessableToken& navigation_token_in,
    std::vector<::blink::mojom::PrefetchedSignedExchangeInfoPtr> prefetched_signed_exchanges_in,
    bool is_browser_initiated_in,
    const ::GURL& web_bundle_physical_url_in,
    const ::GURL& web_bundle_claimed_url_in,
    int64_t document_ukm_source_id_in,
    const ::blink::FramePolicy& frame_policy_in,
    std::vector<std::string> force_enabled_origin_trials_in,
    bool origin_agent_cluster_in,
    std::vector<::network::mojom::WebClientHintsType> enabled_client_hints_in,
    bool is_cross_site_cross_browsing_context_group_in,
    OldPageInfoPtr old_page_info_in,
    int32_t http_response_code_in,
    std::vector<AppHistoryEntryPtr> app_history_back_entries_in,
    std::vector<AppHistoryEntryPtr> app_history_forward_entries_in,
    std::vector<::GURL> early_hints_preloaded_resources_in)
    : origin_to_commit(std::move(origin_to_commit_in)),
      storage_key(std::move(storage_key_in)),
      sandbox_flags(std::move(sandbox_flags_in)),
      is_overriding_user_agent(std::move(is_overriding_user_agent_in)),
      redirects(std::move(redirects_in)),
      redirect_response(std::move(redirect_response_in)),
      redirect_infos(std::move(redirect_infos_in)),
      post_content_type(std::move(post_content_type_in)),
      original_url(std::move(original_url_in)),
      original_method(std::move(original_method_in)),
      can_load_local_resources(std::move(can_load_local_resources_in)),
      page_state(std::move(page_state_in)),
      nav_entry_id(std::move(nav_entry_id_in)),
      subframe_unique_names(std::move(subframe_unique_names_in)),
      intended_as_new_entry(std::move(intended_as_new_entry_in)),
      pending_history_list_offset(std::move(pending_history_list_offset_in)),
      current_history_list_offset(std::move(current_history_list_offset_in)),
      current_history_list_length(std::move(current_history_list_length_in)),
      was_discarded(std::move(was_discarded_in)),
      is_view_source(std::move(is_view_source_in)),
      should_clear_history_list(std::move(should_clear_history_list_in)),
      navigation_timing(std::move(navigation_timing_in)),
      appcache_host_id(std::move(appcache_host_id_in)),
      was_activated(std::move(was_activated_in)),
      navigation_token(std::move(navigation_token_in)),
      prefetched_signed_exchanges(std::move(prefetched_signed_exchanges_in)),
      is_browser_initiated(std::move(is_browser_initiated_in)),
      web_bundle_physical_url(std::move(web_bundle_physical_url_in)),
      web_bundle_claimed_url(std::move(web_bundle_claimed_url_in)),
      document_ukm_source_id(std::move(document_ukm_source_id_in)),
      frame_policy(std::move(frame_policy_in)),
      force_enabled_origin_trials(std::move(force_enabled_origin_trials_in)),
      origin_agent_cluster(std::move(origin_agent_cluster_in)),
      enabled_client_hints(std::move(enabled_client_hints_in)),
      is_cross_site_cross_browsing_context_group(std::move(is_cross_site_cross_browsing_context_group_in)),
      old_page_info(std::move(old_page_info_in)),
      http_response_code(std::move(http_response_code_in)),
      app_history_back_entries(std::move(app_history_back_entries_in)),
      app_history_forward_entries(std::move(app_history_forward_entries_in)),
      early_hints_preloaded_resources(std::move(early_hints_preloaded_resources_in)) {}

CommitNavigationParams::~CommitNavigationParams() = default;

void CommitNavigationParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_to_commit"), this->origin_to_commit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_key"), this->storage_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::StorageKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandbox_flags"), this->sandbox_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::WebSandboxFlags>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_overriding_user_agent"), this->is_overriding_user_agent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirects"), this->redirects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_response"), this->redirect_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::network::mojom::URLResponseHeadPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_infos"), this->redirect_infos,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::net::RedirectInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_content_type"), this->post_content_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_url"), this->original_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_method"), this->original_method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_load_local_resources"), this->can_load_local_resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_state"), this->page_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nav_entry_id"), this->nav_entry_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframe_unique_names"), this->subframe_unique_names,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, bool>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intended_as_new_entry"), this->intended_as_new_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pending_history_list_offset"), this->pending_history_list_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_history_list_offset"), this->current_history_list_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_history_list_length"), this->current_history_list_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_discarded"), this->was_discarded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_view_source"), this->is_view_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_clear_history_list"), this->should_clear_history_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_timing"), this->navigation_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NavigationTimingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appcache_host_id"), this->appcache_host_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_activated"), this->was_activated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WasActivatedOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_token"), this->navigation_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefetched_signed_exchanges"), this->prefetched_signed_exchanges,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::blink::mojom::PrefetchedSignedExchangeInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_browser_initiated"), this->is_browser_initiated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_physical_url"), this->web_bundle_physical_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_claimed_url"), this->web_bundle_claimed_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_ukm_source_id"), this->document_ukm_source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_policy"), this->frame_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::FramePolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_enabled_origin_trials"), this->force_enabled_origin_trials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_agent_cluster"), this->origin_agent_cluster,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_client_hints"), this->enabled_client_hints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::network::mojom::WebClientHintsType>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_cross_site_cross_browsing_context_group"), this->is_cross_site_cross_browsing_context_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "old_page_info"), this->old_page_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OldPageInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_response_code"), this->http_response_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_history_back_entries"), this->app_history_back_entries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AppHistoryEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_history_forward_entries"), this->app_history_forward_entries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AppHistoryEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "early_hints_preloaded_resources"), this->early_hints_preloaded_resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommitNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::BeginNavigationParams::DataView, ::blink::mojom::BeginNavigationParamsPtr>::Read(
    ::blink::mojom::BeginNavigationParams::DataView input,
    ::blink::mojom::BeginNavigationParamsPtr* output) {
  bool success = true;
  ::blink::mojom::BeginNavigationParamsPtr result(::blink::mojom::BeginNavigationParams::New());
  
      if (success && !input.ReadInitiatorFrameToken(&result->initiator_frame_token))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success)
        result->load_flags = input.load_flags();
      if (success)
        result->skip_service_worker = input.skip_service_worker();
      if (success && !input.ReadRequestContextType(&result->request_context_type))
        success = false;
      if (success && !input.ReadRequestDestination(&result->request_destination))
        success = false;
      if (success && !input.ReadMixedContentContextType(&result->mixed_content_context_type))
        success = false;
      if (success)
        result->is_form_submission = input.is_form_submission();
      if (success)
        result->was_initiated_by_link_click = input.was_initiated_by_link_click();
      if (success && !input.ReadSearchableFormUrl(&result->searchable_form_url))
        success = false;
      if (success && !input.ReadSearchableFormEncoding(&result->searchable_form_encoding))
        success = false;
      if (success && !input.ReadClientSideRedirectUrl(&result->client_side_redirect_url))
        success = false;
      if (success && !input.ReadDevtoolsInitiator(&result->devtools_initiator))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadBeforeUnloadStart(&result->before_unload_start))
        success = false;
      if (success && !input.ReadBeforeUnloadEnd(&result->before_unload_end))
        success = false;
      if (success && !input.ReadWebBundleToken(&result->web_bundle_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CommonNavigationParams::DataView, ::blink::mojom::CommonNavigationParamsPtr>::Read(
    ::blink::mojom::CommonNavigationParams::DataView input,
    ::blink::mojom::CommonNavigationParamsPtr* output) {
  bool success = true;
  ::blink::mojom::CommonNavigationParamsPtr result(::blink::mojom::CommonNavigationParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success)
        result->transition = input.transition();
      if (success && !input.ReadNavigationType(&result->navigation_type))
        success = false;
      if (success && !input.ReadDownloadPolicy(&result->download_policy))
        success = false;
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success && !input.ReadBaseUrlForDataUrl(&result->base_url_for_data_url))
        success = false;
      if (success && !input.ReadHistoryUrlForDataUrl(&result->history_url_for_data_url))
        success = false;
      if (success)
        result->previews_state = input.previews_state();
      if (success && !input.ReadNavigationStart(&result->navigation_start))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadPostData(&result->post_data))
        success = false;
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
      if (success)
        result->started_from_context_menu = input.started_from_context_menu();
      if (success)
        result->has_user_gesture = input.has_user_gesture();
      if (success)
        result->text_fragment_token = input.text_fragment_token();
      if (success && !input.ReadShouldCheckMainWorldCsp(&result->should_check_main_world_csp))
        success = false;
      if (success && !input.ReadInitiatorOriginTrialFeatures(&result->initiator_origin_trial_features))
        success = false;
      if (success && !input.ReadHrefTranslate(&result->href_translate))
        success = false;
      if (success)
        result->is_history_navigation_in_new_child_frame = input.is_history_navigation_in_new_child_frame();
      if (success && !input.ReadInputStart(&result->input_start))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::NavigationTiming::DataView, ::blink::mojom::NavigationTimingPtr>::Read(
    ::blink::mojom::NavigationTiming::DataView input,
    ::blink::mojom::NavigationTimingPtr* output) {
  bool success = true;
  ::blink::mojom::NavigationTimingPtr result(::blink::mojom::NavigationTiming::New());
  
      if (success && !input.ReadRedirectStart(&result->redirect_start))
        success = false;
      if (success && !input.ReadRedirectEnd(&result->redirect_end))
        success = false;
      if (success && !input.ReadFetchStart(&result->fetch_start))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::OldPageInfo::DataView, ::blink::mojom::OldPageInfoPtr>::Read(
    ::blink::mojom::OldPageInfo::DataView input,
    ::blink::mojom::OldPageInfoPtr* output) {
  bool success = true;
  ::blink::mojom::OldPageInfoPtr result(::blink::mojom::OldPageInfo::New());
  
      if (success)
        result->routing_id_for_old_main_frame = input.routing_id_for_old_main_frame();
      if (success && !input.ReadNewLifecycleStateForOldPage(&result->new_lifecycle_state_for_old_page))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AppHistoryEntry::DataView, ::blink::mojom::AppHistoryEntryPtr>::Read(
    ::blink::mojom::AppHistoryEntry::DataView input,
    ::blink::mojom::AppHistoryEntryPtr* output) {
  bool success = true;
  ::blink::mojom::AppHistoryEntryPtr result(::blink::mojom::AppHistoryEntry::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CommitNavigationParams::DataView, ::blink::mojom::CommitNavigationParamsPtr>::Read(
    ::blink::mojom::CommitNavigationParams::DataView input,
    ::blink::mojom::CommitNavigationParamsPtr* output) {
  bool success = true;
  ::blink::mojom::CommitNavigationParamsPtr result(::blink::mojom::CommitNavigationParams::New());
  
      if (success && !input.ReadOriginToCommit(&result->origin_to_commit))
        success = false;
      if (success && !input.ReadStorageKey(&result->storage_key))
        success = false;
      if (success && !input.ReadSandboxFlags(&result->sandbox_flags))
        success = false;
      if (success)
        result->is_overriding_user_agent = input.is_overriding_user_agent();
      if (success && !input.ReadRedirects(&result->redirects))
        success = false;
      if (success && !input.ReadRedirectResponse(&result->redirect_response))
        success = false;
      if (success && !input.ReadRedirectInfos(&result->redirect_infos))
        success = false;
      if (success && !input.ReadPostContentType(&result->post_content_type))
        success = false;
      if (success && !input.ReadOriginalUrl(&result->original_url))
        success = false;
      if (success && !input.ReadOriginalMethod(&result->original_method))
        success = false;
      if (success)
        result->can_load_local_resources = input.can_load_local_resources();
      if (success && !input.ReadPageState(&result->page_state))
        success = false;
      if (success)
        result->nav_entry_id = input.nav_entry_id();
      if (success && !input.ReadSubframeUniqueNames(&result->subframe_unique_names))
        success = false;
      if (success)
        result->intended_as_new_entry = input.intended_as_new_entry();
      if (success)
        result->pending_history_list_offset = input.pending_history_list_offset();
      if (success)
        result->current_history_list_offset = input.current_history_list_offset();
      if (success)
        result->current_history_list_length = input.current_history_list_length();
      if (success)
        result->was_discarded = input.was_discarded();
      if (success)
        result->is_view_source = input.is_view_source();
      if (success)
        result->should_clear_history_list = input.should_clear_history_list();
      if (success && !input.ReadNavigationTiming(&result->navigation_timing))
        success = false;
      if (success && !input.ReadAppcacheHostId(&result->appcache_host_id))
        success = false;
      if (success && !input.ReadWasActivated(&result->was_activated))
        success = false;
      if (success && !input.ReadNavigationToken(&result->navigation_token))
        success = false;
      if (success && !input.ReadPrefetchedSignedExchanges(&result->prefetched_signed_exchanges))
        success = false;
      if (success)
        result->is_browser_initiated = input.is_browser_initiated();
      if (success && !input.ReadWebBundlePhysicalUrl(&result->web_bundle_physical_url))
        success = false;
      if (success && !input.ReadWebBundleClaimedUrl(&result->web_bundle_claimed_url))
        success = false;
      if (success)
        result->document_ukm_source_id = input.document_ukm_source_id();
      if (success && !input.ReadFramePolicy(&result->frame_policy))
        success = false;
      if (success && !input.ReadForceEnabledOriginTrials(&result->force_enabled_origin_trials))
        success = false;
      if (success)
        result->origin_agent_cluster = input.origin_agent_cluster();
      if (success && !input.ReadEnabledClientHints(&result->enabled_client_hints))
        success = false;
      if (success)
        result->is_cross_site_cross_browsing_context_group = input.is_cross_site_cross_browsing_context_group();
      if (success && !input.ReadOldPageInfo(&result->old_page_info))
        success = false;
      if (success)
        result->http_response_code = input.http_response_code();
      if (success && !input.ReadAppHistoryBackEntries(&result->app_history_back_entries))
        success = false;
      if (success && !input.ReadAppHistoryForwardEntries(&result->app_history_forward_entries))
        success = false;
      if (success && !input.ReadEarlyHintsPreloadedResources(&result->early_hints_preloaded_resources))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif