// third_party/blink/public/mojom/payments/payment_handler_host.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "components/payments/mojom/payment_request_data.mojom.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_JUMBO_H_
#endif


namespace payments {
namespace mojom {


void PaymentHandlerHostInterceptorForTesting::ChangePaymentMethod(PaymentHandlerMethodDataPtr method_data, ChangePaymentMethodCallback callback) {
  GetForwardingInterface()->ChangePaymentMethod(std::move(method_data), std::move(callback));
}
void PaymentHandlerHostInterceptorForTesting::ChangeShippingOption(const std::string& shipping_option_id, ChangeShippingOptionCallback callback) {
  GetForwardingInterface()->ChangeShippingOption(std::move(shipping_option_id), std::move(callback));
}
void PaymentHandlerHostInterceptorForTesting::ChangeShippingAddress(::payments::mojom::PaymentAddressPtr shipping_address, ChangeShippingAddressCallback callback) {
  GetForwardingInterface()->ChangeShippingAddress(std::move(shipping_address), std::move(callback));
}
PaymentHandlerHostAsyncWaiter::PaymentHandlerHostAsyncWaiter(
    PaymentHandlerHost* proxy) : proxy_(proxy) {}

PaymentHandlerHostAsyncWaiter::~PaymentHandlerHostAsyncWaiter() = default;

void PaymentHandlerHostAsyncWaiter::ChangePaymentMethod(
    PaymentHandlerMethodDataPtr method_data, PaymentRequestDetailsUpdatePtr* out_response_data) {
  base::RunLoop loop;
  proxy_->ChangePaymentMethod(std::move(method_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaymentRequestDetailsUpdatePtr* out_response_data
,
             PaymentRequestDetailsUpdatePtr response_data) {*out_response_data = std::move(response_data);
            loop->Quit();
          },
          &loop,
          out_response_data));
  loop.Run();
}
void PaymentHandlerHostAsyncWaiter::ChangeShippingOption(
    const std::string& shipping_option_id, PaymentRequestDetailsUpdatePtr* out_response_data) {
  base::RunLoop loop;
  proxy_->ChangeShippingOption(std::move(shipping_option_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaymentRequestDetailsUpdatePtr* out_response_data
,
             PaymentRequestDetailsUpdatePtr response_data) {*out_response_data = std::move(response_data);
            loop->Quit();
          },
          &loop,
          out_response_data));
  loop.Run();
}
void PaymentHandlerHostAsyncWaiter::ChangeShippingAddress(
    ::payments::mojom::PaymentAddressPtr shipping_address, PaymentRequestDetailsUpdatePtr* out_response_data) {
  base::RunLoop loop;
  proxy_->ChangeShippingAddress(std::move(shipping_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             PaymentRequestDetailsUpdatePtr* out_response_data
,
             PaymentRequestDetailsUpdatePtr response_data) {*out_response_data = std::move(response_data);
            loop->Quit();
          },
          &loop,
          out_response_data));
  loop.Run();
}





}  // namespace mojom
}  // namespace payments

#if defined(__clang__)
#pragma clang diagnostic pop
#endif