// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-params-data.h"
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
PerContextV8MemoryUsage::PerContextV8MemoryUsage()
    : token(),
      bytes_used(0ULL),
      url() {}

PerContextV8MemoryUsage::PerContextV8MemoryUsage(
    const ::blink::ExecutionContextToken& token_in,
    uint64_t bytes_used_in,
    const absl::optional<std::string>& url_in)
    : token(std::move(token_in)),
      bytes_used(std::move(bytes_used_in)),
      url(std::move(url_in)) {}

PerContextV8MemoryUsage::~PerContextV8MemoryUsage() = default;

void PerContextV8MemoryUsage::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ExecutionContextToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes_used"), this->bytes_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerContextV8MemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PerContextCanvasMemoryUsage::PerContextCanvasMemoryUsage()
    : token(),
      bytes_used(0ULL) {}

PerContextCanvasMemoryUsage::PerContextCanvasMemoryUsage(
    const ::blink::ExecutionContextToken& token_in,
    uint64_t bytes_used_in)
    : token(std::move(token_in)),
      bytes_used(std::move(bytes_used_in)) {}

PerContextCanvasMemoryUsage::~PerContextCanvasMemoryUsage() = default;

void PerContextCanvasMemoryUsage::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::ExecutionContextToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bytes_used"), this->bytes_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerContextCanvasMemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PerIsolateV8MemoryUsage::PerIsolateV8MemoryUsage()
    : num_detached_contexts(),
      detached_bytes_used(),
      shared_bytes_used(),
      blink_bytes_used(),
      contexts(),
      canvas_contexts() {}

PerIsolateV8MemoryUsage::PerIsolateV8MemoryUsage(
    uint64_t num_detached_contexts_in,
    uint64_t detached_bytes_used_in,
    uint64_t shared_bytes_used_in,
    uint64_t blink_bytes_used_in,
    std::vector<PerContextV8MemoryUsagePtr> contexts_in,
    std::vector<PerContextCanvasMemoryUsagePtr> canvas_contexts_in)
    : num_detached_contexts(std::move(num_detached_contexts_in)),
      detached_bytes_used(std::move(detached_bytes_used_in)),
      shared_bytes_used(std::move(shared_bytes_used_in)),
      blink_bytes_used(std::move(blink_bytes_used_in)),
      contexts(std::move(contexts_in)),
      canvas_contexts(std::move(canvas_contexts_in)) {}

PerIsolateV8MemoryUsage::~PerIsolateV8MemoryUsage() = default;

void PerIsolateV8MemoryUsage::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_detached_contexts"), this->num_detached_contexts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "detached_bytes_used"), this->detached_bytes_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_bytes_used"), this->shared_bytes_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blink_bytes_used"), this->blink_bytes_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contexts"), this->contexts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PerContextV8MemoryUsagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "canvas_contexts"), this->canvas_contexts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PerContextCanvasMemoryUsagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerIsolateV8MemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PerProcessV8MemoryUsage::PerProcessV8MemoryUsage()
    : isolates() {}

PerProcessV8MemoryUsage::PerProcessV8MemoryUsage(
    std::vector<PerIsolateV8MemoryUsagePtr> isolates_in)
    : isolates(std::move(isolates_in)) {}

PerProcessV8MemoryUsage::~PerProcessV8MemoryUsage() = default;

void PerProcessV8MemoryUsage::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolates"), this->isolates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PerIsolateV8MemoryUsagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerProcessV8MemoryUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char V8DetailedMemoryReporter::Name_[] = "blink.mojom.V8DetailedMemoryReporter";

class V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback(
      V8DetailedMemoryReporter::GetV8MemoryUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  V8DetailedMemoryReporter::GetV8MemoryUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback);
};

V8DetailedMemoryReporterProxy::V8DetailedMemoryReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void V8DetailedMemoryReporterProxy::GetV8MemoryUsage(
    V8DetailedMemoryReporter::Mode in_mode, GetV8MemoryUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type V8DetailedMemoryReporter::Mode>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kV8DetailedMemoryReporter_GetV8MemoryUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::V8DetailedMemoryReporter_Mode>(
      in_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(V8DetailedMemoryReporter::Name_);
  message.set_method_name("GetV8MemoryUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder {
 public:
  static V8DetailedMemoryReporter::GetV8MemoryUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder> proxy(
        new V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "V8DetailedMemoryReporter::GetV8MemoryUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PerProcessV8MemoryUsagePtr in_memory_usage);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder);
};

bool V8DetailedMemoryReporter_GetV8MemoryUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PerProcessV8MemoryUsagePtr p_memory_usage{};
  V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryUsage(&p_memory_usage))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        V8DetailedMemoryReporter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_memory_usage));
  return true;
}

void V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder::Run(
    PerProcessV8MemoryUsagePtr in_memory_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_usage"), in_memory_usage,
                        "<value of type PerProcessV8MemoryUsagePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kV8DetailedMemoryReporter_GetV8MemoryUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->memory_usage)::BaseType> memory_usage_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PerProcessV8MemoryUsageDataView>(
      in_memory_usage, memory_usage_fragment);
  params->memory_usage.Set(
      memory_usage_fragment.is_null() ? nullptr : memory_usage_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->memory_usage.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_usage in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(V8DetailedMemoryReporter::Name_);
  message.set_method_name("GetV8MemoryUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool V8DetailedMemoryReporterStubDispatch::Accept(
    V8DetailedMemoryReporter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kV8DetailedMemoryReporter_GetV8MemoryUsage_Name: {
      break;
    }
  }
  return false;
}

// static
bool V8DetailedMemoryReporterStubDispatch::AcceptWithResponder(
    V8DetailedMemoryReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kV8DetailedMemoryReporter_GetV8MemoryUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::V8DetailedMemoryReporter::GetV8MemoryUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data* params =
          reinterpret_cast<
              internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      V8DetailedMemoryReporter::Mode p_mode{};
      V8DetailedMemoryReporter_GetV8MemoryUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            V8DetailedMemoryReporter::Name_, 0, false);
        return false;
      }
      V8DetailedMemoryReporter::GetV8MemoryUsageCallback callback =
          V8DetailedMemoryReporter_GetV8MemoryUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetV8MemoryUsage(
std::move(p_mode), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kV8DetailedMemoryReporterValidationInfo[] = {
    {&internal::V8DetailedMemoryReporter_GetV8MemoryUsage_Params_Data::Validate,
     &internal::V8DetailedMemoryReporter_GetV8MemoryUsage_ResponseParams_Data::Validate},
};

bool V8DetailedMemoryReporterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::V8DetailedMemoryReporter::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kV8DetailedMemoryReporterValidationInfo);
}

bool V8DetailedMemoryReporterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::V8DetailedMemoryReporter::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kV8DetailedMemoryReporterValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::PerContextV8MemoryUsage::DataView, ::blink::mojom::PerContextV8MemoryUsagePtr>::Read(
    ::blink::mojom::PerContextV8MemoryUsage::DataView input,
    ::blink::mojom::PerContextV8MemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::PerContextV8MemoryUsagePtr result(::blink::mojom::PerContextV8MemoryUsage::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->bytes_used = input.bytes_used();
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PerContextCanvasMemoryUsage::DataView, ::blink::mojom::PerContextCanvasMemoryUsagePtr>::Read(
    ::blink::mojom::PerContextCanvasMemoryUsage::DataView input,
    ::blink::mojom::PerContextCanvasMemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::PerContextCanvasMemoryUsagePtr result(::blink::mojom::PerContextCanvasMemoryUsage::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->bytes_used = input.bytes_used();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PerIsolateV8MemoryUsage::DataView, ::blink::mojom::PerIsolateV8MemoryUsagePtr>::Read(
    ::blink::mojom::PerIsolateV8MemoryUsage::DataView input,
    ::blink::mojom::PerIsolateV8MemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::PerIsolateV8MemoryUsagePtr result(::blink::mojom::PerIsolateV8MemoryUsage::New());
  
      if (success)
        result->num_detached_contexts = input.num_detached_contexts();
      if (success)
        result->detached_bytes_used = input.detached_bytes_used();
      if (success)
        result->shared_bytes_used = input.shared_bytes_used();
      if (success)
        result->blink_bytes_used = input.blink_bytes_used();
      if (success && !input.ReadContexts(&result->contexts))
        success = false;
      if (success && !input.ReadCanvasContexts(&result->canvas_contexts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PerProcessV8MemoryUsage::DataView, ::blink::mojom::PerProcessV8MemoryUsagePtr>::Read(
    ::blink::mojom::PerProcessV8MemoryUsage::DataView input,
    ::blink::mojom::PerProcessV8MemoryUsagePtr* output) {
  bool success = true;
  ::blink::mojom::PerProcessV8MemoryUsagePtr result(::blink::mojom::PerProcessV8MemoryUsage::New());
  
      if (success && !input.ReadIsolates(&result->isolates))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif