// third_party/blink/public/mojom/permissions/permission_automation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/permissions/permission_automation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/permissions/permission_automation.mojom-params-data.h"
#include "third_party/blink/public/mojom/permissions/permission_automation.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/permissions/permission_automation.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_AUTOMATION_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_AUTOMATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace test {
namespace mojom {
namespace blink {
const char PermissionAutomation::Name_[] = "blink.test.mojom.PermissionAutomation";

class PermissionAutomation_SetPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PermissionAutomation_SetPermission_ForwardToCallback(
      PermissionAutomation::SetPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PermissionAutomation::SetPermissionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PermissionAutomation_SetPermission_ForwardToCallback);
};

PermissionAutomationProxy::PermissionAutomationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PermissionAutomationProxy::SetPermission(
    ::blink::mojom::blink::PermissionDescriptorPtr in_descriptor, ::blink::mojom::blink::PermissionStatus in_status, const ::blink::KURL& in_origin, const ::blink::KURL& in_embedding_origin, SetPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::test::mojom::PermissionAutomation::SetPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor"), in_descriptor,
                        "<value of type ::blink::mojom::blink::PermissionDescriptorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::PermissionStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedding_origin"), in_embedding_origin,
                        "<value of type const ::blink::KURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPermissionAutomation_SetPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::PermissionAutomation_SetPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor)::BaseType> descriptor_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PermissionDescriptorDataView>(
      in_descriptor, descriptor_fragment);
  params->descriptor.Set(
      descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->descriptor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null descriptor in PermissionAutomation.SetPermission request");
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in PermissionAutomation.SetPermission request");
  mojo::internal::MessageFragment<
      typename decltype(params->embedding_origin)::BaseType> embedding_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_embedding_origin, embedding_origin_fragment);
  params->embedding_origin.Set(
      embedding_origin_fragment.is_null() ? nullptr : embedding_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedding_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedding_origin in PermissionAutomation.SetPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionAutomation::Name_);
  message.set_method_name("SetPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PermissionAutomation_SetPermission_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PermissionAutomation_SetPermission_ProxyToResponder {
 public:
  static PermissionAutomation::SetPermissionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PermissionAutomation_SetPermission_ProxyToResponder> proxy(
        new PermissionAutomation_SetPermission_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PermissionAutomation_SetPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PermissionAutomation_SetPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PermissionAutomation_SetPermission_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PermissionAutomation::SetPermissionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PermissionAutomation_SetPermission_ProxyToResponder);
};

bool PermissionAutomation_SetPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::test::mojom::PermissionAutomation::SetPermissionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PermissionAutomation_SetPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PermissionAutomation_SetPermission_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  PermissionAutomation_SetPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PermissionAutomation::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void PermissionAutomation_SetPermission_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::test::mojom::PermissionAutomation::SetPermissionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPermissionAutomation_SetPermission_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::test::mojom::internal::PermissionAutomation_SetPermission_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::test::mojom::PermissionAutomation::SetPermissionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PermissionAutomation::Name_);
  message.set_method_name("SetPermission");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PermissionAutomationStubDispatch::Accept(
    PermissionAutomation* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPermissionAutomation_SetPermission_Name: {
      break;
    }
  }
  return false;
}

// static
bool PermissionAutomationStubDispatch::AcceptWithResponder(
    PermissionAutomation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPermissionAutomation_SetPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::test::mojom::PermissionAutomation::SetPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::test::mojom::PermissionAutomation::SetPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PermissionAutomation_SetPermission_Params_Data* params =
          reinterpret_cast<
              internal::PermissionAutomation_SetPermission_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::PermissionDescriptorPtr p_descriptor{};
      ::blink::mojom::blink::PermissionStatus p_status{};
      ::blink::KURL p_origin{};
      ::blink::KURL p_embedding_origin{};
      PermissionAutomation_SetPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescriptor(&p_descriptor))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadEmbeddingOrigin(&p_embedding_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PermissionAutomation::Name_, 0, false);
        return false;
      }
      PermissionAutomation::SetPermissionCallback callback =
          PermissionAutomation_SetPermission_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPermission(
std::move(p_descriptor), 
std::move(p_status), 
std::move(p_origin), 
std::move(p_embedding_origin), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPermissionAutomationValidationInfo[] = {
    {&internal::PermissionAutomation_SetPermission_Params_Data::Validate,
     &internal::PermissionAutomation_SetPermission_ResponseParams_Data::Validate},
};

bool PermissionAutomationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::blink::PermissionAutomation::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPermissionAutomationValidationInfo);
}

bool PermissionAutomationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::test::mojom::blink::PermissionAutomation::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPermissionAutomationValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace test
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif