// third_party/blink/public/mojom/plugins/plugin_registry.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-params-data.h"
#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PLUGINS_PLUGIN_REGISTRY_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PLUGINS_PLUGIN_REGISTRY_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
PluginMimeType::PluginMimeType()
    : mime_type(),
      description(),
      file_extensions() {}

PluginMimeType::PluginMimeType(
    const WTF::String& mime_type_in,
    const ::WTF::String& description_in,
    WTF::Vector<WTF::String> file_extensions_in)
    : mime_type(std::move(mime_type_in)),
      description(std::move(description_in)),
      file_extensions(std::move(file_extensions_in)) {}

PluginMimeType::~PluginMimeType() = default;

void PluginMimeType::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_extensions"), this->file_extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PluginMimeType::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PluginInfo::PluginInfo()
    : name(),
      description(),
      filename(),
      background_color(),
      mime_types(),
      may_use_external_handler() {}

PluginInfo::PluginInfo(
    const ::WTF::String& name_in,
    const ::WTF::String& description_in,
    const ::base::FilePath& filename_in,
    uint32_t background_color_in,
    WTF::Vector<PluginMimeTypePtr> mime_types_in,
    bool may_use_external_handler_in)
    : name(std::move(name_in)),
      description(std::move(description_in)),
      filename(std::move(filename_in)),
      background_color(std::move(background_color_in)),
      mime_types(std::move(mime_types_in)),
      may_use_external_handler(std::move(may_use_external_handler_in)) {}

PluginInfo::~PluginInfo() = default;

void PluginInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filename"), this->filename,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_types"), this->mime_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PluginMimeTypePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_use_external_handler"), this->may_use_external_handler,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PluginInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PluginRegistry::Name_[] = "blink.mojom.PluginRegistry";
bool PluginRegistry::GetPlugins(bool refresh, const ::scoped_refptr<const ::blink::SecurityOrigin>& main_frame_origin, WTF::Vector<PluginInfoPtr>* out_plugins) {
  NOTREACHED();
  return false;
}
class PluginRegistry_GetPlugins_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PluginRegistry_GetPlugins_HandleSyncResponse(
      bool* result, WTF::Vector<PluginInfoPtr>* out_plugins)
      : result_(result), out_plugins_(out_plugins) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  WTF::Vector<PluginInfoPtr>* out_plugins_;DISALLOW_COPY_AND_ASSIGN(PluginRegistry_GetPlugins_HandleSyncResponse);
};

class PluginRegistry_GetPlugins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PluginRegistry_GetPlugins_ForwardToCallback(
      PluginRegistry::GetPluginsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PluginRegistry::GetPluginsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PluginRegistry_GetPlugins_ForwardToCallback);
};

PluginRegistryProxy::PluginRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool PluginRegistryProxy::GetPlugins(
    bool param_refresh, const ::scoped_refptr<const ::blink::SecurityOrigin>& param_main_frame_origin, WTF::Vector<PluginInfoPtr>* out_param_plugins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::PluginRegistry::GetPlugins", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("refresh"), param_refresh,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_frame_origin"), param_main_frame_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPluginRegistry_GetPlugins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PluginRegistry_GetPlugins_Params_Data> params(
          message);
  params.Allocate();
  params->refresh = param_refresh;
  mojo::internal::MessageFragment<
      typename decltype(params->main_frame_origin)::BaseType> main_frame_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_main_frame_origin, main_frame_origin_fragment);
  params->main_frame_origin.Set(
      main_frame_origin_fragment.is_null() ? nullptr : main_frame_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->main_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_origin in PluginRegistry.GetPlugins request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginRegistry::Name_);
  message.set_method_name("GetPlugins");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PluginRegistry_GetPlugins_HandleSyncResponse(
          &result, out_param_plugins));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::PluginRegistry::GetPlugins", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugins"), out_param_plugins,
                        "<value of type WTF::Vector<PluginInfoPtr>>");
   });
#endif
  return result;
}

void PluginRegistryProxy::GetPlugins(
    bool in_refresh, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_main_frame_origin, GetPluginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PluginRegistry::GetPlugins", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("refresh"), in_refresh,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_frame_origin"), in_main_frame_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPluginRegistry_GetPlugins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PluginRegistry_GetPlugins_Params_Data> params(
          message);
  params.Allocate();
  params->refresh = in_refresh;
  mojo::internal::MessageFragment<
      typename decltype(params->main_frame_origin)::BaseType> main_frame_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_main_frame_origin, main_frame_origin_fragment);
  params->main_frame_origin.Set(
      main_frame_origin_fragment.is_null() ? nullptr : main_frame_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->main_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_origin in PluginRegistry.GetPlugins request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginRegistry::Name_);
  message.set_method_name("GetPlugins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PluginRegistry_GetPlugins_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PluginRegistry_GetPlugins_ProxyToResponder {
 public:
  static PluginRegistry::GetPluginsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PluginRegistry_GetPlugins_ProxyToResponder> proxy(
        new PluginRegistry_GetPlugins_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PluginRegistry_GetPlugins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PluginRegistry_GetPlugins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PluginRegistry_GetPlugins_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PluginRegistry::GetPluginsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<PluginInfoPtr> in_plugins);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PluginRegistry_GetPlugins_ProxyToResponder);
};

bool PluginRegistry_GetPlugins_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PluginRegistry::GetPluginsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PluginRegistry_GetPlugins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PluginRegistry_GetPlugins_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<PluginInfoPtr> p_plugins{};
  PluginRegistry_GetPlugins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPlugins(&p_plugins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PluginRegistry::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_plugins));
  return true;
}

void PluginRegistry_GetPlugins_ProxyToResponder::Run(
    WTF::Vector<PluginInfoPtr> in_plugins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PluginRegistry::GetPluginsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugins"), in_plugins,
                        "<value of type WTF::Vector<PluginInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPluginRegistry_GetPlugins_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PluginRegistry_GetPlugins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->plugins)::BaseType>
      plugins_fragment(params.message());
  const mojo::internal::ContainerValidateParams plugins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PluginInfoDataView>>(
      in_plugins, plugins_fragment, &plugins_validate_params);
  params->plugins.Set(
      plugins_fragment.is_null() ? nullptr : plugins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugins in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PluginRegistry::GetPluginsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginRegistry::Name_);
  message.set_method_name("GetPlugins");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PluginRegistry_GetPlugins_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::PluginRegistry_GetPlugins_ResponseParams_Data* params =
      reinterpret_cast<internal::PluginRegistry_GetPlugins_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  WTF::Vector<PluginInfoPtr> p_plugins{};
  PluginRegistry_GetPlugins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPlugins(&p_plugins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PluginRegistry::Name_, 0, true);
    return false;
  }
  *out_plugins_ = std::move(p_plugins);
  *result_ = true;
  return true;
}

// static
bool PluginRegistryStubDispatch::Accept(
    PluginRegistry* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPluginRegistry_GetPlugins_Name: {
      break;
    }
  }
  return false;
}

// static
bool PluginRegistryStubDispatch::AcceptWithResponder(
    PluginRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPluginRegistry_GetPlugins_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PluginRegistry::GetPlugins",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PluginRegistry::GetPlugins");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PluginRegistry_GetPlugins_Params_Data* params =
          reinterpret_cast<
              internal::PluginRegistry_GetPlugins_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_refresh{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_main_frame_origin{};
      PluginRegistry_GetPlugins_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_refresh = input_data_view.refresh();
      if (success && !input_data_view.ReadMainFrameOrigin(&p_main_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PluginRegistry::Name_, 0, false);
        return false;
      }
      PluginRegistry::GetPluginsCallback callback =
          PluginRegistry_GetPlugins_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPlugins(
std::move(p_refresh), 
std::move(p_main_frame_origin), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPluginRegistryValidationInfo[] = {
    {&internal::PluginRegistry_GetPlugins_Params_Data::Validate,
     &internal::PluginRegistry_GetPlugins_ResponseParams_Data::Validate},
};

bool PluginRegistryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PluginRegistry::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPluginRegistryValidationInfo);
}

bool PluginRegistryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PluginRegistry::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPluginRegistryValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PluginMimeType::DataView, ::blink::mojom::blink::PluginMimeTypePtr>::Read(
    ::blink::mojom::blink::PluginMimeType::DataView input,
    ::blink::mojom::blink::PluginMimeTypePtr* output) {
  bool success = true;
  ::blink::mojom::blink::PluginMimeTypePtr result(::blink::mojom::blink::PluginMimeType::New());
  
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadFileExtensions(&result->file_extensions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PluginInfo::DataView, ::blink::mojom::blink::PluginInfoPtr>::Read(
    ::blink::mojom::blink::PluginInfo::DataView input,
    ::blink::mojom::blink::PluginInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PluginInfoPtr result(::blink::mojom::blink::PluginInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadFilename(&result->filename))
        success = false;
      if (success)
        result->background_color = input.background_color();
      if (success && !input.ReadMimeTypes(&result->mime_types))
        success = false;
      if (success)
        result->may_use_external_handler = input.may_use_external_handler();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif