// third_party/blink/public/mojom/prerender/prerender.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* PrerenderTriggerTypeToStringHelper(PrerenderTriggerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrerenderTriggerType::kLinkRelPrerender:
      return "kLinkRelPrerender";
    case PrerenderTriggerType::kLinkRelNext:
      return "kLinkRelNext";
    case PrerenderTriggerType::kSpeculationRule:
      return "kSpeculationRule";
    default:
      return nullptr;
  }
}

std::string PrerenderTriggerTypeToString(PrerenderTriggerType value) {
  const char *str = PrerenderTriggerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrerenderTriggerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrerenderTriggerType value) {
  return os << PrerenderTriggerTypeToString(value);
}

namespace internal {


// static
bool PrerenderAttributes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrerenderAttributes_Data* object = static_cast<const PrerenderAttributes_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::blink::mojom::internal::PrerenderTriggerType_Data
        ::Validate(object->trigger_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_size, validation_context))
    return false;

  return true;
}

PrerenderAttributes_Data::PrerenderAttributes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NoStatePrefetchProcessor_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NoStatePrefetchProcessor_Start_Params_Data* object = static_cast<const NoStatePrefetchProcessor_Start_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prerender_attribute, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->prerender_attribute, validation_context))
    return false;

  return true;
}

NoStatePrefetchProcessor_Start_Params_Data::NoStatePrefetchProcessor_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NoStatePrefetchProcessor_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NoStatePrefetchProcessor_Cancel_Params_Data* object = static_cast<const NoStatePrefetchProcessor_Cancel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NoStatePrefetchProcessor_Cancel_Params_Data::NoStatePrefetchProcessor_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PrerenderTriggerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PrerenderTriggerType value) {
  return std::move(context).WriteString(::blink::mojom::PrerenderTriggerTypeToString(value));
}

} // namespace perfetto
