// third_party/blink/public/mojom/presentation/presentation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/presentation/presentation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-params-data.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/presentation/presentation.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRESENTATION_PRESENTATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
PresentationInfo::PresentationInfo()
    : url(),
      id() {}

PresentationInfo::PresentationInfo(
    const ::blink::KURL& url_in,
    const WTF::String& id_in)
    : url(std::move(url_in)),
      id(std::move(id_in)) {}

PresentationInfo::~PresentationInfo() = default;

void PresentationInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PresentationInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PresentationError::PresentationError()
    : error_type(),
      message() {}

PresentationError::PresentationError(
    PresentationErrorType error_type_in,
    const WTF::String& message_in)
    : error_type(std::move(error_type_in)),
      message(std::move(message_in)) {}

PresentationError::~PresentationError() = default;
size_t PresentationError::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->error_type);
  seed = mojo::internal::WTFHash(seed, this->message);
  return seed;
}

void PresentationError::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_type"), this->error_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PresentationErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PresentationError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PresentationConnectionResult::PresentationConnectionResult()
    : presentation_info(),
      connection_remote(),
      connection_receiver() {}

PresentationConnectionResult::PresentationConnectionResult(
    PresentationInfoPtr presentation_info_in,
    ::mojo::PendingRemote<PresentationConnection> connection_remote_in,
    ::mojo::PendingReceiver<PresentationConnection> connection_receiver_in)
    : presentation_info(std::move(presentation_info_in)),
      connection_remote(std::move(connection_remote_in)),
      connection_receiver(std::move(connection_receiver_in)) {}

PresentationConnectionResult::~PresentationConnectionResult() = default;

void PresentationConnectionResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presentation_info"), this->presentation_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PresentationInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_remote"), this->connection_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<PresentationConnection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_receiver"), this->connection_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<PresentationConnection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PresentationConnectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PresentationConnectionMessage::PresentationConnectionMessage() : tag_(Tag::MESSAGE) {
  data_.message = new WTF::String;
}

PresentationConnectionMessage::~PresentationConnectionMessage() {
  DestroyActive();
}


void PresentationConnectionMessage::set_message(
    const WTF::String& message) {
  if (tag_ == Tag::MESSAGE) {
    *(data_.message) = std::move(message);
  } else {
    DestroyActive();
    tag_ = Tag::MESSAGE;
    data_.message = new WTF::String(
        std::move(message));
  }
}
void PresentationConnectionMessage::set_data(
    WTF::Vector<uint8_t> data) {
  if (tag_ == Tag::DATA) {
    *(data_.data) = std::move(data);
  } else {
    DestroyActive();
    tag_ = Tag::DATA;
    data_.data = new WTF::Vector<uint8_t>(
        std::move(data));
  }
}

void PresentationConnectionMessage::DestroyActive() {
  switch (tag_) {

    case Tag::MESSAGE:

      delete data_.message;
      break;
    case Tag::DATA:

      delete data_.data;
      break;
  }
}

bool PresentationConnectionMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char PresentationConnection::Name_[] = "blink.mojom.PresentationConnection";

PresentationConnectionProxy::PresentationConnectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationConnectionProxy::OnMessage(
    PresentationConnectionMessagePtr in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationConnection::OnMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type PresentationConnectionMessagePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationConnection_OnMessage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationConnection_OnMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->message)>
      message_fragment(params.message());
  message_fragment.Claim(&params->message);
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionMessageDataView>(
      in_message, message_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in PresentationConnection.OnMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationConnection::Name_);
  message.set_method_name("OnMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationConnectionProxy::DidChangeState(
    PresentationConnectionState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationConnection::DidChangeState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type PresentationConnectionState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationConnection_DidChangeState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationConnection_DidChangeState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationConnection::Name_);
  message.set_method_name("DidChangeState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationConnectionProxy::DidClose(
    PresentationConnectionCloseReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationConnection::DidClose", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type PresentationConnectionCloseReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationConnection_DidClose_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationConnection_DidClose_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionCloseReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationConnection::Name_);
  message.set_method_name("DidClose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PresentationConnectionStubDispatch::Accept(
    PresentationConnection* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPresentationConnection_OnMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationConnection::OnMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationConnection::OnMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationConnection_OnMessage_Params_Data* params =
          reinterpret_cast<internal::PresentationConnection_OnMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PresentationConnectionMessagePtr p_message{};
      PresentationConnection_OnMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationConnection::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMessage(
std::move(p_message));
      return true;
    }
    case internal::kPresentationConnection_DidChangeState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationConnection::DidChangeState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationConnection::DidChangeState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationConnection_DidChangeState_Params_Data* params =
          reinterpret_cast<internal::PresentationConnection_DidChangeState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PresentationConnectionState p_state{};
      PresentationConnection_DidChangeState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationConnection::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeState(
std::move(p_state));
      return true;
    }
    case internal::kPresentationConnection_DidClose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationConnection::DidClose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationConnection::DidClose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationConnection_DidClose_Params_Data* params =
          reinterpret_cast<internal::PresentationConnection_DidClose_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PresentationConnectionCloseReason p_reason{};
      PresentationConnection_DidClose_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationConnection::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidClose(
std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool PresentationConnectionStubDispatch::AcceptWithResponder(
    PresentationConnection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPresentationConnection_OnMessage_Name: {
      break;
    }
    case internal::kPresentationConnection_DidChangeState_Name: {
      break;
    }
    case internal::kPresentationConnection_DidClose_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPresentationConnectionValidationInfo[] = {
    {&internal::PresentationConnection_OnMessage_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationConnection_DidChangeState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationConnection_DidClose_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationConnectionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PresentationConnection::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPresentationConnectionValidationInfo);
}

const char PresentationService::Name_[] = "blink.mojom.PresentationService";

class PresentationService_StartPresentation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PresentationService_StartPresentation_ForwardToCallback(
      PresentationService::StartPresentationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PresentationService::StartPresentationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PresentationService_StartPresentation_ForwardToCallback);
};

class PresentationService_ReconnectPresentation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PresentationService_ReconnectPresentation_ForwardToCallback(
      PresentationService::ReconnectPresentationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PresentationService::ReconnectPresentationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PresentationService_ReconnectPresentation_ForwardToCallback);
};

PresentationServiceProxy::PresentationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationServiceProxy::SetController(
    ::mojo::PendingRemote<PresentationController> in_controller) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::SetController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller"), in_controller,
                        "<value of type ::mojo::PendingRemote<PresentationController>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_SetController_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_SetController_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationControllerInterfaceBase>>(
      in_controller, &params->controller, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->controller),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid controller in PresentationService.SetController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("SetController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationServiceProxy::SetReceiver(
    ::mojo::PendingRemote<PresentationReceiver> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::SetReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingRemote<PresentationReceiver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_SetReceiver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_SetReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationReceiverInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in PresentationService.SetReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("SetReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationServiceProxy::SetDefaultPresentationUrls(
    const WTF::Vector<::blink::KURL>& in_presentation_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::SetDefaultPresentationUrls", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_urls"), in_presentation_urls,
                        "<value of type const WTF::Vector<::blink::KURL>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_SetDefaultPresentationUrls_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_SetDefaultPresentationUrls_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_urls)::BaseType>
      presentation_urls_fragment(params.message());
  const mojo::internal::ContainerValidateParams presentation_urls_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_presentation_urls, presentation_urls_fragment, &presentation_urls_validate_params);
  params->presentation_urls.Set(
      presentation_urls_fragment.is_null() ? nullptr : presentation_urls_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_urls.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_urls in PresentationService.SetDefaultPresentationUrls request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("SetDefaultPresentationUrls");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationServiceProxy::ListenForScreenAvailability(
    const ::blink::KURL& in_availability_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::ListenForScreenAvailability", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("availability_url"), in_availability_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_ListenForScreenAvailability_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_ListenForScreenAvailability_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->availability_url)::BaseType> availability_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_availability_url, availability_url_fragment);
  params->availability_url.Set(
      availability_url_fragment.is_null() ? nullptr : availability_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->availability_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null availability_url in PresentationService.ListenForScreenAvailability request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("ListenForScreenAvailability");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationServiceProxy::StopListeningForScreenAvailability(
    const ::blink::KURL& in_availability_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::StopListeningForScreenAvailability", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("availability_url"), in_availability_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_StopListeningForScreenAvailability_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_StopListeningForScreenAvailability_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->availability_url)::BaseType> availability_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_availability_url, availability_url_fragment);
  params->availability_url.Set(
      availability_url_fragment.is_null() ? nullptr : availability_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->availability_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null availability_url in PresentationService.StopListeningForScreenAvailability request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("StopListeningForScreenAvailability");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationServiceProxy::StartPresentation(
    const WTF::Vector<::blink::KURL>& in_presentation_urls, StartPresentationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::StartPresentation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_urls"), in_presentation_urls,
                        "<value of type const WTF::Vector<::blink::KURL>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_StartPresentation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_StartPresentation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_urls)::BaseType>
      presentation_urls_fragment(params.message());
  const mojo::internal::ContainerValidateParams presentation_urls_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_presentation_urls, presentation_urls_fragment, &presentation_urls_validate_params);
  params->presentation_urls.Set(
      presentation_urls_fragment.is_null() ? nullptr : presentation_urls_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_urls.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_urls in PresentationService.StartPresentation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("StartPresentation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PresentationService_StartPresentation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PresentationServiceProxy::ReconnectPresentation(
    const WTF::Vector<::blink::KURL>& in_presentation_urls, const WTF::String& in_presentation_id, ReconnectPresentationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::ReconnectPresentation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_urls"), in_presentation_urls,
                        "<value of type const WTF::Vector<::blink::KURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_id"), in_presentation_id,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_ReconnectPresentation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_ReconnectPresentation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_urls)::BaseType>
      presentation_urls_fragment(params.message());
  const mojo::internal::ContainerValidateParams presentation_urls_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_presentation_urls, presentation_urls_fragment, &presentation_urls_validate_params);
  params->presentation_urls.Set(
      presentation_urls_fragment.is_null() ? nullptr : presentation_urls_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_urls.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_urls in PresentationService.ReconnectPresentation request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_id)::BaseType> presentation_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_presentation_id, presentation_id_fragment);
  params->presentation_id.Set(
      presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_id in PresentationService.ReconnectPresentation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("ReconnectPresentation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PresentationService_ReconnectPresentation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PresentationServiceProxy::CloseConnection(
    const ::blink::KURL& in_presentation_url, const WTF::String& in_presentation_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::CloseConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_url"), in_presentation_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_id"), in_presentation_id,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_CloseConnection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_CloseConnection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_url)::BaseType> presentation_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_presentation_url, presentation_url_fragment);
  params->presentation_url.Set(
      presentation_url_fragment.is_null() ? nullptr : presentation_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_url in PresentationService.CloseConnection request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_id)::BaseType> presentation_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_presentation_id, presentation_id_fragment);
  params->presentation_id.Set(
      presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_id in PresentationService.CloseConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("CloseConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationServiceProxy::Terminate(
    const ::blink::KURL& in_presentation_url, const WTF::String& in_presentation_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationService::Terminate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_url"), in_presentation_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_id"), in_presentation_id,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_Terminate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_Terminate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_url)::BaseType> presentation_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_presentation_url, presentation_url_fragment);
  params->presentation_url.Set(
      presentation_url_fragment.is_null() ? nullptr : presentation_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_url in PresentationService.Terminate request");
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_id)::BaseType> presentation_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_presentation_id, presentation_id_fragment);
  params->presentation_id.Set(
      presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_id in PresentationService.Terminate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("Terminate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class PresentationService_StartPresentation_ProxyToResponder {
 public:
  static PresentationService::StartPresentationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PresentationService_StartPresentation_ProxyToResponder> proxy(
        new PresentationService_StartPresentation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PresentationService_StartPresentation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PresentationService_StartPresentation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PresentationService_StartPresentation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PresentationService::StartPresentationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PresentationService_StartPresentation_ProxyToResponder);
};

bool PresentationService_StartPresentation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PresentationService::StartPresentationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PresentationService_StartPresentation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PresentationService_StartPresentation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PresentationConnectionResultPtr p_result{};
  PresentationErrorPtr p_error{};
  PresentationService_StartPresentation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PresentationService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  return true;
}

void PresentationService_StartPresentation_ProxyToResponder::Run(
    PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PresentationService::StartPresentationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PresentationConnectionResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type PresentationErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_StartPresentation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_StartPresentation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PresentationService::StartPresentationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("StartPresentation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PresentationService_ReconnectPresentation_ProxyToResponder {
 public:
  static PresentationService::ReconnectPresentationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PresentationService_ReconnectPresentation_ProxyToResponder> proxy(
        new PresentationService_ReconnectPresentation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PresentationService_ReconnectPresentation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PresentationService_ReconnectPresentation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PresentationService_ReconnectPresentation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PresentationService::ReconnectPresentationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PresentationService_ReconnectPresentation_ProxyToResponder);
};

bool PresentationService_ReconnectPresentation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PresentationService::ReconnectPresentationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PresentationService_ReconnectPresentation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PresentationService_ReconnectPresentation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PresentationConnectionResultPtr p_result{};
  PresentationErrorPtr p_error{};
  PresentationService_ReconnectPresentation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PresentationService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  return true;
}

void PresentationService_ReconnectPresentation_ProxyToResponder::Run(
    PresentationConnectionResultPtr in_result, PresentationErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PresentationService::ReconnectPresentationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PresentationConnectionResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type PresentationErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationService_ReconnectPresentation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationService_ReconnectPresentation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PresentationService::ReconnectPresentationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationService::Name_);
  message.set_method_name("ReconnectPresentation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PresentationServiceStubDispatch::Accept(
    PresentationService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPresentationService_SetController_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::SetController",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::SetController");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationService_SetController_Params_Data* params =
          reinterpret_cast<internal::PresentationService_SetController_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<PresentationController> p_controller{};
      PresentationService_SetController_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_controller =
            input_data_view.TakeController<decltype(p_controller)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetController(
std::move(p_controller));
      return true;
    }
    case internal::kPresentationService_SetReceiver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::SetReceiver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::SetReceiver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationService_SetReceiver_Params_Data* params =
          reinterpret_cast<internal::PresentationService_SetReceiver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<PresentationReceiver> p_receiver{};
      PresentationService_SetReceiver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReceiver(
std::move(p_receiver));
      return true;
    }
    case internal::kPresentationService_SetDefaultPresentationUrls_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::SetDefaultPresentationUrls",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::SetDefaultPresentationUrls");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationService_SetDefaultPresentationUrls_Params_Data* params =
          reinterpret_cast<internal::PresentationService_SetDefaultPresentationUrls_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::blink::KURL> p_presentation_urls{};
      PresentationService_SetDefaultPresentationUrls_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrls(&p_presentation_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDefaultPresentationUrls(
std::move(p_presentation_urls));
      return true;
    }
    case internal::kPresentationService_ListenForScreenAvailability_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::ListenForScreenAvailability",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::ListenForScreenAvailability");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationService_ListenForScreenAvailability_Params_Data* params =
          reinterpret_cast<internal::PresentationService_ListenForScreenAvailability_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_availability_url{};
      PresentationService_ListenForScreenAvailability_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAvailabilityUrl(&p_availability_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListenForScreenAvailability(
std::move(p_availability_url));
      return true;
    }
    case internal::kPresentationService_StopListeningForScreenAvailability_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::StopListeningForScreenAvailability",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::StopListeningForScreenAvailability");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationService_StopListeningForScreenAvailability_Params_Data* params =
          reinterpret_cast<internal::PresentationService_StopListeningForScreenAvailability_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_availability_url{};
      PresentationService_StopListeningForScreenAvailability_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAvailabilityUrl(&p_availability_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopListeningForScreenAvailability(
std::move(p_availability_url));
      return true;
    }
    case internal::kPresentationService_StartPresentation_Name: {
      break;
    }
    case internal::kPresentationService_ReconnectPresentation_Name: {
      break;
    }
    case internal::kPresentationService_CloseConnection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::CloseConnection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::CloseConnection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationService_CloseConnection_Params_Data* params =
          reinterpret_cast<internal::PresentationService_CloseConnection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_presentation_url{};
      WTF::String p_presentation_id{};
      PresentationService_CloseConnection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrl(&p_presentation_url))
        success = false;
      if (success && !input_data_view.ReadPresentationId(&p_presentation_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseConnection(
std::move(p_presentation_url), 
std::move(p_presentation_id));
      return true;
    }
    case internal::kPresentationService_Terminate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::Terminate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::Terminate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationService_Terminate_Params_Data* params =
          reinterpret_cast<internal::PresentationService_Terminate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_presentation_url{};
      WTF::String p_presentation_id{};
      PresentationService_Terminate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrl(&p_presentation_url))
        success = false;
      if (success && !input_data_view.ReadPresentationId(&p_presentation_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Terminate(
std::move(p_presentation_url), 
std::move(p_presentation_id));
      return true;
    }
  }
  return false;
}

// static
bool PresentationServiceStubDispatch::AcceptWithResponder(
    PresentationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPresentationService_SetController_Name: {
      break;
    }
    case internal::kPresentationService_SetReceiver_Name: {
      break;
    }
    case internal::kPresentationService_SetDefaultPresentationUrls_Name: {
      break;
    }
    case internal::kPresentationService_ListenForScreenAvailability_Name: {
      break;
    }
    case internal::kPresentationService_StopListeningForScreenAvailability_Name: {
      break;
    }
    case internal::kPresentationService_StartPresentation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::StartPresentation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::StartPresentation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PresentationService_StartPresentation_Params_Data* params =
          reinterpret_cast<
              internal::PresentationService_StartPresentation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::blink::KURL> p_presentation_urls{};
      PresentationService_StartPresentation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrls(&p_presentation_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 5, false);
        return false;
      }
      PresentationService::StartPresentationCallback callback =
          PresentationService_StartPresentation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPresentation(
std::move(p_presentation_urls), std::move(callback));
      return true;
    }
    case internal::kPresentationService_ReconnectPresentation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationService::ReconnectPresentation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationService::ReconnectPresentation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PresentationService_ReconnectPresentation_Params_Data* params =
          reinterpret_cast<
              internal::PresentationService_ReconnectPresentation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::blink::KURL> p_presentation_urls{};
      WTF::String p_presentation_id{};
      PresentationService_ReconnectPresentation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationUrls(&p_presentation_urls))
        success = false;
      if (success && !input_data_view.ReadPresentationId(&p_presentation_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationService::Name_, 6, false);
        return false;
      }
      PresentationService::ReconnectPresentationCallback callback =
          PresentationService_ReconnectPresentation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReconnectPresentation(
std::move(p_presentation_urls), 
std::move(p_presentation_id), std::move(callback));
      return true;
    }
    case internal::kPresentationService_CloseConnection_Name: {
      break;
    }
    case internal::kPresentationService_Terminate_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPresentationServiceValidationInfo[] = {
    {&internal::PresentationService_SetController_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationService_SetReceiver_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationService_SetDefaultPresentationUrls_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationService_ListenForScreenAvailability_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationService_StopListeningForScreenAvailability_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationService_StartPresentation_Params_Data::Validate,
     &internal::PresentationService_StartPresentation_ResponseParams_Data::Validate},
    {&internal::PresentationService_ReconnectPresentation_Params_Data::Validate,
     &internal::PresentationService_ReconnectPresentation_ResponseParams_Data::Validate},
    {&internal::PresentationService_CloseConnection_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationService_Terminate_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PresentationService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPresentationServiceValidationInfo);
}

bool PresentationServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PresentationService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPresentationServiceValidationInfo);
}
const char PresentationController::Name_[] = "blink.mojom.PresentationController";

PresentationControllerProxy::PresentationControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationControllerProxy::OnScreenAvailabilityUpdated(
    const ::blink::KURL& in_url, ScreenAvailability in_availability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationController::OnScreenAvailabilityUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("availability"), in_availability,
                        "<value of type ScreenAvailability>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationController_OnScreenAvailabilityUpdated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PresentationController.OnScreenAvailabilityUpdated request");
  mojo::internal::Serialize<::blink::mojom::ScreenAvailability>(
      in_availability, &params->availability);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnScreenAvailabilityUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationControllerProxy::OnDefaultPresentationStarted(
    PresentationConnectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationController::OnDefaultPresentationStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PresentationConnectionResultPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationController_OnDefaultPresentationStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnDefaultPresentationStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in PresentationController.OnDefaultPresentationStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnDefaultPresentationStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationControllerProxy::OnConnectionStateChanged(
    PresentationInfoPtr in_presentation_info, PresentationConnectionState in_newState) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationController::OnConnectionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_info"), in_presentation_info,
                        "<value of type PresentationInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("newState"), in_newState,
                        "<value of type PresentationConnectionState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationController_OnConnectionStateChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnConnectionStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_info)::BaseType> presentation_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationInfoDataView>(
      in_presentation_info, presentation_info_fragment);
  params->presentation_info.Set(
      presentation_info_fragment.is_null() ? nullptr : presentation_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_info in PresentationController.OnConnectionStateChanged request");
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionState>(
      in_newState, &params->newState);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnConnectionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PresentationControllerProxy::OnConnectionClosed(
    PresentationInfoPtr in_presentation_info, PresentationConnectionCloseReason in_reason, const WTF::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationController::OnConnectionClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("presentation_info"), in_presentation_info,
                        "<value of type PresentationInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type PresentationConnectionCloseReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationController_OnConnectionClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationController_OnConnectionClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->presentation_info)::BaseType> presentation_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationInfoDataView>(
      in_presentation_info, presentation_info_fragment);
  params->presentation_info.Set(
      presentation_info_fragment.is_null() ? nullptr : presentation_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->presentation_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_info in PresentationController.OnConnectionClosed request");
  mojo::internal::Serialize<::blink::mojom::PresentationConnectionCloseReason>(
      in_reason, &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in PresentationController.OnConnectionClosed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationController::Name_);
  message.set_method_name("OnConnectionClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PresentationControllerStubDispatch::Accept(
    PresentationController* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPresentationController_OnScreenAvailabilityUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationController::OnScreenAvailabilityUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationController::OnScreenAvailabilityUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      ScreenAvailability p_availability{};
      PresentationController_OnScreenAvailabilityUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadAvailability(&p_availability))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScreenAvailabilityUpdated(
std::move(p_url), 
std::move(p_availability));
      return true;
    }
    case internal::kPresentationController_OnDefaultPresentationStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationController::OnDefaultPresentationStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationController::OnDefaultPresentationStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationController_OnDefaultPresentationStarted_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnDefaultPresentationStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PresentationConnectionResultPtr p_result{};
      PresentationController_OnDefaultPresentationStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDefaultPresentationStarted(
std::move(p_result));
      return true;
    }
    case internal::kPresentationController_OnConnectionStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationController::OnConnectionStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationController::OnConnectionStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationController_OnConnectionStateChanged_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnConnectionStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PresentationInfoPtr p_presentation_info{};
      PresentationConnectionState p_newState{};
      PresentationController_OnConnectionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationInfo(&p_presentation_info))
        success = false;
      if (success && !input_data_view.ReadNewState(&p_newState))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionStateChanged(
std::move(p_presentation_info), 
std::move(p_newState));
      return true;
    }
    case internal::kPresentationController_OnConnectionClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationController::OnConnectionClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationController::OnConnectionClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationController_OnConnectionClosed_Params_Data* params =
          reinterpret_cast<internal::PresentationController_OnConnectionClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PresentationInfoPtr p_presentation_info{};
      PresentationConnectionCloseReason p_reason{};
      WTF::String p_message{};
      PresentationController_OnConnectionClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPresentationInfo(&p_presentation_info))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationController::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionClosed(
std::move(p_presentation_info), 
std::move(p_reason), 
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool PresentationControllerStubDispatch::AcceptWithResponder(
    PresentationController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPresentationController_OnScreenAvailabilityUpdated_Name: {
      break;
    }
    case internal::kPresentationController_OnDefaultPresentationStarted_Name: {
      break;
    }
    case internal::kPresentationController_OnConnectionStateChanged_Name: {
      break;
    }
    case internal::kPresentationController_OnConnectionClosed_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPresentationControllerValidationInfo[] = {
    {&internal::PresentationController_OnScreenAvailabilityUpdated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationController_OnDefaultPresentationStarted_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationController_OnConnectionStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PresentationController_OnConnectionClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PresentationController::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPresentationControllerValidationInfo);
}

const char PresentationReceiver::Name_[] = "blink.mojom.PresentationReceiver";

PresentationReceiverProxy::PresentationReceiverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PresentationReceiverProxy::OnReceiverConnectionAvailable(
    PresentationInfoPtr in_info, ::mojo::PendingRemote<PresentationConnection> in_controller_connection, ::mojo::PendingReceiver<PresentationConnection> in_receiver_connection_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PresentationReceiver::OnReceiverConnectionAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type PresentationInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_connection"), in_controller_connection,
                        "<value of type ::mojo::PendingRemote<PresentationConnection>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver_connection_receiver"), in_receiver_connection_receiver,
                        "<value of type ::mojo::PendingReceiver<PresentationConnection>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPresentationReceiver_OnReceiverConnectionAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PresentationInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in PresentationReceiver.OnReceiverConnectionAvailable request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
      in_controller_connection, &params->controller_connection, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->controller_connection),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid controller_connection in PresentationReceiver.OnReceiverConnectionAvailable request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
      in_receiver_connection_receiver, &params->receiver_connection_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver_connection_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver_connection_receiver in PresentationReceiver.OnReceiverConnectionAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PresentationReceiver::Name_);
  message.set_method_name("OnReceiverConnectionAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PresentationReceiverStubDispatch::Accept(
    PresentationReceiver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPresentationReceiver_OnReceiverConnectionAvailable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PresentationReceiver::OnReceiverConnectionAvailable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PresentationReceiver::OnReceiverConnectionAvailable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data* params =
          reinterpret_cast<internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PresentationInfoPtr p_info{};
      ::mojo::PendingRemote<PresentationConnection> p_controller_connection{};
      ::mojo::PendingReceiver<PresentationConnection> p_receiver_connection_receiver{};
      PresentationReceiver_OnReceiverConnectionAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success) {
        p_controller_connection =
            input_data_view.TakeControllerConnection<decltype(p_controller_connection)>();
      }
      if (success) {
        p_receiver_connection_receiver =
            input_data_view.TakeReceiverConnectionReceiver<decltype(p_receiver_connection_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PresentationReceiver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiverConnectionAvailable(
std::move(p_info), 
std::move(p_controller_connection), 
std::move(p_receiver_connection_receiver));
      return true;
    }
  }
  return false;
}

// static
bool PresentationReceiverStubDispatch::AcceptWithResponder(
    PresentationReceiver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPresentationReceiver_OnReceiverConnectionAvailable_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPresentationReceiverValidationInfo[] = {
    {&internal::PresentationReceiver_OnReceiverConnectionAvailable_Params_Data::Validate,
     nullptr /* no response */},
};

bool PresentationReceiverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PresentationReceiver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPresentationReceiverValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PresentationInfo::DataView, ::blink::mojom::blink::PresentationInfoPtr>::Read(
    ::blink::mojom::blink::PresentationInfo::DataView input,
    ::blink::mojom::blink::PresentationInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PresentationInfoPtr result(::blink::mojom::blink::PresentationInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PresentationError::DataView, ::blink::mojom::blink::PresentationErrorPtr>::Read(
    ::blink::mojom::blink::PresentationError::DataView input,
    ::blink::mojom::blink::PresentationErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PresentationErrorPtr result(::blink::mojom::blink::PresentationError::New());
  
      if (success && !input.ReadErrorType(&result->error_type))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PresentationConnectionResult::DataView, ::blink::mojom::blink::PresentationConnectionResultPtr>::Read(
    ::blink::mojom::blink::PresentationConnectionResult::DataView input,
    ::blink::mojom::blink::PresentationConnectionResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PresentationConnectionResultPtr result(::blink::mojom::blink::PresentationConnectionResult::New());
  
      if (success && !input.ReadPresentationInfo(&result->presentation_info))
        success = false;
      if (success) {
        result->connection_remote =
            input.TakeConnectionRemote<decltype(result->connection_remote)>();
      }
      if (success) {
        result->connection_receiver =
            input.TakeConnectionReceiver<decltype(result->connection_receiver)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::PresentationConnectionMessage::DataView, ::blink::mojom::blink::PresentationConnectionMessagePtr>::Read(
    ::blink::mojom::blink::PresentationConnectionMessage::DataView input,
    ::blink::mojom::blink::PresentationConnectionMessagePtr* output) {
  using UnionType = ::blink::mojom::blink::PresentationConnectionMessage;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::MESSAGE: {
      WTF::String result_message;
      if (!input.ReadMessage(&result_message))
        return false;

      *output = UnionType::NewMessage(
          std::move(result_message));
      break;
    }
    case Tag::DATA: {
      WTF::Vector<uint8_t> result_data;
      if (!input.ReadData(&result_data))
        return false;

      *output = UnionType::NewData(
          std::move(result_data));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif