// third_party/blink/public/mojom/speech/speech_recognition_error.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/speech/speech_recognition_error.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/speech/speech_recognition_error.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* SpeechAudioErrorDetailsToStringHelper(SpeechAudioErrorDetails value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeechAudioErrorDetails::kNone:
      return "kNone";
    case SpeechAudioErrorDetails::kNoMic:
      return "kNoMic";
    default:
      return nullptr;
  }
}

std::string SpeechAudioErrorDetailsToString(SpeechAudioErrorDetails value) {
  const char *str = SpeechAudioErrorDetailsToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeechAudioErrorDetails value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeechAudioErrorDetails value) {
  return os << SpeechAudioErrorDetailsToString(value);
}

namespace internal {


// static
bool SpeechRecognitionError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionError_Data* object = static_cast<const SpeechRecognitionError_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::SpeechRecognitionErrorCode_Data
        ::Validate(object->code, validation_context))
    return false;


  if (!::blink::mojom::internal::SpeechAudioErrorDetails_Data
        ::Validate(object->details, validation_context))
    return false;

  return true;
}

SpeechRecognitionError_Data::SpeechRecognitionError_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SpeechAudioErrorDetails>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SpeechAudioErrorDetails value) {
  return std::move(context).WriteString(::blink::mojom::SpeechAudioErrorDetailsToString(value));
}

} // namespace perfetto
