// third_party/blink/public/mojom/timing/resource_timing.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/timing/resource_timing.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-params-data.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ServerTimingInfo::ServerTimingInfo()
    : name(),
      duration(),
      description() {}

ServerTimingInfo::ServerTimingInfo(
    const std::string& name_in,
    double duration_in,
    const std::string& description_in)
    : name(std::move(name_in)),
      duration(std::move(duration_in)),
      description(std::move(description_in)) {}

ServerTimingInfo::~ServerTimingInfo() = default;
size_t ServerTimingInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->duration);
  seed = mojo::internal::Hash(seed, this->description);
  return seed;
}

void ServerTimingInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServerTimingInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResourceTimingInfo::ResourceTimingInfo()
    : name(),
      start_time(),
      alpn_negotiated_protocol(),
      connection_info(),
      timing(),
      last_redirect_end_time(),
      response_end(),
      context_type(),
      request_destination(),
      cache_state(),
      encoded_body_size(),
      decoded_body_size(),
      did_reuse_connection(),
      is_secure_transport(),
      allow_timing_details(),
      allow_redirect_details(),
      allow_negative_values(),
      server_timing() {}

ResourceTimingInfo::ResourceTimingInfo(
    const std::string& name_in,
    ::base::TimeTicks start_time_in,
    const std::string& alpn_negotiated_protocol_in,
    const std::string& connection_info_in,
    const absl::optional<::net::LoadTimingInfo>& timing_in,
    ::base::TimeTicks last_redirect_end_time_in,
    ::base::TimeTicks response_end_in,
    ::blink::mojom::RequestContextType context_type_in,
    ::network::mojom::RequestDestination request_destination_in,
    CacheState cache_state_in,
    uint64_t encoded_body_size_in,
    uint64_t decoded_body_size_in,
    bool did_reuse_connection_in,
    bool is_secure_transport_in,
    bool allow_timing_details_in,
    bool allow_redirect_details_in,
    bool allow_negative_values_in,
    std::vector<ServerTimingInfoPtr> server_timing_in)
    : name(std::move(name_in)),
      start_time(std::move(start_time_in)),
      alpn_negotiated_protocol(std::move(alpn_negotiated_protocol_in)),
      connection_info(std::move(connection_info_in)),
      timing(std::move(timing_in)),
      last_redirect_end_time(std::move(last_redirect_end_time_in)),
      response_end(std::move(response_end_in)),
      context_type(std::move(context_type_in)),
      request_destination(std::move(request_destination_in)),
      cache_state(std::move(cache_state_in)),
      encoded_body_size(std::move(encoded_body_size_in)),
      decoded_body_size(std::move(decoded_body_size_in)),
      did_reuse_connection(std::move(did_reuse_connection_in)),
      is_secure_transport(std::move(is_secure_transport_in)),
      allow_timing_details(std::move(allow_timing_details_in)),
      allow_redirect_details(std::move(allow_redirect_details_in)),
      allow_negative_values(std::move(allow_negative_values_in)),
      server_timing(std::move(server_timing_in)) {}

ResourceTimingInfo::~ResourceTimingInfo() = default;

void ResourceTimingInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpn_negotiated_protocol"), this->alpn_negotiated_protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_info"), this->connection_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing"), this->timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::net::LoadTimingInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_redirect_end_time"), this->last_redirect_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_end"), this->response_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_type"), this->context_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::RequestContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_destination"), this->request_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RequestDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_state"), this->cache_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CacheState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_body_size"), this->encoded_body_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoded_body_size"), this->decoded_body_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "did_reuse_connection"), this->did_reuse_connection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_secure_transport"), this->is_secure_transport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_timing_details"), this->allow_timing_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_redirect_details"), this->allow_redirect_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_negative_values"), this->allow_negative_values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_timing"), this->server_timing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ServerTimingInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResourceTimingInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ServerTimingInfo::DataView, ::blink::mojom::ServerTimingInfoPtr>::Read(
    ::blink::mojom::ServerTimingInfo::DataView input,
    ::blink::mojom::ServerTimingInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ServerTimingInfoPtr result(::blink::mojom::ServerTimingInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->duration = input.duration();
      if (success && !input.ReadDescription(&result->description))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ResourceTimingInfo::DataView, ::blink::mojom::ResourceTimingInfoPtr>::Read(
    ::blink::mojom::ResourceTimingInfo::DataView input,
    ::blink::mojom::ResourceTimingInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ResourceTimingInfoPtr result(::blink::mojom::ResourceTimingInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
      if (success && !input.ReadAlpnNegotiatedProtocol(&result->alpn_negotiated_protocol))
        success = false;
      if (success && !input.ReadConnectionInfo(&result->connection_info))
        success = false;
      if (success && !input.ReadTiming(&result->timing))
        success = false;
      if (success && !input.ReadLastRedirectEndTime(&result->last_redirect_end_time))
        success = false;
      if (success && !input.ReadResponseEnd(&result->response_end))
        success = false;
      if (success && !input.ReadContextType(&result->context_type))
        success = false;
      if (success && !input.ReadRequestDestination(&result->request_destination))
        success = false;
      if (success && !input.ReadCacheState(&result->cache_state))
        success = false;
      if (success)
        result->encoded_body_size = input.encoded_body_size();
      if (success)
        result->decoded_body_size = input.decoded_body_size();
      if (success)
        result->did_reuse_connection = input.did_reuse_connection();
      if (success)
        result->is_secure_transport = input.is_secure_transport();
      if (success)
        result->allow_timing_details = input.allow_timing_details();
      if (success)
        result->allow_redirect_details = input.allow_redirect_details();
      if (success)
        result->allow_negative_values = input.allow_negative_values();
      if (success && !input.ReadServerTiming(&result->server_timing))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif