// third_party/blink/public/mojom/timing/worker_timing_container.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/timing/worker_timing_container.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/timing/worker_timing_container.mojom-params-data.h"
#include "third_party/blink/public/mojom/timing/worker_timing_container.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/timing/worker_timing_container.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_WORKER_TIMING_CONTAINER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_WORKER_TIMING_CONTAINER_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char WorkerTimingContainer::Name_[] = "blink.mojom.WorkerTimingContainer";

WorkerTimingContainerProxy::WorkerTimingContainerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WorkerTimingContainerProxy::AddPerformanceEntry(
    ::blink::mojom::blink::PerformanceMarkOrMeasurePtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WorkerTimingContainer::AddPerformanceEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type ::blink::mojom::blink::PerformanceMarkOrMeasurePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWorkerTimingContainer_AddPerformanceEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WorkerTimingContainer_AddPerformanceEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entry)::BaseType> entry_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PerformanceMarkOrMeasureDataView>(
      in_entry, entry_fragment);
  params->entry.Set(
      entry_fragment.is_null() ? nullptr : entry_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entry in WorkerTimingContainer.AddPerformanceEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WorkerTimingContainer::Name_);
  message.set_method_name("AddPerformanceEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WorkerTimingContainerStubDispatch::Accept(
    WorkerTimingContainer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWorkerTimingContainer_AddPerformanceEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WorkerTimingContainer::AddPerformanceEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WorkerTimingContainer::AddPerformanceEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WorkerTimingContainer_AddPerformanceEntry_Params_Data* params =
          reinterpret_cast<internal::WorkerTimingContainer_AddPerformanceEntry_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::PerformanceMarkOrMeasurePtr p_entry{};
      WorkerTimingContainer_AddPerformanceEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntry(&p_entry))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WorkerTimingContainer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddPerformanceEntry(
std::move(p_entry));
      return true;
    }
  }
  return false;
}

// static
bool WorkerTimingContainerStubDispatch::AcceptWithResponder(
    WorkerTimingContainer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWorkerTimingContainer_AddPerformanceEntry_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWorkerTimingContainerValidationInfo[] = {
    {&internal::WorkerTimingContainer_AddPerformanceEntry_Params_Data::Validate,
     nullptr /* no response */},
};

bool WorkerTimingContainerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::WorkerTimingContainer::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWorkerTimingContainerValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif