// third_party/blink/public/mojom/webauthn/authenticator.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-params-data.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
CommonCredentialInfo::CommonCredentialInfo()
    : id(),
      raw_id(),
      client_data_json(),
      authenticator_data() {}

CommonCredentialInfo::CommonCredentialInfo(
    const WTF::String& id_in,
    WTF::Vector<uint8_t> raw_id_in,
    WTF::Vector<uint8_t> client_data_json_in,
    WTF::Vector<uint8_t> authenticator_data_in)
    : id(std::move(id_in)),
      raw_id(std::move(raw_id_in)),
      client_data_json(std::move(client_data_json_in)),
      authenticator_data(std::move(authenticator_data_in)) {}

CommonCredentialInfo::~CommonCredentialInfo() = default;

void CommonCredentialInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_id"), this->raw_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_data_json"), this->client_data_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_data"), this->authenticator_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommonCredentialInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MakeCredentialAuthenticatorResponse::MakeCredentialAuthenticatorResponse()
    : info(),
      attestation_object(),
      transports(),
      echo_hmac_create_secret(),
      hmac_create_secret(),
      echo_prf(),
      prf(),
      echo_cred_blob(),
      cred_blob(),
      public_key_der(),
      public_key_algo(),
      echo_cred_props(),
      has_cred_props_rk(),
      cred_props_rk(),
      echo_large_blob(),
      supports_large_blob() {}

MakeCredentialAuthenticatorResponse::MakeCredentialAuthenticatorResponse(
    CommonCredentialInfoPtr info_in,
    WTF::Vector<uint8_t> attestation_object_in,
    WTF::Vector<AuthenticatorTransport> transports_in,
    bool echo_hmac_create_secret_in,
    bool hmac_create_secret_in,
    bool echo_prf_in,
    bool prf_in,
    bool echo_cred_blob_in,
    bool cred_blob_in,
    absl::optional<WTF::Vector<uint8_t>> public_key_der_in,
    int32_t public_key_algo_in,
    bool echo_cred_props_in,
    bool has_cred_props_rk_in,
    bool cred_props_rk_in,
    bool echo_large_blob_in,
    bool supports_large_blob_in)
    : info(std::move(info_in)),
      attestation_object(std::move(attestation_object_in)),
      transports(std::move(transports_in)),
      echo_hmac_create_secret(std::move(echo_hmac_create_secret_in)),
      hmac_create_secret(std::move(hmac_create_secret_in)),
      echo_prf(std::move(echo_prf_in)),
      prf(std::move(prf_in)),
      echo_cred_blob(std::move(echo_cred_blob_in)),
      cred_blob(std::move(cred_blob_in)),
      public_key_der(std::move(public_key_der_in)),
      public_key_algo(std::move(public_key_algo_in)),
      echo_cred_props(std::move(echo_cred_props_in)),
      has_cred_props_rk(std::move(has_cred_props_rk_in)),
      cred_props_rk(std::move(cred_props_rk_in)),
      echo_large_blob(std::move(echo_large_blob_in)),
      supports_large_blob(std::move(supports_large_blob_in)) {}

MakeCredentialAuthenticatorResponse::~MakeCredentialAuthenticatorResponse() = default;

void MakeCredentialAuthenticatorResponse::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CommonCredentialInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attestation_object"), this->attestation_object,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transports"), this->transports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<AuthenticatorTransport>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_hmac_create_secret"), this->echo_hmac_create_secret,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hmac_create_secret"), this->hmac_create_secret,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_prf"), this->echo_prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf"), this->prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_cred_blob"), this->echo_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_blob"), this->cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key_der"), this->public_key_der,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key_algo"), this->public_key_algo,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_cred_props"), this->echo_cred_props,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_cred_props_rk"), this->has_cred_props_rk,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_props_rk"), this->cred_props_rk,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_large_blob"), this->echo_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_large_blob"), this->supports_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MakeCredentialAuthenticatorResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetAssertionAuthenticatorResponse::GetAssertionAuthenticatorResponse()
    : info(),
      signature(),
      user_handle(),
      echo_appid_extension(),
      appid_extension(),
      echo_prf(),
      prf_results(),
      prf_not_evaluated(),
      echo_large_blob(),
      large_blob(),
      echo_large_blob_written(),
      large_blob_written(),
      echo_get_cred_blob(),
      get_cred_blob() {}

GetAssertionAuthenticatorResponse::GetAssertionAuthenticatorResponse(
    CommonCredentialInfoPtr info_in,
    WTF::Vector<uint8_t> signature_in,
    absl::optional<WTF::Vector<uint8_t>> user_handle_in,
    bool echo_appid_extension_in,
    bool appid_extension_in,
    bool echo_prf_in,
    PRFValuesPtr prf_results_in,
    bool prf_not_evaluated_in,
    bool echo_large_blob_in,
    absl::optional<WTF::Vector<uint8_t>> large_blob_in,
    bool echo_large_blob_written_in,
    bool large_blob_written_in,
    bool echo_get_cred_blob_in,
    absl::optional<WTF::Vector<uint8_t>> get_cred_blob_in)
    : info(std::move(info_in)),
      signature(std::move(signature_in)),
      user_handle(std::move(user_handle_in)),
      echo_appid_extension(std::move(echo_appid_extension_in)),
      appid_extension(std::move(appid_extension_in)),
      echo_prf(std::move(echo_prf_in)),
      prf_results(std::move(prf_results_in)),
      prf_not_evaluated(std::move(prf_not_evaluated_in)),
      echo_large_blob(std::move(echo_large_blob_in)),
      large_blob(std::move(large_blob_in)),
      echo_large_blob_written(std::move(echo_large_blob_written_in)),
      large_blob_written(std::move(large_blob_written_in)),
      echo_get_cred_blob(std::move(echo_get_cred_blob_in)),
      get_cred_blob(std::move(get_cred_blob_in)) {}

GetAssertionAuthenticatorResponse::~GetAssertionAuthenticatorResponse() = default;

void GetAssertionAuthenticatorResponse::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CommonCredentialInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_handle"), this->user_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_appid_extension"), this->echo_appid_extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appid_extension"), this->appid_extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_prf"), this->echo_prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_results"), this->prf_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PRFValuesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_not_evaluated"), this->prf_not_evaluated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_large_blob"), this->echo_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob"), this->large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_large_blob_written"), this->echo_large_blob_written,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_written"), this->large_blob_written,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_get_cred_blob"), this->echo_get_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "get_cred_blob"), this->get_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetAssertionAuthenticatorResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialRpEntity::PublicKeyCredentialRpEntity()
    : id(),
      name(),
      icon() {}

PublicKeyCredentialRpEntity::PublicKeyCredentialRpEntity(
    const WTF::String& id_in,
    const WTF::String& name_in,
    const absl::optional<::blink::KURL>& icon_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      icon(std::move(icon_in)) {}

PublicKeyCredentialRpEntity::~PublicKeyCredentialRpEntity() = default;

void PublicKeyCredentialRpEntity::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialRpEntity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialUserEntity::PublicKeyCredentialUserEntity()
    : id(),
      name(),
      icon(),
      display_name() {}

PublicKeyCredentialUserEntity::PublicKeyCredentialUserEntity(
    WTF::Vector<uint8_t> id_in,
    const WTF::String& name_in,
    const absl::optional<::blink::KURL>& icon_in,
    const WTF::String& display_name_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      icon(std::move(icon_in)),
      display_name(std::move(display_name_in)) {}

PublicKeyCredentialUserEntity::~PublicKeyCredentialUserEntity() = default;

void PublicKeyCredentialUserEntity::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialUserEntity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialParameters::PublicKeyCredentialParameters()
    : type(),
      algorithm_identifier() {}

PublicKeyCredentialParameters::PublicKeyCredentialParameters(
    PublicKeyCredentialType type_in,
    int32_t algorithm_identifier_in)
    : type(std::move(type_in)),
      algorithm_identifier(std::move(algorithm_identifier_in)) {}

PublicKeyCredentialParameters::~PublicKeyCredentialParameters() = default;
size_t PublicKeyCredentialParameters::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->type);
  seed = mojo::internal::WTFHash(seed, this->algorithm_identifier);
  return seed;
}

void PublicKeyCredentialParameters::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm_identifier"), this->algorithm_identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CableAuthentication::CableAuthentication()
    : version(),
      client_eid(),
      authenticator_eid(),
      session_pre_key(),
      server_link_data() {}

CableAuthentication::CableAuthentication(
    uint8_t version_in,
    absl::optional<WTF::Vector<uint8_t>> client_eid_in,
    absl::optional<WTF::Vector<uint8_t>> authenticator_eid_in,
    absl::optional<WTF::Vector<uint8_t>> session_pre_key_in,
    absl::optional<WTF::Vector<uint8_t>> server_link_data_in)
    : version(std::move(version_in)),
      client_eid(std::move(client_eid_in)),
      authenticator_eid(std::move(authenticator_eid_in)),
      session_pre_key(std::move(session_pre_key_in)),
      server_link_data(std::move(server_link_data_in)) {}

CableAuthentication::~CableAuthentication() = default;

void CableAuthentication::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_eid"), this->client_eid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_eid"), this->authenticator_eid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_pre_key"), this->session_pre_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_link_data"), this->server_link_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CableAuthentication::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CableRegistration::CableRegistration()
    : versions(),
      relying_party_public_key() {}

CableRegistration::CableRegistration(
    WTF::Vector<uint8_t> versions_in,
    WTF::Vector<uint8_t> relying_party_public_key_in)
    : versions(std::move(versions_in)),
      relying_party_public_key(std::move(relying_party_public_key_in)) {}

CableRegistration::~CableRegistration() = default;

void CableRegistration::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "versions"), this->versions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relying_party_public_key"), this->relying_party_public_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CableRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PRFValues::PRFValues()
    : id(),
      first(),
      second() {}

PRFValues::PRFValues(
    absl::optional<WTF::Vector<uint8_t>> id_in,
    WTF::Vector<uint8_t> first_in,
    absl::optional<WTF::Vector<uint8_t>> second_in)
    : id(std::move(id_in)),
      first(std::move(first_in)),
      second(std::move(second_in)) {}

PRFValues::~PRFValues() = default;

void PRFValues::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first"), this->first,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "second"), this->second,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PRFValues::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentOptions::PaymentOptions()
    : total(),
      instrument() {}

PaymentOptions::PaymentOptions(
    ::payments::mojom::blink::PaymentCurrencyAmountPtr total_in,
    ::payments::mojom::blink::PaymentCredentialInstrumentPtr instrument_in)
    : total(std::move(total_in)),
      instrument(std::move(instrument_in)) {}

PaymentOptions::~PaymentOptions() = default;

void PaymentOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instrument"), this->instrument,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCredentialInstrumentPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions()
    : is_conditional(),
      challenge(),
      timeout(),
      relying_party_id(),
      allow_credentials(),
      user_verification(),
      appid(),
      cable_authentication_data(),
      prf(),
      prf_inputs(),
      large_blob_read(),
      large_blob_write(),
      get_cred_blob() {}

PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions(
    bool is_conditional_in,
    WTF::Vector<uint8_t> challenge_in,
    absl::optional<::base::TimeDelta> timeout_in,
    const WTF::String& relying_party_id_in,
    WTF::Vector<PublicKeyCredentialDescriptorPtr> allow_credentials_in,
    UserVerificationRequirement user_verification_in,
    const WTF::String& appid_in,
    WTF::Vector<CableAuthenticationPtr> cable_authentication_data_in,
    bool prf_in,
    WTF::Vector<PRFValuesPtr> prf_inputs_in,
    bool large_blob_read_in,
    absl::optional<WTF::Vector<uint8_t>> large_blob_write_in,
    bool get_cred_blob_in)
    : is_conditional(std::move(is_conditional_in)),
      challenge(std::move(challenge_in)),
      timeout(std::move(timeout_in)),
      relying_party_id(std::move(relying_party_id_in)),
      allow_credentials(std::move(allow_credentials_in)),
      user_verification(std::move(user_verification_in)),
      appid(std::move(appid_in)),
      cable_authentication_data(std::move(cable_authentication_data_in)),
      prf(std::move(prf_in)),
      prf_inputs(std::move(prf_inputs_in)),
      large_blob_read(std::move(large_blob_read_in)),
      large_blob_write(std::move(large_blob_write_in)),
      get_cred_blob(std::move(get_cred_blob_in)) {}

PublicKeyCredentialRequestOptions::~PublicKeyCredentialRequestOptions() = default;

void PublicKeyCredentialRequestOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_conditional"), this->is_conditional,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relying_party_id"), this->relying_party_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_credentials"), this->allow_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PublicKeyCredentialDescriptorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_verification"), this->user_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserVerificationRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appid"), this->appid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cable_authentication_data"), this->cable_authentication_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<CableAuthenticationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf"), this->prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_inputs"), this->prf_inputs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PRFValuesPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_read"), this->large_blob_read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_write"), this->large_blob_write,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "get_cred_blob"), this->get_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialRequestOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria()
    : authenticator_attachment(),
      resident_key(),
      user_verification() {}

AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria(
    AuthenticatorAttachment authenticator_attachment_in,
    ResidentKeyRequirement resident_key_in,
    UserVerificationRequirement user_verification_in)
    : authenticator_attachment(std::move(authenticator_attachment_in)),
      resident_key(std::move(resident_key_in)),
      user_verification(std::move(user_verification_in)) {}

AuthenticatorSelectionCriteria::~AuthenticatorSelectionCriteria() = default;
size_t AuthenticatorSelectionCriteria::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->authenticator_attachment);
  seed = mojo::internal::WTFHash(seed, this->resident_key);
  seed = mojo::internal::WTFHash(seed, this->user_verification);
  return seed;
}

void AuthenticatorSelectionCriteria::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_attachment"), this->authenticator_attachment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticatorAttachment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resident_key"), this->resident_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResidentKeyRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_verification"), this->user_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserVerificationRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthenticatorSelectionCriteria::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions()
    : relying_party(),
      user(),
      challenge(),
      public_key_parameters(),
      timeout(),
      exclude_credentials(),
      authenticator_selection(),
      attestation(),
      cable_registration_data(),
      hmac_create_secret(),
      prf_enable(),
      protection_policy(),
      enforce_protection_policy(),
      appid_exclude(),
      cred_props(),
      large_blob_enable(),
      is_payment_credential_creation(),
      cred_blob(),
      google_legacy_app_id_support(false) {}

PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions(
    PublicKeyCredentialRpEntityPtr relying_party_in,
    PublicKeyCredentialUserEntityPtr user_in,
    WTF::Vector<uint8_t> challenge_in,
    WTF::Vector<PublicKeyCredentialParametersPtr> public_key_parameters_in,
    absl::optional<::base::TimeDelta> timeout_in,
    WTF::Vector<PublicKeyCredentialDescriptorPtr> exclude_credentials_in,
    AuthenticatorSelectionCriteriaPtr authenticator_selection_in,
    AttestationConveyancePreference attestation_in,
    CableRegistrationPtr cable_registration_data_in,
    bool hmac_create_secret_in,
    bool prf_enable_in,
    ProtectionPolicy protection_policy_in,
    bool enforce_protection_policy_in,
    const WTF::String& appid_exclude_in,
    bool cred_props_in,
    LargeBlobSupport large_blob_enable_in,
    bool is_payment_credential_creation_in,
    absl::optional<WTF::Vector<uint8_t>> cred_blob_in,
    bool google_legacy_app_id_support_in)
    : relying_party(std::move(relying_party_in)),
      user(std::move(user_in)),
      challenge(std::move(challenge_in)),
      public_key_parameters(std::move(public_key_parameters_in)),
      timeout(std::move(timeout_in)),
      exclude_credentials(std::move(exclude_credentials_in)),
      authenticator_selection(std::move(authenticator_selection_in)),
      attestation(std::move(attestation_in)),
      cable_registration_data(std::move(cable_registration_data_in)),
      hmac_create_secret(std::move(hmac_create_secret_in)),
      prf_enable(std::move(prf_enable_in)),
      protection_policy(std::move(protection_policy_in)),
      enforce_protection_policy(std::move(enforce_protection_policy_in)),
      appid_exclude(std::move(appid_exclude_in)),
      cred_props(std::move(cred_props_in)),
      large_blob_enable(std::move(large_blob_enable_in)),
      is_payment_credential_creation(std::move(is_payment_credential_creation_in)),
      cred_blob(std::move(cred_blob_in)),
      google_legacy_app_id_support(std::move(google_legacy_app_id_support_in)) {}

PublicKeyCredentialCreationOptions::~PublicKeyCredentialCreationOptions() = default;

void PublicKeyCredentialCreationOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relying_party"), this->relying_party,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialRpEntityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user"), this->user,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialUserEntityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key_parameters"), this->public_key_parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PublicKeyCredentialParametersPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_credentials"), this->exclude_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PublicKeyCredentialDescriptorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_selection"), this->authenticator_selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticatorSelectionCriteriaPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attestation"), this->attestation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AttestationConveyancePreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cable_registration_data"), this->cable_registration_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CableRegistrationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hmac_create_secret"), this->hmac_create_secret,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_enable"), this->prf_enable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protection_policy"), this->protection_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProtectionPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforce_protection_policy"), this->enforce_protection_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appid_exclude"), this->appid_exclude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_props"), this->cred_props,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_enable"), this->large_blob_enable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LargeBlobSupport>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_payment_credential_creation"), this->is_payment_credential_creation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_blob"), this->cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "google_legacy_app_id_support"), this->google_legacy_app_id_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialCreationOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor()
    : type(),
      id(),
      transports() {}

PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor(
    PublicKeyCredentialType type_in,
    WTF::Vector<uint8_t> id_in,
    WTF::Vector<AuthenticatorTransport> transports_in)
    : type(std::move(type_in)),
      id(std::move(id_in)),
      transports(std::move(transports_in)) {}

PublicKeyCredentialDescriptor::~PublicKeyCredentialDescriptor() = default;

void PublicKeyCredentialDescriptor::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transports"), this->transports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<AuthenticatorTransport>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Authenticator::Name_[] = "blink.mojom.Authenticator";

class Authenticator_MakeCredential_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_MakeCredential_ForwardToCallback(
      Authenticator::MakeCredentialCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::MakeCredentialCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Authenticator_MakeCredential_ForwardToCallback);
};

class Authenticator_GetAssertion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_GetAssertion_ForwardToCallback(
      Authenticator::GetAssertionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::GetAssertionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Authenticator_GetAssertion_ForwardToCallback);
};

class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback(
      Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback);
};

AuthenticatorProxy::AuthenticatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuthenticatorProxy::MakeCredential(
    PublicKeyCredentialCreationOptionsPtr in_options, MakeCredentialCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Authenticator::MakeCredential", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type PublicKeyCredentialCreationOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthenticator_MakeCredential_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_MakeCredential_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialCreationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in Authenticator.MakeCredential request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("MakeCredential");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_MakeCredential_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AuthenticatorProxy::GetAssertion(
    PublicKeyCredentialRequestOptionsPtr in_options, GetAssertionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Authenticator::GetAssertion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type PublicKeyCredentialRequestOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthenticator_GetAssertion_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_GetAssertion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialRequestOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in Authenticator.GetAssertion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetAssertion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_GetAssertion_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AuthenticatorProxy::IsUserVerifyingPlatformAuthenticatorAvailable(
    IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsUserVerifyingPlatformAuthenticatorAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AuthenticatorProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Authenticator::Cancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthenticator_Cancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Authenticator_MakeCredential_ProxyToResponder {
 public:
  static Authenticator::MakeCredentialCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Authenticator_MakeCredential_ProxyToResponder> proxy(
        new Authenticator_MakeCredential_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Authenticator_MakeCredential_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_MakeCredential_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Authenticator_MakeCredential_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::MakeCredentialCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      AuthenticatorStatus in_status, MakeCredentialAuthenticatorResponsePtr in_credential);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Authenticator_MakeCredential_ProxyToResponder);
};

bool Authenticator_MakeCredential_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Authenticator::MakeCredentialCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Authenticator_MakeCredential_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_MakeCredential_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  AuthenticatorStatus p_status{};
  MakeCredentialAuthenticatorResponsePtr p_credential{};
  Authenticator_MakeCredential_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_credential));
  return true;
}

void Authenticator_MakeCredential_ProxyToResponder::Run(
    AuthenticatorStatus in_status, MakeCredentialAuthenticatorResponsePtr in_credential) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Authenticator::MakeCredentialCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type AuthenticatorStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type MakeCredentialAuthenticatorResponsePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthenticator_MakeCredential_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_MakeCredential_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MakeCredentialAuthenticatorResponseDataView>(
      in_credential, credential_fragment);
  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Authenticator::MakeCredentialCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("MakeCredential");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_GetAssertion_ProxyToResponder {
 public:
  static Authenticator::GetAssertionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Authenticator_GetAssertion_ProxyToResponder> proxy(
        new Authenticator_GetAssertion_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Authenticator_GetAssertion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_GetAssertion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Authenticator_GetAssertion_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::GetAssertionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      AuthenticatorStatus in_status, GetAssertionAuthenticatorResponsePtr in_credential);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Authenticator_GetAssertion_ProxyToResponder);
};

bool Authenticator_GetAssertion_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Authenticator::GetAssertionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Authenticator_GetAssertion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_GetAssertion_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  AuthenticatorStatus p_status{};
  GetAssertionAuthenticatorResponsePtr p_credential{};
  Authenticator_GetAssertion_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_credential));
  return true;
}

void Authenticator_GetAssertion_ProxyToResponder::Run(
    AuthenticatorStatus in_status, GetAssertionAuthenticatorResponsePtr in_credential) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Authenticator::GetAssertionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type AuthenticatorStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type GetAssertionAuthenticatorResponsePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthenticator_GetAssertion_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_GetAssertion_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
      in_credential, credential_fragment);
  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Authenticator::GetAssertionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetAssertion");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder {
 public:
  static Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder> proxy(
        new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_available);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder);
};

bool Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_available{};
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_available = input_data_view.available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_available));
  return true;
}

void Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::Run(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->available = in_available;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsUserVerifyingPlatformAuthenticatorAvailable");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AuthenticatorStubDispatch::Accept(
    Authenticator* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAuthenticator_MakeCredential_Name: {
      break;
    }
    case internal::kAuthenticator_GetAssertion_Name: {
      break;
    }
    case internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name: {
      break;
    }
    case internal::kAuthenticator_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Authenticator_Cancel_Params_Data* params =
          reinterpret_cast<internal::Authenticator_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Authenticator_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel();
      return true;
    }
  }
  return false;
}

// static
bool AuthenticatorStubDispatch::AcceptWithResponder(
    Authenticator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAuthenticator_MakeCredential_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::MakeCredential",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::MakeCredential");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Authenticator_MakeCredential_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_MakeCredential_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PublicKeyCredentialCreationOptionsPtr p_options{};
      Authenticator_MakeCredential_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 0, false);
        return false;
      }
      Authenticator::MakeCredentialCallback callback =
          Authenticator_MakeCredential_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeCredential(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kAuthenticator_GetAssertion_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::GetAssertion",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::GetAssertion");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Authenticator_GetAssertion_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_GetAssertion_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PublicKeyCredentialRequestOptionsPtr p_options{};
      Authenticator_GetAssertion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 1, false);
        return false;
      }
      Authenticator::GetAssertionCallback callback =
          Authenticator_GetAssertion_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAssertion(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 2, false);
        return false;
      }
      Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback =
          Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsUserVerifyingPlatformAuthenticatorAvailable(std::move(callback));
      return true;
    }
    case internal::kAuthenticator_Cancel_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAuthenticatorValidationInfo[] = {
    {&internal::Authenticator_MakeCredential_Params_Data::Validate,
     &internal::Authenticator_MakeCredential_ResponseParams_Data::Validate},
    {&internal::Authenticator_GetAssertion_Params_Data::Validate,
     &internal::Authenticator_GetAssertion_ResponseParams_Data::Validate},
    {&internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::Validate,
     &internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::Validate},
    {&internal::Authenticator_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool AuthenticatorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Authenticator::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAuthenticatorValidationInfo);
}

bool AuthenticatorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Authenticator::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAuthenticatorValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::CommonCredentialInfo::DataView, ::blink::mojom::blink::CommonCredentialInfoPtr>::Read(
    ::blink::mojom::blink::CommonCredentialInfo::DataView input,
    ::blink::mojom::blink::CommonCredentialInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CommonCredentialInfoPtr result(::blink::mojom::blink::CommonCredentialInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadRawId(&result->raw_id))
        success = false;
      if (success && !input.ReadClientDataJson(&result->client_data_json))
        success = false;
      if (success && !input.ReadAuthenticatorData(&result->authenticator_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MakeCredentialAuthenticatorResponse::DataView, ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr>::Read(
    ::blink::mojom::blink::MakeCredentialAuthenticatorResponse::DataView input,
    ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr result(::blink::mojom::blink::MakeCredentialAuthenticatorResponse::New());
  
      if (success && !input.ReadInfo(&result->info))
        success = false;
      if (success && !input.ReadAttestationObject(&result->attestation_object))
        success = false;
      if (success && !input.ReadTransports(&result->transports))
        success = false;
      if (success)
        result->echo_hmac_create_secret = input.echo_hmac_create_secret();
      if (success)
        result->hmac_create_secret = input.hmac_create_secret();
      if (success)
        result->echo_prf = input.echo_prf();
      if (success)
        result->prf = input.prf();
      if (success)
        result->echo_cred_blob = input.echo_cred_blob();
      if (success)
        result->cred_blob = input.cred_blob();
      if (success && !input.ReadPublicKeyDer(&result->public_key_der))
        success = false;
      if (success)
        result->public_key_algo = input.public_key_algo();
      if (success)
        result->echo_cred_props = input.echo_cred_props();
      if (success)
        result->has_cred_props_rk = input.has_cred_props_rk();
      if (success)
        result->cred_props_rk = input.cred_props_rk();
      if (success)
        result->echo_large_blob = input.echo_large_blob();
      if (success)
        result->supports_large_blob = input.supports_large_blob();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::GetAssertionAuthenticatorResponse::DataView, ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr>::Read(
    ::blink::mojom::blink::GetAssertionAuthenticatorResponse::DataView input,
    ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr result(::blink::mojom::blink::GetAssertionAuthenticatorResponse::New());
  
      if (success && !input.ReadInfo(&result->info))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
      if (success && !input.ReadUserHandle(&result->user_handle))
        success = false;
      if (success)
        result->echo_appid_extension = input.echo_appid_extension();
      if (success)
        result->appid_extension = input.appid_extension();
      if (success)
        result->echo_prf = input.echo_prf();
      if (success && !input.ReadPrfResults(&result->prf_results))
        success = false;
      if (success)
        result->prf_not_evaluated = input.prf_not_evaluated();
      if (success)
        result->echo_large_blob = input.echo_large_blob();
      if (success && !input.ReadLargeBlob(&result->large_blob))
        success = false;
      if (success)
        result->echo_large_blob_written = input.echo_large_blob_written();
      if (success)
        result->large_blob_written = input.large_blob_written();
      if (success)
        result->echo_get_cred_blob = input.echo_get_cred_blob();
      if (success && !input.ReadGetCredBlob(&result->get_cred_blob))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialRpEntity::DataView, ::blink::mojom::blink::PublicKeyCredentialRpEntityPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialRpEntity::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialRpEntityPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialRpEntityPtr result(::blink::mojom::blink::PublicKeyCredentialRpEntity::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialUserEntity::DataView, ::blink::mojom::blink::PublicKeyCredentialUserEntityPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialUserEntity::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialUserEntityPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialUserEntityPtr result(::blink::mojom::blink::PublicKeyCredentialUserEntity::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialParameters::DataView, ::blink::mojom::blink::PublicKeyCredentialParametersPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialParameters::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialParametersPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialParametersPtr result(::blink::mojom::blink::PublicKeyCredentialParameters::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->algorithm_identifier = input.algorithm_identifier();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CableAuthentication::DataView, ::blink::mojom::blink::CableAuthenticationPtr>::Read(
    ::blink::mojom::blink::CableAuthentication::DataView input,
    ::blink::mojom::blink::CableAuthenticationPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CableAuthenticationPtr result(::blink::mojom::blink::CableAuthentication::New());
  
      if (success)
        result->version = input.version();
      if (success && !input.ReadClientEid(&result->client_eid))
        success = false;
      if (success && !input.ReadAuthenticatorEid(&result->authenticator_eid))
        success = false;
      if (success && !input.ReadSessionPreKey(&result->session_pre_key))
        success = false;
      if (success && !input.ReadServerLinkData(&result->server_link_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CableRegistration::DataView, ::blink::mojom::blink::CableRegistrationPtr>::Read(
    ::blink::mojom::blink::CableRegistration::DataView input,
    ::blink::mojom::blink::CableRegistrationPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CableRegistrationPtr result(::blink::mojom::blink::CableRegistration::New());
  
      if (success && !input.ReadVersions(&result->versions))
        success = false;
      if (success && !input.ReadRelyingPartyPublicKey(&result->relying_party_public_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PRFValues::DataView, ::blink::mojom::blink::PRFValuesPtr>::Read(
    ::blink::mojom::blink::PRFValues::DataView input,
    ::blink::mojom::blink::PRFValuesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PRFValuesPtr result(::blink::mojom::blink::PRFValues::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadFirst(&result->first))
        success = false;
      if (success && !input.ReadSecond(&result->second))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PaymentOptions::DataView, ::blink::mojom::blink::PaymentOptionsPtr>::Read(
    ::blink::mojom::blink::PaymentOptions::DataView input,
    ::blink::mojom::blink::PaymentOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PaymentOptionsPtr result(::blink::mojom::blink::PaymentOptions::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadInstrument(&result->instrument))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialRequestOptions::DataView, ::blink::mojom::blink::PublicKeyCredentialRequestOptionsPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialRequestOptions::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialRequestOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialRequestOptionsPtr result(::blink::mojom::blink::PublicKeyCredentialRequestOptions::New());
  
      if (success)
        result->is_conditional = input.is_conditional();
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success && !input.ReadRelyingPartyId(&result->relying_party_id))
        success = false;
      if (success && !input.ReadAllowCredentials(&result->allow_credentials))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
      if (success && !input.ReadAppid(&result->appid))
        success = false;
      if (success && !input.ReadCableAuthenticationData(&result->cable_authentication_data))
        success = false;
      if (success)
        result->prf = input.prf();
      if (success && !input.ReadPrfInputs(&result->prf_inputs))
        success = false;
      if (success)
        result->large_blob_read = input.large_blob_read();
      if (success && !input.ReadLargeBlobWrite(&result->large_blob_write))
        success = false;
      if (success)
        result->get_cred_blob = input.get_cred_blob();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AuthenticatorSelectionCriteria::DataView, ::blink::mojom::blink::AuthenticatorSelectionCriteriaPtr>::Read(
    ::blink::mojom::blink::AuthenticatorSelectionCriteria::DataView input,
    ::blink::mojom::blink::AuthenticatorSelectionCriteriaPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AuthenticatorSelectionCriteriaPtr result(::blink::mojom::blink::AuthenticatorSelectionCriteria::New());
  
      if (success && !input.ReadAuthenticatorAttachment(&result->authenticator_attachment))
        success = false;
      if (success && !input.ReadResidentKey(&result->resident_key))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialCreationOptions::DataView, ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialCreationOptions::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr result(::blink::mojom::blink::PublicKeyCredentialCreationOptions::New());
  
      if (success && !input.ReadRelyingParty(&result->relying_party))
        success = false;
      if (success && !input.ReadUser(&result->user))
        success = false;
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadPublicKeyParameters(&result->public_key_parameters))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success && !input.ReadExcludeCredentials(&result->exclude_credentials))
        success = false;
      if (success && !input.ReadAuthenticatorSelection(&result->authenticator_selection))
        success = false;
      if (success && !input.ReadAttestation(&result->attestation))
        success = false;
      if (success && !input.ReadCableRegistrationData(&result->cable_registration_data))
        success = false;
      if (success)
        result->hmac_create_secret = input.hmac_create_secret();
      if (success)
        result->prf_enable = input.prf_enable();
      if (success && !input.ReadProtectionPolicy(&result->protection_policy))
        success = false;
      if (success)
        result->enforce_protection_policy = input.enforce_protection_policy();
      if (success && !input.ReadAppidExclude(&result->appid_exclude))
        success = false;
      if (success)
        result->cred_props = input.cred_props();
      if (success && !input.ReadLargeBlobEnable(&result->large_blob_enable))
        success = false;
      if (success)
        result->is_payment_credential_creation = input.is_payment_credential_creation();
      if (success && !input.ReadCredBlob(&result->cred_blob))
        success = false;
      if (success)
        result->google_legacy_app_id_support = input.google_legacy_app_id_support();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialDescriptor::DataView, ::blink::mojom::blink::PublicKeyCredentialDescriptorPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialDescriptor::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialDescriptorPtr result(::blink::mojom::blink::PublicKeyCredentialDescriptor::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTransports(&result->transports))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif