// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* PointerTypeToStringHelper(PointerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PointerType::kPointerNone:
      return "{kPointerNone, kPointerFirstType}";
    case PointerType::kPointerCoarseType:
      return "kPointerCoarseType";
    case PointerType::kPointerFineType:
      return "kPointerFineType";
    default:
      return nullptr;
  }
}

std::string PointerTypeToString(PointerType value) {
  const char *str = PointerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PointerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PointerType value) {
  return os << PointerTypeToString(value);
}

static NOINLINE const char* HoverTypeToStringHelper(HoverType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HoverType::kHoverNone:
      return "{kHoverNone, kHoverFirstType}";
    case HoverType::kHoverHoverType:
      return "kHoverHoverType";
    default:
      return nullptr;
  }
}

std::string HoverTypeToString(HoverType value) {
  const char *str = HoverTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HoverType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HoverType value) {
  return os << HoverTypeToString(value);
}

static NOINLINE const char* EditingBehaviorToStringHelper(EditingBehavior value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EditingBehavior::kEditingMacBehavior:
      return "kEditingMacBehavior";
    case EditingBehavior::kEditingWindowsBehavior:
      return "kEditingWindowsBehavior";
    case EditingBehavior::kEditingUnixBehavior:
      return "kEditingUnixBehavior";
    case EditingBehavior::kEditingAndroidBehavior:
      return "kEditingAndroidBehavior";
    case EditingBehavior::kEditingChromeOSBehavior:
      return "kEditingChromeOSBehavior";
    default:
      return nullptr;
  }
}

std::string EditingBehaviorToString(EditingBehavior value) {
  const char *str = EditingBehaviorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EditingBehavior value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EditingBehavior value) {
  return os << EditingBehaviorToString(value);
}

static NOINLINE const char* ImageAnimationPolicyToStringHelper(ImageAnimationPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImageAnimationPolicy::kImageAnimationPolicyAllowed:
      return "kImageAnimationPolicyAllowed";
    case ImageAnimationPolicy::kImageAnimationPolicyAnimateOnce:
      return "kImageAnimationPolicyAnimateOnce";
    case ImageAnimationPolicy::kImageAnimationPolicyNoAnimation:
      return "kImageAnimationPolicyNoAnimation";
    default:
      return nullptr;
  }
}

std::string ImageAnimationPolicyToString(ImageAnimationPolicy value) {
  const char *str = ImageAnimationPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImageAnimationPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImageAnimationPolicy value) {
  return os << ImageAnimationPolicyToString(value);
}

static NOINLINE const char* ViewportStyleToStringHelper(ViewportStyle value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ViewportStyle::kDefault:
      return "kDefault";
    case ViewportStyle::kMobile:
      return "kMobile";
    case ViewportStyle::kTelevision:
      return "{kTelevision, kLast}";
    default:
      return nullptr;
  }
}

std::string ViewportStyleToString(ViewportStyle value) {
  const char *str = ViewportStyleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ViewportStyle value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ViewportStyle value) {
  return os << ViewportStyleToString(value);
}

static NOINLINE const char* AutoplayPolicyToStringHelper(AutoplayPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutoplayPolicy::kNoUserGestureRequired:
      return "kNoUserGestureRequired";
    case AutoplayPolicy::kUserGestureRequired:
      return "kUserGestureRequired";
    case AutoplayPolicy::kDocumentUserActivationRequired:
      return "kDocumentUserActivationRequired";
    default:
      return nullptr;
  }
}

std::string AutoplayPolicyToString(AutoplayPolicy value) {
  const char *str = AutoplayPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutoplayPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutoplayPolicy value) {
  return os << AutoplayPolicyToString(value);
}

static NOINLINE const char* EffectiveConnectionTypeToStringHelper(EffectiveConnectionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EffectiveConnectionType::kEffectiveConnectionUnknownType:
      return "kEffectiveConnectionUnknownType";
    case EffectiveConnectionType::kEffectiveConnectionOfflineType:
      return "kEffectiveConnectionOfflineType";
    case EffectiveConnectionType::kEffectiveConnectionSlow2GType:
      return "kEffectiveConnectionSlow2GType";
    case EffectiveConnectionType::kEffectiveConnection2GType:
      return "kEffectiveConnection2GType";
    case EffectiveConnectionType::kEffectiveConnection3GType:
      return "kEffectiveConnection3GType";
    case EffectiveConnectionType::kEffectiveConnection4GType:
      return "kEffectiveConnection4GType";
    case EffectiveConnectionType::kEffectiveConnectionTypeLast:
      return "kEffectiveConnectionTypeLast";
    default:
      return nullptr;
  }
}

std::string EffectiveConnectionTypeToString(EffectiveConnectionType value) {
  const char *str = EffectiveConnectionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EffectiveConnectionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EffectiveConnectionType value) {
  return os << EffectiveConnectionTypeToString(value);
}

namespace internal {


// static
bool WebPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 296, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebPreferences_Data* object = static_cast<const WebPreferences_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->standard_font_family_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams standard_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->standard_font_family_map, validation_context,
                                         &standard_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fixed_font_family_map, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fixed_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->fixed_font_family_map, validation_context,
                                         &fixed_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serif_font_family_map, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams serif_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->serif_font_family_map, validation_context,
                                         &serif_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sans_serif_font_family_map, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sans_serif_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->sans_serif_font_family_map, validation_context,
                                         &sans_serif_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cursive_font_family_map, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cursive_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->cursive_font_family_map, validation_context,
                                         &cursive_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fantasy_font_family_map, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fantasy_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->fantasy_font_family_map, validation_context,
                                         &fantasy_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pictograph_font_family_map, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pictograph_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->pictograph_font_family_map, validation_context,
                                         &pictograph_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_encoding, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams default_encoding_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->default_encoding, validation_context,
                                         &default_encoding_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::PointerType_Data
        ::Validate(object->primary_pointer_type, validation_context))
    return false;


  if (!::blink::mojom::internal::HoverType_Data
        ::Validate(object->primary_hover_type, validation_context))
    return false;


  if (!::blink::mojom::internal::EditingBehavior_Data
        ::Validate(object->editing_behavior, validation_context))
    return false;


  if (!::blink::mojom::internal::ViewportStyle_Data
        ::Validate(object->viewport_style, validation_context))
    return false;


  if (!::blink::mojom::internal::V8CacheOptions_Data
        ::Validate(object->v8_cache_options, validation_context))
    return false;


  if (!::blink::mojom::internal::ImageAnimationPolicy_Data
        ::Validate(object->animation_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_background_color, 100, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_background_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_background_color, validation_context,
                                         &text_track_background_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_color, 101, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_color, validation_context,
                                         &text_track_text_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_size, 102, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_size_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_size, validation_context,
                                         &text_track_text_size_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_shadow, 103, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_shadow_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_shadow, validation_context,
                                         &text_track_text_shadow_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_family, 104, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_family_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_family, validation_context,
                                         &text_track_font_family_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_style, 105, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_style_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_style, validation_context,
                                         &text_track_font_style_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_variant, 106, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_variant_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_variant, validation_context,
                                         &text_track_font_variant_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_color, 107, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_color, validation_context,
                                         &text_track_window_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_padding, 108, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_padding_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_padding, validation_context,
                                         &text_track_window_padding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_radius, 109, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_radius_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_radius, validation_context,
                                         &text_track_window_radius_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_app_scope, 115, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_app_scope, validation_context))
    return false;


  if (!::blink::mojom::internal::AutoplayPolicy_Data
        ::Validate(object->autoplay_policy, validation_context))
    return false;


  if (!::blink::mojom::internal::PreferredColorScheme_Data
        ::Validate(object->preferred_color_scheme, validation_context))
    return false;


  if (!::blink::mojom::internal::PreferredContrast_Data
        ::Validate(object->preferred_contrast, validation_context))
    return false;


  if (!::blink::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->low_priority_iframes_threshold, validation_context))
    return false;


  if (!::blink::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->network_quality_estimator_web_holdback, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_frame_loading_distance_thresholds_px, 131, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_frame_loading_distance_thresholds_px_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_frame_loading_distance_thresholds_px, validation_context,
                                         &lazy_frame_loading_distance_thresholds_px_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_image_loading_distance_thresholds_px, 132, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_image_loading_distance_thresholds_px_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_image_loading_distance_thresholds_px, validation_context,
                                         &lazy_image_loading_distance_thresholds_px_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_image_first_k_fully_load, 133, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_image_first_k_fully_load_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_image_first_k_fully_load, validation_context,
                                         &lazy_image_first_k_fully_load_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->litepage_subresource_redirect_origin, 138, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->litepage_subresource_redirect_origin, validation_context))
    return false;

  return true;
}

WebPreferences_Data::WebPreferences_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PointerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PointerType value) {
  return std::move(context).WriteString(::blink::mojom::PointerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::HoverType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::HoverType value) {
  return std::move(context).WriteString(::blink::mojom::HoverTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EditingBehavior>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::EditingBehavior value) {
  return std::move(context).WriteString(::blink::mojom::EditingBehaviorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ImageAnimationPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ImageAnimationPolicy value) {
  return std::move(context).WriteString(::blink::mojom::ImageAnimationPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ViewportStyle>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ViewportStyle value) {
  return std::move(context).WriteString(::blink::mojom::ViewportStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AutoplayPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AutoplayPolicy value) {
  return std::move(context).WriteString(::blink::mojom::AutoplayPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EffectiveConnectionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::EffectiveConnectionType value) {
  return std::move(context).WriteString(::blink::mojom::EffectiveConnectionTypeToString(value));
}

} // namespace perfetto
