// third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data* object = static_cast<const DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->browser_interface_broker, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->browser_interface_broker,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data* object = static_cast<const DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->service_worker_container_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_script_load_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_script_load_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subresource_loader_factories, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subresource_loader_updater, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subresource_loader_updater,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->controller_info, validation_context))
    return false;

  return true;
}

DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data* object = static_cast<const DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data* object = static_cast<const DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_url, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->browser_interface_broker, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->browser_interface_broker,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data::DedicatedWorkerHostFactory_CreateWorkerHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data* object = static_cast<const DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_coep, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_coep, validation_context))
    return false;

  return true;
}

DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data::DedicatedWorkerHostFactory_CreateWorkerHost_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data* object = static_cast<const DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_url, validation_context))
    return false;


  if (!::network::mojom::internal::CredentialsMode_Data
        ::Validate(object->credentials_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outside_fetch_client_settings_object, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outside_fetch_client_settings_object, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->blob_url_token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink
