// third_party/blink/public/mojom/worker/shared_worker_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_host.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_HOST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_HOST_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char SharedWorkerHost::Name_[] = "blink.mojom.SharedWorkerHost";

SharedWorkerHostProxy::SharedWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerHostProxy::OnConnected(
    int32_t in_connection_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerHost::OnConnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_id"), in_connection_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerHost_OnConnected_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnConnected_Params_Data> params(
          message);
  params.Allocate();
  params->connection_id = in_connection_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnConnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerHostProxy::OnContextClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SharedWorkerHost::OnContextClosed");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerHost_OnContextClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnContextClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnContextClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerHostProxy::OnReadyForInspection(
    ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> in_agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> in_agent_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerHost::OnReadyForInspection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerHost_OnReadyForInspection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnReadyForInspection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DevToolsAgentInterfaceBase>>(
      in_agent, &params->agent, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid agent in SharedWorkerHost.OnReadyForInspection request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DevToolsAgentHostInterfaceBase>>(
      in_agent_host, &params->agent_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid agent_host in SharedWorkerHost.OnReadyForInspection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnReadyForInspection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerHostProxy::OnScriptLoadFailed(
    const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerHost::OnScriptLoadFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerHost_OnScriptLoadFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in SharedWorkerHost.OnScriptLoadFailed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnScriptLoadFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerHostProxy::OnFeatureUsed(
    ::blink::mojom::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerHost::OnFeatureUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::blink::mojom::WebFeature>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedWorkerHost_OnFeatureUsed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedWorkerHost_OnFeatureUsed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
      in_feature, &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerHost::Name_);
  message.set_method_name("OnFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SharedWorkerHostStubDispatch::Accept(
    SharedWorkerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSharedWorkerHost_OnConnected_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerHost::OnConnected",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerHost::OnConnected");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnConnected_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnConnected_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_connection_id{};
      SharedWorkerHost_OnConnected_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_connection_id = input_data_view.connection_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnected(
std::move(p_connection_id));
      return true;
    }
    case internal::kSharedWorkerHost_OnContextClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerHost::OnContextClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerHost::OnContextClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnContextClosed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnContextClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SharedWorkerHost_OnContextClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContextClosed();
      return true;
    }
    case internal::kSharedWorkerHost_OnReadyForInspection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerHost::OnReadyForInspection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerHost::OnReadyForInspection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnReadyForInspection_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnReadyForInspection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> p_agent{};
      ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      SharedWorkerHost_OnReadyForInspection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadyForInspection(
std::move(p_agent), 
std::move(p_agent_host));
      return true;
    }
    case internal::kSharedWorkerHost_OnScriptLoadFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerHost::OnScriptLoadFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerHost::OnScriptLoadFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_error_message{};
      SharedWorkerHost_OnScriptLoadFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadFailed(
std::move(p_error_message));
      return true;
    }
    case internal::kSharedWorkerHost_OnFeatureUsed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerHost::OnFeatureUsed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerHost::OnFeatureUsed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerHost_OnFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerHost_OnFeatureUsed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::WebFeature p_feature{};
      SharedWorkerHost_OnFeatureUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFeatureUsed(
std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerHostStubDispatch::AcceptWithResponder(
    SharedWorkerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedWorkerHost_OnConnected_Name: {
      break;
    }
    case internal::kSharedWorkerHost_OnContextClosed_Name: {
      break;
    }
    case internal::kSharedWorkerHost_OnReadyForInspection_Name: {
      break;
    }
    case internal::kSharedWorkerHost_OnScriptLoadFailed_Name: {
      break;
    }
    case internal::kSharedWorkerHost_OnFeatureUsed_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSharedWorkerHostValidationInfo[] = {
    {&internal::SharedWorkerHost_OnConnected_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerHost_OnContextClosed_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerHost_OnReadyForInspection_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerHost_OnScriptLoadFailed_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerHost_OnFeatureUsed_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedWorkerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SharedWorkerHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSharedWorkerHostValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif