// ui/base/mojom/window_open_disposition.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/mojom/window_open_disposition.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/mojom/window_open_disposition.mojom-params-data.h"
namespace ui {
namespace mojom {

static NOINLINE const char* WindowOpenDispositionToStringHelper(WindowOpenDisposition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowOpenDisposition::UNKNOWN:
      return "UNKNOWN";
    case WindowOpenDisposition::CURRENT_TAB:
      return "CURRENT_TAB";
    case WindowOpenDisposition::SINGLETON_TAB:
      return "SINGLETON_TAB";
    case WindowOpenDisposition::NEW_FOREGROUND_TAB:
      return "NEW_FOREGROUND_TAB";
    case WindowOpenDisposition::NEW_BACKGROUND_TAB:
      return "NEW_BACKGROUND_TAB";
    case WindowOpenDisposition::NEW_POPUP:
      return "NEW_POPUP";
    case WindowOpenDisposition::NEW_WINDOW:
      return "NEW_WINDOW";
    case WindowOpenDisposition::SAVE_TO_DISK:
      return "SAVE_TO_DISK";
    case WindowOpenDisposition::OFF_THE_RECORD:
      return "OFF_THE_RECORD";
    case WindowOpenDisposition::IGNORE_ACTION:
      return "IGNORE_ACTION";
    case WindowOpenDisposition::SWITCH_TO_TAB:
      return "SWITCH_TO_TAB";
    default:
      return nullptr;
  }
}

std::string WindowOpenDispositionToString(WindowOpenDisposition value) {
  const char *str = WindowOpenDispositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowOpenDisposition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowOpenDisposition value) {
  return os << WindowOpenDispositionToString(value);
}

namespace internal {


// static
bool ClickModifiers_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClickModifiers_Data* object = static_cast<const ClickModifiers_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ClickModifiers_Data::ClickModifiers_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::WindowOpenDisposition>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::WindowOpenDisposition value) {
  return std::move(context).WriteString(::ui::mojom::WindowOpenDispositionToString(value));
}

} // namespace perfetto
