// ui/display/mojom/display_mode.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display_mode.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_mode.mojom-params-data.h"
#include "ui/display/mojom/display_mode.mojom-shared-message-ids.h"

#include "ui/display/mojom/display_mode.mojom-import-headers.h"


#ifndef UI_DISPLAY_MOJOM_DISPLAY_MODE_MOJOM_JUMBO_H_
#define UI_DISPLAY_MOJOM_DISPLAY_MODE_MOJOM_JUMBO_H_
#endif
namespace display {
namespace mojom {
DisplayMode::DisplayMode()
    : size(),
      is_interlaced(),
      refresh_rate() {}

DisplayMode::DisplayMode(
    const ::gfx::Size& size_in,
    bool is_interlaced_in,
    float refresh_rate_in)
    : size(std::move(size_in)),
      is_interlaced(std::move(is_interlaced_in)),
      refresh_rate(std::move(refresh_rate_in)) {}

DisplayMode::~DisplayMode() = default;

void DisplayMode::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_interlaced"), this->is_interlaced,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "refresh_rate"), this->refresh_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DisplayMode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace display

namespace mojo {


// static
bool StructTraits<::display::mojom::DisplayMode::DataView, ::display::mojom::DisplayModePtr>::Read(
    ::display::mojom::DisplayMode::DataView input,
    ::display::mojom::DisplayModePtr* output) {
  bool success = true;
  ::display::mojom::DisplayModePtr result(::display::mojom::DisplayMode::New());
  
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success)
        result->is_interlaced = input.is_interlaced();
      if (success)
        result->refresh_rate = input.refresh_rate();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif