// ui/gfx/mojom/buffer_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/buffer_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/buffer_types.mojom-params-data.h"
namespace gfx {
namespace mojom {

static NOINLINE const char* BufferFormatToStringHelper(BufferFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BufferFormat::R_8:
      return "R_8";
    case BufferFormat::R_16:
      return "R_16";
    case BufferFormat::RG_88:
      return "RG_88";
    case BufferFormat::BGR_565:
      return "BGR_565";
    case BufferFormat::RGBA_4444:
      return "RGBA_4444";
    case BufferFormat::RGBX_8888:
      return "RGBX_8888";
    case BufferFormat::RGBA_8888:
      return "RGBA_8888";
    case BufferFormat::BGRX_8888:
      return "BGRX_8888";
    case BufferFormat::BGRA_1010102:
      return "BGRA_1010102";
    case BufferFormat::RGBA_1010102:
      return "RGBA_1010102";
    case BufferFormat::BGRA_8888:
      return "BGRA_8888";
    case BufferFormat::RGBA_F16:
      return "RGBA_F16";
    case BufferFormat::YVU_420:
      return "YVU_420";
    case BufferFormat::YUV_420_BIPLANAR:
      return "YUV_420_BIPLANAR";
    case BufferFormat::P010:
      return "P010";
    default:
      return nullptr;
  }
}

std::string BufferFormatToString(BufferFormat value) {
  const char *str = BufferFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BufferFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BufferFormat value) {
  return os << BufferFormatToString(value);
}

static NOINLINE const char* BufferUsageToStringHelper(BufferUsage value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BufferUsage::GPU_READ:
      return "GPU_READ";
    case BufferUsage::SCANOUT:
      return "SCANOUT";
    case BufferUsage::SCANOUT_CAMERA_READ_WRITE:
      return "SCANOUT_CAMERA_READ_WRITE";
    case BufferUsage::CAMERA_AND_CPU_READ_WRITE:
      return "CAMERA_AND_CPU_READ_WRITE";
    case BufferUsage::SCANOUT_CPU_READ_WRITE:
      return "SCANOUT_CPU_READ_WRITE";
    case BufferUsage::SCANOUT_VDA_WRITE:
      return "SCANOUT_VDA_WRITE";
    case BufferUsage::PROTECTED_SCANOUT_VDA_WRITE:
      return "PROTECTED_SCANOUT_VDA_WRITE";
    case BufferUsage::GPU_READ_CPU_READ_WRITE:
      return "GPU_READ_CPU_READ_WRITE";
    case BufferUsage::SCANOUT_VEA_CPU_READ:
      return "SCANOUT_VEA_CPU_READ";
    case BufferUsage::VEA_READ_CAMERA_AND_CPU_READ_WRITE:
      return "VEA_READ_CAMERA_AND_CPU_READ_WRITE";
    case BufferUsage::SCANOUT_FRONT_RENDERING:
      return "SCANOUT_FRONT_RENDERING";
    default:
      return nullptr;
  }
}

std::string BufferUsageToString(BufferUsage value) {
  const char *str = BufferUsageToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BufferUsage value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BufferUsage value) {
  return os << BufferUsageToString(value);
}

static NOINLINE const char* BufferPlaneToStringHelper(BufferPlane value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BufferPlane::DEFAULT:
      return "DEFAULT";
    case BufferPlane::Y:
      return "Y";
    case BufferPlane::UV:
      return "UV";
    case BufferPlane::U:
      return "U";
    case BufferPlane::V:
      return "V";
    default:
      return nullptr;
  }
}

std::string BufferPlaneToString(BufferPlane value) {
  const char *str = BufferPlaneToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BufferPlane value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BufferPlane value) {
  return os << BufferPlaneToString(value);
}

namespace internal {


// static
bool BufferUsageAndFormat_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BufferUsageAndFormat_Data* object = static_cast<const BufferUsageAndFormat_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::gfx::mojom::internal::BufferUsage_Data
        ::Validate(object->usage, validation_context))
    return false;


  if (!::gfx::mojom::internal::BufferFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  return true;
}

BufferUsageAndFormat_Data::BufferUsageAndFormat_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferId_Data* object = static_cast<const GpuMemoryBufferId_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GpuMemoryBufferId_Data::GpuMemoryBufferId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferHandle_Data* object = static_cast<const GpuMemoryBufferHandle_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->platform_handle, validation_context))
    return false;

  return true;
}

GpuMemoryBufferHandle_Data::GpuMemoryBufferHandle_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gfx

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::BufferFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::gfx::mojom::BufferFormat value) {
  return std::move(context).WriteString(::gfx::mojom::BufferFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::BufferUsage>::WriteIntoTrace(
   perfetto::TracedValue context, ::gfx::mojom::BufferUsage value) {
  return std::move(context).WriteString(::gfx::mojom::BufferUsageToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::BufferPlane>::WriteIntoTrace(
   perfetto::TracedValue context, ::gfx::mojom::BufferPlane value) {
  return std::move(context).WriteString(::gfx::mojom::BufferPlaneToString(value));
}

} // namespace perfetto
