// ui/gfx/mojom/color_space.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/color_space.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/color_space.mojom-params-data.h"
#include "ui/gfx/mojom/color_space.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/color_space.mojom-import-headers.h"


#ifndef UI_GFX_MOJOM_COLOR_SPACE_MOJOM_JUMBO_H_
#define UI_GFX_MOJOM_COLOR_SPACE_MOJOM_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
ColorSpace::ColorSpace()
    : primaries(),
      transfer(),
      matrix(),
      range(),
      custom_primary_matrix(),
      transfer_params() {}

ColorSpace::ColorSpace(
    ColorSpacePrimaryID primaries_in,
    ColorSpaceTransferID transfer_in,
    ColorSpaceMatrixID matrix_in,
    ColorSpaceRangeID range_in,
    std::vector<float> custom_primary_matrix_in,
    std::vector<float> transfer_params_in)
    : primaries(std::move(primaries_in)),
      transfer(std::move(transfer_in)),
      matrix(std::move(matrix_in)),
      range(std::move(range_in)),
      custom_primary_matrix(std::move(custom_primary_matrix_in)),
      transfer_params(std::move(transfer_params_in)) {}

ColorSpace::~ColorSpace() = default;

void ColorSpace::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primaries"), this->primaries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ColorSpacePrimaryID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer"), this->transfer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ColorSpaceTransferID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matrix"), this->matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ColorSpaceMatrixID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "range"), this->range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ColorSpaceRangeID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_primary_matrix"), this->custom_primary_matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer_params"), this->transfer_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorSpace::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace gfx

namespace mojo {


// static
bool StructTraits<::gfx::mojom::ColorSpace::DataView, ::gfx::mojom::ColorSpacePtr>::Read(
    ::gfx::mojom::ColorSpace::DataView input,
    ::gfx::mojom::ColorSpacePtr* output) {
  bool success = true;
  ::gfx::mojom::ColorSpacePtr result(::gfx::mojom::ColorSpace::New());
  
      if (success && !input.ReadPrimaries(&result->primaries))
        success = false;
      if (success && !input.ReadTransfer(&result->transfer))
        success = false;
      if (success && !input.ReadMatrix(&result->matrix))
        success = false;
      if (success && !input.ReadRange(&result->range))
        success = false;
      if (success && !input.ReadCustomPrimaryMatrix(&result->custom_primary_matrix))
        success = false;
      if (success && !input.ReadTransferParams(&result->transfer_params))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif