// ui/gfx/mojom/hdr_metadata.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/hdr_metadata.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/hdr_metadata.mojom-params-data.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/hdr_metadata.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_GFX_MOJOM_HDR_METADATA_MOJOM_BLINK_JUMBO_H_
#define UI_GFX_MOJOM_HDR_METADATA_MOJOM_BLINK_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
namespace blink {
ColorVolumeMetadata::ColorVolumeMetadata()
    : primary_r(),
      primary_g(),
      primary_b(),
      white_point(),
      luminance_max(),
      luminance_min() {}

ColorVolumeMetadata::ColorVolumeMetadata(
    const ::gfx::PointF& primary_r_in,
    const ::gfx::PointF& primary_g_in,
    const ::gfx::PointF& primary_b_in,
    const ::gfx::PointF& white_point_in,
    float luminance_max_in,
    float luminance_min_in)
    : primary_r(std::move(primary_r_in)),
      primary_g(std::move(primary_g_in)),
      primary_b(std::move(primary_b_in)),
      white_point(std::move(white_point_in)),
      luminance_max(std::move(luminance_max_in)),
      luminance_min(std::move(luminance_min_in)) {}

ColorVolumeMetadata::~ColorVolumeMetadata() = default;

void ColorVolumeMetadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_r"), this->primary_r,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_g"), this->primary_g,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_b"), this->primary_b,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "white_point"), this->white_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "luminance_max"), this->luminance_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "luminance_min"), this->luminance_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorVolumeMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HDRMetadata::HDRMetadata()
    : color_volume_metadata(),
      max_content_light_level(),
      max_frame_average_light_level() {}

HDRMetadata::HDRMetadata(
    ColorVolumeMetadataPtr color_volume_metadata_in,
    uint32_t max_content_light_level_in,
    uint32_t max_frame_average_light_level_in)
    : color_volume_metadata(std::move(color_volume_metadata_in)),
      max_content_light_level(std::move(max_content_light_level_in)),
      max_frame_average_light_level(std::move(max_frame_average_light_level_in)) {}

HDRMetadata::~HDRMetadata() = default;

void HDRMetadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_volume_metadata"), this->color_volume_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ColorVolumeMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_content_light_level"), this->max_content_light_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_frame_average_light_level"), this->max_frame_average_light_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HDRMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gfx

namespace mojo {


// static
bool StructTraits<::gfx::mojom::blink::ColorVolumeMetadata::DataView, ::gfx::mojom::blink::ColorVolumeMetadataPtr>::Read(
    ::gfx::mojom::blink::ColorVolumeMetadata::DataView input,
    ::gfx::mojom::blink::ColorVolumeMetadataPtr* output) {
  bool success = true;
  ::gfx::mojom::blink::ColorVolumeMetadataPtr result(::gfx::mojom::blink::ColorVolumeMetadata::New());
  
      if (success && !input.ReadPrimaryR(&result->primary_r))
        success = false;
      if (success && !input.ReadPrimaryG(&result->primary_g))
        success = false;
      if (success && !input.ReadPrimaryB(&result->primary_b))
        success = false;
      if (success && !input.ReadWhitePoint(&result->white_point))
        success = false;
      if (success)
        result->luminance_max = input.luminance_max();
      if (success)
        result->luminance_min = input.luminance_min();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::blink::HDRMetadata::DataView, ::gfx::mojom::blink::HDRMetadataPtr>::Read(
    ::gfx::mojom::blink::HDRMetadata::DataView input,
    ::gfx::mojom::blink::HDRMetadataPtr* output) {
  bool success = true;
  ::gfx::mojom::blink::HDRMetadataPtr result(::gfx::mojom::blink::HDRMetadata::New());
  
      if (success && !input.ReadColorVolumeMetadata(&result->color_volume_metadata))
        success = false;
      if (success)
        result->max_content_light_level = input.max_content_light_level();
      if (success)
        result->max_frame_average_light_level = input.max_frame_average_light_level();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif