// ui/gfx/mojom/rrect_f.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/rrect_f.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/rrect_f.mojom-params-data.h"
namespace gfx {
namespace mojom {

static NOINLINE const char* RRectFTypeToStringHelper(RRectFType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RRectFType::kEmpty:
      return "kEmpty";
    case RRectFType::kRect:
      return "kRect";
    case RRectFType::kSingle:
      return "kSingle";
    case RRectFType::kSimple:
      return "kSimple";
    case RRectFType::kOval:
      return "kOval";
    case RRectFType::kComplex:
      return "kComplex";
    default:
      return nullptr;
  }
}

std::string RRectFTypeToString(RRectFType value) {
  const char *str = RRectFTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RRectFType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RRectFType value) {
  return os << RRectFTypeToString(value);
}

namespace internal {


// static
bool RRectF_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RRectF_Data* object = static_cast<const RRectF_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::gfx::mojom::internal::RRectFType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->upper_left, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->upper_left, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->upper_right, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->upper_right, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lower_right, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lower_right, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lower_left, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lower_left, validation_context))
    return false;

  return true;
}

RRectF_Data::RRectF_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gfx

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::RRectFType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gfx::mojom::RRectFType value) {
  return std::move(context).WriteString(::gfx::mojom::RRectFTypeToString(value));
}

} // namespace perfetto
