// ui/gfx/mojom/swap_result.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/swap_result.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/swap_result.mojom-params-data.h"
namespace gfx {
namespace mojom {

static NOINLINE const char* SwapResultToStringHelper(SwapResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SwapResult::ACK:
      return "ACK";
    case SwapResult::FAILED:
      return "FAILED";
    case SwapResult::SKIPPED:
      return "SKIPPED";
    case SwapResult::NAK_RECREATE_BUFFERS:
      return "NAK_RECREATE_BUFFERS";
    default:
      return nullptr;
  }
}

std::string SwapResultToString(SwapResult value) {
  const char *str = SwapResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SwapResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SwapResult value) {
  return os << SwapResultToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace gfx

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::SwapResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::gfx::mojom::SwapResult value) {
  return std::move(context).WriteString(::gfx::mojom::SwapResultToString(value));
}

} // namespace perfetto
