// ui/gl/mojom/gpu_preference.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gl/mojom/gpu_preference.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gl/mojom/gpu_preference.mojom-params-data.h"
namespace gl {
namespace mojom {

static NOINLINE const char* GpuPreferenceToStringHelper(GpuPreference value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GpuPreference::kDefault:
      return "kDefault";
    case GpuPreference::kLowPower:
      return "kLowPower";
    case GpuPreference::kHighPerformance:
      return "kHighPerformance";
    default:
      return nullptr;
  }
}

std::string GpuPreferenceToString(GpuPreference value) {
  const char *str = GpuPreferenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GpuPreference value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GpuPreference value) {
  return os << GpuPreferenceToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace gl

namespace perfetto {

// static
void TraceFormatTraits<::gl::mojom::GpuPreference>::WriteIntoTrace(
   perfetto::TracedValue context, ::gl::mojom::GpuPreference value) {
  return std::move(context).WriteString(::gl::mojom::GpuPreferenceToString(value));
}

} // namespace perfetto
