// ui/latency/mojom/latency_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/latency/mojom/latency_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/latency/mojom/latency_info.mojom-params-data.h"
namespace ui {
namespace mojom {

static NOINLINE const char* LatencyComponentTypeToStringHelper(LatencyComponentType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LatencyComponentType::INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT:
      return "INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_SCROLL_UPDATE_ORIGINAL_COMPONENT:
      return "INPUT_EVENT_LATENCY_SCROLL_UPDATE_ORIGINAL_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_FIRST_SCROLL_UPDATE_ORIGINAL_COMPONENT:
      return "INPUT_EVENT_LATENCY_FIRST_SCROLL_UPDATE_ORIGINAL_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT:
      return "INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_UI_COMPONENT:
      return "INPUT_EVENT_LATENCY_UI_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_RENDERER_MAIN_COMPONENT:
      return "INPUT_EVENT_LATENCY_RENDERER_MAIN_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_MAIN_COMPONENT:
      return "INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_MAIN_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_IMPL_COMPONENT:
      return "INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_IMPL_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_SCROLL_UPDATE_LAST_EVENT_COMPONENT:
      return "INPUT_EVENT_LATENCY_SCROLL_UPDATE_LAST_EVENT_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_RENDERER_SWAP_COMPONENT:
      return "INPUT_EVENT_LATENCY_RENDERER_SWAP_COMPONENT";
    case LatencyComponentType::DISPLAY_COMPOSITOR_RECEIVED_FRAME_COMPONENT:
      return "DISPLAY_COMPOSITOR_RECEIVED_FRAME_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_GPU_SWAP_BUFFER_COMPONENT:
      return "INPUT_EVENT_GPU_SWAP_BUFFER_COMPONENT";
    case LatencyComponentType::INPUT_EVENT_LATENCY_FRAME_SWAP_COMPONENT:
      return "INPUT_EVENT_LATENCY_FRAME_SWAP_COMPONENT";
    default:
      return nullptr;
  }
}

std::string LatencyComponentTypeToString(LatencyComponentType value) {
  const char *str = LatencyComponentTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LatencyComponentType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LatencyComponentType value) {
  return os << LatencyComponentTypeToString(value);
}

static NOINLINE const char* SourceEventTypeToStringHelper(SourceEventType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SourceEventType::UNKNOWN:
      return "UNKNOWN";
    case SourceEventType::WHEEL:
      return "WHEEL";
    case SourceEventType::MOUSE:
      return "MOUSE";
    case SourceEventType::TOUCH:
      return "TOUCH";
    case SourceEventType::INERTIAL:
      return "INERTIAL";
    case SourceEventType::KEY_PRESS:
      return "KEY_PRESS";
    case SourceEventType::TOUCHPAD:
      return "TOUCHPAD";
    case SourceEventType::SCROLLBAR:
      return "SCROLLBAR";
    case SourceEventType::OTHER:
      return "OTHER";
    default:
      return nullptr;
  }
}

std::string SourceEventTypeToString(SourceEventType value) {
  const char *str = SourceEventTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SourceEventType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SourceEventType value) {
  return os << SourceEventTypeToString(value);
}

namespace internal {


// static
bool LatencyInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LatencyInfo_Data* object = static_cast<const LatencyInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->latency_components, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams latency_components_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::ui::mojom::internal::LatencyComponentType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->latency_components, validation_context,
                                         &latency_components_validate_params)) {
    return false;
  }


  if (!::ui::mojom::internal::SourceEventType_Data
        ::Validate(object->source_event_type, validation_context))
    return false;

  return true;
}

LatencyInfo_Data::LatencyInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::LatencyComponentType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::LatencyComponentType value) {
  return std::move(context).WriteString(::ui::mojom::LatencyComponentTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::SourceEventType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::SourceEventType value) {
  return std::move(context).WriteString(::ui::mojom::SourceEventTypeToString(value));
}

} // namespace perfetto
